// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

angular.module('mm', ['ionic', 'mm.core', 'mm.core.comments', 'mm.core.contentlinks', 'mm.core.course', 'mm.core.courses', 'mm.core.fileuploader', 'mm.core.grades', 'mm.core.login', 'mm.core.question', 'mm.core.settings', 'mm.core.sharedfiles', 'mm.core.sidemenu', 'mm.core.textviewer', 'mm.core.user', 'mm.addons.badges', 'mm.addons.calendar', 'mm.addons.competency', 'mm.addons.coursecompletion', 'mm.addons.files', 'mm.addons.frontpage', 'mm.addons.grades', 'mm.addons.messageoutput', 'mm.addons.messages', 'mm.addons.notes', 'mm.addons.notifications', 'mm.addons.participants', 'mm.addons.pushnotifications', 'mm.addons.remotestyles', 'mm.addons.messageoutput_airnotifier', 'mm.addons.mod_book', 'mm.addons.mod_assign', 'mm.addons.mod_chat', 'mm.addons.mod_choice', 'mm.addons.mod_folder', 'mm.addons.mod_forum', 'mm.addons.mod_glossary', 'mm.addons.mod_imscp', 'mm.addons.mod_label', 'mm.addons.mod_lti', 'mm.addons.mod_page', 'mm.addons.mod_quiz', 'mm.addons.mod_resource', 'mm.addons.mod_scorm', 'mm.addons.mod_survey', 'mm.addons.mod_url', 'mm.addons.mod_wiki', 'mm.addons.qbehaviour_adaptive', 'mm.addons.qbehaviour_adaptivenopenalty', 'mm.addons.qbehaviour_deferredfeedback', 'mm.addons.qbehaviour_deferredcbm', 'mm.addons.qbehaviour_immediatecbm', 'mm.addons.qbehaviour_immediatefeedback', 'mm.addons.qbehaviour_informationitem', 'mm.addons.qbehaviour_interactive', 'mm.addons.qbehaviour_interactivecountback', 'mm.addons.qbehaviour_manualgraded', 'mm.addons.qtype_calculated', 'mm.addons.qtype_calculatedsimple', 'mm.addons.qtype_calculatedmulti', 'mm.addons.qtype_ddimageortext', 'mm.addons.qtype_ddmarker', 'mm.addons.qtype_ddwtos', 'mm.addons.qtype_description', 'mm.addons.qtype_essay', 'mm.addons.qtype_gapselect', 'mm.addons.qtype_match', 'mm.addons.qtype_multianswer', 'mm.addons.qtype_numerical', 'mm.addons.qtype_multichoice', 'mm.addons.qtype_randomsamatch', 'mm.addons.qtype_shortanswer', 'mm.addons.qtype_truefalse', 'mm.addons.userprofilefield_checkbox', 'mm.addons.userprofilefield_datetime', 'mm.addons.userprofilefield_menu', 'mm.addons.userprofilefield_text', 'mm.addons.userprofilefield_textarea', 'ngCordova', 'angular-md5', 'pascalprecht.translate', 'ngAria', 'oc.lazyLoad', 'ckeditor',
            'ngMessages'])
.run(["$ionicPlatform", function($ionicPlatform) {
    $ionicPlatform.ready(function() {
        if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
            window.cordova.plugins.Keyboard.hideKeyboardAccessoryBar(false);
            window.cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            StatusBar.styleDefault();
        }
    });
}]);

angular.module('mm.core', ['pascalprecht.translate'])
.constant('mmCoreSessionExpired', 'mmCoreSessionExpired')
.constant('mmCoreUserDeleted', 'mmCoreUserDeleted')
.constant('mmCoreUserPasswordChangeForced', 'mmCoreUserPasswordChangeForced')
.constant('mmCoreUserNotFullySetup', 'mmCoreUserNotFullySetup')
.constant('mmCoreSitePolicyNotAgreed', 'mmCoreSitePolicyNotAgreed')
.constant('mmCoreUnicodeNotSupported', 'mmCoreUnicodeNotSupported')
.constant('mmCoreSecondsYear', 31536000)
.constant('mmCoreSecondsDay', 86400)
.constant('mmCoreSecondsHour', 3600)
.constant('mmCoreSecondsMinute', 60)
.constant('mmCoreDownloaded', 'downloaded')
.constant('mmCoreDownloading', 'downloading')
.constant('mmCoreNotDownloaded', 'notdownloaded')
.constant('mmCoreOutdated', 'outdated')
.constant('mmCoreNotDownloadable', 'notdownloadable')
.constant('mmCoreWifiDownloadThreshold', 104857600)
.constant('mmCoreDownloadThreshold', 10485760)
.config(["$stateProvider", "$provide", "$ionicConfigProvider", "$httpProvider", "$mmUtilProvider", "$mmLogProvider", "$compileProvider", "$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($stateProvider, $provide, $ionicConfigProvider, $httpProvider, $mmUtilProvider,
        $mmLogProvider, $compileProvider, $mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    $ionicConfigProvider.platform.android.tabs.position('bottom');
    $ionicConfigProvider.form.checkbox('circle');
    $ionicConfigProvider.scrolling.jsScrolling(true);
    if (!ionic.Platform.isAndroid()) {
        $ionicConfigProvider.backButton.text("{{'mm.core.back' | translate}}");
    }
    $provide.decorator('$ionicPlatform', ['$delegate', '$window', function($delegate, $window) {
        $delegate.isTablet = function() {
            var mq = 'only screen and (min-width: 768px) and (-webkit-min-device-pixel-ratio: 1)';
            return $window.matchMedia(mq).matches;
        };
        return $delegate;
    }]);
    $provide.decorator('ionRadioDirective', ['$delegate', function($delegate) {
        var directive = $delegate[0];
        transcludeRegex = /ng-transclude/
        directive.template =  directive.template.replace(transcludeRegex, 'ng-transclude data-tap-disabled="true"');
        return $delegate;
    }]);
    $provide.decorator('ionCheckboxDirective', ['$delegate', function($delegate) {
        var directive = $delegate[0];
        transcludeRegex = /ng-transclude/
        directive.template =  directive.template.replace(transcludeRegex, 'ng-transclude data-tap-disabled="true"');
        return $delegate;
    }]);
        $provide.decorator('$log', ['$delegate', $mmLogProvider.logDecorator]);
    $stateProvider
        .state('redirect', {
            url: '/redirect',
            params: {
                siteid: null,
                state: null,
                params: null
            },
            cache: false,
            template: '<ion-view><ion-content mm-state-class><mm-loading class="mm-loading-center"></mm-loading></ion-content></ion-view>',
            controller: ["$scope", "$state", "$stateParams", "$mmSite", "$mmSitesManager", "$ionicHistory", "$mmAddonManager", "$mmApp", "$mmLoginHelper", function($scope, $state, $stateParams, $mmSite, $mmSitesManager, $ionicHistory, $mmAddonManager, $mmApp,
                        $mmLoginHelper) {
                $ionicHistory.nextViewOptions({disableBack: true});
                function loadSiteAndGo() {
                    $mmSitesManager.loadSite($stateParams.siteid).then(function() {
                        if (!$mmLoginHelper.isSiteLoggedOut($stateParams.state, $stateParams.params)) {
                            $state.go($stateParams.state, $stateParams.params);
                        }
                    }, function() {
                        $state.go('mm_login.sites');
                    });
                }
                $scope.$on('$ionicView.enter', function() {
                    if ($mmSite.isLoggedIn()) {
                        if ($stateParams.siteid && $stateParams.siteid != $mmSite.getId()) {
                            if ($mmAddonManager.hasRemoteAddonsLoaded()) {
                                $mmApp.storeRedirect($stateParams.siteid, $stateParams.state, $stateParams.params);
                                $mmSitesManager.logout();
                            } else {
                                $mmSitesManager.logout().then(function() {
                                    loadSiteAndGo();
                                });
                            }
                        } else {
                            $state.go($stateParams.state, $stateParams.params);
                        }
                    } else {
                        if ($stateParams.siteid) {
                            loadSiteAndGo();
                        } else {
                            $state.go('mm_login.sites');
                        }
                    }
                });
            }]
        });
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';
    $httpProvider.defaults.transformRequest = [function(data) {
        return angular.isObject(data) && String(data) !== '[object File]' ? $mmUtilProvider.param(data) : data;
    }];
    function addProtocolIfMissing(list, protocol) {
        if (list.indexOf(protocol) == -1) {
            list = list.replace('https?', 'https?|' + protocol);
        }
        return list;
    }
    var hreflist = $compileProvider.aHrefSanitizationWhitelist().source,
        imglist = $compileProvider.imgSrcSanitizationWhitelist().source;
    hreflist = addProtocolIfMissing(hreflist, 'file');
    hreflist = addProtocolIfMissing(hreflist, 'tel');
    hreflist = addProtocolIfMissing(hreflist, 'mailto');
    hreflist = addProtocolIfMissing(hreflist, 'geo');
    hreflist = addProtocolIfMissing(hreflist, 'filesystem');
    imglist = addProtocolIfMissing(imglist, 'filesystem');
    imglist = addProtocolIfMissing(imglist, 'file');
    imglist = addProtocolIfMissing(imglist, 'cdvfile');
    moment.relativeTimeThreshold('M', 12);
    moment.relativeTimeThreshold('d', 31);
    moment.relativeTimeThreshold('h', 24);
    moment.relativeTimeThreshold('m', 60);
    moment.relativeTimeThreshold('s', 60);
    $compileProvider.aHrefSanitizationWhitelist(hreflist);
    $compileProvider.imgSrcSanitizationWhitelist(imglist);
    $mmInitDelegateProvider.registerProcess('mmAppInit', '$mmApp.initProcess', mmInitDelegateMaxAddonPriority + 400, true);
    $mmInitDelegateProvider.registerProcess('mmUpdateManager', '$mmUpdateManager.check', mmInitDelegateMaxAddonPriority + 300, true);
    $mmInitDelegateProvider.registerProcess('mmFSClearTmp', '$mmFS.clearTmpFolder', mmInitDelegateMaxAddonPriority + 150, false);
}])
.run(["$ionicPlatform", "$ionicBody", "$window", "$mmEvents", "$mmInitDelegate", "mmCoreEventKeyboardShow", "mmCoreEventKeyboardHide", "$mmApp", "$timeout", "mmCoreEventOnline", "mmCoreEventOnlineStatusChanged", "$mmUtil", "$ionicScrollDelegate", function($ionicPlatform, $ionicBody, $window, $mmEvents, $mmInitDelegate, mmCoreEventKeyboardShow, mmCoreEventKeyboardHide,
        $mmApp, $timeout, mmCoreEventOnline, mmCoreEventOnlineStatusChanged, $mmUtil, $ionicScrollDelegate) {
    $mmInitDelegate.executeInitProcesses();
    $ionicPlatform.ready(function() {
        var checkTablet = function() {
            $ionicBody.enableClass($ionicPlatform.isTablet(), 'tablet');
        };
        ionic.on('resize', checkTablet, $window);
        checkTablet();
        $window.addEventListener('native.keyboardshow', function(e) {
            $mmEvents.trigger(mmCoreEventKeyboardShow, e);
            if (ionic.Platform.isIOS()) {
                ionic.trigger('resize');
            }
            if (ionic.Platform.isIOS() && document.activeElement && document.activeElement.tagName != 'BODY') {
                if ($mmUtil.closest(document.activeElement, 'ion-footer-bar[keyboard-attach]')) {
                    return;
                }
                if ($mmUtil.isElementOutsideOfScreen(document.activeElement)) {
                    var position = $mmUtil.getElementXY(document.activeElement),
                        delegateHandle = $mmUtil.closest(document.activeElement, '*[delegate-handle]'),
                        scrollView;
                    if (position) {
                        if ($window && $window.innerHeight) {
                            position[1] = position[1] - $window.innerHeight * 0.5;
                        }
                        delegateHandle = delegateHandle && delegateHandle.getAttribute('delegate-handle');
                        scrollView = typeof delegateHandle == 'string' ?
                                $ionicScrollDelegate.$getByHandle(delegateHandle) : $ionicScrollDelegate;
                        $ionicScrollDelegate.scrollTo(position[0], position[1]);
                    }
                }
            }
        });
        $window.addEventListener('native.keyboardhide', function(e) {
            $mmEvents.trigger(mmCoreEventKeyboardHide, e);
            if (ionic.Platform.isIOS()) {
                ionic.trigger('resize');
            }
        });
    });
    var lastExecution = 0;
    $mmApp.ready().then(function() {
        document.addEventListener('online', function() { sendOnlineEvent(true); }, false);
        window.addEventListener('online', function() { sendOnlineEvent(true); }, false);
        document.addEventListener('offline', function() { sendOnlineEvent(false); }, false);
        window.addEventListener('offline', function() { sendOnlineEvent(false); }, false);
    });
    function sendOnlineEvent(online) {
        var now = new Date().getTime();
        if (now - lastExecution < 5000) {
            return;
        }
        lastExecution = now;
        $timeout(function() {
            if (online) {
                $mmEvents.trigger(mmCoreEventOnline);
            }
            $mmEvents.trigger(mmCoreEventOnlineStatusChanged, online);
        }, 1000);
    }
}]);

angular.module('mm.core')
.constant('mmAddonManagerComponent', 'mmAddonManager')
.factory('$mmAddonManager', ["$log", "$injector", "$ocLazyLoad", "$mmFilepool", "$mmSite", "$mmFS", "$mmLang", "$mmSitesManager", "$q", "$mmUtil", "$mmApp", "mmAddonManagerComponent", "mmCoreNotDownloaded", function($log, $injector, $ocLazyLoad, $mmFilepool, $mmSite, $mmFS, $mmLang, $mmSitesManager, $q,
            $mmUtil, $mmApp, mmAddonManagerComponent, mmCoreNotDownloaded) {
    $log = $log.getInstance('$mmAddonManager');
    var self = {},
        instances = {},
        remoteAddonsFolderName = 'remoteaddons',
        remoteAddonFilename = 'addon.js',
        remoteAddonCssFilename = 'styles.css',
        pathWildcardRegex = /\$ADDONPATH\$/g,
        headEl = angular.element(document.querySelector('head')),
        loadedAddons = [],
        loadedModules = [];
        self.downloadRemoteAddon = function(addon, siteId) {
        siteId = siteId || $mmSite.getId();
        var name = self.getRemoteAddonName(addon),
            dirPath = self.getRemoteAddonDirectoryPath(addon),
            revision = addon.filehash,
            file = {
                filename: name + '.zip',
                fileurl: addon.fileurl
            };
        return $mmFilepool.getPackageStatus(siteId, mmAddonManagerComponent, name, revision, 0).then(function(status) {
            if (status !== $mmFilepool.FILEDOWNLOADED) {
                return $mmFilepool.downloadPackage(siteId, [file], mmAddonManagerComponent, name, revision, 0).then(function() {
                    return $mmFS.removeDir(dirPath).catch(function() {});
                }).then(function() {
                    return $mmFilepool.getFilePathByUrl(siteId, addon.fileurl);
                }).then(function(zipPath) {
                    return $mmFS.unzipFile(zipPath, dirPath).then(function() {
                        return $mmFilepool.removeFileByUrl(siteId, addon.fileurl).catch(function() {});
                    });
                }).then(function() {
                    return $mmFS.getDir(dirPath);
                }).then(function(dir) {
                    var absoluteDirPath = $mmFS.getInternalURL(dir);
                    if (absoluteDirPath.slice(-1) == '/') {
                        absoluteDirPath = absoluteDirPath.substring(0, absoluteDirPath.length - 1);
                    }
                    var addonMainFile = $mmFS.concatenatePaths(dirPath, remoteAddonFilename);
                    return $mmFS.replaceInFile(addonMainFile, pathWildcardRegex, absoluteDirPath);
                }).catch(function() {
                    return self.setRemoteAddonStatus(addon, status).then(function() {
                        return $q.reject();
                    });
                });
            }
        });
    };
        self.downloadRemoteAddons = function(siteId) {
        siteId = siteId || $mmSite.getId();
        var downloaded = {},
            preSets = {};
        return $mmSitesManager.getSite(siteId).then(function(site) {
            preSets.getFromCache = 0;
            return site.read('tool_mobile_get_plugins_supporting_mobile', {}, preSets).then(function(data) {
                var promises = [];
                angular.forEach(data.plugins, function(addon) {
                    if (site.isFeatureDisabled('remoteAddOn_' + addon.component + '_' + addon.addon)) {
                        return;
                    }
                    promises.push(self.downloadRemoteAddon(addon, siteId).then(function() {
                        downloaded[addon.addon]= addon;
                    }));
                });
                return $mmUtil.allPromises(promises).then(function() {
                    return downloaded;
                }).catch(function() {
                    return downloaded;
                });
            });
        });
    };
        self.get = function(name) {
        if (self.isAvailable(name)) {
            return instances[name];
        }
    };
        self.getRemoteAddonDirectoryPath = function(addon, siteId) {
        siteId = siteId || $mmSite.getId();
        var subPath = remoteAddonsFolderName + '/' + self.getRemoteAddonName(addon);
        return $mmFS.concatenatePaths($mmFilepool.getFilepoolFolderPath(siteId), subPath);
    };
        self.getRemoteAddonName = function(addon) {
        return addon.component + '_' + addon.addon;
    };
        self.hasRemoteAddonsLoaded = function() {
        return loadedAddons.length;
    };
        self.isAvailable = function(name) {
        if (!name) {
            return false;
        }
        if (instances[name]) {
            return true;
        }
        try {
            instances[name] = $injector.get(name);
            return true;
        } catch(ex) {
            $log.warn('Service not available: '+name);
            return false;
        }
    };
        self.loadRemoteAddon = function(addon) {
        var dirPath = self.getRemoteAddonDirectoryPath(addon),
            absoluteDirPath;
        return $mmFS.getDir(dirPath).then(function(dir) {
            absoluteDirPath = $mmFS.getInternalURL(dir);
            return $mmFS.getDir($mmFS.concatenatePaths(dirPath, 'lang')).then(function() {
                return $mmLang.registerLanguageFolder($mmFS.concatenatePaths(absoluteDirPath, 'lang'));
            }).catch(function() {
            }).then(function() {
                return $ocLazyLoad.load($mmFS.concatenatePaths(absoluteDirPath, remoteAddonFilename));
            }).then(function() {
                loadedAddons.push(addon);
                $mmApp.trustResources($mmFS.concatenatePaths(absoluteDirPath, '**'));
                return $mmFS.getFile($mmFS.concatenatePaths(dirPath, remoteAddonCssFilename)).then(function(file) {
                    headEl.append('<link class="remoteaddonstyles" rel="stylesheet" href="' + $mmFS.getInternalURL(file) + '">');
                }).catch(function() {});
            });
        }, function() {
            return self.setRemoteAddonStatus(addon, mmCoreNotDownloaded).then(function() {
                return $q.reject();
            });
        });
    };
        self.loadRemoteAddons = function(addons) {
        var promises = [];
        loadedModules = $ocLazyLoad.getModules();
        angular.forEach(addons, function(addon) {
            self.setRemoteAddonLoadPromise(addons, addon);
            if (addon.loadPromise) {
                promises.push(addon.loadPromise);
            }
        });
        return $mmUtil.allPromises(promises);
    };
        self.setRemoteAddonLoadPromise = function(addons, addon, dependants) {
        if (typeof addon.loadPromise != 'undefined') {
            return;
        }
        dependants = dependants || [];
        var promises = [],
            stop = false;
        angular.forEach(addon.dependencies, function(dependency) {
            if (stop) {
                return;
            }
            if (dependency == addon.addon) {
                return;
            }
            if (dependants.indexOf(dependency) != -1) {
                stop = true;
                return;
            }
            if (!addons[dependency]) {
                if (dependency.indexOf('mm.addons.') == -1) {
                    dependency = 'mm.addons.' + dependency;
                }
                if (loadedModules.indexOf(dependency) == -1) {
                    stop = true;
                }
            } else {
                self.setRemoteAddonLoadPromise(addons, addons[dependency], dependants.concat(addon.addon));
                if (!addons[dependency].loadPromise) {
                    stop = true;
                } else {
                    promises.push(addons[dependency].loadPromise);
                }
            }
        });
        if (!stop) {
            addon.loadPromise = $q.all(promises).then(function() {
                return self.loadRemoteAddon(addon);
            });
        } else {
            addon.loadPromise = false;
        }
    };
        self.setRemoteAddonStatus = function(addon, status, siteId) {
        siteId = siteId || $mmSite.getId();
        var name = self.getRemoteAddonName(addon),
            revision = addon.filehash;
        return $mmFilepool.storePackageStatus(siteId, mmAddonManagerComponent, name, status, revision, 0);
    };
    return self;
}])
.run(["$mmAddonManager", "$mmEvents", "mmCoreEventLogin", "mmCoreEventLogout", "mmCoreEventRemoteAddonsLoaded", "$mmSite", "$window", function($mmAddonManager, $mmEvents, mmCoreEventLogin, mmCoreEventLogout, mmCoreEventRemoteAddonsLoaded, $mmSite, $window) {
    $mmEvents.on(mmCoreEventLogin, function() {
        var siteId = $mmSite.getId();
        $mmAddonManager.downloadRemoteAddons(siteId).then(function(addons) {
            return $mmAddonManager.loadRemoteAddons(addons).finally(function() {
                if ($mmSite.getId() == siteId && $mmAddonManager.hasRemoteAddonsLoaded()) {
                    $mmEvents.trigger(mmCoreEventRemoteAddonsLoaded);
                }
            });
        });
    });
    $mmEvents.on(mmCoreEventLogout, function() {
        if ($mmAddonManager.hasRemoteAddonsLoaded()) {
            $window.location.reload();
        }
    });
}]);

angular.module('mm.core')
.provider('$mmApp', ["$stateProvider", "$sceDelegateProvider", function($stateProvider, $sceDelegateProvider) {
        var DBNAME = 'MoodleMobile',
        dbschema = {
            stores: []
        },
        dboptions = {
            autoSchema: true
        };
        this.registerStore = function(store) {
        if (typeof(store.name) === 'undefined') {
            console.log('$mmApp: Error: store name is undefined.');
            return;
        } else if (storeExists(store.name)) {
            console.log('$mmApp: Error: store ' + store.name + ' is already defined.');
            return;
        }
        dbschema.stores.push(store);
    };
        this.registerStores = function(stores) {
        var self = this;
        angular.forEach(stores, function(store) {
            self.registerStore(store);
        });
    };
        function storeExists(name) {
        var exists = false;
        angular.forEach(dbschema.stores, function(store) {
            if (store.name === name) {
                exists = true;
            }
        });
        return exists;
    }
    this.$get = ["$mmDB", "$cordovaNetwork", "$log", "$injector", "$ionicPlatform", "$timeout", "$q", function($mmDB, $cordovaNetwork, $log, $injector, $ionicPlatform, $timeout, $q) {
        $log = $log.getInstance('$mmApp');
        var db,
            self = {},
            ssoAuthenticationDeferred;
                self.createState = function(name, config) {
            $log.debug('Adding new state: '+name);
            $stateProvider.state(name, config);
        };
                self.closeKeyboard = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard && cordova.plugins.Keyboard.close) {
                cordova.plugins.Keyboard.close();
                return true;
            }
            return false;
        };
                self.getDB = function() {
            if (typeof db == 'undefined') {
                db = $mmDB.getDB(DBNAME, dbschema, dboptions);
            }
            return db;
        };
                self.getSchema = function() {
            return dbschema;
        };
                self.initProcess = function() {
            return $ionicPlatform.ready();
        };
                self.isDevice = function() {
            return !!window.device;
        };
                self.isKeyboardVisible = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard) {
                return cordova.plugins.Keyboard.isVisible;
            }
            return false;
        };
                self.isOnline = function() {
            var online = typeof navigator.connection === 'undefined' || $cordovaNetwork.isOnline();
            if (!online && navigator.onLine) {
                online = true;
            }
            return online;
        };
                self.isNetworkAccessLimited = function() {
            if (typeof navigator.connection === 'undefined') {
                return false;
            }
            var type = $cordovaNetwork.getNetwork();
            var limited = [Connection.CELL_2G, Connection.CELL_3G, Connection.CELL_4G, Connection.CELL];
            return limited.indexOf(type) > -1;
        };
                self.isReady = function() {
            var promise = $injector.get('$mmInitDelegate').ready();
            return promise.$$state.status === 1;
        };
                self.openKeyboard = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard && cordova.plugins.Keyboard.show) {
                cordova.plugins.Keyboard.show();
                return true;
            }
            return false;
        };
                self.ready = function() {
            return $injector.get('$mmInitDelegate').ready();
        };
                self.startSSOAuthentication = function() {
            var cancelPromise;
            ssoAuthenticationDeferred = $q.defer();
            cancelPromise = $timeout(function() {
                self.finishSSOAuthentication();
            }, 10000);
            ssoAuthenticationDeferred.promise.finally(function() {
                $timeout.cancel(cancelPromise);
            });
        };
                self.finishSSOAuthentication = function() {
            ssoAuthenticationDeferred && ssoAuthenticationDeferred.resolve();
            ssoAuthenticationDeferred = undefined;
        };
                self.isSSOAuthenticationOngoing = function() {
            return !!ssoAuthenticationDeferred;
        };
                self.waitForSSOAuthentication = function() {
            if (ssoAuthenticationDeferred) {
                return ssoAuthenticationDeferred.promise;
            }
            return $q.when();
        };
                self.getRedirect = function() {
            if (localStorage && localStorage.getItem) {
                try {
                    var data = {
                        siteid: localStorage.getItem('mmCoreRedirectSiteId'),
                        state: localStorage.getItem('mmCoreRedirectState'),
                        params: localStorage.getItem('mmCoreRedirectParams'),
                        timemodified: localStorage.getItem('mmCoreRedirectTime')
                    };
                    if (data.params) {
                        data.params = JSON.parse(data.params);
                    }
                    return data;
                } catch(ex) {
                    $log.error('Error loading redirect data:', ex);
                }
            }
            return {};
        };
                self.storeRedirect = function(siteId, state, params) {
            if (localStorage && localStorage.setItem) {
                try {
                    localStorage.setItem('mmCoreRedirectSiteId', siteId);
                    localStorage.setItem('mmCoreRedirectState', state);
                    localStorage.setItem('mmCoreRedirectParams', JSON.stringify(params));
                    localStorage.setItem('mmCoreRedirectTime', new Date().getTime());
                } catch(ex) {}
            }
        };
                self.trustResources = function(wildcard) {
            var currentList = $sceDelegateProvider.resourceUrlWhitelist();
            if (currentList.indexOf(wildcard) == -1) {
                currentList.push(wildcard);
                $sceDelegateProvider.resourceUrlWhitelist(currentList);
            }
        };
        return self;
    }];
}]);

angular.module('mm.core')
.constant('mmCoreConfigStore', 'config')
.config(["$mmAppProvider", "mmCoreConfigStore", function($mmAppProvider, mmCoreConfigStore) {
    var stores = [
        {
            name: mmCoreConfigStore,
            keyPath: 'name'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmConfig', ["$q", "$log", "$mmApp", "mmCoreConfigStore", function($q, $log, $mmApp, mmCoreConfigStore) {
    $log = $log.getInstance('$mmConfig');
    var self = {};
        self.get = function(name, defaultValue) {
        return $mmApp.getDB().get(mmCoreConfigStore, name).then(function(entry) {
            return entry.value;
        }).catch(function() {
            if (typeof defaultValue != 'undefined') {
                return defaultValue;
            } else {
                return $q.reject();
            }
        });
    };
        self.set = function(name, value) {
        return $mmApp.getDB().insert(mmCoreConfigStore, {name: name, value: value});
    };
        self.delete = function(name) {
        return $mmApp.getDB().remove(mmCoreConfigStore, name);
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreCronInterval', 3600000)
.constant('mmCoreCronMinInterval', 300000)
.constant('mmCoreCronMaxTimeProcess', 120000)
.constant('mmCoreCronStore', 'cron')
.config(["$mmAppProvider", "mmCoreCronStore", function($mmAppProvider, mmCoreCronStore) {
    var stores = [
        {
            name: mmCoreCronStore,
            keyPath: 'id'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmCronDelegate', ["$log", "$mmConfig", "$mmApp", "$timeout", "$q", "$mmUtil", "mmCoreCronInterval", "mmCoreCronStore", "mmCoreSettingsSyncOnlyOnWifi", "mmCoreCronMinInterval", "mmCoreCronMaxTimeProcess", function($log, $mmConfig, $mmApp, $timeout, $q, $mmUtil, mmCoreCronInterval, mmCoreCronStore,
            mmCoreSettingsSyncOnlyOnWifi, mmCoreCronMinInterval, mmCoreCronMaxTimeProcess) {
    $log = $log.getInstance('$mmCronDelegate');
    var hooks = {},
        self = {},
        queuePromise = $q.when();
        self._executeHook = function(name, force, siteId) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.execute)) {
            $log.debug('Cannot execute hook because is invalid: ' + name);
            return $q.reject();
        }
        var usesNetwork = self._hookUsesNetwork(name),
            isSync = !force && self._isHookSync(name),
            promise;
        if (usesNetwork && !$mmApp.isOnline()) {
            $log.debug('Cannot execute hook because device is offline: ' + name);
            self._stopHook(name);
            return $q.reject();
        }
        if (isSync) {
            promise = $mmConfig.get(mmCoreSettingsSyncOnlyOnWifi, false).catch(function() {
                return false;
            }).then(function(syncOnlyOnWifi) {
                return !syncOnlyOnWifi || !$mmApp.isNetworkAccessLimited();
            });
        } else {
            promise = $q.when(true);
        }
        return promise.then(function(execute) {
            if (!execute) {
                $log.debug('Cannot execute hook because device is using limited connection: ' + name);
                scheduleNextExecution(name, mmCoreCronMinInterval);
                return $q.reject();
            }
            queuePromise = queuePromise.catch(function() {
            }).then(function() {
                return executeHook(name, siteId).then(function() {
                    $log.debug('Execution of hook \'' + name + '\' was a success.');
                    return self._setHookLastExecutionTime(name, new Date().getTime()).then(function() {
                        scheduleNextExecution(name);
                    });
                }, function() {
                    $log.debug('Execution of hook \'' + name + '\' failed.');
                    scheduleNextExecution(name, mmCoreCronMinInterval);
                    return $q.reject();
                });
            });
            return queuePromise;
        });
    };
        function executeHook(name, siteId) {
        var deferred = $q.defer(),
            cancelPromise;
        $log.debug('Executing hook: ' + name);
        $q.when(hooks[name].instance.execute(siteId)).then(function() {
            deferred.resolve();
        }).catch(function() {
            deferred.reject();
        }).finally(function() {
            $timeout.cancel(cancelPromise);
        });
        cancelPromise = $timeout(function() {
            $log.debug('Resolving execution of hook \'' + name + '\' because it took too long.');
            deferred.resolve();
        }, mmCoreCronMaxTimeProcess);
        return deferred.promise;
    }
        self.forceSyncExecution = function(siteId) {
        var promises = [];
        angular.forEach(hooks, function(hook, name) {
            if (self._isHookManualSync(name)) {
                hook.running = true;
                $timeout.cancel(hook.timeout);
                promises.push(self._executeHook(name, true, siteId));
            }
        });
        return $mmUtil.allPromises(promises);
    };
        self._getHookInterval = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.getInterval)) {
            return mmCoreCronInterval;
        }
        return Math.max(mmCoreCronMinInterval, parseInt(hooks[name].instance.getInterval(), 10));
    };
        self._getHookLastExecutionId = function(name) {
        return 'last_execution_'+name;
    };
        self._getHookLastExecutionTime = function(name) {
        var id = self._getHookLastExecutionId(name);
        return $mmApp.getDB().get(mmCoreCronStore, id).then(function(entry) {
            var time = parseInt(entry.value);
            return isNaN(time) ? 0 : time;
        }).catch(function() {
            return 0;
        });
    };
        self.hasSyncHooks = function() {
        for (var name in hooks) {
            if (self._isHookSync(name)) {
                return true;
            }
        }
        return false;
    };
        self.hasManualSyncHooks = function() {
        for (var name in hooks) {
            if (self._isHookManualSync(name)) {
                return true;
            }
        }
        return false;
    };
        self._hookUsesNetwork = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.usesNetwork)) {
            return true;
        }
        return hooks[name].instance.usesNetwork();
    };
        self._isHookSync = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.isSync)) {
            return true;
        }
        return hooks[name].instance.isSync();
    };
        self._isHookManualSync = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.canManualSync)) {
            return self._isHookSync(name);
        }
        return hooks[name].instance.canManualSync();
    };
        self.register = function(name, handler) {
        if (typeof hooks[name] != 'undefined') {
            $log.debug('The cron hook \''+name+'\' is already registered.');
            return;
        }
        $log.debug('Register hook \''+name+'\' in cron.');
        hooks[name] = {
            name: name,
            handler: handler,
            instance: $mmUtil.resolveObject(handler, true),
            running: false
        };
        if (!hooks[name].instance) {
            $log.error('The cron hook \''+name+'\' has an invalid instance, deleting.');
            delete hooks[name];
            return;
        }
        self._startHook(name);
    };
        function scheduleNextExecution(name, time) {
        if (!hooks[name]) {
            return;
        }
        if (hooks[name].timeout && hooks[name].timeout.$$state && hooks[name].timeout.$$state.status === 0) {
            return;
        }
        var promise;
        time = parseInt(time, 10);
        if (time) {
            promise = $q.when(time);
        } else {
            promise = self._getHookLastExecutionTime(name).then(function(lastExecution) {
                var interval = self._getHookInterval(name),
                    nextExecution = lastExecution + interval,
                    now = new Date().getTime();
                return nextExecution - now;
            });
        }
        promise.then(function(nextExecution) {
            $log.debug('Scheduling next execution of hook \'' + name + '\' in: ' + nextExecution + 'ms');
            if (nextExecution < 0) {
                nextExecution = 0;
            }
            hooks[name].timeout = $timeout(function() {
                self._executeHook(name);
            }, nextExecution);
        });
    }
        self._setHookLastExecutionTime = function(name, time) {
        var id = self._getHookLastExecutionId(name),
            entry = {
                id: id,
                value: parseInt(time, 10)
            };
        return $mmApp.getDB().insert(mmCoreCronStore, entry);
    };
        self.startNetworkHooks = function() {
        angular.forEach(hooks, function(hook) {
            if (self._hookUsesNetwork(hook.name)) {
                self._startHook(hook.name);
            }
        });
    };
        self._startHook = function(name) {
        if (!hooks[name]) {
            $log.debug('Cannot start hook \''+name+'\', is invalid.');
            return;
        }
        if (hooks[name].running) {
            $log.debug('Hook \''+name+'\' is already running.');
            return;
        }
        hooks[name].running = true;
        scheduleNextExecution(name);
    };
        self._stopHook = function(name) {
        if (!hooks[name]) {
            $log.debug('Cannot stop hook \''+name+'\', is invalid.');
            return;
        }
        if (!hooks[name].running) {
            $log.debug('Cannot stop hook \''+name+'\', it\'s not running.');
            return;
        }
        hooks[name].running = false;
        $timeout.cancel(hooks[name].timeout);
    };
    return self;
}])
.run(["$mmEvents", "$mmCronDelegate", "mmCoreEventOnlineStatusChanged", function($mmEvents, $mmCronDelegate, mmCoreEventOnlineStatusChanged) {
    $mmEvents.on(mmCoreEventOnlineStatusChanged, function(online) {
        if (online) {
            $mmCronDelegate.startNetworkHooks();
        }
    });
}]);

angular.module('mm.core')
.factory('$mmDB', ["$q", "$log", function($q, $log) {
    $log = $log.getInstance('$mmDB');
    var self = {},
        dbInstances = {};
        function applyOrder(query, order, reverse) {
        if (order) {
            query = query.order(order);
            if (reverse) {
                query = query.reverse();
            }
        }
        return query;
    }
        function applyWhere(query, where) {
        if (where && where.length > 0) {
            query = query.where.apply(query, where);
        }
        return query;
    }
        function callDBFunction(db, func) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db[func].apply(db, Array.prototype.slice.call(arguments, 2)).then(function(result) {
                if (typeof result == 'undefined') {
                    deferred.reject();
                } else {
                    deferred.resolve(result);
                }
            }, deferred.reject);
        } catch(ex) {
            $log.error('Error executing function ' + func + ' to DB ' + db.getName());
            $log.error(ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
        function callCount(db, store, where) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            var query = db.from(store);
            query = applyWhere(query, where);
            query.count().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            var promise;
            if (where[1] == '=') {
                promise = callWhereEqualFallBack(db, store, where[0], where[2]).then(function(list) {
                    deferred.resolve(list.length);
                });
            } else {
                promise = $q.reject();
            }
            promise.catch(function () {
                $log.error('Error counting on db ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
        function callWhere(db, store, field_name, op, value, op2, value2) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(field_name, op, value, op2, value2).list().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            var promise;
            if (op == '=') {
                promise = callWhereEqualFallBack(db, store, field_name, value).then(deferred.resolve).catch(deferred.reject);
            } else {
                promise = $q.reject();
            }
            promise.catch(function () {
                $log.error('Error getting where from db ' + db.getName() + '. ' + ex.name+': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
        function callWhereEqual(db, store, field_name, value) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(field_name, '=', value).list().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            callWhereEqualFallBack(db, store, field_name, value).then(deferred.resolve).catch(function () {
                $log.error('Error getting where equal from db ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
    function callWhereEqualFallBack(db, store, field_name, values) {
        var fields = getCompoundIndex(db, store, field_name);
        if (!fields) {
            return $q.reject();
        }
        if (typeof fields == "string") {
            fields = [fields];
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(fields[0], '=', values[0]).list().then(function(list) {
                var results = filterWhereList(list, fields, values, 1);
                deferred.resolve(results);
            }, deferred.reject);
        } catch(ex) {
            deferred.reject();
        }
        return deferred.promise;
    }
        function getCompoundIndex(db, storeName, index) {
        var stores = db.getSchema().stores;
        for (var x in stores) {
            if (stores[x].name == storeName) {
                var indexes = stores[x].indexes;
                for (var y in indexes) {
                    if (indexes[y].name == index) {
                        return indexes[y].keyPath;
                    }
                }
                return false;
            }
        }
        return false;
    }
        function filterWhereList(list, fields, values, indexNum) {
        if (list.length == 0 || fields.length < indexNum || values.length < indexNum) {
            return list;
        }
        var field = fields[indexNum],
            value = values[indexNum];
        list = list.filter(function (item) {
            return item[field] == value;
        });
        return filterWhereList(list, fields, values, indexNum + 1);
    }
        function callEach(db, store, callback) {
        var deferred = $q.defer();
        callDBFunction(db, 'values', store, undefined, 99999999).then(function(entries) {
            for (var i = 0; i < entries.length; i++) {
                callback(entries[i]);
            }
            deferred.resolve();
        }, deferred.reject);
        return deferred.promise;
    }
        function doQuery(db, store, where, order, reverse, limit) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer(),
            query;
        try {
            query = db.from(store);
            query = applyWhere(query, where);
            query = applyOrder(query, order, reverse);
            query.list(limit).then(deferred.resolve, deferred.reject);
        } catch(ex) {
            $log.error('Error querying ' + store + ' on ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
        function doUpdate(db, store, values, where) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer(),
            query;
        try {
            query = db.from(store);
            query = applyWhere(query, where);
            query.patch(values).then(deferred.resolve, deferred.reject);
        } catch(ex) {
            $log.error('Error updating ' + store + ' on ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
        self.getDB = function(name, schema, options, forceNew) {
        if (typeof dbInstances[name] === 'undefined' || forceNew) {
            var isSafari = !ionic.Platform.isIOS() && !ionic.Platform.isAndroid() && navigator.userAgent.indexOf('Safari') != -1 &&
                            navigator.userAgent.indexOf('Chrome') == -1 && navigator.userAgent.indexOf('Firefox') == -1;
            if (typeof IDBObjectStore == 'undefined' || typeof IDBObjectStore.prototype.count == 'undefined' || isSafari) {
                if (typeof options.mechanisms == 'undefined') {
                    options.mechanisms = ['websql', 'sqlite', 'localstorage', 'sessionstorage', 'userdata', 'memory'];
                } else {
                    var position = options.mechanisms.indexOf('indexeddb');
                    if (position != -1) {
                        options.mechanisms.splice(position, 1);
                    }
                }
            }
            var db = new ydn.db.Storage(name, schema, options);
            dbInstances[name] = {
                                getName: function() {
                    return db.getName();
                },
                                get: function(store, id) {
                    return callDBFunction(db, 'get', store, id);
                },
                                getAll: function(store) {
                    return callDBFunction(db, 'values', store, undefined, 99999999);
                },
                                count: function(store, where) {
                    return callCount(db, store, where);
                },
                                insert: function(store, value, id) {
                    return callDBFunction(db, 'put', store, value, id);
                },
                                insertSync: function(store, value) {
                    if (db) {
                        try {
                            db.put(store, value);
                            return true;
                        } catch(ex) {
                            $log.error('Error executing function sync put to DB '+db.getName());
                            $log.error(ex.name+': '+ex.message);
                        }
                    }
                    return false;
                },
                                query: function(store, where, order, reverse, limit) {
                    return doQuery(db, store, where, order, reverse, limit);
                },
                                remove: function(store, id) {
                    return callDBFunction(db, 'remove', store, id);
                },
                                removeAll: function(store) {
                    return callDBFunction(db, 'clear', store);
                },
                                update: function(store, values, where) {
                    return doUpdate(db, store, values, where);
                },
                                where: function(store, field_name, op, value, op2, value2) {
                    return callWhere(db, store, field_name, op, value, op2, value2);
                },
                                whereEqual: function(store, field_name, value) {
                    return callWhereEqual(db, store, field_name, value);
                },
                                each: function(store, callback) {
                    return callEach(db, store, callback);
                },
                                close: function() {
                    db.close();
                    db = undefined;
                },
                                onReady: function(cb) {
                    db.onReady(cb);
                },
                                getType: function() {
                    return db.getType();
                }
            };
        }
        return dbInstances[name];
    };
        self.deleteDB = function(name) {
        var deferred = $q.defer();
        function deleteDB() {
            var type = dbInstances[name].getType();
            $q.when(ydn.db.deleteDatabase(name, type).then(function() {
                delete dbInstances[name];
                deferred.resolve();
            }, deferred.reject));
        }
        if (typeof dbInstances[name] != 'undefined') {
            dbInstances[name].onReady(deleteDB);
        } else {
            deleteDB();
        }
        return deferred.promise;
    };
    return self;
}]);

angular.module('mm.core')
.factory('$mmEmulatorManager', ["$log", "$q", "$http", "$mmFS", "$window", function($log, $q, $http, $mmFS, $window) {
    $log = $log.getInstance('$mmEmulatorManager');
    var self = {};
        self.loadHTMLAPI = function() {
        if ($mmFS.isAvailable()) {
            $log.debug('Stop loading HTML API, it was already loaded or the environment doesn\'t need it.');
            return $q.when();
        }
        var deferred = $q.defer(),
            basePath;
        $log.debug('Loading HTML API.');
        $window.requestFileSystem  = $window.requestFileSystem || $window.webkitRequestFileSystem;
        $window.resolveLocalFileSystemURL = $window.resolveLocalFileSystemURL || $window.webkitResolveLocalFileSystemURL;
        $window.LocalFileSystem = {
            PERSISTENT: 1
        };
        $window.FileTransfer = function() {};
        $window.FileTransfer.prototype.download = function(url, filePath, successCallback, errorCallback) {
            $http.get(url, {responseType: 'blob'}).then(function(data) {
                if (!data || !data.data) {
                    errorCallback();
                } else {
                    filePath = filePath.replace(basePath, '');
                    filePath = filePath.replace(/%20/g, ' ');
                    $mmFS.writeFile(filePath, data.data).then(function(e) {
                        successCallback(e);
                    }).catch(function(error) {
                        errorCallback(error);
                    });
                }
            }).catch(function(error) {
                errorCallback(error);
            });
        };
        $window.zip = {
            unzip: function(source, destination, callback, progressCallback) {
                source = source.replace(basePath, '');
                source = source.replace(/%20/g, ' ');
                destination = destination.replace(basePath, '');
                destination = destination.replace(/%20/g, ' ');
                $mmFS.readFile(source, $mmFS.FORMATARRAYBUFFER).then(function(data) {
                    var zip = new JSZip(data),
                        promises = [];
                    angular.forEach(zip.files, function(file, name) {
                        var filepath = $mmFS.concatenatePaths(destination, name),
                            type;
                        if (!file.dir) {
                            type = $mmFS.getMimeType($mmFS.getFileExtension(name));
                            promises.push($mmFS.writeFile(filepath, new Blob([file.asArrayBuffer()], {type: type})));
                        } else {
                            promises.push($mmFS.createDir(filepath));
                        }
                    });
                    return $q.all(promises).then(function() {
                        callback(0);
                    });
                }).catch(function() {
                    callback(-1);
                });
            }
        };
        $window.webkitStorageInfo.requestQuota(PERSISTENT, 500 * 1024 * 1024, function(granted) {
            $window.requestFileSystem(PERSISTENT, granted, function(entry) {
                basePath = entry.root.toURL();
                $mmFS.setHTMLBasePath(basePath);
                deferred.resolve();
            }, deferred.reject);
        }, deferred.reject);
        return deferred.promise;
    };
    return self;
}])
.config(["$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    if (!ionic.Platform.isWebView()) {
        $mmInitDelegateProvider.registerProcess('mmEmulator', '$mmEmulatorManager.loadHTMLAPI',
                mmInitDelegateMaxAddonPriority + 500, true);
    }
}]);

angular.module('mm.core')
.constant('mmCoreEventKeyboardShow', 'keyboard_show')
.constant('mmCoreEventKeyboardHide', 'keyboard_hide')
.constant('mmCoreEventSessionExpired', 'session_expired')
.constant('mmCoreEventPasswordChangeForced', 'password_change_forced')
.constant('mmCoreEventUserNotFullySetup', 'user_not_fully_setup')
.constant('mmCoreEventSitePolicyNotAgreed', 'site_policy_not_agreed')
.constant('mmCoreEventLogin', 'login')
.constant('mmCoreEventLogout', 'logout')
.constant('mmCoreEventLanguageChanged', 'language_changed')
.constant('mmCoreEventSiteAdded', 'site_added')
.constant('mmCoreEventSiteUpdated', 'site_updated')
.constant('mmCoreEventSiteDeleted', 'site_deleted')
.constant('mmCoreEventQueueEmpty', 'filepool_queue_empty')
.constant('mmCoreEventCompletionModuleViewed', 'completion_module_viewed')
.constant('mmCoreEventUserDeleted', 'user_deleted')
.constant('mmCoreEventPackageStatusChanged', 'filepool_package_status_changed')
.constant('mmCoreEventSectionStatusChanged', 'section_status_changed')
.constant('mmCoreEventRemoteAddonsLoaded', 'remote_addons_loaded')
.constant('mmCoreEventOnline', 'online')
.constant('mmCoreEventOnlineStatusChanged', 'online_status_changed')
.factory('$mmEvents', ["$log", "md5", function($log, md5) {
    $log = $log.getInstance('$mmEvents');
    var self = {},
        observers = {},
        uniqueEvents = {},
        uniqueEventsData = {};
        self.on = function(eventName, callBack) {
        if (uniqueEvents[eventName]) {
            callBack(uniqueEventsData[eventName]);
            return {
                id: -1,
                off: function() {}
            };
        }
        var observerID;
        if (typeof(observers[eventName]) === 'undefined') {
            observers[eventName] = {};
        }
        while (typeof(observerID) === 'undefined') {
            var candidateID = md5.createHash(Math.random().toString());
            if (typeof(observers[eventName][candidateID]) === 'undefined') {
                observerID = candidateID;
            }
        }
        $log.debug('Observer ' + observerID + ' listening to event '+eventName);
        observers[eventName][observerID] = callBack;
        var observer = {
            id: observerID,
            off: function() {
                $log.debug('Disable observer ' + observerID + ' for event '+eventName);
                delete observers[eventName][observerID];
            }
        };
        return observer;
    };
        self.trigger = function(eventName, data) {
        $log.debug('Event ' + eventName + ' triggered.');
        var affected = observers[eventName];
        for (var observerName in affected) {
            if (typeof(affected[observerName]) === 'function') {
                affected[observerName](data);
            }
        }
    };
        self.triggerUnique = function(eventName, data) {
        if (uniqueEvents[eventName]) {
            $log.debug('Unique event ' + eventName + ' ignored because it was already triggered.');
        } else {
            $log.debug('Unique event ' + eventName + ' triggered.');
            uniqueEvents[eventName] = true;
            uniqueEventsData[eventName] = data;
            var affected = observers[eventName];
            angular.forEach(affected, function(callBack) {
                if (typeof callBack === 'function') {
                    callBack(data);
                }
            });
        }
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmFilepoolQueueProcessInterval', 0)
.constant('mmFilepoolFolder', 'filepool')
.constant('mmFilepoolStore', 'filepool')
.constant('mmFilepoolQueueStore', 'files_queue')
.constant('mmFilepoolLinksStore', 'files_links')
.constant('mmFilepoolPackagesStore', 'filepool_packages')
.constant('mmFilepoolWifiDownloadThreshold', 20971520)
.constant('mmFilepoolDownloadThreshold', 2097152)
.config(["$mmAppProvider", "$mmSitesFactoryProvider", "mmFilepoolStore", "mmFilepoolLinksStore", "mmFilepoolQueueStore", "mmFilepoolPackagesStore", function($mmAppProvider, $mmSitesFactoryProvider, mmFilepoolStore, mmFilepoolLinksStore, mmFilepoolQueueStore,
            mmFilepoolPackagesStore) {
    var siteStores = [
        {
            name: mmFilepoolStore,
            keyPath: 'fileId',
            indexes: []
        },
        {
            name: mmFilepoolLinksStore,
            keyPath: ['fileId', 'component', 'componentId'],
            indexes: [
                {
                    name: 'fileId',
                },
                {
                    name: 'component',
                },
                {
                    name: 'componentAndId',
                    keyPath: ['component', 'componentId']
                }
            ]
        },
        {
            name: mmFilepoolPackagesStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'component',
                },
                {
                    name: 'componentId',
                },
                {
                    name: 'status',
                }
            ]
        }
    ];
    var appStores = [
        {
            name: mmFilepoolQueueStore,
            keyPath: ['siteId', 'fileId'],
            indexes: [
                {
                    name: 'siteId',
                },
                {
                    name: 'sortorder',
                    generator: function(obj) {
                        var sortorder = parseInt(obj.added, 10),
                            priority = 999 - Math.max(0, Math.min(parseInt(obj.priority || 0, 10), 999)),
                            padding = "000";
                        sortorder = "" + sortorder;
                        priority = "" + priority;
                        priority = padding.substring(0, padding.length - priority.length) + priority;
                        sortorder = priority + '-' + sortorder;
                        return sortorder;
                    }
                }
            ]
        }
    ];
    $mmAppProvider.registerStores(appStores);
    $mmSitesFactoryProvider.registerStores(siteStores);
}])
.factory('$mmFilepool', ["$q", "$log", "$timeout", "$mmApp", "$mmFS", "$mmWS", "$mmSitesManager", "$mmEvents", "md5", "mmFilepoolStore", "mmFilepoolLinksStore", "mmFilepoolQueueStore", "mmFilepoolFolder", "mmFilepoolQueueProcessInterval", "mmCoreEventQueueEmpty", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreNotDownloadable", "mmFilepoolPackagesStore", "mmCoreEventPackageStatusChanged", "$mmText", "$mmUtil", "mmFilepoolWifiDownloadThreshold", "mmFilepoolDownloadThreshold", function($q, $log, $timeout, $mmApp, $mmFS, $mmWS, $mmSitesManager, $mmEvents, md5, mmFilepoolStore,
        mmFilepoolLinksStore, mmFilepoolQueueStore, mmFilepoolFolder, mmFilepoolQueueProcessInterval, mmCoreEventQueueEmpty,
        mmCoreDownloaded, mmCoreDownloading, mmCoreNotDownloaded, mmCoreOutdated, mmCoreNotDownloadable, mmFilepoolPackagesStore,
        mmCoreEventPackageStatusChanged, $mmText, $mmUtil, mmFilepoolWifiDownloadThreshold, mmFilepoolDownloadThreshold) {
    $log = $log.getInstance('$mmFilepool');
    var self = {},
        tokenRegex = new RegExp('(\\?|&)token=([A-Za-z0-9]+)'),
        queueState,
        urlAttributes = [
            tokenRegex,
            new RegExp('(\\?|&)forcedownload=[0-1]')
        ],
        revisionRegex = new RegExp('/content/([0-9]+)/'),
        queueDeferreds = {},
        packagesPromises = {},
        filePromises = {},
        sizeCache = {};
    var QUEUE_RUNNING = 'mmFilepool:QUEUE_RUNNING',
        QUEUE_PAUSED = 'mmFilepool:QUEUE_PAUSED';
    var ERR_QUEUE_IS_EMPTY = 'mmFilepoolError:ERR_QUEUE_IS_EMPTY',
        ERR_FS_OR_NETWORK_UNAVAILABLE = 'mmFilepoolError:ERR_FS_OR_NETWORK_UNAVAILABLE',
        ERR_QUEUE_ON_PAUSE = 'mmFilepoolError:ERR_QUEUE_ON_PAUSE';
        self.FILEDOWNLOADED = 'downloaded';
    self.FILEDOWNLOADING = 'downloading';
    self.FILENOTDOWNLOADED = 'notdownloaded';
    self.FILEOUTDATED = 'outdated';
        function getSiteDb(siteId) {
        return $mmSitesManager.getSiteDb(siteId);
    }
        self._addFileLink = function(siteId, fileId, component, componentId) {
        if (!component) {
            return $q.reject();
        }
        componentId = self._fixComponentId(componentId);
        return getSiteDb(siteId).then(function(db) {
            return db.insert(mmFilepoolLinksStore, {
                fileId: fileId,
                component: component,
                componentId: componentId
            });
        });
    };
        self.addFileLinkByUrl = function(siteId, fileUrl, component, componentId) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._addFileLink(siteId, fileId, component, componentId);
        });
    };
        self._addFileLinks = function(siteId, fileId, links) {
        var promises = [];
        angular.forEach(links, function(link) {
            promises.push(self._addFileLink(siteId, fileId, link.component, link.componentId));
        });
        return $q.all(promises);
    };
        self._addFileToPool = function(siteId, fileId, data) {
        var values = angular.copy(data) || {};
        values.fileId = fileId;
        return getSiteDb(siteId).then(function(db) {
            return db.insert(mmFilepoolStore, values);
        });
    };
        self.addToQueueByUrl = function(siteId, fileUrl, component, componentId, timemodified, filePath, priority) {
        var db = $mmApp.getDB(),
            fileId,
            now = new Date(),
            link,
            revision,
            queueDeferred;
        if (!$mmFS.isAvailable()) {
            return $q.reject();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (!site.canDownloadFiles()) {
                return $q.reject();
            }
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                timemodified = timemodified || 0;
                revision = self.getRevisionFromUrl(fileUrl);
                fileId = self._getFileIdByUrl(fileUrl);
                priority = priority || 0;
                if (typeof component !== 'undefined') {
                    link = {
                        component: component,
                        componentId: self._fixComponentId(componentId)
                    };
                }
                queueDeferred = self._getQueueDeferred(siteId, fileId, false);
                return db.get(mmFilepoolQueueStore, [siteId, fileId]).then(function(fileObject) {
                    var foundLink = false,
                        update = false;
                    if (fileObject) {
                        if (fileObject.priority < priority) {
                            update = true;
                            fileObject.priority = priority;
                        }
                        if (revision && fileObject.revision !== revision) {
                            update = true;
                            fileObject.revision = revision;
                        }
                        if (timemodified && fileObject.timemodified !== timemodified) {
                            update = true;
                            fileObject.timemodified = timemodified;
                        }
                        if (filePath && fileObject.path !== filePath) {
                            update = true;
                            fileObject.path = filePath;
                        }
                        if (link) {
                            angular.forEach(fileObject.links, function(fileLink) {
                                if (fileLink.component == link.component && fileLink.componentId == link.componentId) {
                                    foundLink = true;
                                }
                            });
                            if (!foundLink) {
                                update = true;
                                fileObject.links.push(link);
                            }
                        }
                        if (update) {
                            $log.debug('Updating file ' + fileId + ' which is already in queue');
                            return db.insert(mmFilepoolQueueStore, fileObject).then(function() {
                                return self._getQueuePromise(siteId, fileId);
                            });
                        }
                        $log.debug('File ' + fileId + ' already in queue and does not require update');
                        if (queueDeferred) {
                            return queueDeferred.promise;
                        } else {
                            return self._getQueuePromise(siteId, fileId);
                        }
                    } else {
                        return addToQueue();
                    }
                }, function() {
                    return addToQueue();
                });
                function addToQueue() {
                    $log.debug('Adding ' + fileId + ' to the queue');
                    return db.insert(mmFilepoolQueueStore, {
                        siteId: siteId,
                        fileId: fileId,
                        added: now.getTime(),
                        priority: priority,
                        url: fileUrl,
                        revision: revision,
                        timemodified: timemodified,
                        path: filePath,
                        links: link ? [link] : []
                    }).then(function() {
                        self.checkQueueProcessing();
                        self._notifyFileDownloading(siteId, fileId);
                        return self._getQueuePromise(siteId, fileId);
                    });
                }
            });
        });
    };
        self.checkQueueProcessing = function() {
        if (!$mmFS.isAvailable() || !$mmApp.isOnline()) {
            queueState = QUEUE_PAUSED;
            return;
        } else if (queueState === QUEUE_RUNNING) {
            return;
        }
        queueState = QUEUE_RUNNING;
        self._processQueue();
    };
        self.clearAllPackagesStatus = function(siteId) {
        var promises = [];
        $log.debug('Clear all packages status for site ' + siteId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb();
            return db.getAll(mmFilepoolPackagesStore).then(function(entries) {
                angular.forEach(entries, function(entry) {
                    promises.push(db.remove(mmFilepoolPackagesStore, entry.id).then(function() {
                        self._triggerPackageStatusChanged(siteId, entry.component, entry.componentId, mmCoreNotDownloaded);
                    }));
                });
                return $q.all(promises);
            });
        });
    };
        self.clearFilepool = function(siteId) {
        return getSiteDb(siteId).then(function(db) {
            return db.removeAll(mmFilepoolStore);
        });
    };
        self.componentHasFiles = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            var where;
            if (typeof componentId !== 'undefined') {
                where = ['componentAndId', '=', [component, self._fixComponentId(componentId)]];
            } else {
                where = ['component', '=', component];
            }
            return db.count(mmFilepoolLinksStore, where).then(function(count) {
                if (count > 0) {
                    return true;
                }
                return $q.reject();
            });
        });
    };
        self.determinePackagesStatus = function(current, packagestatus) {
        if (!current) {
            current = mmCoreNotDownloadable;
        }
        if (packagestatus === mmCoreNotDownloaded) {
            return mmCoreNotDownloaded;
        } else if (packagestatus === mmCoreDownloaded && current === mmCoreNotDownloadable) {
            return mmCoreDownloaded;
        } else if (packagestatus === mmCoreDownloading && (current === mmCoreNotDownloadable || current === mmCoreDownloaded)) {
            return mmCoreDownloading;
        } else if (packagestatus === mmCoreOutdated && current !== mmCoreNotDownloaded) {
            return mmCoreOutdated;
        }
        return current;
    };
        self._downloadOrPrefetchPackage = function(siteId, fileList, prefetch, component, componentId, revision, timemod, dirPath) {
        var packageId = self.getPackageId(component, componentId);
        if (packagesPromises[siteId] && packagesPromises[siteId][packageId]) {
            return packagesPromises[siteId][packageId];
        } else if (!packagesPromises[siteId]) {
            packagesPromises[siteId] = {};
        }
        revision = revision || self.getRevisionFromFileList(fileList);
        timemod = timemod || self.getTimemodifiedFromFileList(fileList);
        var dwnPromise,
            deleted = false;
        dwnPromise = self.storePackageStatus(siteId, component, componentId, mmCoreDownloading).then(function() {
            var promises = [],
                deferred = $q.defer(),
                packageLoaded = 0;
            angular.forEach(fileList, function(file) {
                var path,
                    promise,
                    fileLoaded = 0;
                if (dirPath) {
                    path = file.filename;
                    if (file.filepath !== '/') {
                        path = file.filepath.substr(1) + path;
                    }
                    path = $mmFS.concatenatePaths(dirPath, path);
                }
                if (prefetch) {
                    promise = self.addToQueueByUrl(siteId, file.fileurl, component, componentId, file.timemodified, path);
                } else {
                    promise = self.downloadUrl(siteId, file.fileurl, false, component, componentId, file.timemodified, path);
                }
                promises.push(promise.then(undefined, undefined, function(progress) {
                    if (progress && progress.loaded) {
                        packageLoaded = packageLoaded + (progress.loaded - fileLoaded);
                        fileLoaded = progress.loaded;
                        deferred.notify({
                            packageDownload: true,
                            loaded: packageLoaded,
                            fileProgress: progress
                        });
                    }
                }));
            });
            $q.all(promises).then(function() {
                return self.storePackageStatus(siteId, component, componentId, mmCoreDownloaded, revision, timemod);
            }).catch(function() {
                return self.setPackagePreviousStatus(siteId, component, componentId).then(function() {
                    return $q.reject();
                });
            }).then(deferred.resolve, deferred.reject);
            return deferred.promise;
        }).finally(function() {
            delete packagesPromises[siteId][packageId];
            deleted = true;
        });
        if (!deleted) {
            packagesPromises[siteId][packageId] = dwnPromise;
        }
        return dwnPromise;
    };
        self.downloadPackage = function(siteId, fileList, component, componentId, revision, timemodified, dirPath) {
        return self._downloadOrPrefetchPackage(siteId, fileList, false, component, componentId, revision, timemodified, dirPath);
    };
        self.downloadUrl = function(siteId, fileUrl, ignoreStale, component, componentId, timemodified, filePath) {
        var fileId,
            revision,
            promise;
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
                fileUrl = fixedUrl;
                timemodified = timemodified || 0;
                revision = self.getRevisionFromUrl(fileUrl);
                fileId = self._getFileIdByUrl(fileUrl);
                return self._restoreOldFileIfNeeded(siteId, fileId, fileUrl, filePath);
            }).then(function() {
                return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                    if (typeof fileObject === 'undefined') {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, revision, timemodified, filePath);
                    } else if (self._isFileOutdated(fileObject, revision, timemodified) && $mmApp.isOnline() && !ignoreStale) {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, revision, timemodified, filePath, fileObject);
                    }
                    if (filePath) {
                        promise = self._getInternalUrlByPath(filePath);
                    } else {
                        promise = self._getInternalUrlById(siteId, fileId);
                    }
                    return promise.then(function(response) {
                        return response;
                    }, function() {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, revision, timemodified, filePath, fileObject);
                    });
                }, function() {
                    self._notifyFileDownloading(siteId, fileId);
                    return self._downloadForPoolByUrl(siteId, fileUrl, revision, timemodified, filePath);
                })
                .then(function(response) {
                    if (typeof component !== 'undefined') {
                        self._addFileLink(siteId, fileId, component, componentId);
                    }
                    self._notifyFileDownloaded(siteId, fileId);
                    return response;
                }, function(err) {
                    self._notifyFileDownloadError(siteId, fileId);
                    return $q.reject(err);
                });
            });
        } else {
            return $q.reject();
        }
    };
        self._downloadForPoolByUrl = function(siteId, fileUrl, revision, timemodified, filePath, poolFileObject) {
        var fileId = self._getFileIdByUrl(fileUrl),
            extension = $mmFS.guessExtensionFromUrl(fileUrl),
            addExtension = typeof filePath == "undefined",
            pathPromise = filePath ? filePath : self._getFilePath(siteId, fileId, extension);
        return $q.when(pathPromise).then(function(filePath) {
            if (poolFileObject && poolFileObject.fileId !== fileId) {
                $log.error('Invalid object to update passed');
                return $q.reject();
            }
            var downloadId = self.getFileDownloadId(fileUrl, filePath),
                deleted = false,
                promise;
            if (filePromises[siteId] && filePromises[siteId][downloadId]) {
                return filePromises[siteId][downloadId];
            } else if (!filePromises[siteId]) {
                filePromises[siteId] = {};
            }
            promise = $mmSitesManager.getSite(siteId).then(function(site) {
                if (!site.canDownloadFiles()) {
                    return $q.reject();
                }
                return $mmWS.downloadFile(fileUrl, filePath, addExtension).then(function(fileEntry) {
                    var now = new Date(),
                        data = poolFileObject || {};
                    data.downloaded = now.getTime();
                    data.stale = false;
                    data.url = fileUrl;
                    data.revision = revision;
                    data.timemodified = timemodified;
                    data.path = fileEntry.path;
                    data.extension = fileEntry.extension;
                    return self._addFileToPool(siteId, fileId, data).then(function() {
                        return fileEntry.toURL();
                    });
                });
            }).finally(function() {
                delete filePromises[siteId][downloadId];
                deleted = true;
            });
            if (!deleted) {
                filePromises[siteId][downloadId] = promise;
            }
            return promise;
        });
    };
        self._fixComponentId = function(componentId) {
        var id = parseInt(componentId, 10);
        if (isNaN(id)) {
            if (typeof componentId == 'undefined' || componentId === null) {
                return -1;
            } else {
                return componentId;
            }
        }
        return id;
    };
        self._fixPluginfileURL = function(siteId, fileUrl) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.fixPluginfileURL(fileUrl);
        });
    };
        self._getFileLinks = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId);
        });
    };
        self.getFileDownloadId = function(fileUrl, filePath) {
        return md5.createHash(fileUrl + '###' + filePath);
    };
        self._getFileEventName = function(siteId, fileId) {
        return 'mmFilepoolFile:'+siteId+':'+fileId;
    };
        self.getFileEventNameByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._getFileEventName(siteId, fileId);
        });
    };
        self.getPackageDownloadPromise = function(siteId, component, componentId) {
        var packageId = self.getPackageId(component, componentId);
        if (packagesPromises[siteId] && packagesPromises[siteId][packageId]) {
            return packagesPromises[siteId][packageId];
        }
    };
        self.getPackageId = function(component, componentId) {
        return md5.createHash(component + '#' + self._fixComponentId(componentId));
    };
        self.getPackageData = function(siteId, component, componentId) {
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (!entry) {
                    return $q.reject();
                }
                return entry;
            });
        });
    };
        self.getPackagePreviousStatus = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.previous || mmCoreNotDownloaded;
        }).catch(function() {
            return mmCoreNotDownloaded;
        });
    };
        self.getPackageCurrentStatus = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.status || mmCoreNotDownloaded;
        }).catch(function() {
            return mmCoreNotDownloaded;
        });
    };
        self.getPackageStatus = function(siteId, component, componentId, revision, timemodified) {
        revision = revision || 0;
        timemodified = timemodified || 0;
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (entry.status === mmCoreDownloaded) {
                    if (revision != entry.revision || timemodified > entry.timemodified) {
                        entry.status = mmCoreOutdated;
                        entry.updated = new Date().getTime();
                        db.insert(mmFilepoolPackagesStore, entry).then(function() {
                            self._triggerPackageStatusChanged(siteId, component, componentId, mmCoreOutdated);
                        });
                    }
                } else if (entry.status === mmCoreOutdated) {
                    if (revision === entry.revision && timemodified === entry.timemodified) {
                        entry.status = mmCoreDownloaded;
                        entry.updated = new Date().getTime();
                        db.insert(mmFilepoolPackagesStore, entry).then(function() {
                            self._triggerPackageStatusChanged(siteId, component, componentId, mmCoreDownloaded);
                        });
                    }
                }
                return entry.status;
            }, function() {
                return mmCoreNotDownloaded;
            });
        });
    };
        self.getPackageRevision = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.revision;
        });
    };
        self.getPackageTimemodified = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.timemodified;
        }).catch(function() {
            return -1;
        });
    };
        self._getQueueDeferred = function(siteId, fileId, create) {
        if (typeof create == 'undefined') {
            create = true;
        }
        if (!queueDeferreds[siteId]) {
            if (!create) {
                return;
            }
            queueDeferreds[siteId] = {};
        }
        if (!queueDeferreds[siteId][fileId]) {
            if (!create) {
                return;
            }
            queueDeferreds[siteId][fileId] = $q.defer();
        }
        return queueDeferreds[siteId][fileId];
    };
        self._getQueuePromise = function(siteId, fileId, create) {
        return self._getQueueDeferred(siteId, fileId, create).promise;
    };
        self._hasFileInPool = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                if (typeof fileObject === 'undefined') {
                    return $q.reject();
                }
                return fileObject;
            });
        });
    };
        self._hasFileInQueue = function(siteId, fileId) {
        return $mmApp.getDB().get(mmFilepoolQueueStore, [siteId, fileId]).then(function(fileObject) {
            if (typeof fileObject === 'undefined') {
                return $q.reject();
            }
            return fileObject;
        });
    };
        self.getDirectoryUrlByUrl = function(siteId, fileUrl) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                var fileId = self._getFileIdByUrl(fileUrl);
                return $mmFS.getDir(self._getFilePath(siteId, fileId, false)).then(function(dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
        self._getFileIdByUrl = function(fileUrl) {
        var url = self._removeRevisionFromUrl(fileUrl),
            filename;
        url = $mmText.decodeHTML($mmText.decodeURIComponent(url));
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            angular.forEach(urlAttributes, function(regex) {
                url = url.replace(regex, '');
            });
        }
        filename = self._guessFilenameFromUrl(url);
        return filename + '_' + md5.createHash('url:' + url);
    };
        self._getNonReadableFileIdByUrl = function(fileUrl) {
        var url = self._removeRevisionFromUrl(fileUrl),
            candidate,
            extension = '';
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            angular.forEach(urlAttributes, function(regex) {
                url = url.replace(regex, '');
            });
            candidate = $mmFS.guessExtensionFromUrl(url);
            if (candidate && candidate !== 'php') {
                extension = '.' + candidate;
            }
        }
        return md5.createHash('url:' + url) + extension;
    };
        self._getFileUrlByUrl = function(siteId, fileUrl, mode, component, componentId, timemodified, checkSize, downloadUnknown) {
        var fileId,
            revision;
        if (typeof checkSize == 'undefined') {
            checkSize = true;
        }
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
            fileUrl = fixedUrl;
            timemodified = timemodified || 0;
            revision = self.getRevisionFromUrl(fileUrl);
            fileId = self._getFileIdByUrl(fileUrl);
            return self._restoreOldFileIfNeeded(siteId, fileId, fileUrl);
        }).then(function() {
            return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                var response,
                    fn;
                if (typeof fileObject === 'undefined') {
                    addToQueueIfNeeded();
                    response = fileUrl;
                } else if (self._isFileOutdated(fileObject, revision, timemodified) && $mmApp.isOnline()) {
                    addToQueueIfNeeded();
                    response = fileUrl;
                } else {
                    if (mode === 'src') {
                        fn = self._getInternalSrcById;
                    } else {
                        fn = self._getInternalUrlById;
                    }
                    response = fn(siteId, fileId).then(function(internalUrl) {
                        return internalUrl;
                    }, function() {
                        $log.debug('File ' + fileId + ' not found on disk');
                        self._removeFileById(siteId, fileId);
                        addToQueueIfNeeded();
                        if ($mmApp.isOnline()) {
                            return fileUrl;
                        }
                        return $q.reject();
                    });
                }
                return response;
            }, function() {
                addToQueueIfNeeded();
                return fileUrl;
            });
        });
        function addToQueueIfNeeded() {
            var promise;
            if (checkSize) {
                if (!$mmApp.isOnline()) {
                    return;
                }
                if (typeof sizeCache[fileUrl] != 'undefined') {
                    promise = $q.when(sizeCache[fileUrl]);
                } else {
                    promise = $mmWS.getRemoteFileSize(fileUrl);
                }
                promise.then(function(size) {
                    var isWifi = !$mmApp.isNetworkAccessLimited(),
                        sizeUnknown = size <= 0;
                    if (!sizeUnknown) {
                        sizeCache[fileUrl] = size;
                    }
                    if (sizeUnknown) {
                        if (downloadUnknown && isWifi) {
                            self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified);
                        }
                    } else if (size <= mmFilepoolDownloadThreshold || (isWifi && size <= mmFilepoolWifiDownloadThreshold)) {
                        self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified);
                    }
                });
            } else {
                self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified);
            }
        }
    };
        self.getFilepoolFolderPath = function(siteId) {
        return $mmFS.getSiteFolder(siteId) + '/' + mmFilepoolFolder;
    };
        self._getFilePath = function(siteId, fileId, extension) {
        var path = $mmFS.getSiteFolder(siteId) + '/' + mmFilepoolFolder + '/' + fileId;
        if (typeof extension == 'undefined') {
            return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                if (fileObject.extension) {
                    path += '.' + fileObject.extension;
                }
                return path;
            }).catch(function() {
                return path;
            });
        } else {
            if (extension) {
                path += '.' + extension;
            }
            return path;
        }
    };
        self.getFilePathByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._getFilePath(siteId, fileId);
        });
    };
    function getComponentFiles(db, component, componentId) {
        var fieldName, where;
        if (typeof componentId !== 'undefined') {
            fieldName = 'componentAndId';
            where = [component, self._fixComponentId(componentId)];
        } else {
            fieldName = 'component';
            where = component;
        }
        return db.whereEqual(mmFilepoolLinksStore, fieldName, where);
    }
        self.getFilesByComponent = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId).then(function(items) {
                var promises = [],
                    files = [];
                angular.forEach(items, function(item) {
                    promises.push(db.get(mmFilepoolStore, item.fileId).then(function(fileEntry) {
                        if (!fileEntry) {
                            return;
                        }
                        files.push({
                            url: fileEntry.url,
                            path: fileEntry.path,
                            extension: fileEntry.extension,
                            revision: fileEntry.revision,
                            timemodified: fileEntry.timemodified
                        });
                    }));
                });
                return $q.all(promises).then(function() {
                    return files;
                });
            });
        });
    };
        self.getFilesSizeByComponent = function(siteId, component, componentId) {
        return self.getFilesByComponent(siteId, component, componentId).then(function(files) {
            var promises = [],
                size = 0;
            angular.forEach(files, function(file) {
                promises.push($mmFS.getFileSize(file.path).then(function(fs) {
                    size += fs;
                }).catch(function() {
                }));
            });
            return $q.all(promises).then(function() {
                return size;
            });
        });
    };
        self.getFileStateByUrl = function(siteId, fileUrl, timemodified, filePath) {
        var fileId,
            revision;
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
            fileUrl = fixedUrl;
            timemodified = timemodified || 0;
            revision = self.getRevisionFromUrl(fileUrl);
            fileId = self._getFileIdByUrl(fileUrl);
            return self._restoreOldFileIfNeeded(siteId, fileId, fileUrl);
        }).then(function() {
            return self._hasFileInQueue(siteId, fileId).then(function() {
                return mmCoreDownloading;
            }, function() {
                var extension = $mmFS.guessExtensionFromUrl(fileUrl),
                    pathPromise = filePath ? filePath : self._getFilePath(siteId, fileId, extension);
                return $q.when(pathPromise).then(function(filePath) {
                    var downloadId = self.getFileDownloadId(fileUrl, filePath);
                    if (filePromises[siteId] && filePromises[siteId][downloadId]) {
                        return mmCoreDownloading;
                    }
                    return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                        if (self._isFileOutdated(fileObject, revision, timemodified)) {
                            return mmCoreOutdated;
                        } else {
                            return mmCoreDownloaded;
                        }
                    }, function() {
                        return mmCoreNotDownloaded;
                    });
                });
            });
        });
    };
        self._getInternalSrcById = function(siteId, fileId) {
        if ($mmFS.isAvailable()) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                return $mmFS.getFile(path).then(function(fileEntry) {
                    return $mmFS.getInternalURL(fileEntry);
                });
            });
        }
        return $q.reject();
    };
        self._getInternalUrlById = function(siteId, fileId) {
        if ($mmFS.isAvailable()) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                return $mmFS.getFile(path).then(function(fileEntry) {
                    return fileEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
        self._getInternalUrlByPath = function(filePath) {
        if ($mmFS.isAvailable()) {
            return $mmFS.getFile(filePath).then(function(fileEntry) {
                return fileEntry.toURL();
            });
        }
        return $q.reject();
    };
        self.getInternalUrlByUrl = function(siteId, fileUrl) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                var fileId = self._getFileIdByUrl(fileUrl);
                return self._getInternalUrlById(siteId, fileId);
            });
        }
        return $q.reject();
    };
        self.getPackageDirPathByUrl = function(siteId, url) {
        return self._fixPluginfileURL(siteId, url).then(function(fixedUrl) {
            var fileId = self._getNonReadableFileIdByUrl(fixedUrl);
            return self._getFilePath(siteId, fileId, false);
        });
    };
        self.getPackageDirUrlByUrl = function(siteId, url) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, url).then(function(fixedUrl) {
                var fileId = self._getNonReadableFileIdByUrl(fixedUrl);
                return $mmFS.getDir(self._getFilePath(siteId, fileId, false)).then(function(dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
        self.getRevisionFromFileList = function(files) {
        var revision = 0;
        angular.forEach(files, function(file) {
            if (file.fileurl) {
                var r = self.getRevisionFromUrl(file.fileurl);
                if (r > revision) {
                    revision = r;
                }
            }
        });
        return revision;
    };
        self.getRevisionFromUrl = function(url) {
        var matches = url.match(revisionRegex);
        if (matches && typeof matches[1] != 'undefined') {
            return parseInt(matches[1]);
        }
    };
        self.getSrcByUrl = function(siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown) {
        return self._getFileUrlByUrl(siteId, fileUrl, 'src', component, componentId, timemodified, checkSize, downloadUnknown);
    };
        self.getTimemodifiedFromFileList = function(files) {
        var timemod = 0;
        angular.forEach(files, function(file) {
            if (file.timemodified > timemod) {
                timemod = file.timemodified;
            }
        });
        return timemod;
    };
        self.getUrlByUrl = function(siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown) {
        return self._getFileUrlByUrl(siteId, fileUrl, 'url', component, componentId, timemodified, checkSize, downloadUnknown);
    };
        self._guessFilenameFromUrl = function(fileUrl) {
        var filename = '';
        if (fileUrl.indexOf('/webservice/pluginfile') !== -1) {
            var params = $mmUtil.extractUrlParams(fileUrl);
            if (params.file) {
                filename = params.file.substr(params.file.lastIndexOf('/') + 1);
            } else {
                filename = $mmText.getLastFileWithoutParams(fileUrl);
            }
        } else if ($mmUtil.isGravatarUrl(fileUrl)) {
            filename = 'gravatar_' + $mmText.getLastFileWithoutParams(fileUrl);
        } else if ($mmUtil.isThemeImageUrl(fileUrl)) {
            var matches = fileUrl.match(/clean\/core\/([^\/]*)\//);
            if (matches && matches[1]) {
                filename = matches[1];
            }
            filename = 'default_' + filename + '_' + $mmText.getLastFileWithoutParams(fileUrl);
        } else {
            filename = $mmText.getLastFileWithoutParams(fileUrl);
        }
        filename = $mmFS.removeExtension(filename);
        return $mmText.removeSpecialCharactersForFiles(filename);
    };
        self.invalidateAllFiles = function(siteId) {
        return getSiteDb(siteId).then(function(db) {
            return db.getAll(mmFilepoolStore).then(function(items) {
                var promises = [];
                angular.forEach(items, function(item) {
                    item.stale = true;
                    promises.push(db.insert(mmFilepoolStore, item));
                });
                return $q.all(promises);
            });
        });
    };
        self.invalidateFileByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return getSiteDb(siteId).then(function(db) {
                return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                    if (!fileObject) {
                        return;
                    }
                    fileObject.stale = true;
                    return db.insert(mmFilepoolStore, fileObject);
                });
            });
        });
    };
        self.invalidateFilesByComponent = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId).then(function(items) {
                var promise,
                    promises = [];
                angular.forEach(items, function(item) {
                    promise = db.get(mmFilepoolStore, item.fileId).then(function(fileEntry) {
                        if (!fileEntry) {
                            return;
                        }
                        fileEntry.stale = true;
                        return db.insert(mmFilepoolStore, fileEntry);
                    });
                    promises.push(promise);
                });
                return $q.all(promises);
            });
        });
    };
        self.isFileDownloadingByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            fileId = self._getFileIdByUrl(fileUrl);
            return self._hasFileInQueue(siteId, fileId);
        });
    };
        self._isFileOutdated = function(fileObject, revision, timemodified) {
        return fileObject.stale || revision > fileObject.revision || timemodified > fileObject.timemodified;
    };
        self._notifyFileDeleted = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'deleted'});
    };
        self._notifyFileDownloaded = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'download', success: true});
    };
        self._notifyFileDownloadError = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'download', success: false});
    };
        self._notifyFileDownloading = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'downloading'});
    };
        self._notifyFileOutdated = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'outdated'});
    };
        self.prefetchPackage = function(siteId, fileList, component, componentId, revision, timemodified, dirPath) {
        return self._downloadOrPrefetchPackage(siteId, fileList, true, component, componentId, revision, timemodified, dirPath);
    };
        self._processQueue = function() {
        var deferred = $q.defer(),
            promise;
        if (queueState !== QUEUE_RUNNING) {
            deferred.reject(ERR_QUEUE_ON_PAUSE);
            promise = deferred.promise;
        } else if (!$mmFS.isAvailable() || !$mmApp.isOnline()) {
            deferred.reject(ERR_FS_OR_NETWORK_UNAVAILABLE);
            promise = deferred.promise;
        } else {
            promise = self._processImportantQueueItem();
        }
        promise.then(function() {
            $timeout(self._processQueue, mmFilepoolQueueProcessInterval);
        }, function(error) {
            if (error === ERR_FS_OR_NETWORK_UNAVAILABLE) {
                $log.debug('Filesysem or network unavailable, pausing queue processing.');
            } else if (error === ERR_QUEUE_IS_EMPTY) {
                $log.debug('Queue is empty, pausing queue processing.');
                $mmEvents.trigger(mmCoreEventQueueEmpty);
            }
            queueState = QUEUE_PAUSED;
        });
    };
        self._processImportantQueueItem = function() {
        return $mmApp.getDB().query(mmFilepoolQueueStore, undefined, 'sortorder', undefined, 1)
        .then(function(items) {
            var item = items.pop();
            if (!item) {
                return $q.reject(ERR_QUEUE_IS_EMPTY);
            }
            return self._processQueueItem(item);
        }, function() {
            return $q.reject(ERR_QUEUE_IS_EMPTY);
        });
    };
        self._processQueueItem = function(item) {
        var siteId = item.siteId,
            fileId = item.fileId,
            fileUrl = item.url,
            revision = item.revision,
            timemodified = item.timemodified,
            filePath = item.path,
            links = item.links || [];
        $log.debug('Processing queue item: ' + siteId + ', ' + fileId);
        return getSiteDb(siteId).then(function(db) {
            return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                if (fileObject && !self._isFileOutdated(fileObject, revision, timemodified)) {
                    $log.debug('Queued file already in store, ignoring...');
                    self._addFileLinks(siteId, fileId, links);
                    self._removeFromQueue(siteId, fileId).finally(function() {
                        self._treatQueueDeferred(siteId, fileId, true);
                    });
                    self._notifyFileDownloaded(siteId, fileId);
                    return;
                }
                return download(siteId, fileUrl, fileObject, links);
            }, function() {
                return download(siteId, fileUrl, undefined, links);
            });
        }, function() {
            $log.debug('Item dropped from queue due to site DB not retrieved: ' + fileUrl);
            return self._removeFromQueue(siteId, fileId).catch(function() {}).finally(function() {
                self._treatQueueDeferred(siteId, fileId, false);
                self._notifyFileDownloadError(siteId, fileId);
            });
        });
                function download(siteId, fileUrl, fileObject, links) {
            return self._restoreOldFileIfNeeded(siteId, fileId, fileUrl, filePath).then(function() {
                return self._downloadForPoolByUrl(siteId, fileUrl, revision, timemodified, filePath, fileObject).then(function() {
                    var promise;
                    self._addFileLinks(siteId, fileId, links);
                    promise = self._removeFromQueue(siteId, fileId);
                    self._treatQueueDeferred(siteId, fileId, true);
                    self._notifyFileDownloaded(siteId, fileId);
                    return promise.catch(function() {});
                }, function(errorObject) {
                    var dropFromQueue = false;
                    if (typeof errorObject !== 'undefined' && errorObject.source === fileUrl) {
                        if (errorObject.code === 1) {
                            dropFromQueue = true;
                        } else if (errorObject.code === 2) {
                            dropFromQueue = true;
                        } else if (errorObject.code === 3) {
                            dropFromQueue = true;
                        } else if (errorObject.code === 4) {
                        } else if (errorObject.code === 5) {
                            dropFromQueue = true;
                        } else {
                            dropFromQueue = true;
                        }
                    } else {
                        dropFromQueue = true;
                    }
                    if (dropFromQueue) {
                        var promise;
                        $log.debug('Item dropped from queue due to error: ' + fileUrl);
                        promise = self._removeFromQueue(siteId, fileId);
                        return promise.catch(function() {}).finally(function() {
                            self._treatQueueDeferred(siteId, fileId, false);
                            self._notifyFileDownloadError(siteId, fileId);
                        });
                    } else {
                        self._treatQueueDeferred(siteId, fileId, false);
                        self._notifyFileDownloadError(siteId, fileId);
                        return $q.reject();
                    }
                }, function(progress) {
                    if (queueDeferreds[siteId] && queueDeferreds[siteId][fileId]) {
                        queueDeferreds[siteId][fileId].notify(progress);
                    }
                });
            });
        }
    };
        self._removeFromQueue = function(siteId, fileId) {
        return $mmApp.getDB().remove(mmFilepoolQueueStore, [siteId, fileId]);
    };
        self._removeFileById = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                var promises = [];
                promises.push(db.remove(mmFilepoolStore, fileId));
                promises.push(db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId).then(function(entries) {
                    return $q.all(entries.map(function(entry) {
                        return db.remove(mmFilepoolLinksStore, [entry.fileId, entry.component, entry.componentId]);
                    }));
                }));
                if ($mmFS.isAvailable()) {
                    promises.push($mmFS.removeFile(path).catch(function(error) {
                        if (error && error.code == 1) {
                        } else {
                            return $q.reject(error);
                        }
                    }));
                }
                return $q.all(promises).then(function() {
                    self._notifyFileDeleted(siteId, fileId);
                });
            });
        });
    };
        self.removeFilesByComponent = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId);
        }).then(function(items) {
            return $q.all(items.map(function(item) {
                return self._removeFileById(siteId, item.fileId);
            }));
        });
    };
        self.removeFileByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._restoreOldFileIfNeeded(siteId, fileId, fileUrl).then(function() {
                return self._removeFileById(siteId, fileId);
            });
        });
    };
        self._removeRevisionFromUrl = function(url) {
        return url.replace(revisionRegex, '/content/0/');
    };
        self._fillExtensionInFile = function(fileObject, siteId) {
        var extension;
        if (typeof fileObject.extension != 'undefined') {
            return;
        }
        return getSiteDb(siteId).then(function(db) {
            extension = $mmFS.getFileExtension(fileObject.path);
            if (!extension) {
                fileObject.stale = true;
                $log.debug('Staled file with no extension ' + fileObject.fileId);
                return db.insert(mmFilepoolStore, fileObject);
            }
            var fileId = fileObject.fileId;
            fileObject.fileId = $mmFS.removeExtension(fileId);
            fileObject.extension = extension;
            return db.insert(mmFilepoolStore, fileObject).then(function() {
                if (fileObject.fileId == fileId) {
                    $log.debug('Removed extesion ' + extension + ' from file ' + fileObject.fileId);
                    return $q.when();
                }
                return db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId).then(function(entries) {
                    return $q.all(entries.map(function(linkEntry) {
                        linkEntry.fileId = fileObject.fileId;
                        return db.insert(mmFilepoolLinksStore, linkEntry).then(function() {
                            $log.debug('Removed extesion ' + extension + ' from file links ' + linkEntry.fileId);
                            return db.remove(mmFilepoolLinksStore, [fileId, linkEntry.component, linkEntry.componentId]);
                        });
                    }));
                }).finally(function() {
                    $log.debug('Removed extesion ' + extension + ' from file ' + fileObject.fileId);
                    return db.remove(mmFilepoolStore, fileId);
                });
            });
        });
    };
        self.fillMissingExtensionInFiles = function(siteId) {
        $log.debug('Fill missing extensions in files of ' + siteId);
        return getSiteDb(siteId).then(function(db) {
            return db.getAll(mmFilepoolStore).then(function(fileObjects) {
                var promises = [];
                angular.forEach(fileObjects, function(fileObject) {
                    promises.push(self._fillExtensionInFile(fileObject, siteId));
                });
                return $q.all(promises);
            });
        });
    };
        self.treatExtensionInQueue = function() {
        var appDB;
        $log.debug('Treat extensions in queue');
        appDB = $mmApp.getDB();
        return appDB.getAll(mmFilepoolQueueStore).then(function(fileObjects) {
            var promises = [];
            angular.forEach(fileObjects, function(fileObject) {
                var fileId = fileObject.fileId;
                fileObject.fileId = $mmFS.removeExtension(fileId);
                if (fileId == fileObject.fileId) {
                    return;
                }
                promises.push(appDB.insert(mmFilepoolQueueStore, fileObject).then(function() {
                    $log.debug('Removed extesion from queued file ' + fileObject.fileId);
                    return self._removeFromQueue(fileObject.siteId, fileId);
                }));
            });
            return $q.all(promises);
        });
    };
        self._restoreOldFileIfNeeded = function(siteId, fileId, fileUrl, filePath) {
        var fileObject,
            oldFileId = self._getNonReadableFileIdByUrl(fileUrl);
        if (fileId == oldFileId) {
            return $q.when();
        }
        return self._hasFileInPool(siteId, fileId).catch(function() {
            return self._hasFileInPool(siteId, oldFileId).then(function(entry) {
                fileObject = entry;
                if (filePath) {
                    return $q.when();
                } else {
                    return self._getFilePath(siteId, oldFileId).then(function(oldPath) {
                        return self._getFilePath(siteId, fileId).then(function(newPath) {
                            return $mmFS.copyFile(oldPath, newPath);
                        });
                    });
                }
            }).then(function() {
                return self._addFileToPool(siteId, fileId, fileObject);
            }).then(function() {
                return self._getFileLinks(siteId, fileId).then(function(links) {
                    var promises = [];
                    angular.forEach(links, function(link) {
                        promises.push(self._addFileLink(siteId, fileId, link.component, link.componentId));
                    });
                    return $q.all(promises);
                });
            }).then(function() {
                return self._removeFileById(siteId, oldFileId);
            }).catch(function() {
            });
        });
    };
        self.setPackagePreviousStatus = function(siteId, component, componentId) {
        $log.debug('Set previous status for package ' + component + ' ' + componentId);
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (entry.status == mmCoreDownloading) {
                    entry.downloadtime = entry.previousdownloadtime;
                }
                entry.status = entry.previous || mmCoreNotDownloaded;
                entry.updated = new Date().getTime();
                $log.debug('Set status \'' + entry.status + '\' for package ' + component + ' ' + componentId);
                return db.insert(mmFilepoolPackagesStore, entry).then(function() {
                    self._triggerPackageStatusChanged(siteId, component, componentId, entry.status);
                    return entry.status;
                });
            });
        });
    };
        self.shouldDownloadBeforeOpen = function(url, size) {
        if (size >= 0 && size <= mmFilepoolDownloadThreshold) {
            return $q.when();
        }
        return $mmUtil.getMimeType(url).then(function(mimetype) {
            if (mimetype.indexOf('video') != -1 || mimetype.indexOf('audio') != -1) {
                return $q.reject();
            }
        });
    };
        self.storePackageStatus = function(siteId, component, componentId, status, revision, timemodified) {
        $log.debug('Set status \'' + status + '\' for package ' + component + ' ' + componentId);
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId),
                downloadTime,
                previousDownloadTime;
            if (status == mmCoreDownloading) {
                downloadTime = $mmUtil.timestamp();
            }
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (typeof revision == 'undefined') {
                    revision = entry.revision;
                }
                if (typeof timemodified == 'undefined') {
                    timemodified = entry.timemodified;
                }
                if (typeof downloadTime == 'undefined') {
                    downloadTime = entry.downloadtime;
                    previousDownloadTime = entry.previousdownloadtime;
                } else {
                    previousDownloadTime = entry.downloadTime;
                }
                return entry.status;
            }).catch(function() {
                return undefined;
            }).then(function(previousStatus) {
                revision = revision || 0;
                timemodified = timemodified || 0;
                var promise;
                if (previousStatus === status) {
                    promise = $q.when();
                } else {
                    promise = db.insert(mmFilepoolPackagesStore, {
                        id: packageId,
                        component: component,
                        componentId: componentId,
                        status: status,
                        previous: previousStatus,
                        revision: revision,
                        timemodified: timemodified,
                        updated: new Date().getTime(),
                        downloadtime: downloadTime,
                        previousdownloadtime: previousDownloadTime
                    });
                }
                return promise.then(function() {
                    self._triggerPackageStatusChanged(siteId, component, componentId, status);
                });
            });
        });
    };
        self._treatQueueDeferred = function(siteId, fileId, resolve) {
        if (queueDeferreds[siteId] && queueDeferreds[siteId][fileId]) {
            if (resolve) {
                queueDeferreds[siteId][fileId].resolve();
            } else {
                queueDeferreds[siteId][fileId].reject();
            }
            delete queueDeferreds[siteId][fileId];
        }
    };
        self._triggerPackageStatusChanged = function(siteId, component, componentId, status) {
        var data = {
            siteid: siteId,
            component: component,
            componentId: self._fixComponentId(componentId),
            status: status
        };
        $mmEvents.trigger(mmCoreEventPackageStatusChanged, data);
    };
    return self;
}])
.run(["$ionicPlatform", "$timeout", "$mmFilepool", "$mmEvents", "mmCoreEventOnlineStatusChanged", function($ionicPlatform, $timeout, $mmFilepool, $mmEvents, mmCoreEventOnlineStatusChanged) {
    $ionicPlatform.ready(function() {
        $timeout($mmFilepool.checkQueueProcessing, 1000);
        $mmEvents.on(mmCoreEventOnlineStatusChanged, function(online) {
            if (online) {
                $mmFilepool.checkQueueProcessing();
            }
        });
    });
}]);

angular.module('mm.core')
.constant('mmFsSitesFolder', 'sites')
.constant('mmFsTmpFolder', 'tmp')
.factory('$mmFS', ["$ionicPlatform", "$cordovaFile", "$log", "$q", "$http", "$cordovaZip", "$mmText", "mmFsSitesFolder", "mmFsTmpFolder", function($ionicPlatform, $cordovaFile, $log, $q, $http, $cordovaZip, $mmText, mmFsSitesFolder, mmFsTmpFolder) {
    $log = $log.getInstance('$mmFS');
    var self = {},
        initialized = false,
        basePath = '',
        isHTMLAPI = false,
        extToMime = {},
        mimeToExt = {},
        extensionRegex = new RegExp('^[a-z0-9]+$');
    $http.get('core/assets/mimetypes.json').then(function(response) {
        extToMime = response.data;
    }, function() {
    });
    $http.get('core/assets/mimetoext.json').then(function(response) {
        mimeToExt = response.data;
    }, function() {
    });
    self.FORMATTEXT         = 0;
    self.FORMATDATAURL      = 1;
    self.FORMATBINARYSTRING = 2;
    self.FORMATARRAYBUFFER  = 3;
        self.setHTMLBasePath = function(path) {
        isHTMLAPI = true;
        basePath = path;
    };
        self.usesHTMLAPI = function() {
        return isHTMLAPI;
    };
        self.init = function() {
        var deferred = $q.defer();
        if (initialized) {
            deferred.resolve();
            return deferred.promise;
        }
        $ionicPlatform.ready(function() {
            if (ionic.Platform.isAndroid()) {
                basePath = cordova.file.externalApplicationStorageDirectory;
            } else if (ionic.Platform.isIOS()) {
                basePath = cordova.file.documentsDirectory;
            } else if (!self.isAvailable() || basePath === '') {
                $log.error('Error getting device OS.');
                deferred.reject();
                return;
            }
            initialized = true;
            $log.debug('FS initialized: '+basePath);
            deferred.resolve();
        });
        return deferred.promise;
    };
        self.isAvailable = function() {
        return typeof window.resolveLocalFileSystemURL !== 'undefined' && typeof FileTransfer !== 'undefined';
    };
        self.getFile = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Get file: ' + path);
            return $cordovaFile.checkFile(basePath, path);
        });
    };
        self.getDir = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Get directory: '+path);
            return $cordovaFile.checkDir(basePath, path);
        });
    };
        self.getSiteFolder = function(siteId) {
        return mmFsSitesFolder + '/' + siteId;
    };
        function create(isDirectory, path, failIfExists, base) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            base = base || basePath;
            if (path.indexOf('/') == -1) {
                if (isDirectory) {
                    $log.debug('Create dir ' + path + ' in ' + base);
                    return $cordovaFile.createDir(base, path, !failIfExists);
                } else {
                    $log.debug('Create file ' + path + ' in ' + base);
                    return $cordovaFile.createFile(base, path, !failIfExists);
                }
            } else {
                var firstDir = path.substr(0, path.indexOf('/'));
                var restOfPath = path.substr(path.indexOf('/') + 1);
                $log.debug('Create dir ' + firstDir + ' in ' + base);
                return $cordovaFile.createDir(base, firstDir, true).then(function(newDirEntry) {
                    return create(isDirectory, restOfPath, failIfExists, newDirEntry.toURL());
                }, function(error) {
                    $log.error('Error creating directory ' + firstDir + ' in ' + base);
                    return $q.reject(error);
                });
            }
        });
    }
        self.createDir = function(path, failIfExists) {
        failIfExists = failIfExists || false;
        return create(true, path, failIfExists);
    };
        self.createFile = function(path, failIfExists) {
        failIfExists = failIfExists || false;
        return create(false, path, failIfExists);
    };
        self.removeDir = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Remove directory: ' + path);
            return $cordovaFile.removeRecursively(basePath, path);
        });
    };
        self.removeFile = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Remove file: ' + path);
            return $cordovaFile.removeFile(basePath, path);
        });
    };
        self.removeFileByFileEntry = function(fileEntry) {
        var deferred = $q.defer();
        fileEntry.remove(deferred.resolve, deferred.reject);
        return deferred.promise;
    };
        self.getDirectoryContents = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get contents of dir: ' + path);
        return self.getDir(path).then(function(dirEntry) {
            var deferred = $q.defer();
            var directoryReader = dirEntry.createReader();
            directoryReader.readEntries(deferred.resolve, deferred.reject);
            return deferred.promise;
        });
    };
        function getSize(entry) {
        var deferred = $q.defer();
        if (entry.isDirectory) {
            var directoryReader = entry.createReader();
            directoryReader.readEntries(function(entries) {
                var promises = [];
                for (var i = 0; i < entries.length; i++) {
                    promises.push(getSize(entries[i]));
                }
                $q.all(promises).then(function(sizes) {
                    var directorySize = 0;
                    for (var i = 0; i < sizes.length; i++) {
                        var fileSize = parseInt(sizes[i]);
                        if (isNaN(fileSize)) {
                            deferred.reject();
                            return;
                        }
                        directorySize += fileSize;
                    }
                    deferred.resolve(directorySize);
                }, deferred.reject);
            }, deferred.reject);
        } else if (entry.isFile) {
            entry.file(function(file) {
                deferred.resolve(file.size);
            }, deferred.reject);
        }
        return deferred.promise;
    }
        self.getDirectorySize = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get size of dir: ' + path);
        return self.getDir(path).then(function(dirEntry) {
           return getSize(dirEntry);
        });
    };
        self.getFileSize = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get size of file: ' + path);
        return self.getFile(path).then(function(fileEntry) {
           return getSize(fileEntry);
        });
    };
        self.getFileObjectFromFileEntry = function(entry) {
        $log.debug('Get file object of: ' + entry.fullPath);
        var deferred = $q.defer();
        entry.file(function(file) {
            deferred.resolve(file);
        }, deferred.reject);
        return deferred.promise;
    };
        self.calculateFreeSpace = function() {
        if (ionic.Platform.isIOS() || isHTMLAPI) {
            if (window.requestFileSystem) {
                var iterations = 0,
                    maxIterations = 50,
                    deferred = $q.defer();
                function calculateByRequest(size, ratio) {
                    var deferred = $q.defer();
                    window.requestFileSystem(LocalFileSystem.PERSISTENT, size, function() {
                        iterations++;
                        if (iterations > maxIterations) {
                            deferred.resolve(size);
                            return;
                        }
                        calculateByRequest(size * ratio, ratio).then(deferred.resolve);
                    }, function() {
                        deferred.resolve(size / ratio);
                    });
                    return deferred.promise;
                }
                calculateByRequest(1048576, 1.3).then(function(size) {
                    iterations = 0;
                    maxIterations = 10;
                    calculateByRequest(size, 1.1).then(deferred.resolve);
                });
                return deferred.promise;
            } else {
                return $q.reject();
            }
        } else {
            return $cordovaFile.getFreeDiskSpace().then(function(size) {
                return size * 1024;
            });
        }
    };
        self.normalizeFileName = function(filename) {
        filename = $mmText.decodeURIComponent(filename);
        return filename;
    };
        self.readFile = function(path, format) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        format = format || self.FORMATTEXT;
        $log.debug('Read file ' + path + ' with format '+format);
        switch (format) {
            case self.FORMATDATAURL:
                return $cordovaFile.readAsDataURL(basePath, path);
            case self.FORMATBINARYSTRING:
                return $cordovaFile.readAsBinaryString(basePath, path);
            case self.FORMATARRAYBUFFER:
                return $cordovaFile.readAsArrayBuffer(basePath, path);
            default:
                return $cordovaFile.readAsText(basePath, path);
        }
    };
        self.readFileData = function(fileData, format) {
        format = format || self.FORMATTEXT;
        $log.debug('Read file from file data with format '+format);
        var deferred = $q.defer();
        var reader = new FileReader();
        reader.onloadend = function(evt) {
            if (evt.target.result !== undefined || evt.target.result !== null) {
                deferred.resolve(evt.target.result);
            } else if (evt.target.error !== undefined || evt.target.error !== null) {
                deferred.reject(evt.target.error);
            } else {
                deferred.reject({code: null, message: 'READER_ONLOADEND_ERR'});
            }
        };
        switch (format) {
            case self.FORMATDATAURL:
                reader.readAsDataURL(fileData);
                break;
            case self.FORMATBINARYSTRING:
                reader.readAsBinaryString(fileData);
                break;
            case self.FORMATARRAYBUFFER:
                reader.readAsArrayBuffer(fileData);
                break;
            default:
                reader.readAsText(fileData);
        }
        return deferred.promise;
    };
        self.writeFile = function(path, data) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Write file: ' + path);
        return self.init().then(function() {
            return self.createFile(path).then(function(fileEntry) {
                if (isHTMLAPI && typeof data == 'string') {
                    var type = self.getMimeType(self.getFileExtension(path));
                    data = new Blob([data], {type: type || 'text/plain'});
                }
                return $cordovaFile.writeFile(basePath, path, data, true).then(function() {
                    return fileEntry;
                });
            });
        });
    };
        self.getExternalFile = function(fullPath) {
        return $cordovaFile.checkFile(fullPath, '');
    };
        self.removeExternalFile = function(fullPath) {
        var directory = fullPath.substring(0, fullPath.lastIndexOf('/') );
        var filename = fullPath.substr(fullPath.lastIndexOf('/') + 1);
        return $cordovaFile.removeFile(directory, filename);
    };
        self.getBasePath = function() {
        return self.init().then(function() {
            if (basePath.slice(-1) == '/') {
                return basePath;
            } else {
                return basePath + '/';
            }
        });
    };
        self.getBasePathToDownload = function() {
        return self.init().then(function() {
            if (ionic.Platform.isIOS()) {
                return $cordovaFile.checkDir(basePath, '').then(function(dirEntry) {
                    return dirEntry.toInternalURL();
                });
            } else {
                return basePath;
            }
        });
    };
        self.getTmpFolder = function() {
        return mmFsTmpFolder;
    };
        self.moveFile = function(originalPath, newPath) {
        originalPath = self.removeStartingSlash(originalPath.replace(basePath, ''));
        newPath = self.removeStartingSlash(newPath.replace(basePath, ''));
        return self.init().then(function() {
            if (isHTMLAPI) {
                var commonPath = basePath,
                    dirsA = originalPath.split('/'),
                    dirsB = newPath.split('/');
                for (var i = 0; i < dirsA.length; i++) {
                    var dir = dirsA[i];
                    if (dirsB[i] === dir) {
                        dir = dir + '/';
                        commonPath = self.concatenatePaths(commonPath, dir);
                        originalPath = originalPath.replace(dir, '');
                        newPath = newPath.replace(dir, '');
                    } else {
                        break;
                    }
                }
                return $cordovaFile.moveFile(commonPath, originalPath, commonPath, newPath);
            } else {
                return $cordovaFile.moveFile(basePath, originalPath, basePath, newPath);
            }
        });
    };
        self.copyFile = function(from, to) {
        from = self.removeStartingSlash(from.replace(basePath, ''));
        to = self.removeStartingSlash(to.replace(basePath, ''));
        return self.init().then(function() {
            if (isHTMLAPI) {
                var commonPath = basePath,
                    dirsA = from.split('/'),
                    dirsB = to.split('/');
                for (var i = 0; i < dirsA.length; i++) {
                    var dir = dirsA[i];
                    if (dirsB[i] === dir) {
                        dir = dir + '/';
                        commonPath = self.concatenatePaths(commonPath, dir);
                        from = from.replace(dir, '');
                        to = to.replace(dir, '');
                    } else {
                        break;
                    }
                }
                return $cordovaFile.copyFile(commonPath, from, commonPath, to);
            } else {
                var toFile = self.getFileAndDirectoryFromPath(to);
                if (toFile.directory == '') {
                    return $cordovaFile.copyFile(basePath, from, basePath, to);
                } else {
                    return self.createDir(toFile.directory).then(function() {
                        return $cordovaFile.copyFile(basePath, from, basePath, to);
                    });
                }
            }
        });
    };
        self.getFileAndDirectoryFromPath = function(path) {
        var file = {
            directory: '',
            name: ''
        };
        file.directory = path.substring(0, path.lastIndexOf('/') );
        file.name = path.substr(path.lastIndexOf('/') + 1);
        return file;
    };
        self.concatenatePaths = function(leftPath, rightPath) {
        if (!leftPath) {
            return rightPath;
        } else if (!rightPath) {
            return leftPath;
        }
        var lastCharLeft = leftPath.slice(-1),
            firstCharRight = rightPath.charAt(0);
        if (lastCharLeft === '/' && firstCharRight === '/') {
            return leftPath + rightPath.substr(1);
        } else if(lastCharLeft !== '/' && firstCharRight !== '/') {
            return leftPath + '/' + rightPath;
        } else {
            return leftPath + rightPath;
        }
    };
        self.getInternalURL = function(fileEntry) {
        if (isHTMLAPI) {
            return fileEntry.toURL();
        }
        return fileEntry.toInternalURL();
    };
        self.getFileIcon = function(filename) {
        var ext = self.getFileExtension(filename),
            icon = 'unknown';
        if (ext && extToMime[ext]) {
            if (extToMime[ext].icon) {
                icon = extToMime[ext].icon;
            } else {
                var type = extToMime[ext].type.split('/')[0];
                if (type == 'video' || type == 'text' || type == 'image' || type == 'document' || type == 'audio') {
                    icon = type;
                }
            }
        }
        return 'img/files/' + icon + '-64.png';
    };
        self.getFolderIcon = function() {
        return 'img/files/folder-64.png';
    };
        self.getFileExtension = function(filename) {
        var dot = filename.lastIndexOf("."),
            ext;
        if (dot > -1) {
            ext = filename.substr(dot + 1).toLowerCase();
            ext = ext.replace(/_.{32}$/, '');
            if (typeof self.getMimeType(ext) == 'undefined') {
                $log.debug('Get file extension: Not valid extension ' + ext);
                return;
            }
        }
        return ext;
    };
        self.getMimeType = function(extension) {
        if (extToMime[extension] && extToMime[extension].type) {
            return extToMime[extension].type;
        }
    };
        self.guessExtensionFromUrl = function(fileUrl) {
        var split = fileUrl.split('.'),
            candidate,
            extension,
            position;
        if (split.length > 1) {
            candidate = split.pop().toLowerCase();
            position = candidate.indexOf('?');
            if (position > -1) {
                candidate = candidate.substr(0, position);
            }
            if (extensionRegex.test(candidate)) {
                extension = candidate;
            }
        }
        if (extension && typeof self.getMimeType(extension) == 'undefined') {
            $log.debug('Guess file extension: Not valid extension ' + extension);
            return;
        }
        return extension;
    };
        self.getExtension = function(mimetype, url) {
        if (mimetype == 'application/x-forcedownload' || mimetype == 'application/forcedownload') {
            return self.guessExtensionFromUrl(url);
        }
        var extensions = mimeToExt[mimetype];
        if (extensions && extensions.length) {
            if (extensions.length > 1 && url) {
                var candidate = self.guessExtensionFromUrl(url);
                if (extensions.indexOf(candidate) != -1) {
                    return candidate;
                }
            }
            return extensions[0];
        }
        return undefined;
    };
        self.removeExtension = function(path) {
        var extension,
            position = path.lastIndexOf('.');
        if (position > -1) {
            extension = path.substr(position + 1);
            if (typeof self.getMimeType(extension) != 'undefined') {
                return path.substr(0, position);
            }
        }
        return path;
    };
        self.addBasePathIfNeeded = function(path) {
        if (path.indexOf(basePath) > -1) {
            return path;
        } else {
            return self.concatenatePaths(basePath, path);
        }
    };
        self.removeBasePath = function(path) {
        if (path.indexOf(basePath) > -1) {
            return path.replace(basePath, '');
        } else {
            return false;
        }
    };
        self.unzipFile = function(path, destFolder) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.getFile(path).then(function(fileEntry) {
            destFolder = self.addBasePathIfNeeded(destFolder || self.removeExtension(path));
            return $cordovaZip.unzip(fileEntry.toURL(), destFolder);
        });
    };
        self.replaceInFile = function(path, search, newValue) {
        return self.readFile(path).then(function(content) {
            if (typeof content == 'undefined' || content === null || !content.replace) {
                return $q.reject();
            }
            if (content.match(search)) {
                content = content.replace(search, newValue);
                return self.writeFile(path, content);
            }
        });
    };
        self.getMetadata = function(fileEntry) {
        if (!fileEntry || !fileEntry.getMetadata) {
            return $q.reject();
        }
        var deferred = $q.defer();
        fileEntry.getMetadata(deferred.resolve, deferred.reject);
        return deferred.promise;
    };
        self.getMetadataFromPath = function(path, isDir) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        var fn = isDir ? self.getDir : self.getFile;
        return fn(path).then(function(entry) {
            return self.getMetadata(entry);
        });
    };
        self.removeStartingSlash = function(path) {
        if (path[0] == '/') {
            return path.substr(1);
        }
        return path;
    };
        function copyOrMoveExternalFile(from, to, copy) {
        return self.getExternalFile(from).then(function(fileEntry) {
            var dirAndFile = self.getFileAndDirectoryFromPath(to);
            return self.createDir(dirAndFile.directory).then(function(dirEntry) {
                var deferred = $q.defer();
                if (copy) {
                    fileEntry.copyTo(dirEntry, dirAndFile.name, deferred.resolve, deferred.reject);
                } else {
                    fileEntry.moveTo(dirEntry, dirAndFile.name, deferred.resolve, deferred.reject);
                }
                return deferred.promise;
            });
        });
    }
        self.copyExternalFile = function(from, to) {
        return copyOrMoveExternalFile(from, to, true);
    };
        self.moveExternalFile = function(from, to) {
        return copyOrMoveExternalFile(from, to, false);
    };
        self.getUniqueNameInFolder = function(dirPath, fileName, defaultExt) {
        return self.getDirectoryContents(dirPath).then(function(entries) {
            var files = {},
                fileNameWithoutExtension = self.removeExtension(fileName),
                extension = self.getFileExtension(fileName) || defaultExt,
                newName,
                number = 1;
            fileNameWithoutExtension = $mmText.removeSpecialCharactersForFiles($mmText.decodeURIComponent(fileNameWithoutExtension));
            angular.forEach(entries, function(entry) {
                files[entry.name] = entry;
            });
            if (extension) {
                extension = '.' + extension;
            } else {
                extension = '';
            }
            newName = fileNameWithoutExtension + extension;
            if (typeof files[newName] == 'undefined') {
                return newName;
            } else {
                do {
                    newName = fileNameWithoutExtension + '(' + number + ')' + extension;
                    number++;
                } while (typeof files[newName] != 'undefined');
                return newName;
            }
        }).catch(function() {
            return $mmText.removeSpecialCharactersForFiles($mmText.decodeURIComponent(fileName));
        });
    };
        self.clearTmpFolder = function() {
        return self.removeDir(mmFsTmpFolder);
    };
        self.removeUnusedFiles = function(dirPath, files) {
        return self.getDirectoryContents(dirPath).then(function(contents) {
            if (!contents.length) {
                return;
            }
            var filesMap = {},
                promises = [];
            angular.forEach(files, function(file) {
                if (file.fullPath) {
                    filesMap[file.fullPath] = file;
                }
            });
            angular.forEach(contents, function(file) {
                if (!filesMap[file.fullPath]) {
                    promises.push(self.removeFileByFileEntry(file));
                }
            });
            return $q.all(promises);
        }).catch(function() {
        });
    };
    return self;
}]);

angular.module('mm.core')
.factory('$mmGroups', ["$log", "$q", "$mmSite", "$mmSitesManager", function($log, $q, $mmSite, $mmSitesManager) {
    $log = $log.getInstance('$mmGroups');
    var self = {};
    self.NOGROUPS       = 0;
    self.SEPARATEGROUPS = 1;
    self.VISIBLEGROUPS  = 2;
        self.canGetActivityGroupMode = function() {
        return $mmSite.wsAvailable('core_group_get_activity_groupmode');
    };
        self.getActivityAllowedGroups = function(cmId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            var params = {
                    cmid: cmId,
                    userid: userId
                },
                preSets = {
                    cacheKey: getActivityAllowedGroupsCacheKey(cmId, userId)
                };
            return site.read('core_group_get_activity_allowed_groups', params, preSets).then(function(response) {
                if (!response || !response.groups) {
                    return $q.reject();
                }
                return response.groups;
            });
        });
    };
        function getActivityAllowedGroupsCacheKey(cmId, userId) {
        return 'mmGroups:allowedgroups:' + cmId + ':' + userId;
    }
        self.getActivityGroupMode = function(cmId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    cmid: cmId
                },
                preSets = {
                    cacheKey: getActivityGroupModeCacheKey(cmId)
                };
            return site.read('core_group_get_activity_groupmode', params, preSets).then(function(response) {
                if (!response || typeof response.groupmode == 'undefined') {
                    return $q.reject();
                }
                return response.groupmode;
            });
        });
    };
        self.activityHasGroups = function(cmId, siteId) {
        return self.getActivityGroupMode(cmId, siteId).then(function(groupmode) {
            return groupmode === self.SEPARATEGROUPS || groupmode === self.VISIBLEGROUPS;
        }).catch(function() {
            return false;
        });
    };
        self.getActivityAllowedGroupsIfEnabled = function(cmId, userId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.activityHasGroups(cmId, siteId).then(function(hasGroups) {
            if (hasGroups) {
                return self.getActivityAllowedGroups(cmId, userId, siteId);
            }
            return [];
        });
    };
        function getActivityGroupModeCacheKey(cmid) {
        return 'mmGroups:groupmode:' + cmid;
    }
        self.getUserGroups = function(courses, refresh, siteid, userid) {
        var promises = [],
            groups = [],
            deferred = $q.defer();
        angular.forEach(courses, function(course) {
            var courseid;
            if (typeof course == 'object') {
                courseid = course.id;
            } else {
                courseid = course;
            }
            var promise = self.getUserGroupsInCourse(courseid, refresh, siteid, userid).then(function(coursegroups) {
                groups = groups.concat(coursegroups);
            });
            promises.push(promise);
        });
        $q.all(promises).finally(function() {
            deferred.resolve(groups);
        });
        return deferred.promise;
    };
        self.getUserGroupsInCourse = function(courseid, refresh, siteid, userid) {
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var presets = {},
                data = {
                    userid: userid || site.getUserId(),
                    courseid: courseid
                };
            if (refresh) {
                presets.getFromCache = false;
            }
            return site.read('core_group_get_course_user_groups', data, presets).then(function(response) {
                if (response && response.groups) {
                    return response.groups;
                } else {
                    return $q.reject();
                }
            });
        });
    };
        self.invalidateActivityAllowedGroups = function(cmid, userid) {
        userid = userid || $mmSite.getUserId();
        return $mmSite.invalidateWsCacheForKey(getActivityAllowedGroupsCacheKey(cmid, userid));
    };
        self.invalidateActivityGroupMode = function(cmid) {
        return $mmSite.invalidateWsCacheForKey(getActivityGroupModeCacheKey(cmid));
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmInitDelegateDefaultPriority', 100)
.constant('mmInitDelegateMaxAddonPriority', 599)
.provider('$mmInitDelegate', ["mmInitDelegateDefaultPriority", function(mmInitDelegateDefaultPriority) {
    var initProcesses = {},
        self = {};
        self.registerProcess = function(name, callable, priority, blocking) {
        priority = typeof priority === 'undefined' ? mmInitDelegateDefaultPriority : priority;
        if (typeof initProcesses[name] !== 'undefined') {
            console.log('$mmInitDelegateProvider: Process \'' + name + '\' already defined.');
            return;
        }
        console.log('$mmInitDelegateProvider: Registered process \'' + name + '\'.');
        initProcesses[name] = {
            blocking: blocking,
            callable: callable,
            name: name,
            priority: priority
        };
    };
    self.$get = ["$q", "$log", "$injector", "$mmUtil", function($q, $log, $injector, $mmUtil) {
        $log = $log.getInstance('$mmInitDelegate');
        var self = {},
            readiness;
                function prepareProcess(data) {
            return function() {
                var promise,
                    fn;
                $log.debug('Executing init process \'' + data.name + '\'');
                try {
                    fn = $mmUtil.resolveObject(data.callable);
                } catch (e) {
                    $log.error('Could not resolve object of init process \'' + data.name + '\'. ' + e);
                    return;
                }
                try {
                    promise = fn($injector);
                } catch (e) {
                    $log.error('Error while calling the init process \'' + data.name + '\'. ' + e);
                    return;
                }
                return promise;
            };
        }
                self.executeInitProcesses = function() {
            var ordered = [],
                promises = [],
                dependency = $q.when();
            if (typeof readiness === 'undefined') {
                readiness = $q.defer();
            }
            angular.forEach(initProcesses, function(data) {
                ordered.push(data);
            });
            ordered.sort(function(a, b) {
                return b.priority - a.priority;
            });
            angular.forEach(ordered, function(data) {
                var promise;
                promise = dependency.finally(prepareProcess(data));
                promises.push(promise);
                if (data.blocking) {
                    dependency = promise;
                }
            });
            $mmUtil.allPromises(promises).finally(readiness.resolve);
        };
                self.ready = function() {
            if (typeof readiness === 'undefined') {
                readiness = $q.defer();
            }
            return readiness.promise;
        };
        return self;
    }];
    return self;
}]);

angular.module('mm.core')
.factory('$mmLang', ["$translate", "$translatePartialLoader", "$mmConfig", "$cordovaGlobalization", "$q", "mmCoreConfigConstants", function($translate, $translatePartialLoader, $mmConfig, $cordovaGlobalization, $q, mmCoreConfigConstants) {
    var self = {},
        fallbackLanguage = mmCoreConfigConstants.default_lang || 'en',
        currentLanguage,
        customStrings = {},
        customStringsRaw;
        self.changeCurrentLanguage = function(language) {
        var p1 = $translate.use(language),
            p2 = $mmConfig.set('current_language', language);
        moment.locale(language);
        currentLanguage = language;
        return $q.all([p1, p2]);
    };
        self.clearCustomStrings = function() {
        customStrings = {};
        customStringsRaw = '';
    };
        self.getAllCustomStrings = function() {
        return customStrings;
    };
        self.getCurrentLanguage = function() {
        if (typeof currentLanguage != 'undefined') {
            return $q.when(currentLanguage);
        }
        return $mmConfig.get('current_language').then(function(language) {
            return language;
        }, function() {
            if (mmCoreConfigConstants.forcedefaultlanguage && mmCoreConfigConstants.forcedefaultlanguage !== 'false') {
                return mmCoreConfigConstants.default_lang;
            }
            try {
                return $cordovaGlobalization.getPreferredLanguage().then(function(result) {
                    var language = result.value.toLowerCase();
                    if (language.indexOf('-') > -1) {
                        if (mmCoreConfigConstants.languages && typeof mmCoreConfigConstants.languages[language] == 'undefined') {
                            language = language.substr(0, language.indexOf('-'));
                        }
                    }
                    return language;
                }, function() {
                    return fallbackLanguage;
                });
            } catch(err) {
                return fallbackLanguage;
            }
        }).then(function(language) {
            currentLanguage = language;
            return language;
        });
    };
        self.getCustomStrings = function(lang) {
        lang = lang || currentLanguage;
        return customStrings[lang];
    };
        self.loadCustomStrings = function(strings) {
        if (strings == customStringsRaw) {
            return;
        }
        self.clearCustomStrings();
        if (!strings || typeof strings != 'string') {
            return;
        }
        var list = strings.split(/(?:\r\n|\r|\n)/);
        angular.forEach(list, function(entry) {
            var values = entry.split('|'),
                lang;
            if (values.length < 3) {
                return;
            }
            lang = values[2];
            if (!customStrings[lang]) {
                customStrings[lang] = {};
            }
            customStrings[lang][values[0]] = values[1];
        });
    };
        self.registerLanguageFolder = function(path) {
        $translatePartialLoader.addPart(path);
        var promises = [];
        promises.push($translate.refresh(currentLanguage));
        if (currentLanguage !== fallbackLanguage) {
            promises.push($translate.refresh(fallbackLanguage));
        }
        return $q.all(promises);
    };
        self.translateAndReject = function(errorkey, translateParams) {
        return $translate(errorkey, translateParams).then(function(errorMessage) {
            return $q.reject(errorMessage);
        }, function() {
            return $q.reject(errorkey);
        });
    };
        self.translateAndRejectDeferred = function(deferred, errorkey) {
        $translate(errorkey).then(function(errorMessage) {
            deferred.reject(errorMessage);
        }, function() {
            deferred.reject(errorkey);
        });
    };
    return self;
}])
.config(["$translateProvider", "$translatePartialLoaderProvider", "mmCoreConfigConstants", function($translateProvider, $translatePartialLoaderProvider, mmCoreConfigConstants) {
    $translateProvider.useLoader('$translatePartialLoader', {
        urlTemplate: '{part}/{lang}.json'
    });
    $translatePartialLoaderProvider.addPart('build/lang');
    var lang = mmCoreConfigConstants.default_lang || 'en';
    $translateProvider.fallbackLanguage(lang);
    $translateProvider.preferredLanguage(lang);
}])
.config(["$provide", function($provide) {
    $provide.decorator('$translate', ['$delegate', '$q', '$injector', function($delegate, $q, $injector) {
        var $mmLang;
        var newTranslate = function(translationId, interpolateParams, interpolationId, defaultTranslationText, forceLanguage) {
            var value = getCustomString(translationId, forceLanguage);
            if (value !== false) {
                return $q.when(value);
            }
            return $delegate(translationId, interpolateParams, interpolationId, defaultTranslationText, forceLanguage);
        };
        newTranslate.instant = function(translationId, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy) {
            var value = getCustomString(translationId, forceLanguage);
            if (value !== false) {
                return value;
            }
            return $delegate.instant(translationId, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
        };
        for (var name in $delegate) {
            if (name != 'instant') {
                newTranslate[name] = $delegate[name];
            }
        }
        return newTranslate;
        function getCustomString(translationId, forceLanguage) {
            if (!$mmLang) {
                $mmLang = $injector.get('$mmLang');
            }
            var customStrings = $mmLang.getCustomStrings(forceLanguage);
            if (customStrings && typeof customStrings[translationId] != 'undefined') {
                return customStrings[translationId];
            }
            return false;
        }
    }]);
}])
.run(["$ionicPlatform", "$translate", "$mmLang", "$mmSite", "$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", function($ionicPlatform, $translate, $mmLang, $mmSite, $mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated,
            mmCoreEventLogout) {
    $ionicPlatform.ready(function() {
        $mmLang.getCurrentLanguage().then(function(language) {
            $translate.use(language);
            moment.locale(language);
        });
    });
    $mmEvents.on(mmCoreEventLogin, loadCustomStrings);
    $mmEvents.on(mmCoreEventSiteUpdated, function(siteId) {
        if (siteId == $mmSite.getId()) {
            loadCustomStrings();
        }
    });
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmLang.clearCustomStrings();
    });
    function loadCustomStrings() {
        var customStrings = $mmSite.getStoredConfig('tool_mobile_customlangstrings');
        if (typeof customStrings != 'undefined') {
            $mmLang.loadCustomStrings(customStrings);
        }
    }
}]);
angular.module('mm.core')
.constant('mmCoreNotificationsSitesStore', 'notification_sites')
.constant('mmCoreNotificationsComponentsStore', 'notification_components')
.constant('mmCoreNotificationsTriggeredStore', 'notifications_triggered')
.config(["$mmAppProvider", "mmCoreNotificationsSitesStore", "mmCoreNotificationsComponentsStore", "mmCoreNotificationsTriggeredStore", function($mmAppProvider, mmCoreNotificationsSitesStore, mmCoreNotificationsComponentsStore,
        mmCoreNotificationsTriggeredStore) {
    var stores = [
        {
            name: mmCoreNotificationsSitesStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'code',
                }
            ]
        },
        {
            name: mmCoreNotificationsComponentsStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'code',
                }
            ]
        },
        {
            name: mmCoreNotificationsTriggeredStore,
            keyPath: 'id',
            indexes: []
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmLocalNotifications', ["$log", "$cordovaLocalNotification", "$mmApp", "$q", "$rootScope", "$ionicPopover", "$timeout", "mmCoreNotificationsSitesStore", "mmCoreNotificationsComponentsStore", "mmCoreNotificationsTriggeredStore", function($log, $cordovaLocalNotification, $mmApp, $q, $rootScope, $ionicPopover, $timeout,
        mmCoreNotificationsSitesStore, mmCoreNotificationsComponentsStore, mmCoreNotificationsTriggeredStore) {
    $log = $log.getInstance('$mmLocalNotifications');
    var self = {},
        observers = {},
        codes = {},
        scope,
        hidePopoverTimeout;
    scope = $rootScope.$new();
    $ionicPopover.fromTemplateUrl('core/templates/notificationpopover.html', {
        scope: scope,
    }).then(function(popover) {
        popover.viewType = 'mm-inappnotif-popover';
        angular.element(popover.el).removeClass('popover-backdrop').addClass('mm-inapp-notification-backdrop');
        scope.popover = popover;
        scope.hide = function() {
            scope.popover.hide();
            $timeout.cancel(hidePopoverTimeout);
        };
    });
    var codeRequestsQueue = {};
        function getCode(store, id) {
        var db = $mmApp.getDB(),
            key = store + '#' + id;
        if (typeof codes[key] != 'undefined') {
            return $q.when(codes[key]);
        }
        return db.get(store, id).then(function(entry) {
            var code = parseInt(entry.code);
            codes[key] = code;
            return code;
        }, function() {
            return db.query(store, undefined, 'code', true).then(function(entries) {
                var newCode = 0;
                if (entries.length > 0) {
                    newCode = parseInt(entries[0].code) + 1;
                }
                return db.insert(store, {id: id, code: newCode}).then(function() {
                    codes[key] = newCode;
                    return newCode;
                });
            });
        });
    }
        function getSiteCode(siteid) {
        return requestCode(mmCoreNotificationsSitesStore, siteid);
    }
        function getComponentCode(component) {
        return requestCode(mmCoreNotificationsComponentsStore, component);
    }
        function getUniqueNotificationId(notificationid, component, siteid) {
        if (!siteid || !component) {
            return $q.reject();
        }
        return getSiteCode(siteid).then(function(sitecode) {
            return getComponentCode(component).then(function(componentcode) {
                return (sitecode * 100000000 + componentcode * 10000000 + parseInt(notificationid)) % 2147483647;
            });
        });
    }
        function processNextRequest() {
        var nextKey = Object.keys(codeRequestsQueue)[0],
            request,
            promise;
        if (typeof nextKey == 'undefined') {
            return;
        }
        request = codeRequestsQueue[nextKey];
        if (angular.isObject(request) && typeof request.store != 'undefined' && typeof request.id != 'undefined') {
            promise = getCode(request.store, request.id).then(function(code) {
                angular.forEach(request.promises, function(p) {
                    p.resolve(code);
                });
            }, function(error) {
                angular.forEach(request.promises, function(p) {
                    p.reject(error);
                });
            });
        } else {
            promise = $q.when();
        }
        promise.finally(function() {
            delete codeRequestsQueue[nextKey];
            processNextRequest();
        });
    }
        function requestCode(store, id) {
        var deferred = $q.defer(),
            key = store+'#'+id,
            isQueueEmpty = Object.keys(codeRequestsQueue).length == 0;
        if (typeof codeRequestsQueue[key] != 'undefined') {
            codeRequestsQueue[key].promises.push(deferred);
        } else {
            codeRequestsQueue[key] = {
                store: store,
                id: id,
                promises: [deferred]
            };
        }
        if (isQueueEmpty) {
            processNextRequest();
        }
        return deferred.promise;
    }
        self.cancel = function(id, component, siteid) {
        return getUniqueNotificationId(id, component, siteid).then(function(uniqueId) {
            return $cordovaLocalNotification.cancel(uniqueId);
        });
    };
        self.cancelSiteNotifications = function(siteid) {
        if (!self.isAvailable()) {
            return $q.when();
        } else if (!siteid) {
            return $q.reject();
        }
        return $cordovaLocalNotification.getAllScheduled().then(function(scheduled) {
            var ids = [];
            angular.forEach(scheduled, function(notif) {
                if (typeof notif.data == 'string') {
                    notif.data = JSON.parse(notif.data);
                }
                if (typeof notif.data == 'object' && notif.data.siteid === siteid) {
                    ids.push(notif.id);
                }
            });
            return $cordovaLocalNotification.cancel(ids);
        });
    };
        self.isAvailable = function() {
        return window.plugin && window.plugin.notification && window.plugin.notification.local ? true: false;
    };
        self.isTriggered = function(notification) {
        return $mmApp.getDB().get(mmCoreNotificationsTriggeredStore, notification.id).then(function(stored) {
            var notifTime = notification.at.getTime() / 1000;
            return stored.at === notifTime;
        }, function() {
            return false;
        });
    };
        self.notifyClick = function(data) {
        var component = data.component;
        if (component) {
            var callback = observers[component];
            if (typeof callback == 'function') {
                callback(data);
            }
        }
    };
        self.registerClick = function(component, callback) {
        $log.debug("Register observer '"+component+"' for notification click.");
        observers[component] = callback;
    };
        self.removeTriggered = function(id) {
        return $mmApp.getDB().remove(mmCoreNotificationsTriggeredStore, id);
    };
        self.schedule = function(notification, component, siteid) {
        return getUniqueNotificationId(notification.id, component, siteid).then(function(uniqueId) {
            notification.id = uniqueId;
            notification.data = notification.data || {};
            notification.data.component = component;
            notification.data.siteid = siteid;
            if (ionic.Platform.isAndroid()) {
                notification.icon = notification.icon || 'res://icon';
                notification.smallIcon = notification.smallIcon || 'res://icon';
                notification.led = notification.led || 'FF9900';
                notification.ledOnTime = notification.ledOnTime || 1000;
                notification.ledOffTime = notification.ledOffTime || 1000;
            }
            return self.isTriggered(notification).then(function(triggered) {
                if (!triggered) {
                    self.removeTriggered(notification.id);
                    return $cordovaLocalNotification.schedule(notification);
                }
            });
        });
    };
        self.showNotificationPopover = function(notification) {
        if (!scope || !scope.popover) {
            return;
        }
        if (!notification || !notification.title || !notification.text) {
            return;
        }
        var isShown = scope.popover.isShown();
        setData(isShown);
        if (isShown) {
            $timeout.cancel(hidePopoverTimeout);
        } else {
            scope.popover.show(document.querySelector('ion-nav-bar'));
        }
        hidePopoverTimeout = $timeout(function() {
            scope.popover.hide();
        }, 4000);
        function setData(isShown) {
            $timeout(function() {
                if (isShown && scope.title == notification.title) {
                    if (scope.ids.indexOf(notification.id) != -1) {
                        return;
                    }
                    scope.texts.push(notification.text);
                    scope.ids.push(notification.id);
                    if (scope.texts.length > 3) {
                        scope.texts.shift();
                        scope.ids.shift();
                    }
                } else {
                    scope.title = notification.title;
                    scope.texts = [notification.text];
                    scope.ids = [notification.id];
                }
            });
        }
    };
        self.trigger = function(notification) {
        if (ionic.Platform.isIOS() && parseInt(ionic.Platform.version(), 10) >= 10) {
            self.showNotificationPopover(notification);
        }
        var id = parseInt(notification.id);
        if (!isNaN(id)) {
            return $mmApp.getDB().insert(mmCoreNotificationsTriggeredStore, {
                id: id,
                at: parseInt(notification.at)
            });
        } else {
            return $q.reject();
        }
    };
    return self;
}])
.run(["$rootScope", "$log", "$mmLocalNotifications", "$mmEvents", "mmCoreEventSiteDeleted", function($rootScope, $log, $mmLocalNotifications, $mmEvents, mmCoreEventSiteDeleted) {
    $log = $log.getInstance('$mmLocalNotifications');
    $rootScope.$on('$cordovaLocalNotification:trigger', function(e, notification, state) {
        $mmLocalNotifications.trigger(notification);
    });
    $rootScope.$on('$cordovaLocalNotification:click', function(e, notification, state) {
        if (notification && notification.data) {
            $log.debug('Notification clicked: '+notification.data);
            var data = JSON.parse(notification.data);
            $mmLocalNotifications.notifyClick(data);
        }
    });
    $mmEvents.on(mmCoreEventSiteDeleted, function(site) {
        if (site) {
            $mmLocalNotifications.cancelSiteNotifications(site.id);
        }
    });
}]);

angular.module('mm.core')
.constant('mmCoreLogEnabledDefault', false)
.constant('mmCoreLogEnabledConfigName', 'debug_enabled')
.provider('$mmLog', ["mmCoreLogEnabledDefault", function(mmCoreLogEnabledDefault) {
    var isEnabled = mmCoreLogEnabledDefault,
        self = this;
    function prepareLogFn(logFn, className) {
        className = className || '';
        var enhancedLogFn = function() {
            if (isEnabled) {
                var args = Array.prototype.slice.call(arguments),
                    now  = moment().format('l LTS');
                args[0] = now + ' ' + className + ': ' + args[0];
                logFn.apply(null, args);
            }
        };
        enhancedLogFn.logs = [];
        return enhancedLogFn;
    }
        self.logDecorator = function($log) {
        var _$log = (function($log) {
            return {
                log   : $log.log,
                info  : $log.info,
                warn  : $log.warn,
                debug : $log.debug,
                error : $log.error
            };
        })($log);
        var getInstance = function(className) {
            return {
                log   : prepareLogFn(_$log.log, className),
                info  : prepareLogFn(_$log.info, className),
                warn  : prepareLogFn(_$log.warn, className),
                debug : prepareLogFn(_$log.debug, className),
                error : prepareLogFn(_$log.error, className)
            };
        };
        $log.log   = prepareLogFn($log.log);
        $log.info  = prepareLogFn($log.info);
        $log.warn  = prepareLogFn($log.warn);
        $log.debug = prepareLogFn($log.debug);
        $log.error = prepareLogFn($log.error);
        $log.getInstance = getInstance;
        return $log;
    };
    this.$get = ["$mmConfig", "mmCoreLogEnabledDefault", "mmCoreLogEnabledConfigName", function($mmConfig, mmCoreLogEnabledDefault, mmCoreLogEnabledConfigName) {
        var self = {};
                self.init = function() {
            $mmConfig.get(mmCoreLogEnabledConfigName).then(function(enabled) {
                isEnabled = enabled;
            }, function() {
                isEnabled = mmCoreLogEnabledDefault;
            });
        }
                self.enabled = function(flag) {
            $mmConfig.set(mmCoreLogEnabledConfigName, flag);
            isEnabled = flag;
        };
                self.isEnabled = function() {
            return isEnabled;
        };
        return self;
    }];
}])
.run(["$mmLog", function($mmLog) {
    $mmLog.init();
}]);

angular.module('mm.core')
.factory('$mmSite', ["$mmSitesManager", "$mmSitesFactory", function($mmSitesManager, $mmSitesFactory) {
    var self = {},
        siteMethods = $mmSitesFactory.getSiteMethods();
    angular.forEach(siteMethods, function(method) {
        self[method] = function() {
            var currentSite = $mmSitesManager.getCurrentSite();
            if (typeof currentSite == 'undefined') {
                return undefined;
            } else {
                return currentSite[method].apply(currentSite, arguments);
            }
        };
    });
        self.isLoggedIn = function() {
        var currentSite = $mmSitesManager.getCurrentSite();
        return typeof currentSite != 'undefined' && typeof currentSite.token != 'undefined' && currentSite.token != '';
    };
    return self;
}]);

angular.module('mm.core')
.value('mmCoreWSPrefix', 'local_mobile_')
.constant('mmCoreWSCacheStore', 'wscache')
.config(["$mmSitesFactoryProvider", "mmCoreWSCacheStore", function($mmSitesFactoryProvider, mmCoreWSCacheStore) {
    var stores = [
        {
            name: mmCoreWSCacheStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'key'
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.provider('$mmSitesFactory', function() {
        var siteSchema = {
            stores: []
        },
        dboptions = {
            autoSchema: true
        },
        supportWhereEqual;
        this.registerStore = function(store) {
        if (typeof(store.name) === 'undefined') {
            console.log('$mmSite: Error: store name is undefined.');
            return;
        } else if (storeExists(store.name)) {
            console.log('$mmSite: Error: store ' + store.name + ' is already defined.');
            return;
        }
        store.indexes = getIndexes(store.indexes);
        siteSchema.stores.push(store);
    };
        function getIndexes(indexes) {
        if (!isWhereEqualSupported()) {
            var neededIndexes = {},
                uniqueIndexes = {};
            angular.forEach(indexes, function(index) {
                if (index.keyPath) {
                    angular.forEach(index.keyPath, function(keyName) {
                        neededIndexes[keyName] = keyName;
                    });
                } else {
                    uniqueIndexes[index.name] = true;
                }
            });
            angular.forEach(neededIndexes, function(index) {
                if (typeof uniqueIndexes[index] == "undefined") {
                    indexes.push({
                        name: index
                    });
                    uniqueIndexes[index] = true;
                }
            });
        } else {
            angular.forEach(indexes, function(index) {
                if (index.keyPath) {
                    var path = index.keyPath;
                    index.generator = function(obj) {
                        var arr = [];
                        angular.forEach(path, function(keyName) {
                            arr.push(obj[keyName]);
                        });
                        return arr;
                    };
                    delete index.keyPath;
                }
            });
        }
        return indexes;
    }
        function isWhereEqualSupported() {
        if (typeof supportWhereEqual != "undefined") {
            return supportWhereEqual;
        }
        if (ionic.Platform.isIOS()) {
            supportWhereEqual = true;
            return true;
        }
        var isSafari = !ionic.Platform.isIOS() && !ionic.Platform.isAndroid() && navigator.userAgent.indexOf('Safari') != -1 &&
                            navigator.userAgent.indexOf('Chrome') == -1 && navigator.userAgent.indexOf('Firefox') == -1;
        supportWhereEqual = typeof IDBObjectStore != 'undefined' && typeof IDBObjectStore.prototype.count != 'undefined' &&
                            !isSafari;
        return supportWhereEqual;
    }
        this.registerStores = function(stores) {
        var self = this;
        angular.forEach(stores, function(store) {
            self.registerStore(store);
        });
    };
        function storeExists(name) {
        var exists = false;
        angular.forEach(siteSchema.stores, function(store) {
            if (store.name === name) {
                exists = true;
            }
        });
        return exists;
    }
    this.$get = ["$http", "$q", "$mmWS", "$mmDB", "$log", "md5", "$mmApp", "$mmLang", "$mmUtil", "$mmFS", "mmCoreWSCacheStore", "mmCoreWSPrefix", "mmCoreSessionExpired", "$mmEvents", "mmCoreEventSessionExpired", "mmCoreUserDeleted", "mmCoreEventUserDeleted", "$mmText", "$translate", "mmCoreConfigConstants", "mmCoreUserPasswordChangeForced", "mmCoreEventPasswordChangeForced", "mmCoreLoginTokenChangePassword", "mmCoreSecondsMinute", "mmCoreUserNotFullySetup", "mmCoreEventUserNotFullySetup", "mmCoreSitePolicyNotAgreed", "mmCoreEventSitePolicyNotAgreed", "mmCoreUnicodeNotSupported", function($http, $q, $mmWS, $mmDB, $log, md5, $mmApp, $mmLang, $mmUtil, $mmFS, mmCoreWSCacheStore,
            mmCoreWSPrefix, mmCoreSessionExpired, $mmEvents, mmCoreEventSessionExpired, mmCoreUserDeleted, mmCoreEventUserDeleted,
            $mmText, $translate, mmCoreConfigConstants, mmCoreUserPasswordChangeForced, mmCoreEventPasswordChangeForced,
            mmCoreLoginTokenChangePassword, mmCoreSecondsMinute, mmCoreUserNotFullySetup, mmCoreEventUserNotFullySetup,
            mmCoreSitePolicyNotAgreed, mmCoreEventSitePolicyNotAgreed, mmCoreUnicodeNotSupported) {
        $log = $log.getInstance('$mmSite');
                var deprecatedFunctions = {
            "core_grade_get_definitions": "core_grading_get_definitions",
            "moodle_course_create_courses": "core_course_create_courses",
            "moodle_course_get_courses": "core_course_get_courses",
            "moodle_enrol_get_users_courses": "core_enrol_get_users_courses",
            "moodle_file_get_files": "core_files_get_files",
            "moodle_file_upload": "core_files_upload",
            "moodle_group_add_groupmembers": "core_group_add_group_members",
            "moodle_group_create_groups": "core_group_create_groups",
            "moodle_group_delete_groupmembers": "core_group_delete_group_members",
            "moodle_group_delete_groups": "core_group_delete_groups",
            "moodle_group_get_course_groups": "core_group_get_course_groups",
            "moodle_group_get_groupmembers": "core_group_get_group_members",
            "moodle_group_get_groups": "core_group_get_groups",
            "moodle_message_send_instantmessages": "core_message_send_instant_messages",
            "moodle_notes_create_notes": "core_notes_create_notes",
            "moodle_role_assign": "core_role_assign_role",
            "moodle_role_unassign": "core_role_unassign_role",
            "moodle_user_create_users": "core_user_create_users",
            "moodle_user_delete_users": "core_user_delete_users",
            "moodle_user_get_course_participants_by_id": "core_user_get_course_user_profiles",
            "moodle_user_get_users_by_courseid": "core_enrol_get_enrolled_users",
            "moodle_user_get_users_by_id": "core_user_get_users_by_id",
            "moodle_user_update_users": "core_user_update_users",
            "moodle_webservice_get_siteinfo": "core_webservice_get_site_info",
        };
        var self = {},
            moodleReleases = {
                '2.4': 2012120300,
                '2.5': 2013051400,
                '2.6': 2013111800,
                '2.7': 2014051200,
                '2.8': 2014111000,
                '2.9': 2015051100,
                '3.0': 2015111600,
                '3.1': 2016052300,
                '3.2': 2016120500
            };
                function Site(id, siteurl, token, infos, privateToken, config, loggedOut) {
            this.id = id;
            this.siteurl = siteurl;
            this.token = token;
            this.infos = infos;
            this.privateToken = privateToken;
            this.config = config;
            this.loggedOut = !!loggedOut;
            this.cleanUnicode = false;
            if (this.id) {
                this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions);
            }
        }
                Site.prototype.getId = function() {
            return this.id;
        };
                Site.prototype.getURL = function() {
            return this.siteurl;
        };
                Site.prototype.getToken = function() {
            return this.token;
        };
                Site.prototype.getInfo = function() {
            return this.infos;
        };
                Site.prototype.getPrivateToken = function() {
            return this.privateToken;
        };
                Site.prototype.getDb = function() {
            return this.db;
        };
                Site.prototype.reloadDb = function() {
            if (this.db) {
                this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions, true);
            }
        };
                Site.prototype.getUserId = function() {
            if (typeof this.infos != 'undefined' && typeof this.infos.userid != 'undefined') {
                return this.infos.userid;
            } else {
                return undefined;
            }
        };
                Site.prototype.getSiteHomeId = function() {
            return this.infos && this.infos.siteid || 1;
        };
                Site.prototype.setId = function(id) {
            this.id = id;
            this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions);
        };
                Site.prototype.setToken = function(token) {
            this.token = token;
        };
                Site.prototype.setPrivateToken = function(privateToken) {
            this.privateToken = privateToken;
        };
                Site.prototype.isTokenExpired = function() {
            return this.token == mmCoreLoginTokenChangePassword;
        };
                Site.prototype.isLoggedOut = function() {
            return !!this.loggedOut;
        };
                Site.prototype.setInfo = function(infos) {
            this.infos = infos;
        };
                Site.prototype.setConfig = function(config) {
            this.config = config;
        };
                Site.prototype.setLoggedOut = function(loggedOut) {
            this.loggedOut = !!loggedOut;
        };
                Site.prototype.canAccessMyFiles = function() {
            var infos = this.getInfo();
            return infos && (typeof infos.usercanmanageownfiles === 'undefined' || infos.usercanmanageownfiles);
        };
                Site.prototype.canDownloadFiles = function() {
            var infos = this.getInfo();
            return infos && infos.downloadfiles;
        };
                Site.prototype.canUseAdvancedFeature = function(feature, whenUndefined) {
            var infos = this.getInfo(),
                canUse = true;
            whenUndefined = (typeof whenUndefined === 'undefined') ? true : whenUndefined;
            if (typeof infos.advancedfeatures === 'undefined') {
                canUse = whenUndefined;
            } else {
                angular.forEach(infos.advancedfeatures, function(item) {
                    if (item.name === feature && parseInt(item.value, 10) === 0) {
                        canUse = false;
                    }
                });
            }
            return canUse;
        };
                Site.prototype.canUploadFiles = function() {
            var infos = this.getInfo();
            return infos && infos.uploadfiles;
        };
                Site.prototype.fetchSiteInfo = function() {
            var deferred = $q.defer(),
                site = this;
            var preSets = {
                getFromCache: 0,
                saveToCache: 0
            };
            site.cleanUnicode = false;
            site.read('core_webservice_get_site_info', {}, preSets).then(deferred.resolve, function(error) {
                site.read('moodle_webservice_get_siteinfo', {}, preSets).then(deferred.resolve, function(error) {
                    deferred.reject(error);
                });
            });
            return deferred.promise;
        };
                Site.prototype.read = function(method, data, preSets) {
            preSets = preSets || {};
            if (typeof(preSets.getFromCache) === 'undefined') {
                preSets.getFromCache = 1;
            }
            if (typeof(preSets.saveToCache) === 'undefined') {
                preSets.saveToCache = 1;
            }
            if (typeof(preSets.sync) === 'undefined') {
                preSets.sync = 0;
            }
            return this.request(method, data, preSets);
        };
                Site.prototype.write = function(method, data, preSets) {
            preSets = preSets || {};
            if (typeof(preSets.getFromCache) === 'undefined') {
                preSets.getFromCache = 0;
            }
            if (typeof(preSets.saveToCache) === 'undefined') {
                preSets.saveToCache = 0;
            }
            if (typeof(preSets.sync) === 'undefined') {
                preSets.sync = 0;
            }
            if (typeof(preSets.emergencyCache) === 'undefined') {
                preSets.emergencyCache = 0;
            }
            return this.request(method, data, preSets);
        };
                Site.prototype.request = function(method, data, preSets, retrying) {
            var site = this,
                initialToken = site.token;
            data = data || {};
            method = site.getCompatibleFunction(method);
            if (site.getInfo() && !site.wsAvailable(method, false)) {
                if (site.wsAvailable(mmCoreWSPrefix + method, false)) {
                    $log.info("Using compatibility WS method '" + mmCoreWSPrefix + method + "'");
                    method = mmCoreWSPrefix + method;
                } else {
                    $log.error("WS function '" + method + "' is not available, even in compatibility mode.");
                    return $mmLang.translateAndReject('mm.core.wsfunctionnotavailable');
                }
            }
            preSets = angular.copy(preSets) || {};
            preSets.wstoken = site.token;
            preSets.siteurl = site.siteurl;
            preSets.cleanUnicode = site.cleanUnicode;
            if (preSets.cleanUnicode && $mmText.hasUnicodeData(data)) {
                $mmUtil.showToast('mm.core.unicodenotsupported', true, 3000);
            } else {
                preSets.cleanUnicode = false;
            }
            data.moodlewssettingfilter = preSets.filter === false ? false : true;
            data.moodlewssettingfileurl = preSets.rewriteurls === false ? false : true;
            return getFromCache(site, method, data, preSets).catch(function() {
                var wsPreSets = angular.copy(preSets);
                delete wsPreSets.getFromCache;
                delete wsPreSets.saveToCache;
                delete wsPreSets.omitExpires;
                delete wsPreSets.cacheKey;
                delete wsPreSets.emergencyCache;
                delete wsPreSets.getCacheUsingCacheKey;
                delete wsPreSets.getEmergencyCacheUsingCacheKey;
                delete wsPreSets.uniqueCacheKey;
                return $mmWS.call(method, data, wsPreSets).then(function(response) {
                    if (preSets.saveToCache) {
                        saveToCache(site, method, data, response, preSets);
                    }
                    return angular.copy(response);
                }).catch(function(error) {
                    if (error === mmCoreSessionExpired) {
                        if (initialToken !== site.token && !retrying) {
                            return site.request(method, data, preSets, true);
                        } else if ($mmApp.isSSOAuthenticationOngoing()) {
                            return $mmApp.waitForSSOAuthentication().then(function() {
                                return site.request(method, data, preSets, true);
                            });
                        }
                        $mmEvents.trigger(mmCoreEventSessionExpired, {siteid: site.id});
                        error = $translate.instant('mm.core.lostconnection');
                    } else if (error === mmCoreUserDeleted) {
                        $mmEvents.trigger(mmCoreEventUserDeleted, {siteid: site.id, params: data});
                        return $mmLang.translateAndReject('mm.core.userdeleted');
                    } else if (error === mmCoreUserPasswordChangeForced) {
                        $mmEvents.trigger(mmCoreEventPasswordChangeForced, site.id);
                        return $mmLang.translateAndReject('mm.core.forcepasswordchangenotice');
                    } else if (error === mmCoreUserNotFullySetup) {
                        $mmEvents.trigger(mmCoreEventUserNotFullySetup, site.id);
                        return $mmLang.translateAndReject('mm.core.usernotfullysetup');
                    } else if (error === mmCoreSitePolicyNotAgreed) {
                        $mmEvents.trigger(mmCoreEventSitePolicyNotAgreed, site.id);
                        return $mmLang.translateAndReject('mm.login.sitepolicynotagreederror');
                    } else if (error === mmCoreUnicodeNotSupported) {
                        if (!site.cleanUnicode) {
                            site.cleanUnicode = true;
                            return site.request(method, data, preSets);
                        }
                        return $mmLang.translateAndReject('mm.core.unicodenotsupported');
                    } else if (typeof preSets.emergencyCache !== 'undefined' && !preSets.emergencyCache) {
                        $log.debug('WS call ' + method + ' failed. Emergency cache is forbidden, rejecting.');
                        return $q.reject(error);
                    }
                    $log.debug('WS call ' + method + ' failed. Trying to use the emergency cache.');
                    preSets.omitExpires = true;
                    preSets.getFromCache = true;
                    return getFromCache(site, method, data, preSets, true).catch(function() {
                        return $q.reject(error);
                    });
                });
            });
        };
                Site.prototype.wsAvailable = function(method, checkPrefix) {
            checkPrefix = (typeof checkPrefix === 'undefined') ? true : checkPrefix;
            if (typeof this.infos == 'undefined') {
                return false;
            }
            for (var i = 0; i < this.infos.functions.length; i++) {
                var f = this.infos.functions[i];
                if (f.name == method) {
                    return true;
                }
            }
            if (checkPrefix) {
                return this.wsAvailable(mmCoreWSPrefix + method, false);
            }
            return false;
        };
                Site.prototype.uploadFile = function(uri, options) {
            if (!options.fileArea) {
                if (this.isVersionGreaterEqualThan('3.1')) {
                    options.fileArea = 'draft';
                } else {
                    options.fileArea = 'private';
                }
            }
            return $mmWS.uploadFile(uri, options, {
                siteurl: this.siteurl,
                token: this.token
            });
        };
                Site.prototype.invalidateWsCache = function() {
            var db = this.db;
            if (!db) {
                return $q.reject();
            }
            $log.debug('Invalidate all the cache for site: '+ this.id);
            return db.getAll(mmCoreWSCacheStore).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
                Site.prototype.invalidateWsCacheForKey = function(key) {
            var db = this.db;
            if (!db || !key) {
                return $q.reject();
            }
            $log.debug('Invalidate cache for key: '+key);
            return db.whereEqual(mmCoreWSCacheStore, 'key', key).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
                Site.prototype.invalidateMultipleWsCacheForKey = function(keys) {
            var db = this.db;
            if (!db) {
                return $q.reject();
            }
            var allEntries = [],
                promises = [];
            $log.debug('Invalidating multiple cache keys');
            angular.forEach(keys, function(key) {
                if (key) {
                    promises.push(db.whereEqual(mmCoreWSCacheStore, 'key', key).then(function(entries) {
                        if (entries && entries.length > 0) {
                            allEntries.concat(entries);
                        }
                    }));
                }
            });
            return $q.all(promises).then(function() {
                return invalidateWsCacheEntries(db, allEntries);
            });
        };
                Site.prototype.invalidateWsCacheForKeyStartingWith = function(key) {
            var db = this.db;
            if (!db || !key) {
                return $q.reject();
            }
            $log.debug('Invalidate cache for key starting with: '+key);
            return db.where(mmCoreWSCacheStore, 'key', '^', key).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
                Site.prototype.fixPluginfileURL = function(url) {
            return $mmUtil.fixPluginfileURL(url, this.token);
        };
                Site.prototype.deleteDB = function() {
            return $mmDB.deleteDB('Site-' + this.id);
        };
                Site.prototype.deleteFolder = function() {
            if ($mmFS.isAvailable()) {
                var siteFolder = $mmFS.getSiteFolder(this.id);
                return $mmFS.removeDir(siteFolder).catch(function() {
                });
            } else {
                return $q.when();
            }
        };
                Site.prototype.getSpaceUsage = function() {
            if ($mmFS.isAvailable()) {
                var siteFolderPath = $mmFS.getSiteFolder(this.id);
                return $mmFS.getDirectorySize(siteFolderPath).catch(function() {
                    return 0;
                });
            } else {
                return $q.when(0);
            }
        };
                Site.prototype.getDocsUrl = function(page) {
            var release = this.infos.release ? this.infos.release : undefined;
            return $mmUtil.getDocsUrl(release, page);
        };
                Site.prototype.checkLocalMobilePlugin = function(retrying) {
            var siteurl = this.siteurl,
                self = this,
                service = mmCoreConfigConstants.wsextservice;
            if (!service) {
                return $q.when({code: 0});
            }
            return $http.post(siteurl + '/local/mobile/check.php', {service: service}).then(function(response) {
                var data = response.data;
                if (typeof data != 'undefined' && data.errorcode === 'requirecorrectaccess') {
                    if (!retrying) {
                        self.siteurl = $mmText.addOrRemoveWWW(siteurl);
                        return self.checkLocalMobilePlugin(true);
                    } else {
                        return $q.reject(data.error);
                    }
                } else if (typeof data == 'undefined' || typeof data.code == 'undefined') {
                    return {code: 0, warning: 'mm.login.localmobileunexpectedresponse'};
                }
                var code = parseInt(data.code, 10);
                if (data.error) {
                    switch (code) {
                        case 1:
                            return $mmLang.translateAndReject('mm.login.siteinmaintenance');
                        case 2:
                            return $mmLang.translateAndReject('mm.login.webservicesnotenabled');
                        case 3:
                            return {code: 0};
                        case 4:
                            return $mmLang.translateAndReject('mm.login.mobileservicesnotenabled');
                        default:
                            return $mmLang.translateAndReject('mm.core.unexpectederror');
                    }
                } else {
                    return {code: code, service: service, coresupported: !!data.coresupported};
                }
            }, function() {
                return {code: 0};
            });
        };
                Site.prototype.checkIfAppUsesLocalMobile = function() {
            var appUsesLocalMobile = false;
            angular.forEach(this.infos.functions, function(func) {
                if (func.name.indexOf(mmCoreWSPrefix) != -1) {
                    appUsesLocalMobile = true;
                }
            });
            return appUsesLocalMobile;
        };
                Site.prototype.checkIfLocalMobileInstalledAndNotUsed = function() {
            var appUsesLocalMobile = this.checkIfAppUsesLocalMobile();
            if (appUsesLocalMobile) {
                return $q.reject();
            }
            return this.checkLocalMobilePlugin().then(function(data) {
                if (typeof data.service == 'undefined') {
                    return $q.reject();
                }
                return data;
            });
        };
                Site.prototype.containsUrl = function(url) {
            if (!url) {
                return false;
            }
            var siteurl = $mmText.removeProtocolAndWWW(this.siteurl);
            url = $mmText.removeProtocolAndWWW(url);
            return url.indexOf(siteurl) == 0;
        };
                Site.prototype.getPublicConfig = function() {
            var that = this;
            return $mmWS.callAjax('tool_mobile_get_public_config', {}, {siteurl: this.siteurl}).then(function(config) {
                if (config.httpswwwroot) {
                    that.siteurl = config.httpswwwroot;
                }
                return config;
            });
        };
                Site.prototype.openInBrowserWithAutoLogin = function(url, alertMessage) {
            return this.openWithAutoLogin(false, url, undefined, alertMessage);
        };
                Site.prototype.openInBrowserWithAutoLoginIfSameSite = function(url, alertMessage) {
            return this.openWithAutoLoginIfSameSite(false, url, undefined, alertMessage);
        };
                Site.prototype.openInAppWithAutoLogin = function(url, options, alertMessage) {
            return this.openWithAutoLogin(true, url, options, alertMessage);
        };
                Site.prototype.openInAppWithAutoLoginIfSameSite = function(url, options, alertMessage) {
            return this.openWithAutoLoginIfSameSite(true, url, options, alertMessage);
        };
                Site.prototype.openWithAutoLogin = function(inApp, url, options, alertMessage) {
            if (!this.privateToken || !this.wsAvailable('tool_mobile_get_autologin_key') ||
                    (this.lastAutoLogin && $mmUtil.timestamp() - this.lastAutoLogin < 6 * mmCoreSecondsMinute)) {
                return open(url);
            }
            var that = this,
                userId = that.getUserId(),
                params = {
                    privatetoken: that.privateToken
                },
                modal = $mmUtil.showModalLoading();
            return that.write('tool_mobile_get_autologin_key', params).then(function(data) {
                if (!data.autologinurl || !data.key) {
                    return open(url);
                }
                that.lastAutoLogin = $mmUtil.timestamp();
                return open(data.autologinurl + '?userid=' + userId + '&key=' + data.key + '&urltogo=' + url);
            }).catch(function() {
                return open(url);
            });
            function open(url) {
                if (modal) {
                    modal.dismiss();
                }
                var promise;
                if (alertMessage) {
                    promise = $mmUtil.showModal('mm.core.notice', alertMessage, 3000);
                } else {
                    promise = $q.when();
                }
                return promise.finally(function() {
                    if (inApp) {
                        $mmUtil.openInApp(url, options);
                    } else {
                        $mmUtil.openInBrowser(url);
                    }
                });
            }
        };
                Site.prototype.openWithAutoLoginIfSameSite = function(inApp, url, options, alertMessage) {
            if (this.containsUrl(url)) {
                return this.openWithAutoLogin(inApp, url, options, alertMessage);
            } else {
                if (inApp) {
                    $mmUtil.openInApp(url, options);
                } else {
                    $mmUtil.openInBrowser(url);
                }
                return $q.when();
            }
        };
                Site.prototype.getConfig = function(name, ignoreCache) {
            var site = this;
            var preSets = {
                cacheKey: getConfigCacheKey()
            };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('tool_mobile_get_config', {}, preSets).then(function(config) {
                if (name) {
                    for (var x in config.settings) {
                        if (config.settings[x].name == name) {
                            return config.settings[x].value;
                        }
                    }
                    return $q.reject();
                } else {
                    var settings = {};
                    angular.forEach(config.settings, function(setting) {
                        settings[setting.name] = setting.value;
                    });
                    return settings;
                }
            });
        };
                Site.prototype.invalidateConfig = function() {
            var site = this;
            return site.invalidateWsCacheForKey(getConfigCacheKey());
        };
                function getConfigCacheKey() {
            return 'tool_mobile_get_config';
        }
                Site.prototype.getStoredConfig = function(name) {
            if (!this.config) {
                return;
            }
            if (name) {
                return this.config[name];
            } else {
                return this.config;
            }
        };
                Site.prototype.isFeatureDisabled = function(name) {
            var disabledFeatures = this.getStoredConfig('tool_mobile_disabledfeatures');
            if (!disabledFeatures) {
                return false;
            }
            var regEx = new RegExp('(,|^)' + $mmText.escapeForRegex(name) + '(,|$)', 'g');
            return !!disabledFeatures.match(regEx);
        };
                function invalidateWsCacheEntries(db, entries) {
            var promises = [];
            angular.forEach(entries, function(entry) {
                if (entry.expirationtime > 0) {
                    entry.expirationtime = 0;
                    promises.push(db.insert(mmCoreWSCacheStore, entry));
                }
            });
            return $q.all(promises);
        }
                Site.prototype.getCompatibleFunction = function(method) {
            if (typeof deprecatedFunctions[method] !== "undefined") {
                if (this.wsAvailable(deprecatedFunctions[method])) {
                    $log.warn("You are using deprecated Web Services: " + method +
                        " you must replace it with the newer function: " + deprecatedFunctions[method]);
                    return deprecatedFunctions[method];
                } else {
                    $log.warn("You are using deprecated Web Services. " +
                        "Your remote site seems to be outdated, consider upgrade it to the latest Moodle version.");
                }
            } else if (!this.wsAvailable(method)) {
                for (var oldFunc in deprecatedFunctions) {
                    if (deprecatedFunctions[oldFunc] === method && this.wsAvailable(oldFunc)) {
                        $log.warn("Your remote site doesn't support the function " + method +
                            ", it seems to be outdated, consider upgrade it to the latest Moodle version.");
                        return oldFunc;
                    }
                }
            }
            return method;
        };
                Site.prototype.isVersionGreaterEqualThan = function(versions) {
            var siteVersion = parseInt(this.getInfo().version, 10);
            if (angular.isArray(versions)) {
                if (!versions.length) {
                    return false;
                }
                for (var i = 0; i < versions.length; i++) {
                    var versionNumber = getVersionNumber(versions[i]);
                    if (i == versions.length - 1) {
                        return siteVersion >= versionNumber;
                    } else {
                        if (siteVersion >= versionNumber && siteVersion < getNextMajorVersionNumber(versions[i])) {
                            return true;
                        }
                    }
                }
            } else if (typeof versions == 'string') {
                return siteVersion >= getVersionNumber(versions);
            }
            return false;
        };
                function getVersionNumber(version) {
            var data = getMajorAndMinor(version);
            if (!data) {
                return 0;
            }
            if (typeof moodleReleases[data.major] == 'undefined') {
                data.major = Object.keys(moodleReleases).slice(-1);
            }
            return moodleReleases[data.major] + data.minor;
        }
                function getMajorAndMinor(version) {
            var match = version.match(/(\d)+(?:\.(\d)+)?(?:\.(\d)+)?/);
            if (!match || !match[1]) {
                return false;
            }
            return {
                major: match[1] + '.' + (match[2] || '0'),
                minor: parseInt(match[3] || 0, 10)
            };
        }
                function getNextMajorVersionNumber(version) {
            var data = getMajorAndMinor(version),
                position,
                releases = Object.keys(moodleReleases);
            if (!data) {
                return 0;
            }
            position = releases.indexOf(data.major);
            if (position == -1 || position == releases.length -1) {
                return moodleReleases[releases[position]];
            }
            return moodleReleases[releases[position + 1]];
        }
                function getCacheId(method, data) {
            return md5.createHash(method + ':' + JSON.stringify(data));
        }
                function getFromCache(site, method, data, preSets, emergency) {
            var db = site.db,
                id = getCacheId(method, data),
                promise;
            if (!db || !preSets.getFromCache) {
                return $q.reject();
            }
            if (preSets.getCacheUsingCacheKey || (emergency && preSets.getEmergencyCacheUsingCacheKey)) {
                promise = db.whereEqual(mmCoreWSCacheStore, 'key', preSets.cacheKey).then(function(entries) {
                    if (!entries.length) {
                        return db.get(mmCoreWSCacheStore, id);
                    } else if (entries.length > 1) {
                        for (var i = 0, len = entries.length; i < len; i++) {
                            var entry = entries[i];
                            if (entry.id == id) {
                                return entry;
                            }
                        }
                    }
                    return entries[0];
                });
            } else {
                promise = db.get(mmCoreWSCacheStore, id);
            }
            return promise.then(function(entry) {
                var now = new Date().getTime();
                preSets.omitExpires = preSets.omitExpires || !$mmApp.isOnline();
                if (!preSets.omitExpires) {
                    if (now > entry.expirationtime) {
                        $log.debug('Cached element found, but it is expired');
                        return $q.reject();
                    }
                }
                if (typeof entry != 'undefined' && typeof entry.data != 'undefined') {
                    var expires = (entry.expirationtime - now) / 1000;
                    $log.info('Cached element found, id: ' + id + ' expires in ' + expires + ' seconds');
                    return entry.data;
                }
                return $q.reject();
            });
        }
                function saveToCache(site, method, data, response, preSets) {
            var db = site.db,
                id = getCacheId(method, data),
                cacheExpirationTime = mmCoreConfigConstants.cache_expiration_time,
                promise,
                entry = {
                    id: id,
                    data: response
                };
            if (!db) {
                return $q.reject();
            } else {
                if (preSets.uniqueCacheKey) {
                    promise = deleteFromCache(site, method, data, preSets, true).catch(function() {
                    });
                } else {
                    promise = $q.when();
                }
                return promise.then(function() {
                    cacheExpirationTime = isNaN(cacheExpirationTime) ? 300000 : cacheExpirationTime;
                    entry.expirationtime = new Date().getTime() + cacheExpirationTime;
                    if (preSets.cacheKey) {
                        entry.key = preSets.cacheKey;
                    }
                    return db.insert(mmCoreWSCacheStore, entry);
                });
            }
        }
                function deleteFromCache(site, method, data, preSets, allCacheKey) {
            var db = site.db,
                id = getCacheId(method, data);
            if (!db) {
                return $q.reject();
            } else {
                if (allCacheKey) {
                    return db.whereEqual(mmCoreWSCacheStore, 'key', preSets.cacheKey).then(function(entries) {
                        var promises = [];
                        angular.forEach(entries, function(entry) {
                            promises.push(db.remove(mmCoreWSCacheStore, entry.id));
                        });
                        return $q.all(promises);
                    });
                } else {
                    return db.remove(mmCoreWSCacheStore, id);
                }
            }
        }
                self.makeSite = function(id, siteurl, token, infos, privateToken, config, loggedOut) {
            return new Site(id, siteurl, token, infos, privateToken, config, loggedOut);
        };
                self.getSiteMethods = function() {
            var methods = [];
            for (var name in Site.prototype) {
                methods.push(name);
            }
            return methods;
        };
        return self;
    }];
});

angular.module('mm.core')
.constant('mmCoreSitesStore', 'sites')
.constant('mmCoreCurrentSiteStore', 'current_site')
.config(["$mmAppProvider", "mmCoreSitesStore", "mmCoreCurrentSiteStore", function($mmAppProvider, mmCoreSitesStore, mmCoreCurrentSiteStore) {
    var stores = [
        {
            name: mmCoreSitesStore,
            keyPath: 'id'
        },
        {
            name: mmCoreCurrentSiteStore,
            keyPath: 'id'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmSitesManager', ["$http", "$q", "$mmSitesFactory", "md5", "$mmLang", "$mmApp", "$mmUtil", "$mmEvents", "$translate", "mmCoreSitesStore", "mmCoreCurrentSiteStore", "mmCoreEventLogin", "mmCoreEventLogout", "$log", "mmCoreWSPrefix", "mmCoreEventSiteUpdated", "mmCoreEventSiteAdded", "mmCoreEventSessionExpired", "mmCoreEventSiteDeleted", "$mmText", "mmCoreConfigConstants", "mmLoginSSOCode", "mmLoginSSOInAppCode", function($http, $q, $mmSitesFactory, md5, $mmLang, $mmApp, $mmUtil, $mmEvents,
            $translate, mmCoreSitesStore, mmCoreCurrentSiteStore, mmCoreEventLogin, mmCoreEventLogout, $log, mmCoreWSPrefix,
            mmCoreEventSiteUpdated, mmCoreEventSiteAdded, mmCoreEventSessionExpired, mmCoreEventSiteDeleted, $mmText,
            mmCoreConfigConstants, mmLoginSSOCode, mmLoginSSOInAppCode) {
    $log = $log.getInstance('$mmSitesManager');
    var self = {},
        services = {},
        sessionRestored = false,
        currentSite,
        sites = {};
        self.getDemoSiteData = function(siteurl) {
        var demoSites = mmCoreConfigConstants.demo_sites;
        if (typeof demoSites != 'undefined' && typeof demoSites[siteurl] != 'undefined') {
            return demoSites[siteurl];
        }
    };
        self.checkSite = function(siteurl, protocol) {
        siteurl = $mmUtil.formatURL(siteurl);
        if (!$mmUtil.isValidURL(siteurl)) {
            return $mmLang.translateAndReject('mm.login.invalidsite');
        } else if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        } else {
            protocol = protocol || 'https://';
            return checkSite(siteurl, protocol).catch(function(error) {
                if (error.critical) {
                    return $q.reject(error.error);
                }
                protocol = protocol == 'https://' ? 'http://' : 'https://';
                return checkSite(siteurl, protocol).catch(function(secondError){
                    if (secondError.error) {
                        return $q.reject(secondError.error);
                    } else if (error.error) {
                        return $q.reject(error.error);
                    }
                    return $mmLang.translateAndReject('mm.login.checksiteversion');
                });
            });
        }
    };
        function checkSite(siteurl, protocol) {
        siteurl = siteurl.replace(/^http(s)?\:\/\//i, protocol);
        return self.siteExists(siteurl).catch(function(error) {
            if (error.errorcode && error.errorcode == 'enablewsdescription') {
                return rejectWithCriticalError(error.error, error.errorcode);
            }
            var treatedUrl = $mmText.addOrRemoveWWW(siteurl);
            return self.siteExists(treatedUrl).then(function() {
                siteurl = treatedUrl;
            }).catch(function(secondError) {
                if (secondError.errorcode && secondError.errorcode == 'enablewsdescription') {
                    return rejectWithCriticalError(secondError.error, secondError.errorcode);
                }
                error = secondError || error;
                return $q.reject({error: typeof error == 'object' ? error.error : error});
            });
        }).then(function() {
            var temporarySite = $mmSitesFactory.makeSite(undefined, siteurl);
            return temporarySite.checkLocalMobilePlugin().then(function(data) {
                data.service = data.service || mmCoreConfigConstants.wsservice;
                services[siteurl] = data.service;
                if (data.coresupported || (data.code != mmLoginSSOCode && data.code != mmLoginSSOInAppCode)) {
                    return temporarySite.getPublicConfig().then(function(config) {
                        if (!config.enablewebservices) {
                            return rejectWithCriticalError($translate.instant('mm.login.webservicesnotenabled'));
                        } else if (!config.enablemobilewebservice) {
                            return rejectWithCriticalError($translate.instant('mm.login.mobileservicesnotenabled'));
                        } else if (config.maintenanceenabled) {
                            var message = $translate.instant('mm.core.sitemaintenance');
                            if (config.maintenancemessage) {
                                message += config.maintenancemessage;
                            }
                            return rejectWithCriticalError(message);
                        }
                        if (data.code === 0) {
                            data.code = config.typeoflogin;
                        }
                        data.config = config;
                        return data;
                    }, function(error) {
                        if (error.available === 1) {
                            return $q.reject({error: error.error});
                        }
                        return data;
                    });
                }
                return data;
            }).then(function(data) {
                siteurl = temporarySite.getURL();
                return {siteurl: siteurl, code: data.code, warning: data.warning, service: data.service, config: data.config};
            });
        });
        function rejectWithCriticalError(message, errorCode) {
            return $q.reject({
                error: message,
                errorcode: errorCode,
                critical: true
            });
        }
    }
        self.siteExists = function(siteurl) {
        var data = {};
        if (!ionic.Platform.isWebView()) {
            data.username = 'a';
            data.password = 'b';
            data.service = 'c';
        }
        return $http.post(siteurl + '/login/token.php', data, {timeout: 30000, responseType: 'json'}).then(function(data) {
            data = data.data;
            if (data.errorcode && (data.errorcode == 'enablewsdescription' || data.errorcode == 'requirecorrectaccess')) {
                return $q.reject({errorcode: data.errorcode, error: data.error});
            } else if (data.error && data.error == 'Web services must be enabled in Advanced features.') {
                return $q.reject({errorcode: 'enablewsdescription', error: data.error});
            }
            return $q.when();
        });
    };
        self.getUserToken = function(siteurl, username, password, service, retry) {
        retry = retry || false;
        if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        if (!service) {
            service = self.determineService(siteurl);
        }
        var loginurl = siteurl + '/login/token.php';
        var data = {
            username: username,
            password: password,
            service: service
        };
        return $http.post(loginurl, data).then(function(response) {
            var data = response.data;
            if (typeof data == 'undefined') {
                return $mmLang.translateAndReject('mm.core.cannotconnect');
            } else {
                if (typeof data.token != 'undefined') {
                    return {token: data.token, siteurl: siteurl, privatetoken: data.privatetoken};
                } else {
                    if (typeof data.error != 'undefined') {
                        if (!retry && data.errorcode == "requirecorrectaccess") {
                            siteurl = $mmText.addOrRemoveWWW(siteurl);
                            return self.getUserToken(siteurl, username, password, service, true);
                        } else if (typeof data.errorcode != 'undefined') {
                            return $q.reject({error: data.error, errorcode: data.errorcode});
                        } else {
                            return $q.reject(data.error);
                        }
                    } else {
                        return $mmLang.translateAndReject('mm.login.invalidaccount');
                    }
                }
            }
        }, function() {
            return $mmLang.translateAndReject('mm.core.cannotconnect');
        });
    };
        self.newSite = function(siteurl, token, privateToken) {
        privateToken = privateToken || '';
        var candidateSite = $mmSitesFactory.makeSite(undefined, siteurl, token, undefined, privateToken);
        return candidateSite.fetchSiteInfo().then(function(infos) {
            if (isValidMoodleVersion(infos)) {
                var siteId = self.createSiteID(infos.siteurl, infos.username);
                candidateSite.setId(siteId);
                candidateSite.setInfo(infos);
                return getSiteConfig(candidateSite).then(function(config) {
                    candidateSite.setConfig(config);
                    self.addSite(siteId, siteurl, token, infos, privateToken, config);
                    currentSite = candidateSite;
                    self.login(siteId);
                    $mmEvents.trigger(mmCoreEventSiteAdded, siteId);
                });
            } else {
                return $mmLang.translateAndReject('mm.login.invalidmoodleversion');
            }
        });
    };
        self.createSiteID = function(siteurl, username) {
        return md5.createHash(siteurl + username);
    };
        self.determineService = function(siteurl) {
        siteurl = siteurl.replace("https://", "http://");
        if (services[siteurl]) {
            return services[siteurl];
        }
        siteurl = siteurl.replace("http://", "https://");
        if (services[siteurl]) {
            return services[siteurl];
        }
        return mmCoreConfigConstants.wsservice;
    };
        function isValidMoodleVersion(infos) {
        if (!infos) {
            return false;
        }
        var minVersion = 2012120300,
            minRelease = "2.4";
        if (infos.version) {
            var version = parseInt(infos.version);
            if (!isNaN(version)) {
                return version >= minVersion;
            }
        }
        if (infos.release) {
            var matches = infos.release.match(/^([\d|\.]*)/);
            if (matches && matches.length > 1) {
                return matches[1] >= minRelease;
            }
        }
        var appUsesLocalMobile = false;
        angular.forEach(infos.functions, function(func) {
            if (func.name.indexOf(mmCoreWSPrefix) != -1) {
                appUsesLocalMobile = true;
            }
        });
        return appUsesLocalMobile;
    }
        function validateSiteInfo(infos) {
        if (!infos.firstname || !infos.lastname) {
            var moodleLink = '<a mm-link href="' + infos.siteurl + '">' + infos.siteurl + '</a>';
            return {error: 'mm.core.requireduserdatamissing', params: {'$a': moodleLink}};
        }
        return true;
    }
        self.addSite = function(id, siteurl, token, infos, privateToken, config) {
        privateToken = privateToken || '';
        return $mmApp.getDB().insert(mmCoreSitesStore, {
            id: id,
            siteurl: siteurl,
            token: token,
            infos: infos,
            privatetoken: privateToken,
            config: config,
            loggedout: 0
        });
    };
        self.loadSite = function(siteId) {
        $log.debug('Load site ' + siteId);
        return self.getSite(siteId).then(function(site) {
            currentSite = site;
            self.login(siteId);
            if (site.isLoggedOut()) {
                return;
            }
            return site.checkIfLocalMobileInstalledAndNotUsed().then(function() {
                $mmEvents.trigger(mmCoreEventSessionExpired, {siteid: siteId});
            }, function() {
                self.updateSiteInfo(siteId);
            });
        });
    };
        self.getCurrentSite = function() {
        return currentSite;
    };
        self.deleteSite = function(siteid) {
        $log.debug('Delete site '+siteid);
        if (typeof currentSite != 'undefined' && currentSite.id == siteid) {
            self.logout();
        }
        return self.getSite(siteid).then(function(site) {
            return site.deleteDB().then(function() {
                delete sites[siteid];
                return $mmApp.getDB().remove(mmCoreSitesStore, siteid).then(function() {
                    return site.deleteFolder();
                }, function() {
                    return site.deleteFolder();
                }).then(function() {
                    $mmEvents.trigger(mmCoreEventSiteDeleted, site);
                });
            });
        });
    };
        self.hasNoSites = function() {
        return $mmApp.getDB().count(mmCoreSitesStore).then(function(count) {
            if (count > 0) {
                return $q.reject();
            }
        });
    };
        self.hasSites = function() {
        return $mmApp.getDB().count(mmCoreSitesStore).then(function(count) {
            if (count == 0) {
                return $q.reject();
            }
        });
    };
        self.getSite = function(siteId) {
        if (!siteId) {
            return currentSite ? $q.when(currentSite) : $q.reject();
        } else if (currentSite && currentSite.getId() === siteId) {
            return $q.when(currentSite);
        } else if (typeof sites[siteId] != 'undefined') {
            return $q.when(sites[siteId]);
        } else {
            return $mmApp.getDB().get(mmCoreSitesStore, siteId).then(function(data) {
                var site = $mmSitesFactory.makeSite(siteId, data.siteurl, data.token,
                        data.infos, data.privatetoken, data.config, data.loggedout);
                sites[siteId] = site;
                return site;
            });
        }
    };
        self.isCurrentSite = function(site) {
        if (!site || !currentSite) {
            return !!currentSite;
        }
        var siteId = typeof site == 'object' ? site.getId() : site;
        return currentSite.getId() === siteId;
    };
        self.getSiteDb = function(siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.getDb();
        });
    };
        self.getSiteHomeId = function(siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.getSiteHomeId();
        });
    };
        self.getSites = function(ids) {
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var formattedSites = [];
            angular.forEach(sites, function(site) {
                if (!ids || ids.indexOf(site.id) > -1) {
                    formattedSites.push({
                        id: site.id,
                        siteurl: site.siteurl,
                        fullname: site.infos.fullname,
                        sitename: site.infos.sitename,
                        avatar: site.infos.userpictureurl
                    });
                }
            });
            return formattedSites;
        });
    };
        self.getSitesIds = function() {
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var ids = [];
            angular.forEach(sites, function(site) {
                ids.push(site.id);
            });
            return ids;
        });
    };
        self.login = function(siteid) {
        return $mmApp.getDB().insert(mmCoreCurrentSiteStore, {
            id: 1,
            siteid: siteid
        }).then(function() {
            $mmEvents.trigger(mmCoreEventLogin);
        });
    };
        self.logout = function() {
        if (!currentSite) {
            return $q.when();
        }
        var siteId = currentSite.getId(),
            siteConfig = currentSite.getStoredConfig(),
            promises = [];
        currentSite = undefined;
        if (siteConfig && siteConfig.tool_mobile_forcelogout == "1") {
            promises.push(self.setSiteLoggedOut(siteId, true));
        }
        promises.push($mmApp.getDB().remove(mmCoreCurrentSiteStore, 1));
        return $q.all(promises).finally(function() {
            $mmEvents.trigger(mmCoreEventLogout, siteId);
        });
    };
        self.restoreSession = function() {
        if (sessionRestored) {
            return $q.reject();
        }
        sessionRestored = true;
        return $mmApp.getDB().get(mmCoreCurrentSiteStore, 1).then(function(current_site) {
            var siteid = current_site.siteid;
            $log.debug('Restore session in site '+siteid);
            return self.loadSite(siteid);
        }, function() {
            return $q.reject();
        });
    };
        self.setSiteLoggedOut = function(siteId, loggedOut) {
        return self.getSite(siteId).then(function(site) {
            site.setLoggedOut(loggedOut);
            return $mmApp.getDB().insert(mmCoreSitesStore, {
                id: siteId,
                siteurl: site.getURL(),
                token: site.getToken(),
                infos: site.getInfo(),
                privatetoken: site.getPrivateToken(),
                config: site.getStoredConfig(),
                loggedout: loggedOut ? 1 : 0
            });
        });
    };
        self.updateSiteToken = function(siteUrl, username, token, privateToken) {
        var siteId = self.createSiteID(siteUrl, username);
        return self.updateSiteTokenBySiteId(siteId, token, privateToken);
    };
        self.updateSiteTokenBySiteId = function(siteId, token, privateToken) {
        privateToken = privateToken || '';
        return self.getSite(siteId).then(function(site) {
            site.token = token;
            site.privateToken = privateToken;
            site.setLoggedOut(false);
            return $mmApp.getDB().insert(mmCoreSitesStore, {
                id: siteId,
                siteurl: site.getURL(),
                token: token,
                infos: site.getInfo(),
                privatetoken: privateToken,
                config: site.getStoredConfig(),
                loggedout: 0
            });
        });
    };
        self.updateSiteInfo = function(siteid) {
        return self.getSite(siteid).then(function(site) {
            return site.fetchSiteInfo().then(function(infos) {
                site.setInfo(infos);
                return getSiteConfig(site).catch(function() {
                    return site.getStoredConfig();
                }).then(function(config) {
                    site.setConfig(config);
                    return $mmApp.getDB().insert(mmCoreSitesStore, {
                        id: siteid,
                        siteurl: site.getURL(),
                        token: site.getToken(),
                        infos: infos,
                        privatetoken: site.getPrivateToken(),
                        config: config,
                        loggedout: site.isLoggedOut() ? 1 : 0
                    }).finally(function() {
                        $mmEvents.trigger(mmCoreEventSiteUpdated, siteid);
                    });
                });
            });
        });
    };
        self.updateSiteInfoByUrl = function(siteurl, username) {
        var siteid = self.createSiteID(siteurl, username);
        return self.updateSiteInfo(siteid);
    };
        self.getSiteIdsFromUrl = function(url, prioritize, username) {
        if (prioritize && currentSite && currentSite.containsUrl(url)) {
            if (!username || currentSite.getInfo().username == username) {
                return $q.when([currentSite.getId()]);
            }
        }
        if (!url.match(/^https?:\/\//i)) {
            if (url.match(/^[^:]{2,10}:\/\//i)) {
                return $q.when([]);
            } else {
                if (currentSite) {
                    return $q.when([currentSite.getId()]);
                } else {
                    return $q.when([]);
                }
            }
        }
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var ids = [];
            angular.forEach(sites, function(site) {
                if (!sites[site.id]) {
                    sites[site.id] = $mmSitesFactory.makeSite(
                            site.id, site.siteurl, site.token, site.infos, site.privatetoken, site.config, site.loggedout);
                }
                if (sites[site.id].containsUrl(url)) {
                    if (!username || sites[site.id].getInfo().username == username) {
                        ids.push(site.id);
                    }
                }
            });
            return ids;
        }).catch(function() {
            return [];
        });
    };
        self.getStoredCurrentSiteId = function() {
        return $mmApp.getDB().get(mmCoreCurrentSiteStore, 1).then(function(current_site) {
            return current_site.siteid;
        });
    };
        self.getSitePublicConfig = function(siteUrl) {
        var temporarySite = $mmSitesFactory.makeSite(undefined, siteUrl);
        return temporarySite.getPublicConfig();
    };
        function getSiteConfig(site) {
        if (!site.wsAvailable('tool_mobile_get_config')) {
            return $q.when();
        }
        return site.getConfig(false, true);
    }
        self.isFeatureDisabled = function(name, siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.isFeatureDisabled(name);
        });
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreSynchronizationStore', 'sync')
.constant('mmCoreSynchronizationWarningsStore', 'sync_warnings')
.config(["$mmSitesFactoryProvider", "mmCoreSynchronizationStore", "mmCoreSynchronizationWarningsStore", function($mmSitesFactoryProvider, mmCoreSynchronizationStore, mmCoreSynchronizationWarningsStore) {
    var stores = [
        {
            name: mmCoreSynchronizationStore,
            keyPath: ['component', 'id'],
            indexes: []
        },
        {
            name: mmCoreSynchronizationWarningsStore,
            keyPath: ['component', 'id'],
            indexes: []
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmSync', ["$q", "$log", "$mmSitesManager", "$mmSite", "mmCoreSynchronizationStore", "mmCoreSynchronizationWarningsStore", function($q, $log, $mmSitesManager, $mmSite, mmCoreSynchronizationStore, mmCoreSynchronizationWarningsStore) {
    $log = $log.getInstance('$mmSync');
    var self = {},
        mmSync = (function () {
            var syncPromises = {};
            this.component = 'core';
            this.syncInterval = 300000;
                        this.getSyncTime = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    return db.get(mmCoreSynchronizationStore, [that.component, id]).then(function(entry) {
                        return entry.time;
                    }).catch(function() {
                        return 0;
                    });
                });
            };
                        this.setSyncTime = function(id, siteId, time) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    var entry = {
                            id: id,
                            component: that.component,
                            time: typeof time != 'undefined' ? time : new Date().getTime()
                        };
                    return db.insert(mmCoreSynchronizationStore, entry);
                });
            };
                        this.isSyncNeeded = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return this.getSyncTime(id, siteId).then(function(time) {
                    return new Date().getTime() - that.syncInterval >= time;
                });
            };
                        this.isSyncing = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var uniqueId = this.getUniqueSyncId(id);
                return !!(syncPromises[siteId] && syncPromises[siteId][uniqueId]);
            };
                        this.waitForSync = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isSyncing(id, siteId)) {
                    var uniqueId = this.getUniqueSyncId(id);
                    return syncPromises[siteId][uniqueId].catch(function() {});
                }
                return $q.when();
            };
                        this.getOngoingSync = function (id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isSyncing(id, siteId)) {
                    var uniqueId = this.getUniqueSyncId(id);
                    return syncPromises[siteId][uniqueId];
                }
                return false;
            };
                        this.addOngoingSync = function (id, promise, siteId) {
                var uniqueId = this.getUniqueSyncId(id);
                siteId = siteId || $mmSite.getId();
                if (!syncPromises[siteId]) {
                    syncPromises[siteId] = {};
                }
                syncPromises[siteId][uniqueId] = promise;
                return promise.finally(function() {
                    delete syncPromises[siteId][uniqueId];
                });
            };
            this.getUniqueSyncId = function(id) {
                return this.component + '#' + id;
            };
                        this.getSyncWarnings = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    return db.get(mmCoreSynchronizationWarningsStore, [that.component, id]).then(function(entry) {
                        return entry.warnings;
                    }).catch(function() {
                        return [];
                    });
                });
            };
                        this.setSyncWarnings = function(id, warnings, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    var entry = {
                        id: id,
                        component: that.component,
                        warnings: typeof warnings != 'undefined' ? warnings : []
                    };
                    return db.insert(mmCoreSynchronizationWarningsStore, entry);
                });
            };
            return this;
        }());
        self.createChild = function(component, syncInterval) {
        var child = Object.create(mmSync);
        child.component = component;
        if (typeof syncInterval != 'undefined') {
            child.syncInterval = syncInterval;
        }
        return child;
    };
    return self;
}]);
angular.module('mm.core')
.factory('$mmSyncBlock', ["$log", "$mmSite", function($log, $mmSite) {
    $log = $log.getInstance('$mmSyncBlock');
    var self = {
        blockedItems: {}
    };
        self.isBlocked = function(component, id, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (!self.blockedItems[siteId]) {
            return false;
        }
        if (!self.blockedItems[siteId][uniqueId]) {
            return false;
        }
        return Object.keys(self.blockedItems[siteId][uniqueId]).length > 0;
    };
        self.blockOperation = function(component, id, operation, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (!self.blockedItems[siteId]) {
            self.blockedItems[siteId] = {};
        }
        if (!self.blockedItems[siteId][uniqueId]) {
            self.blockedItems[siteId][uniqueId] = {};
        }
        operation = operation || '-';
        self.blockedItems[siteId][uniqueId][operation] = true;
    };
        self.unblockOperation = function(component, id, operation, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (self.blockedItems[siteId]) {
            if (self.blockedItems[siteId][uniqueId]) {
                operation = operation || '-';
                delete self.blockedItems[siteId][uniqueId][operation];
            }
        }
    };
        self.clearBlock = function(component, id, iteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (self.blockedItems[siteId]) {
            delete self.blockedItems[siteId][uniqueId];
        }
    };
        self.clearAllBlocks = function(siteId) {
        if (siteId) {
            delete self.blockedItems[siteId];
        } else {
            self.blockedItems = {};
        }
    };
    function getUniqueSyncBlockId(component, id) {
        return component + '#' + id;
    }
    return self;
}])
.run(["$mmSyncBlock", "$mmEvents", "mmCoreEventLogout", function($mmSyncBlock, $mmEvents, mmCoreEventLogout) {
    $mmEvents.on(mmCoreEventLogout, function(siteId) {
        $mmSyncBlock.clearAllBlocks(siteId);
    });
}]);
angular.module('mm.core')
.factory('$mmText', ["$q", "$mmLang", "$translate", "$state", function($q, $mmLang, $translate, $state) {
    var self = {},
        element = document.createElement('div');
        self.buildMessage = function(messages) {
        var result = '';
        angular.forEach(messages, function(message) {
            if (message) {
                result = result + '<p>' + message + '</p>';
            }
        });
        return result;
    };
        self.bytesToSize = function(bytes, precision) {
        if (typeof bytes == 'undefined' || bytes < 0) {
            return $translate.instant('mm.core.notapplicable');
        }
        if (typeof precision == 'undefined' || precision < 0) {
            precision = 2;
        }
        var keys = ['mm.core.sizeb', 'mm.core.sizekb', 'mm.core.sizemb', 'mm.core.sizegb', 'mm.core.sizetb'];
        var units = $translate.instant(keys);
        var posttxt = 0;
        if (bytes >= 1024) {
            while (bytes >= 1024) {
                posttxt++;
                bytes = bytes / 1024;
            }
            bytes = Number(Math.round(bytes+'e+'+precision) + 'e-'+precision);
        }
        return $translate.instant('mm.core.humanreadablesize', {size: Number(bytes), unit: units[keys[posttxt]]});
    };
        self.cleanTags = function(text, singleLine) {
        if (!text) {
            return '';
        }
        text = text.replace(/(<([^>]+)>)/ig,"");
        text = angular.element('<p>').html(text).text();
        text = self.replaceNewLines(text, singleLine ? ' ' : '<br>');
        return text;
    };
        self.replaceNewLines = function(text, newValue) {
        return text.replace(/(?:\r\n|\r|\n)/g, newValue);
    };
        self.formatText = function(text, clean, singleLine, shortenLength) {
        return self.treatMultilangTags(text).then(function(formatted) {
            if (clean) {
                formatted = self.cleanTags(formatted, singleLine);
            }
            if (shortenLength && parseInt(shortenLength) > 0) {
                formatted = self.shortenText(formatted, parseInt(shortenLength));
            }
            return formatted;
        });
    };
        self.formatHtmlLines = function(text) {
        var hasHTMLTags = self.hasHTMLTags(text);
        if (text.indexOf('<p>') == -1) {
            text = '<p>' + text + '</p>';
        }
        if (!hasHTMLTags) {
            return self.replaceNewLines(text, '<br>');
        }
        return text;
    };
        self.shortenText = function(text, length) {
        if (text.length > length) {
            text = text.substr(0, length);
            var lastWordPos = text.lastIndexOf(' ');
            if (lastWordPos > 0) {
                text = text.substr(0, lastWordPos);
            }
            text += '&hellip;';
        }
        return text;
    };
        self.expandText = function(title, text, replaceLineBreaks, component, componentId) {
        if (text.length > 0) {
            $state.go('site.mm_textviewer', {
                title: title,
                content: text,
                replacelinebreaks: replaceLineBreaks,
                component: component,
                componentId: componentId
            });
        }
    };
        self.treatMultilangTags = function(text) {
        if (!text) {
            return $q.when('');
        }
        return $mmLang.getCurrentLanguage().then(function(language) {
            var currentLangRe = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g'),
                anyLangRE = /<(?:lang|span)[^>]+lang="[a-zA-Z0-9_-]+"[^>]*>(.*?)<\/(?:lang|span)>/g;
            if (!text.match(currentLangRe)) {
                var matches = text.match(anyLangRE);
                if (matches && matches[0]) {
                    language = matches[0].match(/lang="([a-zA-Z0-9_-]+)"/)[1];
                    currentLangRe = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g');
                } else {
                    return text;
                }
            }
            text = text.replace(currentLangRe, '$1');
            text = text.replace(anyLangRE, '');
            return text;
        });
    };
        self.escapeHTML = function(text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        } else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    };
        self.decodeHTML = function(text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        } else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&quot;/g, '"')
            .replace(/&#039;/g, "'")
            .replace(/&nbsp;/g, ' ');
    };
        self.decodeHTMLEntities = function(text) {
        if (text && typeof text === 'string') {
            element.innerHTML = text;
            text = element.textContent;
            element.textContent = '';
        }
        return text;
    };
        self.addOrRemoveWWW = function(url) {
        if (typeof url == 'string') {
            if (url.match(/http(s)?:\/\/www\./)) {
                url = url.replace('www.', '');
            } else {
                url = url.replace('https://', 'https://www.');
                url = url.replace('http://', 'http://www.');
            }
        }
        return url;
    };
        self.removeProtocolAndWWW = function(url) {
        url = url.replace(/.*?:\/\//g, '');
        url = url.replace(/^www./, '');
        return url;
    };
        self.getUsernameFromUrl = function(url) {
        if (url.indexOf('@') > -1) {
            var withoutProtocol = url.replace(/.*?:\/\//, ''),
                matches = withoutProtocol.match(/[^@]*/);
            if (matches && matches.length && !matches[0].match(/[\/|?]/)) {
                return matches[0];
            }
        }
    };
        self.removeSpecialCharactersForFiles = function(text) {
        return text.replace(/[#:\/\?\\]+/g, '_');
    };
        self.getLastFileWithoutParams = function(url) {
        var filename = url.substr(url.lastIndexOf('/') + 1);
        if (filename.indexOf('?') != -1) {
            filename = filename.substr(0, filename.indexOf('?'));
        }
        return filename;
    };
        self.twoDigits = function(num) {
        if (num < 10) {
            return '0' + num;
        } else {
            return '' + num;
        }
    };
        self.escapeForRegex = function(text) {
        if (!text || !text.replace) {
            return '';
        }
        return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    };
        self.countWords = function(text) {
        text = text.replace(/<script[^>]*>([\S\s]*?)<\/script>/gmi, '');
        text = text.replace(/<\/?(?!\!)[^>]*>/gi, '');
        text = self.decodeHTMLEntities(text);
        text = text.replace(/_/gi, " ");
        text = text.replace(/[\'"’-]/gi, "");
        text = text.replace(/([0-9])[.,]([0-9])/gi, '$1$2');
        return text.split(/\w\b/gi).length - 1;
    };
        self.getTextPluginfileUrl = function(files) {
        if (files && files.length) {
            var fileURL = files[0].fileurl;
            return fileURL.substr(0, Math.max(fileURL.lastIndexOf('/'), fileURL.lastIndexOf('%2F')));
        }
        return false;
    };
        self.replacePluginfileUrls = function(text, files) {
        if (text) {
            var fileURL = self.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(/@@PLUGINFILE@@/g, fileURL);
            }
        }
        return text;
    };
        self.restorePluginfileUrls = function(text, files) {
        if (text) {
            var fileURL = self.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(new RegExp(self.escapeForRegex(fileURL), 'g'), '@@PLUGINFILE@@');
            }
        }
        return text;
    };
        self.getUrlProtocol = function(url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([^\/:\.\?]*):\/\//);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
        self.getUrlScheme = function(url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([a-z][a-z0-9+\-.]*):/);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
        self.hasHTMLTags = function(text) {
        return /<[a-z][\s\S]*>/i.test(text);
    };
        self.hasUnicode = function(text) {
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) > 55295) {
                return true;
            }
        }
        return false;
    };
        self.hasUnicodeData = function(data) {
        for (var el in data) {
            if (angular.isObject(data[el])) {
                if (self.hasUnicodeData(data[el])) {
                    return true;
                }
            } else if (typeof data[el] == "string" && self.hasUnicode(data[el])) {
                return true;
            }
        }
        return false;
    };
        self.stripUnicode = function(text) {
        var stripped = "";
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) <= 55295){
                stripped += text.charAt(x);
            }
        }
        return stripped;
    };
        self.decodeURI = function(uri) {
        try {
            return decodeURI(uri);
        } catch(ex) {
        }
        return uri;
    };
        self.decodeURIComponent = function(uri) {
        try {
            return decodeURIComponent(uri);
        } catch(ex) {
        }
        return uri;
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreVersionApplied', 'version_applied')
.factory('$mmUpdateManager', ["$log", "$q", "$mmConfig", "$mmSitesManager", "$mmFS", "$cordovaLocalNotification", "$mmLocalNotifications", "$mmApp", "$mmEvents", "mmCoreSitesStore", "mmCoreVersionApplied", "mmCoreEventSiteAdded", "mmCoreEventSiteUpdated", "mmCoreEventSiteDeleted", "$injector", "$mmFilepool", "mmCoreCourseModulesStore", "mmFilepoolLinksStore", "$mmAddonManager", "mmFilepoolPackagesStore", "mmCoreConfigConstants", function($log, $q, $mmConfig, $mmSitesManager, $mmFS, $cordovaLocalNotification, $mmLocalNotifications,
            $mmApp, $mmEvents, mmCoreSitesStore, mmCoreVersionApplied, mmCoreEventSiteAdded, mmCoreEventSiteUpdated,
            mmCoreEventSiteDeleted, $injector, $mmFilepool, mmCoreCourseModulesStore, mmFilepoolLinksStore, $mmAddonManager,
            mmFilepoolPackagesStore, mmCoreConfigConstants) {
    $log = $log.getInstance('$mmUpdateManager');
    var self = {},
        sitesFilePath = 'migration/sites.json';
        self.check = function() {
        var promises = [],
            versionCode = mmCoreConfigConstants.versioncode;
        return $mmConfig.get(mmCoreVersionApplied, 0).then(function(versionApplied) {
            if (versionCode >= 391 && versionApplied < 391) {
                promises.push(migrateMM1Sites());
                promises.push(clearAppFolder().catch(function() {}));
            }
            if (versionCode >= 2003 && versionApplied < 2003) {
                promises.push(cancelAndroidNotifications());
            }
            if (versionCode >= 2003) {
                setStoreSitesInFile();
            }
            if (versionCode >= 2007 && versionApplied < 2007) {
                promises.push(migrateModulesStatus());
            }
            if (versionCode >= 2013 && versionApplied < 2013) {
                promises.push(migrateFileExtensions());
            }
            if (versionCode >= 2017 && versionApplied < 2017) {
                promises.push(setCalendarDefaultNotifTime());
                promises.push(setSitesConfig());
                promises.push(migrateWikiNewPagesStore());
            }
            return $q.all(promises).then(function() {
                return $mmConfig.set(mmCoreVersionApplied, versionCode);
            }).catch(function() {
                $log.error('Error applying update from ' + versionApplied + ' to ' + versionCode);
            });
        });
    };
        function clearAppFolder() {
        if ($mmFS.isAvailable()) {
            return $mmFS.getDirectoryContents('').then(function(entries) {
                var promises = [];
                angular.forEach(entries, function(entry) {
                    var canDeleteAndroid = ionic.Platform.isAndroid() && entry.name !== 'cache' && entry.name !== 'files';
                    var canDeleteIOS = ionic.Platform.isIOS() && entry.name !== 'NoCloud';
                    if (canDeleteIOS || canDeleteAndroid) {
                        promises.push($mmFS.removeDir(entry.name));
                    }
                });
                return $q.all(promises);
            });
        } else {
            return $q.when();
        }
    }
        function migrateMM1Sites() {
        var sites = localStorage.getItem('sites'),
            promises = [];
        if (sites) {
            sites = sites.split(',');
            angular.forEach(sites, function(siteid) {
                if (!siteid) {
                    return;
                }
                $log.debug('Migrating site from MoodleMobile 1: ' + siteid);
                var site = localStorage.getItem('sites-'+siteid),
                    infos;
                if (site) {
                    try {
                        site = JSON.parse(site);
                    } catch(ex) {
                        $log.warn('Site ' + siteid + ' data is invalid. Ignoring.');
                        return;
                    }
                    infos = angular.copy(site);
                    delete infos.id;
                    delete infos.token;
                    promises.push($mmSitesManager.addSite(site.id, site.siteurl, site.token, infos));
                } else {
                    $log.warn('Site ' + siteid + ' not found in local storage. Ignoring.');
                }
            });
        }
        return $q.all(promises).then(function() {
            if (sites) {
                localStorage.clear();
            }
        });
    }
        function cancelAndroidNotifications() {
        if ($mmLocalNotifications.isAvailable() && ionic.Platform.isAndroid()) {
            return $cordovaLocalNotification.cancelAll().catch(function() {
                $log.error('Error cancelling Android notifications.');
            });
        }
        return $q.when();
    }
        function setStoreSitesInFile() {
        $mmEvents.on(mmCoreEventSiteAdded, storeSitesInFile);
        $mmEvents.on(mmCoreEventSiteUpdated, storeSitesInFile);
        $mmEvents.on(mmCoreEventSiteDeleted, storeSitesInFile);
        storeSitesInFile();
    }
        function getSitesStoredInFile() {
        if ($mmFS.isAvailable()) {
            return $mmFS.readFile(sitesFilePath).then(function(sites) {
                try {
                    sites = JSON.parse(sites);
                } catch (ex) {
                    sites = [];
                }
                return sites;
            }).catch(function() {
                return [];
            });
        } else {
            return $q.when([]);
        }
    }
        function storeSitesInFile() {
        if ($mmFS.isAvailable()) {
            return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
                angular.forEach(sites, function(site) {
                    site.token = 'private';
                });
                return $mmFS.writeFile(sitesFilePath, JSON.stringify(sites));
            });
        } else {
            return $q.when();
        }
    }
        function deleteSitesFile() {
        if ($mmFS.isAvailable()) {
            return $mmFS.removeFile(sitesFilePath);
        } else {
            return $q.when();
        }
    }
        function migrateModulesStatus() {
        var components = [];
        components.push($injector.get('mmaModBookComponent'));
        components.push($injector.get('mmaModImscpComponent'));
        components.push($injector.get('mmaModPageComponent'));
        components.push($injector.get('mmaModResourceComponent'));
        return $mmSitesManager.getSitesIds().then(function(sites) {
            var promises = [];
            angular.forEach(sites, function(siteId) {
                promises.push(migrateSiteModulesStatus(siteId, components));
            });
            return $q.all(promises);
        });
    }
        function migrateSiteModulesStatus(siteId, components) {
        $log.debug('Migrate site modules status from site ' + siteId);
        return $mmSitesManager.getSiteDb(siteId).then(function(db) {
            return db.getAll(mmCoreCourseModulesStore).then(function(entries) {
                var promises = [];
                angular.forEach(entries, function(entry) {
                    if (!parseInt(entry.id)) {
                        return;
                    }
                    promises.push(determineComponent(db, entry.id, components).then(function(component) {
                        if (component) {
                            entry.component = component;
                            entry.componentId = entry.id;
                            entry.id = $mmFilepool.getPackageId(component, entry.id);
                            promises.push(db.insert(mmFilepoolPackagesStore, entry));
                        }
                    }));
                });
                return $q.all(promises).then(function() {
                    return db.removeAll(mmCoreCourseModulesStore).catch(function() {
                    });
                });
            });
        });
    }
        function migrateFileExtensions() {
        return $mmSitesManager.getSitesIds().then(function(sites) {
            var promises = [];
            angular.forEach(sites, function(siteId) {
                promises.push($mmFilepool.fillMissingExtensionInFiles(siteId));
            });
            promises.push($mmFilepool.treatExtensionInQueue());
            return $q.all(promises);
        });
    }
        function determineComponent(db, componentId, components) {
        var promises = [],
            component;
        angular.forEach(components, function(c) {
            if (c) {
                promises.push(db.whereEqual(mmFilepoolLinksStore, 'componentAndId', [c, componentId]).then(function(items) {
                    if (items.length) {
                        component = c;
                    }
                }).catch(function() {
                }));
            }
        });
        return $q.all(promises).then(function() {
            return component;
        });
    }
        function setCalendarDefaultNotifTime() {
        if (!$mmLocalNotifications.isAvailable()) {
            return $q.when();
        }
        var $mmaCalendar = $mmAddonManager.get('$mmaCalendar'),
            mmaCalendarDefaultNotifTime = $mmAddonManager.get('mmaCalendarDefaultNotifTime');
        if (!$mmaCalendar || typeof mmaCalendarDefaultNotifTime == 'undefined') {
            return $q.when();
        }
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            var promises = [];
            angular.forEach(siteIds, function(siteId) {
                promises.push($mmaCalendar.getAllEventsFromLocalDb(siteId).then(function(events) {
                    var eventPromises = [];
                    angular.forEach(events, function(event) {
                        if (event.notificationtime == mmaCalendarDefaultNotifTime) {
                            event.notificationtime = -1;
                            eventPromises.push($mmaCalendar.storeEventInLocalDb(event, siteId));
                        }
                    });
                    return $q.all(eventPromises);
                }));
            });
            return $q.all(promises);
        });
    }
        function setSitesConfig() {
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            return $mmSitesManager.getStoredCurrentSiteId().catch(function() {
            }).then(function(currentSiteId) {
                var promise;
                if (currentSiteId) {
                    promise = setSiteConfig(currentSiteId);
                } else {
                    promise = $q.when();
                }
                angular.forEach(siteIds, function(siteId) {
                    if (siteId != currentSiteId) {
                        setSiteConfig(siteId);
                    }
                });
                return promise;
            });
        });
    }
        function setSiteConfig(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (site.getStoredConfig() || !site.wsAvailable('tool_mobile_get_config')) {
                return;
            }
            return site.getConfig().then(function(config) {
                return $mmSitesManager.addSite(site.getId(), site.getURL(),
                        site.getToken(), site.getInfo(), site.getPrivateToken(), config);
            }).catch(function() {
            });
        });
    }
        function migrateWikiNewPagesStore() {
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            return $mmSitesManager.getStoredCurrentSiteId().catch(function() {
            }).then(function(currentSiteId) {
                var promise;
                if (currentSiteId) {
                    promise = migrateWikiNewPagesSiteStore(currentSiteId);
                } else {
                    promise = $q.when();
                }
                angular.forEach(siteIds, function(siteId) {
                    if (siteId != currentSiteId) {
                        migrateWikiNewPagesSiteStore(siteId);
                    }
                });
                return promise;
            });
        });
    }
        function migrateWikiNewPagesSiteStore(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var $mmaModWikiOffline = $injector.get('$mmaModWikiOffline'),
                oldStorageName = 'mma_mod_wiki_new_pages',
                db = site.getDb();
            try {
                return db.getAll(oldStorageName).then(function(pages) {
                    if (pages.length > 0) {
                        $log.debug('Found ' + pages.length + ' new wiki pages from old store to migrate on site' + siteId);
                        var promises = [];
                        angular.forEach(pages, function(page) {
                            if (page.subwikiid > 0) {
                                promises.push($mmaModWikiOffline.saveNewPage(page.title, page.cachedcontent, page.subwikiid, 0, 0,
                                    0, siteId));
                            }
                        });
                        return $q.all(promises).finally(function() {
                            db.removeAll(oldStorageName);
                        });
                    }
                }).catch(function() {
                    return $q.when();
                });
            } catch (e) {
            }
            return $q.when();
        });
    }
    return self;
}]);

angular.module('mm.core')
.factory('$mmURLDelegate', ["$log", function($log) {
    $log = $log.getInstance('$mmURLDelegate');
    var observers = {},
        self = {};
        self.register = function(name, callback) {
        $log.debug("Register observer '"+name+"' for custom URL.");
        observers[name] = callback;
    };
        self.notify = function(url) {
        var treated = false;
        angular.forEach(observers, function(callback, name) {
            if (!treated && typeof(callback) === 'function') {
                treated = callback(url);
            }
        });
    };
    return self;
}])
.run(["$mmURLDelegate", "$log", function($mmURLDelegate, $log) {
    window.handleOpenURL = function(url) {
        $log.debug('App launched by URL.');
        $mmURLDelegate.notify(url);
    };
}]);

angular.module('mm.core')
.provider('$mmUtil', ["mmCoreSecondsYear", "mmCoreSecondsDay", "mmCoreSecondsHour", "mmCoreSecondsMinute", function(mmCoreSecondsYear, mmCoreSecondsDay, mmCoreSecondsHour, mmCoreSecondsMinute) {
    var self = this,
        provider = this;
        self.param = function(obj, addNull) {
        var query = '', name, value, fullSubName, subName, subValue, innerObj, i;
        for (name in obj) {
            value = obj[name];
            if (value instanceof Array) {
                for (i = 0; i < value.length; ++i) {
                    subValue = value[i];
                    fullSubName = name + '[' + i + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += self.param(innerObj) + '&';
                }
            } else if (value instanceof Object) {
                for (subName in value) {
                    subValue = value[subName];
                    fullSubName = name + '[' + subName + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += self.param(innerObj) + '&';
                }
            } else if (addNull || (value !== undefined && value !== null)) {
                query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
            }
        }
        return query.length ? query.substr(0, query.length - 1) : query;
    };
    this.$get = ["$ionicLoading", "$ionicPopup", "$injector", "$translate", "$http", "$log", "$q", "$mmLang", "$mmFS", "$timeout", "$mmApp", "$mmText", "mmCoreWifiDownloadThreshold", "mmCoreDownloadThreshold", "$ionicScrollDelegate", "$mmWS", "$cordovaInAppBrowser", "$mmConfig", "mmCoreSettingsRichTextEditor", "$rootScope", "$ionicPlatform", "$ionicHistory", "mmCoreSplitViewBlock", "$state", "$window", "$cordovaClipboard", function($ionicLoading, $ionicPopup, $injector, $translate, $http, $log, $q, $mmLang, $mmFS, $timeout, $mmApp,
                $mmText, mmCoreWifiDownloadThreshold, mmCoreDownloadThreshold, $ionicScrollDelegate, $mmWS, $cordovaInAppBrowser,
                $mmConfig, mmCoreSettingsRichTextEditor, $rootScope, $ionicPlatform, $ionicHistory, mmCoreSplitViewBlock, $state,
                $window, $cordovaClipboard) {
        $log = $log.getInstance('$mmUtil');
        var self = {},
            matchesFn,
            inputSupportKeyboard = ['date', 'datetime', 'datetime-local', 'email', 'month', 'number', 'password',
                'search', 'tel', 'text', 'time', 'url', 'week'],
            originalBackFunction = $rootScope.$ionicGoBack,
            backFunctionsStack = [originalBackFunction],
            toastPromise;
                self.formatURL = function(url) {
            url = url.trim();
            if (! /^http(s)?\:\/\/.*/i.test(url)) {
                url = "https://" + url;
            }
            url = url.replace(/^http/i, 'http');
            url = url.replace(/^https/i, 'https');
            url = url.replace(/\/$/, "");
            return url;
        };
                self.resolveObject = function(object, instantiate) {
            var toInject,
                resolved;
            instantiate = angular.isUndefined(instantiate) ? false : instantiate;
            if (angular.isFunction(object) || angular.isObject(object)) {
                resolved = object;
            } else if (angular.isString(object)) {
                toInject = object.split('.');
                resolved = $injector.get(toInject[0]);
                if (toInject.length > 1) {
                    resolved = resolved[toInject[1]];
                }
            }
            if (angular.isFunction(resolved) && instantiate) {
                resolved = resolved();
            }
            if (typeof resolved === 'undefined') {
                throw new Error('Unexpected argument object passed');
            }
            return resolved;
        };
                self.isDownloadableUrl = function(url) {
            return self.isPluginFileUrl(url) || self.isThemeImageUrl(url) || self.isGravatarUrl(url);
        };
                self.isGravatarUrl = function(url) {
            return url && url.indexOf('gravatar.com/avatar') !== -1;
        };
                self.isPluginFileUrl = function(url) {
            return url && url.indexOf('/pluginfile.php') !== -1;
        };
                self.isThemeImageUrl = function(url) {
            return url && url.indexOf('/theme/image.php') !== -1;
        };
                self.isValidURL = function(url) {
            return /^http(s)?\:\/\/.+/i.test(url);
        };
                self.fixPluginfileURL = function(url, token) {
            if (!url) {
                return '';
            }
            if (url.indexOf('token=') != -1) {
                return url;
            }
            if (url.indexOf('pluginfile') == -1) {
                return url;
            }
            if (!token) {
                return '';
            }
            if (url.indexOf('?file=') != -1 || url.indexOf('?forcedownload=') != -1 || url.indexOf('?rev=') != -1) {
                url += '&';
            } else {
                url += '?';
            }
            url += 'token=' + token;
            if (url.indexOf('/webservice/pluginfile') == -1) {
                url = url.replace('/pluginfile', '/webservice/pluginfile');
            }
            return url;
        };
                self.openFile = function(path) {
            var deferred = $q.defer();
            if (window.plugins) {
                var extension = $mmFS.getFileExtension(path),
                    mimetype = $mmFS.getMimeType(extension);
                if (ionic.Platform.isAndroid() && window.plugins.webintent) {
                    var iParams = {
                        action: "android.intent.action.VIEW",
                        url: path,
                        type: mimetype
                    };
                    window.plugins.webintent.startActivity(
                        iParams,
                        function() {
                            $log.debug('Intent launched');
                            deferred.resolve();
                        },
                        function() {
                            $log.debug('Intent launching failed.');
                            $log.debug('action: ' + iParams.action);
                            $log.debug('url: ' + iParams.url);
                            $log.debug('type: ' + iParams.type);
                            if (!extension || extension.indexOf('/') > -1 || extension.indexOf('\\') > -1) {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoextension');
                            } else {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoapp');
                            }
                        }
                    );
                } else if (ionic.Platform.isIOS() && typeof handleDocumentWithURL == 'function') {
                    $mmFS.getBasePath().then(function(fsRoot) {
                        if (path.indexOf(fsRoot > -1)) {
                            path = path.replace(fsRoot, "");
                            path = encodeURIComponent($mmText.decodeURIComponent(path));
                            path = fsRoot + path;
                        }
                        handleDocumentWithURL(
                            function() {
                                $log.debug('File opened with handleDocumentWithURL' + path);
                                deferred.resolve();
                            },
                            function(error) {
                                $log.debug('Error opening with handleDocumentWithURL' + path);
                                if(error == 53) {
                                    $log.error('No app that handles this file type.');
                                }
                                self.openInBrowser(path);
                                deferred.resolve();
                            },
                            path
                        );
                    }, deferred.reject);
                } else {
                    self.openInBrowser(path);
                    deferred.resolve();
                }
            } else {
                $log.debug('Opening external file using window.open()');
                window.open(path, '_blank');
                deferred.resolve();
            }
            return deferred.promise;
        };
                self.openInBrowser = function(url) {
            window.open(url, '_system');
        };
                self.openInApp = function(url, options) {
            if (!url) {
                return;
            }
            options = options || {};
            if (!options.enableViewPortScale) {
                options.enableViewPortScale = 'yes';
            }
            if (!options.location && ionic.Platform.isIOS() && url.indexOf('file://') === 0) {
                options.location = 'no';
            }
            $cordovaInAppBrowser.open(url, '_blank', options);
        };
                self.closeInAppBrowser = function() {
            $cordovaInAppBrowser.close();
        };
                self.openOnlineFile = function(url) {
            var deferred = $q.defer();
            if (ionic.Platform.isAndroid() && window.plugins && window.plugins.webintent) {
                var extension,
                    iParams;
                $mmWS.getRemoteFileMimeType(url).then(function(mimetype) {
                    if (!mimetype) {
                        extension = $mmFS.guessExtensionFromUrl(url);
                        mimetype = $mmFS.getMimeType(extension);
                    }
                    iParams = {
                        action: "android.intent.action.VIEW",
                        url: url,
                        type: mimetype
                    };
                    window.plugins.webintent.startActivity(
                        iParams,
                        function() {
                            $log.debug('Intent launched');
                            deferred.resolve();
                        },
                        function() {
                            $log.debug('Intent launching failed.');
                            $log.debug('action: ' + iParams.action);
                            $log.debug('url: ' + iParams.url);
                            $log.debug('type: ' + iParams.type);
                            if (!extension || extension.indexOf('/') > -1 || extension.indexOf('\\') > -1) {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoextension');
                            } else {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoapp');
                            }
                        }
                    );
                });
            } else {
                $log.debug('Opening remote file using window.open()');
                window.open(url, '_blank');
                deferred.resolve();
            }
            return deferred.promise;
        };
                self.getMimeType = function(url) {
            return $mmWS.getRemoteFileMimeType(url).then(function(mimetype) {
                if (!mimetype) {
                    extension = $mmFS.guessExtensionFromUrl(url);
                    mimetype = $mmFS.getMimeType(extension);
                }
                return mimetype || '';
            });
        };
                self.showModalLoading = function(text, needsTranslate) {
            var modalClosed = false,
                modalShown = false,
                showModalPromise;
            if (!modalClosed) {
                if (!text) {
                    text = $translate.instant('mm.core.loading');
                } else if (needsTranslate) {
                    text = $translate.instant(text);
                }
                showModalPromise = $ionicLoading.show({
                    template:   '<ion-spinner></ion-spinner>' +
                                '<p>' + addFormatTextIfNeeded(text) + '</p>'
                }).then(function() {
                    showModalPromise = null;
                    if (!modalClosed) {
                        modalShown = true;
                    }
                });
            }
            return {
                dismiss: function() {
                    modalClosed = true;
                    if (showModalPromise) {
                        showModalPromise.finally(function() {
                            $ionicLoading.hide();
                        });
                    } else if (modalShown) {
                        $ionicLoading.hide();
                    }
                }
            };
        };
                self.showToast = function(text, needsTranslate, duration) {
            duration = duration || 2000;
            if (needsTranslate) {
                text = $translate.instant(text);
            }
            return $ionicLoading.show({
                template: text,
                duration: duration,
                noBackdrop: true,
                hideOnStateChange: true
            }).then(function() {
                var container = angular.element(document.querySelector(".loading-container.visible")).addClass('mm-toast');
                $timeout.cancel(toastPromise);
                toastPromise = $timeout(function() {
                    container.removeClass('mm-toast');
                }, duration);
            });
        };
                self.copyToClipboard = function(text) {
            return $cordovaClipboard.copy(text).then(function() {
                return self.showToast('mm.core.copiedtoclipboard', true);
            }).catch(function () {
            });
        };
                self.showModalLoadingWithTemplate = function(template, options) {
            options = options || {};
            if (!template) {
                template = "<ion-spinner></ion-spinner><p>{{'mm.core.loading' | translate}}</p>";
            }
            options.template = addFormatTextIfNeeded(template);
            $ionicLoading.show(options);
            return {
                dismiss: function() {
                    $ionicLoading.hide();
                }
            };
        };
                self.showErrorModal = function(errorMessage, needsTranslate, autocloseTime) {
            if (angular.isObject(errorMessage)) {
                if (typeof errorMessage.content != 'undefined') {
                    errorMessage = errorMessage.content;
                } else if (typeof errorMessage.body != 'undefined') {
                    errorMessage = errorMessage.body;
                } else if (typeof errorMessage.message != 'undefined') {
                    errorMessage = errorMessage.message;
                } else if (typeof errorMessage.error != 'undefined') {
                    errorMessage = errorMessage.error;
                } else {
                    errorMessage = JSON.stringify(errorMessage);
                }
                var matches = errorMessage.match(/token"?[=|:]"?(\w*)/, '');
                if (matches && matches[1]) {
                    errorMessage = errorMessage.replace(new RegExp(matches[1], 'g'), 'secret');
                }
            }
            var message = $mmText.decodeHTML(needsTranslate ? $translate.instant(errorMessage) : errorMessage),
                popup = $ionicPopup.alert({
                    title: getErrorTitle(message),
                    template: addFormatTextIfNeeded(message)
                });
            if (typeof autocloseTime != 'undefined' && !isNaN(parseInt(autocloseTime))) {
                $timeout(function() {
                    popup.close();
                }, parseInt(autocloseTime));
            }
        };
        function getErrorTitle(message) {
            if (message == $translate.instant('mm.core.networkerrormsg')) {
                return '<span class="mm-icon-with-badge"><i class="icon ion-wifi"></i>\
                    <i class="icon ion-alert-circled mm-icon-badge"></i></span>';
            }
            return $mmText.decodeHTML($translate.instant('mm.core.error'));
        }
                self.showErrorModalDefault = function(errorMessage, defaultError, needsTranslate, autocloseTime) {
            errorMessage = typeof errorMessage == 'string' ? errorMessage : defaultError;
            return self.showErrorModal(errorMessage, needsTranslate, autocloseTime);
        };
                self.showModal = function(title, message, autocloseTime) {
            title = $translate.instant(title);
            message = $translate.instant(message);
            autocloseTime = parseInt(autocloseTime);
            var popup = $ionicPopup.alert({
                title: title,
                template: addFormatTextIfNeeded(message)
            });
            if (autocloseTime > 0) {
                $timeout(function() {
                    popup.close();
                }, autocloseTime);
            }
            return popup;
        };
                self.showConfirm = function(template, title, options) {
            options = options || {};
            options.template = addFormatTextIfNeeded(template);
            options.title = title;
            if (!title) {
                options.cssClass = 'mm-nohead';
            }
            return $ionicPopup.confirm(options).then(function(confirmed) {
                if (!confirmed) {
                    return $q.reject();
                }
            });
        };
                self.showPrompt = function(body, title, inputPlaceholder, inputType) {
            inputType = inputType || 'password';
            var options = {
                template: addFormatTextIfNeeded(body),
                title: title,
                inputPlaceholder: inputPlaceholder,
                inputType: inputType
            };
            return $ionicPopup.prompt(options).then(function(data) {
                if (typeof data == 'undefined') {
                    return $q.reject();
                }
                return data;
            });
        };
                function addFormatTextIfNeeded(message) {
            if ($mmText.hasHTMLTags(message)) {
                return '<mm-format-text watch="true">' + message + '</mm-format-text>';
            }
            return message;
        }
                self.readJSONFile = function(path) {
            return $http.get(path).then(function(response) {
                return response.data;
            });
        };
                self.getCountryName = function(code) {
            var countryKey = 'mm.core.country-' + code,
                countryName = $translate.instant(countryKey);
            return countryName !== countryKey ? countryName : code;
        };
                self.getCountryList = function() {
            var table = $translate.getTranslationTable(),
                countries = {};
            angular.forEach(table, function(value, name) {
                if (name.indexOf('mm.core.country-') === 0) {
                    name = name.replace('mm.core.country-', '');
                    countries[name] = value;
                }
            });
            return countries;
        };
                self.getDocsUrl = function(release, page) {
            page = page || 'Mobile_app';
            var docsurl = 'https://docs.moodle.org/en/' + page;
            if (typeof release != 'undefined') {
                var version = release.substr(0, 3).replace(".", "");
                if (parseInt(version) >= 24) {
                    docsurl = docsurl.replace('https://docs.moodle.org/', 'https://docs.moodle.org/' + version + '/');
                }
            }
            return $mmLang.getCurrentLanguage().then(function(lang) {
                return docsurl.replace('/en/', '/' + lang + '/');
            }, function() {
                return docsurl;
            });
        };
                self.timestamp = function() {
            return Math.round(Date.now() / 1000);
        };
                self.readableTimestamp = function() {
            return moment(Date.now()).format('YYYYMMDDHHmmSS');
        };
                self.isFalseOrZero = function(value) {
            return typeof value != 'undefined' && (value === false || value === "false" || parseInt(value) === 0);
        };
                self.isTrueOrOne = function(value) {
            return typeof value != 'undefined' && (value === true || value === "true" || parseInt(value) === 1);
        };
                self.formatTime = function(seconds) {
            var langKeys = ['mm.core.day', 'mm.core.days', 'mm.core.hour', 'mm.core.hours', 'mm.core.min', 'mm.core.mins',
                            'mm.core.sec', 'mm.core.secs', 'mm.core.year', 'mm.core.years', 'mm.core.now'];
            return $translate(langKeys).then(function(translations) {
                totalSecs = Math.abs(seconds);
                var years     = Math.floor(totalSecs / mmCoreSecondsYear);
                var remainder = totalSecs - (years * mmCoreSecondsYear);
                var days      = Math.floor(remainder / mmCoreSecondsDay);
                remainder = totalSecs - (days * mmCoreSecondsDay);
                var hours     = Math.floor(remainder / mmCoreSecondsHour);
                remainder = remainder - (hours * mmCoreSecondsHour);
                var mins      = Math.floor(remainder / mmCoreSecondsMinute);
                var secs      = remainder - (mins * mmCoreSecondsMinute);
                var ss = (secs == 1)  ? translations['mm.core.sec']  : translations['mm.core.secs'];
                var sm = (mins == 1)  ? translations['mm.core.min']  : translations['mm.core.mins'];
                var sh = (hours == 1) ? translations['mm.core.hour'] : translations['mm.core.hours'];
                var sd = (days == 1)  ? translations['mm.core.day']  : translations['mm.core.days'];
                var sy = (years == 1) ? translations['mm.core.year'] : translations['mm.core.years'];
                var oyears = '',
                    odays = '',
                    ohours = '',
                    omins = '',
                    osecs = '';
                if (years) {
                    oyears  = years + ' ' + sy;
                }
                if (days) {
                    odays  = days + ' ' + sd;
                }
                if (hours) {
                    ohours = hours + ' ' + sh;
                }
                if (mins) {
                    omins  = mins + ' ' + sm;
                }
                if (secs) {
                    osecs  = secs + ' ' + ss;
                }
                if (years) {
                    return oyears + ' ' + odays;
                }
                if (days) {
                    return odays + ' ' + ohours;
                }
                if (hours) {
                    return ohours + ' ' + omins;
                }
                if (mins) {
                    return omins + ' ' + osecs;
                }
                if (secs) {
                    return osecs;
                }
                return translations['mm.core.now'];
            });
        };
                self.formatDuration = function(duration, precission) {
            eventDuration = moment.duration(duration, 'seconds');
            if (!precission) {
                precission = 5;
            }
            durationString = "";
            if (precission && eventDuration.years() > 0) {
                durationString += " " + moment.duration(eventDuration.years(), 'years').humanize();
                precission--;
            }
            if (precission && eventDuration.months() > 0) {
                durationString += " " + moment.duration(eventDuration.months(), 'months').humanize();
                precission--;
            }
            if (precission && eventDuration.days() > 0) {
                durationString += " " + moment.duration(eventDuration.days(), 'days').humanize();
                precission--;
            }
            if (precission && eventDuration.hours() > 0) {
                durationString += " " + moment.duration(eventDuration.hours(), 'hours').humanize();
                precission--;
            }
            if (precission && eventDuration.minutes() > 0) {
                durationString += " " + moment.duration(eventDuration.minutes(), 'minutes').humanize();
                precission--;
            }
            return durationString.trim();
        };
                self.formatTree = function(list, parentFieldName, idFieldName, rootParentId, maxDepth) {
            var map = {},
                mapDepth = {},
                parent, id,
                tree = [];
            parentFieldName = parentFieldName || 'parent';
            idFieldName = idFieldName || 'id';
            rootParentId = rootParentId || 0;
            maxDepth = maxDepth || 5;
            angular.forEach(list, function(node, index) {
                id = node[idFieldName];
                parent = node[parentFieldName];
                node.children = [];
                map[id] = index;
                if (parent != rootParentId) {
                    var parentNode = list[map[parent]];
                    if (parentNode) {
                        if (mapDepth[parent] == maxDepth) {
                            var parentOfParent = parentNode[parentFieldName];
                            if (parentOfParent) {
                                list[map[parentOfParent]].children.push(node);
                                mapDepth[id] = mapDepth[parent];
                                node.parent = parentOfParent;
                            }
                        } else {
                            parentNode.children.push(node);
                            mapDepth[id] = mapDepth[parent] + 1;
                        }
                    }
                } else {
                    tree.push(node);
                    mapDepth[id] = 1;
                }
            });
            return tree;
        };
                self.emptyArray = function(array) {
            array.length = 0;
        };
                self.emptyObject = function(object) {
            for (var key in object) {
                if (object.hasOwnProperty(key)) {
                    delete object[key];
                }
            }
        };
                self.allPromises = function(promises) {
            if (!promises || !promises.length) {
                return $q.when();
            }
            var count = 0,
                failed = false,
                deferred = $q.defer();
            angular.forEach(promises, function(promise) {
                promise.catch(function() {
                    failed = true;
                }).finally(function() {
                    count++;
                    if (count === promises.length) {
                        if (failed) {
                            deferred.reject();
                        } else {
                            deferred.resolve();
                        }
                    }
                });
            });
            return deferred.promise;
        };
                self.promiseWorks = function(promise) {
            return promise.then(function() {
                return true;
            }).catch(function() {
                return false;
            });
        };
                self.promiseFails = function(promise) {
            return promise.then(function() {
                return false;
            }).catch(function() {
                return true;
            });
        };
                self.basicLeftCompare = function(itemA, itemB, maxLevels, level, undefinedIsNull) {
            level = level || 0;
            maxLevels = maxLevels || 0;
            undefinedIsNull = typeof undefinedIsNull == 'undefined' ? true : undefinedIsNull;
            if (angular.isFunction(itemA) || angular.isFunction(itemB)) {
                return true;
            } else if (angular.isObject(itemA) && angular.isObject(itemB)) {
                if (level >= maxLevels) {
                    return true;
                }
                var equal = true;
                angular.forEach(itemA, function(value, name) {
                    if (!self.basicLeftCompare(value, itemB[name], maxLevels, level + 1)) {
                        equal = false;
                    }
                });
                return equal;
            } else {
                if (undefinedIsNull && (
                        (typeof itemA == 'undefined' && itemB === null) || (itemA === null && typeof itemB == 'undefined'))) {
                    return true;
                }
                var floatA = parseFloat(itemA),
                    floatB = parseFloat(itemB);
                if (!isNaN(floatA) && !isNaN(floatB)) {
                    return floatA == floatB;
                }
                return itemA === itemB;
            }
        };
                self.confirmDownloadSize = function(sizeCalc, message, unknownsizemessage, wifiThreshold, limitedThreshold) {
            wifiThreshold = typeof wifiThreshold == 'undefined' ? mmCoreWifiDownloadThreshold : wifiThreshold;
            limitedThreshold = typeof limitedThreshold == 'undefined' ? mmCoreDownloadThreshold : limitedThreshold;
            if (typeof sizeCalc == 'number') {
                sizeCalc = {size: sizeCalc, total: false};
            }
            if (sizeCalc.size < 0 || (sizeCalc.size == 0 && !sizeCalc.total)) {
                unknownsizemessage = unknownsizemessage || 'mm.course.confirmdownloadunknownsize';
                return self.showConfirm($translate(unknownsizemessage));
            } else if (!sizeCalc.total) {
                var readableSize = $mmText.bytesToSize(sizeCalc.size, 2);
                return self.showConfirm($translate('mm.course.confirmpartialdownloadsize', {size: readableSize}));
            } else if (sizeCalc.size >= wifiThreshold || ($mmApp.isNetworkAccessLimited() && sizeCalc.size >= limitedThreshold)) {
                message = message || 'mm.course.confirmdownload';
                var readableSize = $mmText.bytesToSize(sizeCalc.size, 2);
                return self.showConfirm($translate(message, {size: readableSize}));
            }
            return $q.when();
        };
                self.sumFileSizes = function(files) {
            var results = {
                size: 0,
                total: true
            };
            angular.forEach(files, function(file) {
                if (typeof file.filesize == 'undefined') {
                    results.total = false;
                } else {
                    results.size += file.filesize;
                }
            });
            return results;
        };
                self.formatPixelsSize = function(size) {
            if (typeof size == 'string' && (size.indexOf('px') > -1 || size.indexOf('%') > -1)) {
                return size;
            }
            size = parseInt(size, 10);
            if (!isNaN(size)) {
                return size + 'px';
            }
            return '';
        };
                self.formatFloat = function(float) {
            if (typeof float == "undefined") {
                return '';
            }
            var localeSeparator = $translate.instant('mm.core.decsep');
            float += '';
            return float.replace('.', localeSeparator);
        };
                self.unformatFloat = function(localeFloat) {
            if (typeof localeFloat == "undefined") {
                return false;
            }
            if (localeFloat == null) {
                return "";
            }
            localeFloat += '';
            localeFloat = localeFloat.trim();
            if (localeFloat == "") {
                return "";
            }
            var localeSeparator = $translate.instant('mm.core.decsep');
            localeFloat = localeFloat.replace(' ', '');
            localeFloat = localeFloat.replace(localeSeparator, '.');
            localeFloat = parseFloat(localeFloat);
            if (isNaN(localeFloat)) {
                return false;
            }
            return localeFloat;
        };
                self.param = function(obj) {
            return provider.param(obj);
        };
                self.roundToDecimals = function(number, decimals) {
            if (typeof decimals == 'undefined') {
                decimals = 2;
            }
            var multiplier = Math.pow(10, decimals);
            return Math.round(parseFloat(number) * multiplier) / multiplier;
        };
                self.extractUrlParams = function(url) {
            var regex = /[?&]+([^=&]+)=?([^&]*)?/gi,
                params = {};
            url.replace(regex, function(match, key, value) {
                params[key] = value !== undefined ? value : '';
            });
            return params;
        };
                self.restoreSourcesInHtml = function(html, paths, anchorFn) {
            var div = angular.element('<div>'),
                media;
            div.html(html);
            media = div[0].querySelectorAll('img, video, audio, source, track');
            angular.forEach(media, function(el) {
                var src = paths[$mmText.decodeURIComponent(el.getAttribute('src'))];
                if (typeof src !== 'undefined') {
                    el.setAttribute('src', src);
                }
                if (el.tagName == 'VIDEO' && el.getAttribute('poster')) {
                    src = paths[$mmText.decodeURIComponent(el.getAttribute('poster'))];
                    if (typeof src !== 'undefined') {
                        el.setAttribute('poster', src);
                    }
                }
            });
            angular.forEach(div.find('a'), function(anchor) {
                var href = $mmText.decodeURIComponent(anchor.getAttribute('href')),
                    url = paths[href];
                if (typeof url !== 'undefined') {
                    anchor.setAttribute('href', url);
                    if (angular.isFunction(anchorFn)) {
                        anchorFn(anchor, href);
                    }
                }
            });
            return div.html();
        };
                self.scrollToElement = function(container, selector, scrollDelegate, scrollParentClass) {
            var position;
            if (!scrollDelegate) {
                scrollDelegate = $ionicScrollDelegate;
            }
            position = self.getElementXY(container, selector, scrollParentClass);
            if (!position) {
                return false;
            }
            scrollDelegate.scrollTo(position[0], position[1]);
            return true;
        };
                self.scrollToInputError = function(container, scrollDelegate, scrollParentClass) {
            return $timeout(function() {
                if (!scrollDelegate) {
                    scrollDelegate = $ionicScrollDelegate;
                }
                scrollDelegate.resize();
                return self.scrollToElement(container, '.mm-input-has-errors', scrollDelegate, scrollParentClass);
            }, 100);
        };
                self.getElementXY = function(container, selector, positionParentClass) {
            var element = selector ? container.querySelector(selector) : container,
                offsetElement,
                positionTop = 0,
                positionLeft = 0;
            if (!positionParentClass) {
                positionParentClass = 'scroll-content';
            }
            if (!element) {
                return false;
            }
            while (element) {
                positionLeft += (element.offsetLeft - element.scrollLeft + element.clientLeft);
                positionTop += (element.offsetTop - element.scrollTop + element.clientTop);
                offsetElement = element.offsetParent;
                element = element.parentElement;
                while (offsetElement != element && element) {
                    if (angular.element(element).hasClass(positionParentClass)) {
                        element = false;
                    } else {
                        element = element.parentElement;
                    }
                }
                if (angular.element(element).hasClass(positionParentClass)) {
                    element = false;
                }
            }
            return [positionLeft, positionTop];
        };
                self.extractUrlsFromCSS = function(code) {
            var urls = [],
                matches = code.match(/url\(\s*["']?(?!data:)([^)]+)\)/igm);
            angular.forEach(matches, function(match) {
                var submatches = match.match(/url\(\s*['"]?([^'"]*)['"]?\s*\)/im);
                if (submatches && submatches[1]) {
                    urls.push(submatches[1]);
                }
            });
            return urls;
        };
                self.getContentsOfElement = function(element, selector) {
            if (element) {
                var el = element[0] || element,
                    selected = el.querySelector(selector);
                if (selected) {
                    return selected.innerHTML;
                }
            }
        };
                self.removeElement = function(element, selector) {
            if (element) {
                var el = element[0] || element,
                    selected = el.querySelector(selector);
                if (selected) {
                    angular.element(selected).remove();
                }
            }
        };
                self.removeElementFromHtml = function(html, selector, removeAll) {
            var div = document.createElement('div'),
                selected;
            div.innerHTML = html;
            if (removeAll) {
                selected = div.querySelectorAll(selector);
                angular.forEach(selected, function(el) {
                    angular.element(el).remove();
                });
            } else {
                selected = div.querySelector(selector);
                if (selected) {
                    angular.element(selected).remove();
                }
            }
            return div.innerHTML;
        };
                self.replaceClassesInElement = function(element, map) {
            element = element[0] || element;
            angular.forEach(map, function(newValue, toReplace) {
                var matches = element.querySelectorAll('.' + toReplace);
                angular.forEach(matches, function(element) {
                    element.className = element.className.replace(toReplace, newValue);
                });
            });
        };
                self.closest = function(element, selector) {
            if (typeof element.closest == 'function') {
                return element.closest(selector);
            }
            if (!matchesFn) {
                ['matches','webkitMatchesSelector','mozMatchesSelector','msMatchesSelector','oMatchesSelector'].some(function(fn) {
                    if (typeof document.body[fn] == 'function') {
                        matchesFn = fn;
                        return true;
                    }
                    return false;
                });
                if (!matchesFn) {
                    return;
                }
            }
            while (element) {
                if (element[matchesFn](selector)) {
                    return element;
                }
                element = element.parentElement;
            }
        };
                self.extractDownloadableFilesFromHtml = function(html) {
            var div = document.createElement('div'),
                elements,
                urls = [];
            div.innerHTML = html;
            elements = div.querySelectorAll('a, img, audio, video, source, track');
            angular.forEach(elements, function(element) {
                var url = element.tagName === 'A' ? element.href : element.src;
                if (url && self.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                    urls.push(url);
                }
                if (element.tagName == 'VIDEO' && element.getAttribute('poster')) {
                    url = element.getAttribute('poster');
                    if (url && self.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                        urls.push(url);
                    }
                }
            });
            return urls;
        };
                self.extractDownloadableFilesFromHtmlAsFakeFileObjects = function(html) {
            var urls = self.extractDownloadableFilesFromHtml(html);
            return urls.map(function(url) {
                return {
                    fileurl: url
                };
            });
        };
                self.objectToArrayOfObjects = function(obj, keyName, valueName, sort) {
            var keys = Object.keys(obj);
            if (sort) {
                keys = keys.sort();
            }
            return keys.map(function(key) {
                var entry = {};
                entry[keyName] = key;
                entry[valueName] = obj[key];
                return entry;
            });
        };
                self.objectToArray = function(obj) {
            return Object.keys(obj).map(function(key) {
                return obj[key];
            });
        };
                self.sameAtKeyMissingIsBlank = function(obj1, obj2, key) {
            var value1 = typeof obj1[key] != 'undefined' ? obj1[key] : '',
                value2 = typeof obj2[key] != 'undefined' ? obj2[key] : '';
            if (typeof value1 == 'number' || typeof value1 == 'boolean') {
                value1 = '' + value1;
            }
            if (typeof value2 == 'number' || typeof value2 == 'boolean') {
                value2 = '' + value2;
            }
            return value1 === value2;
        };
                self.mergeArraysWithoutDuplicates = function(array1, array2) {
            return self.uniqueArray(array1.concat(array2));
        };
                self.uniqueArray = function(array) {
            var unique = [],
                len = array.length;
            for (var i = 0; i < len; i++) {
                var value = array[i];
                if (unique.indexOf(value) == -1) {
                    unique.push(value);
                }
            }
            return unique;
        };
                self.isWebServiceError = function(error) {
            var localErrors = [
                $translate.instant('mm.core.wsfunctionnotavailable'),
                $translate.instant('mm.core.lostconnection'),
                $translate.instant('mm.core.userdeleted'),
                $translate.instant('mm.core.unexpectederror'),
                $translate.instant('mm.core.networkerrormsg'),
                $translate.instant('mm.core.serverconnection'),
                $translate.instant('mm.core.errorinvalidresponse'),
                $translate.instant('mm.core.sitemaintenance'),
                $translate.instant('mm.core.upgraderunning'),
                $translate.instant('mm.core.nopasswordchangeforced'),
                $translate.instant('mm.core.unicodenotsupported')
            ];
            return error && localErrors.indexOf(error) == -1;
        };
                self.focusElement = function(el) {
            if (el && el.focus) {
                el.focus();
                if (ionic.Platform.isAndroid() && self.supportsInputKeyboard(el)) {
                    $mmApp.openKeyboard();
                }
            }
        };
                self.supportsInputKeyboard = function(el) {
            return el && !el.disabled && (el.tagName.toLowerCase() == 'textarea' ||
                (el.tagName.toLowerCase() == 'input' && inputSupportKeyboard.indexOf(el.type) != -1));
        };
                self.isRichTextEditorSupported = function() {
            if (!ionic.Platform.isIOS() && !ionic.Platform.isAndroid()) {
                return true;
            }
            if (ionic.Platform.isAndroid() && ionic.Platform.version() >= 4.4) {
                return true;
            }
            return false;
        };
                self.isRichTextEditorEnabled = function() {
            if (self.isRichTextEditorSupported()) {
                return $mmConfig.get(mmCoreSettingsRichTextEditor, true);
            }
            return $q.when(false);
        };
                self.hasRepeatedFilenames = function(files) {
            if (!files || !files.length) {
                return false;
            }
            var names = [];
            for (var i = 0; i < files.length; i++) {
                var name = files[i].filename || files[i].name;
                if (names.indexOf(name) > -1) {
                    return $translate.instant('mm.core.filenameexist', {$a: name});
                } else {
                    names.push(name);
                }
            }
            return false;
        };
                self.blockLeaveView = function(scope, canLeaveFn, currentView) {
            currentView = currentView || $ionicHistory.currentView();
            var unregisterHardwareBack,
                leaving = false,
                hasSplitView = $ionicPlatform.isTablet() && $state.current.name.split('.').length == 3,
                skipSplitViewLeave = false;
            $rootScope.$ionicGoBack = goBack;
            unregisterHardwareBack = $ionicPlatform.registerBackButtonAction(goBack, 101);
            backFunctionsStack.push(goBack);
            if (hasSplitView) {
                blockSplitView(true);
            }
            scope.$on('$destroy', unblock);
            return {
                back: originalBackFunction,
                unblock: unblock
            };
            function goBack() {
                if ($ionicHistory.currentView() !== currentView) {
                    originalBackFunction();
                    return;
                }
                if (leaving) {
                    return;
                }
                leaving = true;
                canLeaveFn().then(function() {
                    skipSplitViewLeave = hasSplitView;
                    originalBackFunction();
                }).finally(function() {
                    leaving = false;
                });
            }
            function leaveViewInSplitView() {
                if (skipSplitViewLeave) {
                    skipSplitViewLeave = false;
                    return $q.when();
                }
                return canLeaveFn();
            }
            function unblock() {
                unregisterHardwareBack();
                if (hasSplitView) {
                    blockSplitView(false);
                }
                var position = backFunctionsStack.indexOf(goBack);
                if (position > -1) {
                    backFunctionsStack.splice(position, 1);
                }
                if ($rootScope.$ionicGoBack === goBack) {
                    if (!backFunctionsStack.length) {
                        backFunctionsStack = [originalBackFunction];
                        $rootScope.$ionicGoBack = originalBackFunction;
                    } else {
                        $rootScope.$ionicGoBack = backFunctionsStack[backFunctionsStack.length - 1];
                    }
                }
            }
            function blockSplitView(block) {
                $rootScope.$broadcast(mmCoreSplitViewBlock, {
                    block: block,
                    blockFunction: leaveViewInSplitView,
                    state: currentView.stateName,
                    stateParams: currentView.stateParams
                });
            }
        };
                self.isElementOutsideOfScreen = function(element, scrollSelector) {
            scrollSelector = scrollSelector || '.scroll-content';
            var elementRect = element.getBoundingClientRect(),
                elementMidPoint,
                scrollEl = self.closest(element, scrollSelector),
                scrollElRect,
                scrollTopPos = 0;
            if (!elementRect) {
                return false;
            }
            elementMidPoint = Math.round((elementRect.bottom + elementRect.top) / 2);
            if (scrollEl) {
                scrollElRect = scrollEl.getBoundingClientRect();
                scrollTopPos = (scrollElRect && scrollElRect.top) || 0;
            }
            return elementMidPoint > $window.innerHeight || elementMidPoint < scrollTopPos;
        };
                self.copyProperties = function(from, to) {
            angular.forEach(from, function(value, name) {
                to[name] = angular.copy(value);
            });
        };
                self.filterEnabledSites = function(siteIds, isEnabledFn, checkAll) {
            var promises = [],
                enabledSites = [],
                extraParams = Array.prototype.slice.call(arguments, 3);
            angular.forEach(siteIds, function(siteId) {
                if (checkAll || !promises.length) {
                    promises.push($q.when(isEnabledFn.apply(isEnabledFn, [siteId].concat(extraParams))).then(function(enabled) {
                        if (enabled) {
                            enabledSites.push(siteId);
                        }
                    }));
                }
            });
            return self.allPromises(promises).catch(function() {
            }).then(function() {
                if (!checkAll) {
                    return enabledSites.length ? siteIds : [];
                } else {
                    return enabledSites;
                }
            });
        };
                self.getElementHeight = function(element, usePadding, useMargin, useBorder, innerMeasure) {
            var measure = element.offsetHeight || element.height || element.clientHeight || 0;
            if (measure <= 0) {
                var angElement = angular.element(element);
                if (angElement.css('display') == '') {
                    angElement.css('display', 'inline-block');
                    measure = element.offsetHeight || element.height || element.clientHeight || 0;
                    angElement.css('display', '');
                }
            }
            if (usePadding || useMargin || useBorder) {
                var surround = 0,
                    cs = getComputedStyle(element);
                if (usePadding) {
                    surround += parseInt(cs.paddingTop, 10) + parseInt(cs.paddingBottom, 10);
                }
                if (useMargin) {
                    surround += parseInt(cs.marginTop, 10) + parseInt(cs.marginBottom, 10);
                }
                if (useBorder) {
                    surround += parseInt(cs.borderTop, 10) + parseInt(cs.borderBottom, 10);
                }
                if (innerMeasure) {
                    measure = measure > surround ? measure - surround : 0;
                } else {
                    measure += surround;
                }
            }
            return measure;
        };
                self.getElementWidth = function(element, usePadding, useMargin, useBorder, innerMeasure) {
            var measure = element.offsetWidth || element.width || element.clientWidth || 0;
            if (measure <= 0) {
                var angElement = angular.element(element);
                if (angElement.css('display') == '') {
                    angElement.css('display', 'inline-block');
                    measure = element.offsetWidth || element.width || element.clientWidth || 0;
                    angElement.css('display', '');
                }
            }
            if (usePadding || useMargin || useBorder) {
                var surround = 0,
                    cs = getComputedStyle(element);
                if (usePadding) {
                    surround += parseInt(cs.paddingLeft, 10) + parseInt(cs.paddingRight, 10);
                }
                if (useMargin) {
                    surround += parseInt(cs.marginLeft, 10) + parseInt(cs.marginRight, 10);
                }
                if (useBorder) {
                    surround += parseInt(cs.borderLeft, 10) + parseInt(cs.borderRight, 10);
                }
                if (innerMeasure) {
                    measure = measure > surround ? measure - surround : 0;
                } else {
                    measure += surround;
                }
            }
            return measure;
        };
        return self;
    }];
}]);

angular.module('mm.core')
.factory('$mmWebWorkers', ["$injector", "$q", "$log", "$window", "md5", function($injector, $q, $log, $window, md5) {
    $log = $log.getInstance('$mmWebWorkers');
    var self = {},
        workers = {};
        function createWorker(name, path) {
        try {
            if (typeof workers[name] == 'undefined') {
                workers[name] = {
                    path: path,
                    worker: new Worker(path)
                };
            } else {
                $log.warn('There\'s already a worker with this name: ' + name);
            }
            return true;
        } catch(ex) {
            return false;
        }
    }
        self.isSupportedByDevice = function() {
        return !!$window.Worker && !!$window.URL;
    };
        self.isSupportedInSite = function(site) {
        if (!site) {
            site = $injector.get('$mmSite');
            if (!site || !site.isLoggedIn()) {
                return false;
            }
        }
        return site.isVersionGreaterEqualThan('2.8');
    };
        self.startWorker = function(name, path, params) {
        if (typeof workers[name] == 'undefined') {
            if (!createWorker(name, path)) {
                return $q.reject();
            }
        } else if (workers[name].path != path) {
            $log.warn('The path of the worker to call doesn\t match the path passed as parameter: ', name, path);
            return $q.reject();
        }
        var deferred = $q.defer(),
            id = md5.createHash(JSON.stringify(params)),
            worker = workers[name].worker;
        worker.addEventListener('message', onMessage, false);
        worker.addEventListener('error', onError, false);
        params.workerId = id;
        worker.postMessage(params);
        return deferred.promise;
        function onMessage(e) {
            if (e && e.data) {
                if (e.data.workerId == id) {
                    delete e.data.workerId;
                    if (e.data.notify) {
                        deferred.notify(e.data);
                    } else {
                        worker.removeEventListener('message', onMessage, false);
                        worker.removeEventListener('error', onError, false);
                        deferred.resolve(e.data);
                    }
                }
            } else {
                deferred.reject();
            }
        }
        function onError() {
            worker.removeEventListener('message', onMessage, false);
            worker.removeEventListener('error', onError, false);
            delete workers[name];
            deferred.reject();
        }
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmWSTimeout', 30000)
.factory('$mmWS', ["$http", "$q", "$log", "$mmLang", "$cordovaFileTransfer", "$mmApp", "$mmFS", "mmCoreSessionExpired", "$translate", "$window", "mmCoreUserDeleted", "md5", "$timeout", "mmWSTimeout", "mmCoreUserPasswordChangeForced", "mmCoreUserNotFullySetup", "$mmText", "mmCoreSitePolicyNotAgreed", "mmCoreUnicodeNotSupported", function($http, $q, $log, $mmLang, $cordovaFileTransfer, $mmApp, $mmFS, mmCoreSessionExpired, $translate, $window,
            mmCoreUserDeleted, md5, $timeout, mmWSTimeout, mmCoreUserPasswordChangeForced, mmCoreUserNotFullySetup, $mmText,
            mmCoreSitePolicyNotAgreed, mmCoreUnicodeNotSupported) {
    $log = $log.getInstance('$mmWS');
    var self = {},
        mimeTypeCache = {},
        ongoingCalls = {},
        retryCalls = [],
        retryTimeout = 0;
        self.call = function(method, data, preSets) {
        var siteurl;
        if (typeof preSets == 'undefined' || preSets === null ||
                typeof preSets.wstoken == 'undefined' || typeof preSets.siteurl == 'undefined') {
            return $mmLang.translateAndReject('mm.core.unexpectederror');
        } else if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        preSets.typeExpected = preSets.typeExpected || 'object';
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        try {
            data = convertValuesToString(data, preSets.cleanUnicode);
        } catch (e) {
           return $mmLang.translateAndReject('mm.core.unicodenotsupportedcleanerror');
        }
        data.wsfunction = method;
        data.wstoken = preSets.wstoken;
        siteurl = preSets.siteurl + '/webservice/rest/server.php?moodlewsrestformat=json';
        var ajaxData = data;
        var promise = getPromiseHttp('post', preSets.siteurl, ajaxData);
        if (!promise) {
            if (retryCalls.length > 0) {
                $log.warn('Calls locked, trying later...');
                promise = addToRetryQueue(method, siteurl, ajaxData, preSets);
            } else {
                promise = performPost(method, siteurl, ajaxData, preSets);
            }
        }
        return promise;
    };
        function performPost(method, siteurl, ajaxData, preSets) {
        var promise = $http.post(siteurl, ajaxData, {timeout: mmWSTimeout}).then(function(data) {
            if ((!data || !data.data) && !preSets.responseExpected) {
                data = {};
            } else {
                data = data.data;
            }
            if (!data) {
                return $mmLang.translateAndReject('mm.core.serverconnection');
            } else if (typeof data != preSets.typeExpected) {
                $log.warn('Response of type "' + typeof data + '" received, expecting "' + preSets.typeExpected + '"');
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (typeof(data.exception) !== 'undefined') {
                if (data.errorcode == 'invalidtoken' ||
                        (data.errorcode == 'accessexception' && data.message.indexOf('Invalid token - token expired') > -1)) {
                    $log.error("Critical error: " + JSON.stringify(data));
                    return $q.reject(mmCoreSessionExpired);
                } else if (data.errorcode === 'userdeleted') {
                    return $q.reject(mmCoreUserDeleted);
                } else if (data.errorcode === 'sitemaintenance' || data.errorcode === 'upgraderunning') {
                    return $mmLang.translateAndReject('mm.core.' + data.errorcode);
                } else if (data.errorcode === 'forcepasswordchangenotice') {
                    return $q.reject(mmCoreUserPasswordChangeForced);
                } else if (data.errorcode === 'usernotfullysetup') {
                    return $q.reject(mmCoreUserNotFullySetup);
                } else if (data.errorcode === 'sitepolicynotagreed') {
                    return $q.reject(mmCoreSitePolicyNotAgreed);
                } else if (data.errorcode === 'dmlwriteexception' && $mmText.hasUnicodeData(ajaxData)) {
                    return $q.reject(mmCoreUnicodeNotSupported);
                } else {
                    return $q.reject(data.message);
                }
            }
            if (typeof(data.debuginfo) != 'undefined') {
                return $q.reject('Error. ' + data.message);
            }
            $log.info('WS: Data received from WS ' + typeof(data));
            if (typeof(data) == 'object' && typeof(data.length) != 'undefined') {
                $log.info('WS: Data number of elements '+ data.length);
            }
            return data;
        }, function(data) {
            if (data.status == 429) {
                var retryPromise = addToRetryQueue(method, siteurl, ajaxData, preSets);
                if (retryTimeout == 0) {
                    retryTimeout = parseInt(data.headers('Retry-After'), 10) || 5;
                    $log.warn(data.statusText + '. Retrying in ' + retryTimeout + ' seconds. ' + retryCalls.length + ' calls left.');
                    $timeout(function() {
                        $log.warn('Retrying now with ' + retryCalls.length + ' calls to process.');
                        retryTimeout = 0;
                        processRetryQueue();
                    }, retryTimeout * 1000);
                } else {
                    $log.warn('Calls locked, trying later...');
                }
                return retryPromise;
            }
            return $mmLang.translateAndReject('mm.core.serverconnection');
        });
        setPromiseHttp(promise, 'post', preSets.siteurl, ajaxData);
        return promise;
    }
        function processRetryQueue() {
        if (retryCalls.length > 0 && retryTimeout == 0) {
            var call = retryCalls.shift();
            $timeout(function() {
                call.deferred.resolve(performPost(call.method, call.siteurl, call.ajaxData, call.preSets));
                processRetryQueue();
            }, 200);
        } else {
            $log.warn('Retry queue has stopped with ' + retryCalls.length + ' calls and ' + retryTimeout + ' timeout seconds.');
        }
    }
        function addToRetryQueue(method, siteurl, ajaxData, preSets) {
        var call = {
            method: method,
            siteurl: siteurl,
            ajaxData: ajaxData,
            preSets: preSets,
            deferred: $q.defer()
        };
        retryCalls.push(call);
        return call.deferred.promise;
    }
        function setPromiseHttp(promise, method, url, params) {
        var deletePromise,
            queueItemId = getQueueItemId(method, url, params);
        ongoingCalls[queueItemId] = promise;
        deletePromise = $timeout(function() {
            delete ongoingCalls[queueItemId];
        }, mmWSTimeout);
        ongoingCalls[queueItemId].finally(function() {
            delete ongoingCalls[queueItemId];
            $timeout.cancel(deletePromise);
        });
    }
        function getPromiseHttp(method, url, params) {
        var queueItemId = getQueueItemId(method, url, params);
        if (typeof ongoingCalls[queueItemId] != 'undefined') {
            return ongoingCalls[queueItemId];
        }
        return false;
    }
        function getQueueItemId(method, url, params) {
        if (params) {
            url += '###' + serializeParams(params);
        }
        return method + '#' + md5.createHash(url);
    }
        function convertValuesToString(data, stripUnicode) {
        var result = [];
        if (!angular.isArray(data) && angular.isObject(data)) {
            result = {};
        }
        for (var el in data) {
            if (angular.isObject(data[el])) {
                result[el] = convertValuesToString(data[el], stripUnicode);
            } else {
                if (typeof data[el] == "string") {
                    result[el] = stripUnicode ? $mmText.stripUnicode(data[el]) : data[el];
                    if (stripUnicode && data[el] != result[el] && result[el].trim().length == 0) {
                        throw new Exception();
                    }
                } else {
                    result[el] = data[el] + '';
                }
            }
        }
        return result;
    }
        self.downloadFile = function(url, path, addExtension) {
        $log.debug('Downloading file ' + url, path, addExtension);
        var tmpPath = path + '.tmp';
        return $mmFS.createFile(tmpPath).then(function(fileEntry) {
            return $cordovaFileTransfer.download(url, fileEntry.toURL(), { encodeURI: false }, true).then(function() {
                var promise;
                if (addExtension) {
                    ext = $mmFS.getFileExtension(path);
                    if (!ext) {
                        promise = self.getRemoteFileMimeType(url).then(function(mime) {
                            var ext;
                            if (mime) {
                                ext = $mmFS.getExtension(mime, url);
                                if (ext) {
                                    path += '.' + ext;
                                }
                                return ext;
                            }
                            return false;
                        });
                    } else {
                        promise = $q.when(ext);
                    }
                } else {
                    promise = $q.when("");
                }
                return promise.then(function(extension) {
                    return $mmFS.moveFile(tmpPath, path).then(function(movedEntry) {
                        movedEntry.extension = extension;
                        movedEntry.path = path;
                        $log.debug('Success downloading file ' + url + ' to ' + path + ' with extension ' + extension);
                        return movedEntry;
                    });
                });
            });
        }).catch(function(err) {
            $log.error('Error downloading ' + url + ' to ' + path);
            $log.error(JSON.stringify(err));
            return $q.reject(err);
        });
    };
        self.uploadFile = function(uri, options, preSets) {
        $log.debug('Trying to upload file: ' + uri);
        if (!uri || !options || !preSets) {
            return $q.reject();
        }
        var ftOptions = {},
            uploadUrl = preSets.siteurl + '/webservice/upload.php';
        ftOptions.fileKey = options.fileKey;
        ftOptions.fileName = options.fileName;
        ftOptions.httpMethod = 'POST';
        ftOptions.mimeType = options.mimeType;
        ftOptions.params = {
            token: preSets.token,
            filearea: options.fileArea || 'draft',
            itemid: options.itemId || 0
        };
        ftOptions.chunkedMode = false;
        ftOptions.headers = {
            Connection: "close"
        };
        $log.debug('Initializing upload');
        return $cordovaFileTransfer.upload(uploadUrl, uri, ftOptions, true).then(function(success) {
            var data = success.response;
            try {
                data = JSON.parse(data);
            } catch(err) {
                $log.error('Error parsing response:', err, data);
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (!data) {
                return $mmLang.translateAndReject('mm.core.serverconnection');
            } else if (typeof data != 'object') {
                $log.warn('Upload file: Response of type "' + typeof data + '" received, expecting "object"');
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (typeof data.exception !== 'undefined') {
                return $q.reject(data.message);
            } else if (data && typeof data.error !== 'undefined') {
                return $q.reject(data.error);
            } else if (data[0] && typeof data[0].error !== 'undefined') {
                return $q.reject(data[0].error);
            }
            $log.debug('Successfully uploaded file');
            return data[0];
        }, function(error) {
            $log.error('Error while uploading file', error.exception);
            return $mmLang.translateAndReject('mm.core.serverconnection');
        });
    };
        self.getRemoteFileSize = function(url) {
        var promise = getPromiseHttp('head', url);
        if (!promise) {
            promise = $http.head(url, {timeout: mmWSTimeout}).then(function(data) {
                var size = parseInt(data.headers('Content-Length'), 10);
                if (size) {
                    return size;
                }
                return -1;
            }).catch(function() {
                return -1;
            });
            setPromiseHttp(promise, 'head', url);
        }
        return promise;
    };
        self.getRemoteFileMimeType = function(url, ignoreCache) {
        if (mimeTypeCache[url] && !ignoreCache) {
            return $q.when(mimeTypeCache[url]);
        }
        var promise = getPromiseHttp('head', url);
        if (!promise) {
            promise = $http.head(url, {timeout: mmWSTimeout}).then(function(data) {
                var mimeType = data.headers('Content-Type');
                if (mimeType) {
                    mimeType = mimeType.split(';')[0];
                }
                mimeTypeCache[url] = mimeType;
                return mimeType || '';
            }).catch(function() {
                return '';
            });
            setPromiseHttp(promise, 'head', url);
        }
        return promise;
    };
        self.syncCall = function(method, data, preSets) {
        var siteurl,
            xhr,
            errorResponse = {
                error: true,
                message: ''
            };
        data = convertValuesToString(data);
        if (typeof preSets == 'undefined' || preSets === null ||
                typeof preSets.wstoken == 'undefined' || typeof preSets.siteurl == 'undefined') {
            errorResponse.message = $translate.instant('mm.core.unexpectederror');
            return errorResponse;
        } else if (!$mmApp.isOnline()) {
            errorResponse.message = $translate.instant('mm.core.networkerrormsg');
            return errorResponse;
        }
        preSets.typeExpected = preSets.typeExpected || 'object';
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        data.wsfunction = method;
        data.wstoken = preSets.wstoken;
        siteurl = preSets.siteurl + '/webservice/rest/server.php?moodlewsrestformat=json';
        data = serializeParams(data);
        xhr = new $window.XMLHttpRequest();
        xhr.open('post', siteurl, false);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=utf-8');
        xhr.send(data);
        data = ('response' in xhr) ? xhr.response : xhr.responseText;
        xhr.status = Math.max(xhr.status === 1223 ? 204 : xhr.status, 0);
        if (xhr.status < 200 || xhr.status >= 300) {
            errorResponse.message = data;
            return errorResponse;
        }
        try {
            data = JSON.parse(data);
        } catch(ex) {}
        if ((!data || !data.data) && !preSets.responseExpected) {
            data = {};
        }
        if (!data) {
            errorResponse.message = $translate.instant('mm.core.serverconnection');
        } else if (typeof data != preSets.typeExpected) {
            $log.warn('Response of type "' + typeof data + '" received, expecting "' + preSets.typeExpected + '"');
            errorResponse.message = $translate.instant('mm.core.errorinvalidresponse');
        }
        if (typeof data.exception != 'undefined' || typeof data.debuginfo != 'undefined') {
            errorResponse.message = data.message;
        }
        if (errorResponse.message !== '') {
            return errorResponse;
        }
        $log.info('Synchronous: Data received from WS ' + typeof data);
        if (typeof(data) == 'object' && typeof(data.length) != 'undefined') {
            $log.info('Synchronous: Data number of elements '+ data.length);
        }
        return data;
    };
        function serializeParams(obj) {
        var query = '', name, value, fullSubName, subName, subValue, innerObj, i;
        for (name in obj) {
            value = obj[name];
            if (value instanceof Array) {
                for (i = 0; i < value.length; ++i) {
                    subValue = value[i];
                    fullSubName = name + '[' + i + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += serializeParams(innerObj) + '&';
                }
            }
            else if (value instanceof Object) {
                for (subName in value) {
                    subValue = value[subName];
                    fullSubName = name + '[' + subName + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += serializeParams(innerObj) + '&';
                }
            }
            else if (value !== undefined && value !== null) query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
        }
        return query.length ? query.substr(0, query.length - 1) : query;
    }
        self.callAjax = function(method, data, preSets) {
        var siteurl,
            ajaxData;
        if (typeof preSets.siteurl == 'undefined') {
            return rejectWithError($translate.instant('mm.core.unexpectederror'));
        } else if (!$mmApp.isOnline()) {
            return rejectWithError($translate.instant('mm.core.networkerrormsg'));
        }
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        ajaxData = [{
            index: 0,
            methodname: method,
            args: convertValuesToString(data)
        }];
        siteurl = preSets.siteurl + '/lib/ajax/service.php';
        return $http.post(siteurl, JSON.stringify(ajaxData), {timeout: mmWSTimeout}).then(function(data) {
            if ((!data || !data.data) && !preSets.responseExpected) {
                data = [{}];
            } else {
                data = data.data;
            }
            if (!data || typeof data != 'object') {
                return rejectWithError($translate.instant('mm.core.serverconnection'));
            } else if (data.error) {
                return rejectWithError(data.error, data.errorcode);
            }
            data = data[0];
            if (data.error) {
                return rejectWithError(data.exception.message, data.exception.errorcode);
            }
            return data.data;
        }, function(data) {
            var available = data.status == 404 ? -1 : 0;
            return rejectWithError($translate.instant('mm.core.serverconnection'), '', available);
        });
        function rejectWithError(message, code, available) {
            if (typeof available == 'undefined') {
                if (code) {
                    available = code == 'invalidrecord' ? -1 : 1;
                } else {
                    available = 0;
                }
            }
            return $q.reject({
                error: message,
                errorcode: code,
                available: available
            });
        }
    };
    return self;
}]);

angular.module('mm.core')
.filter('mmBytesToSize', ["$mmText", function($mmText) {
    return function(text) {
        return $mmText.bytesToSize(text);
    };
}]);
angular.module('mm.core')
.filter('mmCreateLinks', function() {
    var replacePattern = /(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])(?![^<]*>|[^<>]*<\/)/gim;
    return function(text) {
        return text.replace(replacePattern, '<a href="$1">$1</a>');
    };
});
angular.module('mm.core')
.filter('mmDateDayOrTime', ["$translate", function($translate) {
    return function(timestamp) {
        return moment(timestamp * 1000).calendar(null, {
            sameDay: $translate.instant('mm.core.dftimedate'),
            lastDay: $translate.instant('mm.core.dflastweekdate'),
            lastWeek: $translate.instant('mm.core.dflastweekdate')
        });
    };
}]);

angular.module('mm.core')
.filter('mmDuration', function() {
    return function(timestamp) {
        return moment.duration(timestamp * 1000).humanize();
    };
});

angular.module('mm.core')
.filter('mmFormatDate', ["$translate", function($translate) {
    return function(timestamp, format) {
        if (format.indexOf('.') == -1) {
            format = 'mm.core.' + format;
        }
        return moment(timestamp).format($translate.instant(format));
    };
}]);

angular.module('mm.core')
.filter('mmNoTags', function() {
    return function(text) {
        return String(text).replace(/(<([^>]+)>)/ig, '');
    }
});
angular.module('mm.core')
.filter('mmSecondsToHMS', ["$mmText", "mmCoreSecondsHour", "mmCoreSecondsMinute", function($mmText, mmCoreSecondsHour, mmCoreSecondsMinute) {
    return function(seconds) {
        var hours,
            minutes;
        if (typeof seconds == 'undefined' || seconds < 0) {
            seconds = 0;
        }
        hours = Math.floor(seconds / mmCoreSecondsHour);
        seconds -= hours * mmCoreSecondsHour;
        minutes = Math.floor(seconds / mmCoreSecondsMinute);
        seconds -= minutes * mmCoreSecondsMinute;
        return $mmText.twoDigits(hours) + ':' + $mmText.twoDigits(minutes) + ':' + $mmText.twoDigits(seconds);
    };
}]);

angular.module('mm.core')
.filter('mmTimeAgo', function() {
    return function(timestamp) {
        return moment(timestamp * 1000).fromNow(true);
    };
});

angular.module('mm.core')
.filter('mmToLocaleString', function() {
    return function(text) {
        var timestamp = parseInt(text);
        if (isNaN(timestamp) || timestamp < 0) {
            return '';
        }
        if (timestamp < 100000000000) {
            timestamp = timestamp * 1000;
        }
        return new Date(timestamp).toLocaleString();
    };
});

angular.module('mm.core')
.directive('mmAttachments', ["$mmText", "$translate", "$ionicScrollDelegate", "$mmUtil", "$mmApp", "$mmFileUploaderHelper", "$q", function($mmText, $translate, $ionicScrollDelegate, $mmUtil, $mmApp, $mmFileUploaderHelper, $q) {
    return {
        restrict: 'E',
        priority: 100,
        templateUrl: 'core/templates/attachments.html',
        scope: {
            files: '=',
            maxSize: '@?',
            maxSubmissions: '@?',
            component: '@?',
            componentId: '@?',
            allowOffline: '@?'
        },
        link: function(scope) {
            var allowOffline = scope.allowOffline && scope.allowOffline !== 'false';
                maxSize = parseInt(scope.maxSize, 10);
            maxSize = !isNaN(maxSize) && maxSize > 0 ? maxSize : -1;
            if (maxSize == -1) {
                scope.maxSizeReadable = $translate.instant('mm.core.unknown');
            } else {
                scope.maxSizeReadable = $mmText.bytesToSize(maxSize, 2);
            }
            if (typeof scope.maxSubmissions == 'undefined' || scope.maxSubmissions < 0) {
                scope.maxSubmissions = $translate.instant('mm.core.unknown');
                scope.unlimitedFiles = true;
            }
            scope.add = function() {
                if (!allowOffline && !$mmApp.isOnline()) {
                    $mmUtil.showErrorModal('mm.fileuploader.errormustbeonlinetoupload', true);
                } else {
                    return $mmFileUploaderHelper.selectFile(maxSize, allowOffline).then(function(result) {
                        scope.files.push(result);
                    });
                }
            };
            scope.delete = function(index, askConfirm) {
                var promise;
                if (askConfirm) {
                    promise = $mmUtil.showConfirm($translate.instant('mm.core.confirmdeletefile'));
                } else {
                    promise = $q.when();
                }
                promise.then(function() {
                    scope.files.splice(index, 1);
                    $ionicScrollDelegate.resize();
                });
            };
            scope.renamed = function(index, file) {
                scope.files[index] = file;
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmAutoFocus', ["$mmUtil", function($mmUtil) {
    return {
        restrict: 'A',
        link: function(scope, el, attrs) {
            var unregister = scope.$watch(function() {
                return ionic.transition.isActive;
            }, function(isActive) {
                var showKeyboard = typeof attrs.mmAutoFocus == 'undefined' ||
                    (attrs.mmAutoFocus !== false && attrs.mmAutoFocus !== 'false' && attrs.mmAutoFocus !== '0');
                if (!isActive && showKeyboard) {
                    $mmUtil.focusElement(el[0]);
                    unregister();
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmAutoRows', ["$mmUtil", function($mmUtil) {
        function calculateRows(element, attrs) {
        var currentRows = parseInt(element.attr('rows'), 10) || 1,
            maxRows = parseInt(attrs.mmMaxRows, 10) || 5,
            computedStyle = getComputedStyle(element[0]),
            padding = (parseInt(computedStyle.paddingBottom, 10) || 0) + (parseInt(computedStyle.paddingTop, 10) || 0),
            height = $mmUtil.getElementHeight(element[0]) - padding,
            scrollHeight,
            rows;
        if (height <= 0) {
            return 1;
        }
        element.css('height', '1px');
        scrollHeight = element[0].scrollHeight;
        rows = Math.ceil((scrollHeight - padding) / (height / currentRows));
        element.css('height', '');
        if (maxRows && rows >= maxRows) {
            return maxRows;
        } else {
            return rows;
        }
    }
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var lastModelChange;
            if (attrs.ngModel) {
                scope.$watch(attrs.ngModel, function(newValue) {
                    if (typeof newValue != 'undefined') {
                        lastModelChange = Date.now();
                        valueChanged();
                    }
                });
            }
            element.on('input propertychange', function() {
                if (lastModelChange && Date.now() - lastModelChange <= 20) {
                    lastModelChange = 0;
                } else {
                    valueChanged();
                }
            });
            function valueChanged() {
                var currentRows = element.attr('rows'),
                    rows = calculateRows(element, attrs);
                if (rows != currentRows) {
                    element.attr('rows', rows);
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmCompletion', ["$mmSite", "$mmUtil", "$mmText", "$translate", "$q", function($mmSite, $mmUtil, $mmText, $translate, $q) {
    function showStatus(scope) {
        var langKey,
            moduleName = scope.moduleName || '';
        if (scope.completion.tracking === 1 && scope.completion.state === 0) {
            scope.completionImage = 'img/completion/completion-manual-n.svg';
            langKey = 'mm.core.completion-alt-manual-n';
        } else if(scope.completion.tracking === 1 && scope.completion.state === 1) {
            scope.completionImage = 'img/completion/completion-manual-y.svg';
            langKey = 'mm.core.completion-alt-manual-y';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 0) {
            scope.completionImage = 'img/completion/completion-auto-n.svg';
            langKey = 'mm.core.completion-alt-auto-n';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 1) {
            scope.completionImage = 'img/completion/completion-auto-y.svg';
            langKey = 'mm.core.completion-alt-auto-y';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 2) {
            scope.completionImage = 'img/completion/completion-auto-pass.svg';
            langKey = 'mm.core.completion-alt-auto-pass';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 3) {
            scope.completionImage = 'img/completion/completion-auto-fail.svg';
            langKey = 'mm.core.completion-alt-auto-fail';
        }
        if (moduleName) {
            $mmText.formatText(moduleName, true, true, 50).then(function(formatted) {
                $translate(langKey, {$a: formatted}).then(function(translated) {
                    scope.completionDescription = translated;
                });
            });
        }
    }
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            completion: '=',
            afterChange: '=',
            moduleName: '=?'
        },
        templateUrl: 'core/templates/completion.html',
        link: function(scope, element, attrs) {
            if (scope.completion) {
                showStatus(scope);
                element.on('click', function(e) {
                    if (typeof scope.completion.cmid == 'undefined' || scope.completion.tracking !== 1) {
                        return;
                    }
                    e.preventDefault();
                    e.stopPropagation();
                    var modal = $mmUtil.showModalLoading(),
                        params = {
                            cmid: scope.completion.cmid,
                            completed: scope.completion.state === 1 ? 0 : 1
                        };
                    $mmSite.write('core_completion_update_activity_completion_status_manually', params).then(function(response) {
                        if (!response.status) {
                            return $q.reject();
                        }
                        if (angular.isFunction(scope.afterChange)) {
                            scope.afterChange();
                        }
                    }).catch(function(error) {
                        $mmUtil.showErrorModalDefault(error, 'mm.core.errorchangecompletion', true);
                    }).finally(function() {
                        modal.dismiss();
                    });
                });
            }
        }
    };
}]);

angular.module('mm.core')
.controller('mmContextMenu', ["$scope", "$ionicPopover", "$q", "$timeout", function($scope, $ionicPopover, $q, $timeout) {
    var items = $scope.ctxtMenuItems = [];
        this.addContextMenuItem = function(item) {
        if (!item.$$destroyed) {
            items.push(item);
            item.$on('$destroy', function() {
                var index = items.indexOf(item);
                items.splice(index, 1);
            });
        }
    };
        this.shouldMerge = function() {
        return !!($scope.merge && $scope.merge !== 'false');
    };
        $scope.contextMenuItemClicked = function($event, item) {
        if (typeof item.action == 'function') {
            $event.preventDefault();
            $event.stopPropagation();
            if (!item.iconAction || item.iconAction == 'spinner') {
                return false;
            }
            hideContextMenu(item.closeOnClick);
            return $q.when(item.action()).finally(function() {
                if (!item.closeOnClick) {
                    hideContextMenu(item.closeWhenDone);
                }
            });
        } else if (item.href) {
            hideContextMenu(item.closeOnClick);
        }
        return true;
    };
        $scope.showContextMenu = function($event) {
        $scope.contextMenuPopover.show($event);
    };
        function hideContextMenu(close) {
        if (close) {
            $scope.contextMenuPopover.hide();
        }
    }
    $ionicPopover.fromTemplateUrl('core/templates/contextmenu.html', {
        scope: $scope
    }).then(function(popover) {
        $scope.contextMenuPopover = popover;
    });
    $scope.$on('$destroy', function() {
        if ($scope.contextMenuPopover) {
            $scope.contextMenuPopover.remove();
        } else {
            $timeout(function() {
                $scope.contextMenuPopover && $scope.contextMenuPopover.remove();
            }, 200);
        }
    });
}])
.directive('mmContextMenu', ["$translate", function($translate) {
    return {
        restrict: 'E',
        scope: {
            icon: '@?',
            title: '@?',
            merge: '@?'
        },
        transclude: true,
        templateUrl: 'core/templates/contextmenuicon.html',
        controller: 'mmContextMenu',
        link: function(scope, element) {
            scope.contextMenuIcon = scope.icon || 'ion-android-more-vertical';
            scope.contextMenuAria = scope.title || $translate.instant('mm.core.info');
            scope.filterNgShow = function(value) {
                return value && value.ngShow;
            };
            var div = element[0].querySelector('div[ng-transclude]');
            if (div && div.removeAttribute) {
                div.removeAttribute('ng-transclude');
            }
        }
    };
}])
.directive('mmContextMenuItem', ["$mmUtil", "$timeout", "$ionicPlatform", function($mmUtil, $timeout, $ionicPlatform) {
        function getBooleanValue(value, defaultValue) {
        if (typeof value == 'undefined') {
            return defaultValue;
        }
        return !!(value && value !== "false");
    }
        function getOuterContextMenuController() {
        var menus = document.querySelectorAll('ion-header-bar mm-context-menu'),
            outerContextMenu;
        angular.forEach(menus, function(menu) {
            var div = $mmUtil.closest(menu, '.buttons-left, .buttons-right');
            if (div && angular.element(div).css('opacity') !== '0') {
                outerContextMenu = menu;
            }
        });
        if (outerContextMenu) {
            return angular.element(outerContextMenu).controller('mmContextMenu');
        }
    }
    return {
        require: '^^mmContextMenu',
        restrict: 'E',
        scope: {
            content: '=',
            iconAction: '=?',
            iconDescription: '=?',
            ariaAction: '=?',
            ariaDescription: '=?',
            action: '&?',
            href: '=?',
            captureLink: '=?',
            autoLogin: '=?',
            closeOnClick: '=?',
            closeWhenDone: '=?',
            priority: '=?',
            ngShow: '=?'
        },
        link: function(scope, element, attrs, CtxtMenuCtrl) {
            scope.priority = scope.priority || 1;
            scope.closeOnClick = getBooleanValue(scope.closeOnClick, true);
            scope.closeWhenDone = getBooleanValue(scope.closeWhenDone, false);
            if (typeof attrs.ngShow == 'undefined') {
                scope.ngShow = true;
            }
            if (scope.action) {
                scope.href = "";
            } else if (scope.href) {
                scope.action = false;
            }
            scope.captureLink = scope.href && scope.captureLink ? scope.captureLink : "false";
            scope.autoLogin = scope.autoLogin || 'check';
            if (CtxtMenuCtrl.shouldMerge() && $ionicPlatform.isTablet()) {
                $timeout(function() {
                    if (!scope.$$destroyed) {
                        var ctrl = getOuterContextMenuController();
                        if (ctrl) {
                            CtxtMenuCtrl = ctrl;
                        }
                        CtxtMenuCtrl.addContextMenuItem(scope);
                    }
                });
            } else {
                CtxtMenuCtrl.addContextMenuItem(scope);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmExternalContent', ["$log", "$mmFilepool", "$mmSite", "$mmSitesManager", "$mmUtil", "$q", "$mmApp", "$ionicPlatform", function($log, $mmFilepool, $mmSite, $mmSitesManager, $mmUtil, $q, $mmApp, $ionicPlatform) {
    $log = $log.getInstance('mmExternalContent');
        function addSource(dom, url) {
        if (dom.tagName !== 'SOURCE') {
            return;
        }
        var e = document.createElement('source'),
            type = dom.getAttribute('type');
        e.setAttribute('src', url);
        if (type) {
            if (ionic.Platform.isAndroid() && type == 'video/quicktime') {
                e.setAttribute('type', 'video/mp4');
            } else {
                e.setAttribute('type', type);
            }
        }
        dom.parentNode.insertBefore(e, dom);
    }
        function handleExternalContent(siteId, dom, targetAttr, url, component, componentId) {
        if (dom.tagName == 'VIDEO' && dom.textTracks && targetAttr != 'poster') {
            dom.textTracks.onaddtrack = function(event) {
                if (event.track) {
                    event.track.oncuechange = function() {
                        var line = $ionicPlatform.isTablet() || ionic.Platform.isAndroid() ? 90 : 80;
                        angular.forEach(event.track.cues, function(cue) {
                            cue.snapToLines = false;
                            cue.line = line;
                            cue.size = 100;
                        });
                        event.track.oncuechange = null;
                    };
                }
            };
        }
        if (!url || !$mmUtil.isDownloadableUrl(url)) {
            $log.debug('Ignoring non-downloadable URL: ' + url);
            if (dom.tagName === 'SOURCE') {
                addSource(dom, url);
            }
            return $q.reject();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (!site.canDownloadFiles() && $mmUtil.isPluginFileUrl(url)) {
                angular.element(dom).remove();
                return $q.reject();
            }
            var fn,
                downloadUnknown = dom.tagName == 'IMG' || dom.tagName == 'TRACK' || targetAttr == 'poster';
            if (targetAttr === 'src' && dom.tagName !== 'SOURCE' && dom.tagName !== 'TRACK') {
                fn = $mmFilepool.getSrcByUrl;
            } else {
                fn = $mmFilepool.getUrlByUrl;
            }
            return fn(siteId, url, component, componentId, 0, true, downloadUnknown).then(function(finalUrl) {
                $log.debug('Using URL ' + finalUrl + ' for ' + url);
                if (dom.tagName === 'SOURCE') {
                    addSource(dom, finalUrl);
                } else {
                    dom.setAttribute(targetAttr, finalUrl);
                }
                if (finalUrl.indexOf('http') === 0 && targetAttr != 'poster' &&
                            (dom.tagName == 'VIDEO' || dom.tagName == 'AUDIO' || dom.tagName == 'A' || dom.tagName == 'SOURCE')) {
                    var eventName = dom.tagName == 'A' ? 'click' : 'play';
                    if (dom.tagName == 'SOURCE') {
                        dom = $mmUtil.closest(dom, 'video,audio');
                        if (!dom) {
                            return;
                        }
                    }
                    angular.element(dom).on(eventName, function() {
                        if (!$mmApp.isNetworkAccessLimited()) {
                            fn(siteId, url, component, componentId, undefined, false);
                        }
                    });
                }
            });
        });
    }
    return {
        restrict: 'A',
        scope: {
            siteid: '='
        },
        link: function(scope, element, attrs) {
            var dom = element[0],
                siteid = scope.siteid || $mmSite.getId(),
                component = attrs.component,
                componentId = attrs.componentId,
                targetAttr,
                sourceAttr,
                observe = false;
            if (dom.tagName === 'A') {
                targetAttr = 'href';
                sourceAttr = 'href';
                if (attrs.hasOwnProperty('ngHref')) {
                    observe = true;
                }
            } else if (dom.tagName === 'IMG') {
                targetAttr = 'src';
                sourceAttr = 'src';
                if (attrs.hasOwnProperty('ngSrc')) {
                    observe = true;
                }
            } else if (dom.tagName === 'AUDIO' || dom.tagName === 'VIDEO' || dom.tagName === 'SOURCE' || dom.tagName === 'TRACK') {
                targetAttr = 'src';
                sourceAttr = 'targetSrc';
                if (attrs.hasOwnProperty('ngSrc')) {
                    observe = true;
                }
                if (dom.tagName === 'VIDEO' && attrs.poster) {
                    handleExternalContent(siteid, dom, 'poster', attrs.poster, component, componentId);
                }
            } else {
                $log.warn('Directive attached to non-supported tag: ' + dom.tagName);
                return;
            }
            if (observe) {
                attrs.$observe(targetAttr, function(url) {
                    if (!url) {
                        return;
                    }
                    handleExternalContent(siteid, dom, targetAttr, url, component, componentId);
                });
            } else {
                handleExternalContent(siteid, dom, targetAttr, attrs[sourceAttr] || attrs[targetAttr], component, componentId);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmFile', ["$q", "$mmUtil", "$mmFilepool", "$mmSite", "$mmApp", "$mmEvents", "$mmFS", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", function($q, $mmUtil, $mmFilepool, $mmSite, $mmApp, $mmEvents, $mmFS, mmCoreDownloaded, mmCoreDownloading,
            mmCoreNotDownloaded, mmCoreOutdated) {
        function getState(scope, siteId, fileUrl, timeModified, alwaysDownload) {
        return $mmFilepool.getFileStateByUrl(siteId, fileUrl, timeModified).then(function(state) {
            var canDownload = $mmSite.canDownloadFiles();
            scope.isDownloaded = state === mmCoreDownloaded || state === mmCoreOutdated;
            scope.isDownloading = canDownload && state === mmCoreDownloading;
            scope.showDownload = canDownload && (state === mmCoreNotDownloaded || state === mmCoreOutdated ||
                    (alwaysDownload && state === mmCoreDownloaded));
        });
    }
        function downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload) {
        if (!$mmSite.canDownloadFiles()) {
            $mmUtil.showErrorModal('mm.core.cannotdownloadfiles', true);
            return $q.reject();
        }
        scope.isDownloading = true;
        return $mmFilepool.downloadUrl(siteId, fileUrl, false, component, componentId, timeModified).then(function(localUrl) {
            return localUrl;
        }).catch(function() {
            return getState(scope, siteId, fileUrl, timeModified, alwaysDownload).then(function() {
                if (scope.isDownloaded) {
                    return $mmFilepool.getInternalUrlByUrl(siteId, fileUrl);
                } else {
                    return $q.reject();
                }
            });
        });
    }
        function openFile(scope, siteId, fileUrl, fileSize, component, componentId, timeModified, alwaysDownload) {
        var fixedUrl = $mmSite.fixPluginfileURL(fileUrl),
            promise;
        if ($mmFS.isAvailable()) {
            promise = $q.when().then(function() {
                var isWifi = !$mmApp.isNetworkAccessLimited(),
                    isOnline = $mmApp.isOnline();
                if (scope.isDownloaded && !scope.showDownload) {
                    return $mmFilepool.getUrlByUrl(siteId, fileUrl, component, componentId, timeModified);
                } else {
                    if (!isOnline && !scope.isDownloaded) {
                        return $q.reject();
                    }
                    var isDownloading = scope.isDownloading;
                    scope.isDownloading = true;
                    return $mmFilepool.shouldDownloadBeforeOpen(fixedUrl, fileSize).then(function() {
                        if (isDownloading) {
                            return;
                        }
                        return downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload);
                    }, function() {
                        if (isWifi && isOnline) {
                            downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload);
                        }
                        if (isDownloading|| !scope.isDownloaded || isOnline) {
                            return fixedUrl;
                        } else {
                            return $mmFilepool.getUrlByUrl(siteId, fileUrl, component, componentId, timeModified);
                        }
                    });
                }
            });
        } else {
            promise = $q.when(fixedUrl);
        }
        return promise.then(function(url) {
            if (!url) {
                return;
            }
            if (url.indexOf('http') === 0) {
                return $mmUtil.openOnlineFile(url);
            } else {
                return $mmUtil.openFile(url);
            }
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/file.html',
        scope: {
            file: '=',
            canDelete: '@?',
            onDelete: '&?',
            canDownload: '@?',
            noBorder : '@?'
        },
        link: function(scope, element, attrs) {
            var fileUrl = scope.file.fileurl || scope.file.url,
                fileName = scope.file.filename,
                fileSize = scope.file.filesize,
                timeModified = attrs.timemodified || 0,
                siteId = $mmSite.getId(),
                component = attrs.component,
                componentId = attrs.componentId,
                alwaysDownload = attrs.alwaysDownload && attrs.alwaysDownload !== 'false',
                canDownload = scope.canDownload !== false && scope.canDownload !== 'false',
                observer;
            if (!fileName) {
                return;
            }
            scope.filename = fileName;
            scope.fileicon = $mmFS.getFileIcon(fileName);
            if (canDownload) {
                getState(scope, siteId, fileUrl, timeModified, alwaysDownload);
                $mmFilepool.getFileEventNameByUrl(siteId, fileUrl).then(function(eventName) {
                    observer = $mmEvents.on(eventName, function() {
                        getState(scope, siteId, fileUrl, timeModified, alwaysDownload);
                    });
                });
            }
            scope.download = function(e, openAfterDownload) {
                e.preventDefault();
                e.stopPropagation();
                var promise;
                if (scope.isDownloading && !openAfterDownload) {
                    return;
                }
                if (!$mmApp.isOnline() && (!openAfterDownload || (openAfterDownload && !scope.isDownloaded))) {
                    $mmUtil.showErrorModal('mm.core.networkerrormsg', true);
                    return;
                }
                if (openAfterDownload) {
                    openFile(scope, siteId, fileUrl, fileSize, component, componentId, timeModified, alwaysDownload)
                            .catch(function(error) {
                        $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
                    });
                } else {
                    promise = fileSize ? $mmUtil.confirmDownloadSize({size: fileSize, total: true}) : $q.when();
                    promise.then(function() {
                        $mmFilepool.invalidateFileByUrl(siteId, fileUrl).finally(function() {
                            scope.isDownloading = true;
                            $mmFilepool.addToQueueByUrl(siteId, fileUrl, component, componentId, timeModified).catch(function() {
                                $mmUtil.showErrorModal('mm.core.errordownloading', true);
                            });
                        });
                    });
                }
            };
            if (scope.canDelete) {
                scope.delete = function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (scope.onDelete) {
                        scope.onDelete();
                    }
                };
            }
            scope.$on('$destroy', function() {
                if (observer && observer.off) {
                    observer.off();
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmFormatText', ["$interpolate", "$mmText", "$compile", "$translate", "$mmUtil", function($interpolate, $mmText, $compile, $translate, $mmUtil) {
    var extractVariableRegex = new RegExp('{{([^|]+)(|.*)?}}', 'i'),
        tagsToIgnore = ['AUDIO', 'VIDEO', 'BUTTON', 'INPUT', 'SELECT', 'TEXTAREA', 'A'];
        function addExternalContent(el, component, componentId, siteId) {
        el.setAttribute('mm-external-content', '');
        if (component) {
            el.setAttribute('component', component);
            if (componentId) {
                el.setAttribute('component-id', componentId);
            }
        }
        if (siteId) {
            el.setAttribute('siteid', siteId);
        }
    }
        function addMediaAdaptClass(el) {
        angular.element(el).addClass('mm-media-adapt-width');
    }
        function getElementWidth(element) {
        var width = $mmUtil.getElementWidth(element);
        if (!width) {
            var angElement = angular.element(element),
                parentWidth = $mmUtil.getElementWidth(element.parentNode, true, false, false, true),
                previousDisplay = angElement.css('display');
            angElement.css('display', 'inline-block');
            width = $mmUtil.getElementWidth(element);
            if (parentWidth > 0 && (!width || width > parentWidth)) {
                width = parentWidth;
            }
            angElement.css('display', previousDisplay);
        }
        return parseInt(width, 10);
    }
        function getElementHeight(elementAng) {
        var element = elementAng[0],
            height;
        elementAng.removeClass('mm-enabled-media-adapt');
        height = $mmUtil.getElementHeight(element);
        elementAng.addClass('mm-enabled-media-adapt');
        return parseInt(height, 10) || false;
    }
        function formatAndRenderContents(scope, element, attrs, text) {
        var maxHeight = false;
        if (typeof text == 'undefined') {
            element.removeClass('opacity-hide');
            return;
        }
        text = $interpolate(text)(scope);
        text = text.trim();
        if (typeof attrs.maxHeight != "undefined") {
            maxHeight = parseInt(attrs.maxHeight || 0, 10) || false;
        } else if (typeof attrs.shorten != "undefined") {
            console.warn("mm-format-text: shorten attribute is deprecated please use max-height and expand-in-fullview instead.");
            maxHeight = 100;
        }
        formatContents(scope, element, attrs, text).then(function(fullText) {
            if (maxHeight && fullText != "") {
                renderText(scope, element, fullText);
                var height = element.css('max-height') ? false : getElementHeight(element);
                if (!height || height > maxHeight) {
                    var expandInFullview = $mmUtil.isTrueOrOne(attrs.fullviewOnClick) || false;
                    fullText += '<div class="mm-show-more">' + $translate.instant('mm.core.showmore') + '</div>';
                    if (expandInFullview) {
                        element.addClass('mm-expand-in-fullview');
                    }
                    element.addClass('mm-text-formatted mm-shortened');
                    element.css('max-height', maxHeight + 'px');
                    element.on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        var target = e.target;
                        if (tagsToIgnore.indexOf(target.tagName) === -1 || (target.tagName === 'A' &&
                                !target.getAttribute('href'))) {
                            if (!expandInFullview) {
                                element.toggleClass('mm-shortened');
                            } else {
                                $mmText.expandText(attrs.expandTitle || $translate.instant('mm.core.description'), text,
                                    attrs.newlinesOnFullview, attrs.component, attrs.componentId);
                            }
                        } else {
                            $mmText.expandText(attrs.expandTitle || $translate.instant('mm.core.description'), text,
                                attrs.newlinesOnFullview, attrs.component, attrs.componentId);
                        }
                    });
                }
            }
            element.addClass('mm-enabled-media-adapt');
            renderText(scope, element, fullText, attrs.afterRender);
        });
    }
        function formatContents(scope, element, attrs, text) {
        var siteId = scope.siteid,
            component = attrs.component,
            componentId = attrs.componentId;
        return $mmText.formatText(text, attrs.clean, attrs.singleline).then(function(formatted) {
            var el = element[0],
                dom = angular.element('<div>').html(formatted),
                images = dom.find('img');
            angular.forEach(dom.find('a'), function(anchor) {
                anchor.setAttribute('mm-link', '');
                anchor.setAttribute('capture-link', true);
                addExternalContent(anchor, component, componentId, siteId);
            });
            if (images && images.length > 0) {
                var elWidth = getElementWidth(el) || 100;
                angular.forEach(images, function(img) {
                    addMediaAdaptClass(img);
                    addExternalContent(img, component, componentId, siteId);
                    if (!attrs.notAdaptImg) {
                        var imgWidth = getElementWidth(img),
                            container = angular.element('<span class="mm-adapted-img-container"></span>'),
                            jqImg = angular.element(img);
                        container.css('float', img.style.float);
                        jqImg.wrap(container);
                        if (imgWidth > elWidth) {
                            var label = $mmText.escapeHTML($translate.instant('mm.core.openfullimage')),
                                imgSrc = $mmText.escapeHTML(img.getAttribute('src'));
                            jqImg.after('<a href="#" class="mm-image-viewer-icon" mm-image-viewer img="' + imgSrc +
                                            '" aria-label="' + label + '"><i class="icon ion-ios-search-strong"></i></a>');
                        }
                    }
                });
            }
            angular.forEach(dom.find('audio'), function(el) {
                treatMedia(el, component, componentId, siteId);
            });
            angular.forEach(dom.find('video'), function(el) {
                treatVideoFilters(el);
                treatMedia(el, component, componentId, siteId);
                el.setAttribute('data-tap-disabled', true);
            });
            angular.forEach(dom.find('iframe'), addMediaAdaptClass);
            if (ionic.Platform.isIOS()) {
                angular.forEach(dom.find('select'), function(select) {
                    select.setAttribute('mm-ios-select-fix', '');
                });
            }
            angular.forEach(dom[0].querySelectorAll('.button'), function(button) {
                if (button.querySelector('a')) {
                    angular.element(button).addClass('mm-button-with-inner-link');
                }
            });
            return dom.html();
        });
    }
        function renderText(scope, element, text, afterRender) {
        element.html(text);
        element.removeClass('opacity-hide');
        $compile(element.contents())(scope);
        if (afterRender && scope[afterRender]) {
            scope[afterRender](scope);
        }
    }
    function youtubeGetId(url) {
        var regExp = /^.*(?:(?:youtu.be\/)|(?:v\/)|(?:\/u\/\w\/)|(?:embed\/)|(?:watch\?))\??v?=?([^#\&\?]*).*/;
        var match = url.match(regExp);
        return (match && match[1].length == 11)? match[1] : false;
    }
        function treatVideoFilters(el) {
        if (!angular.element(el).hasClass('video-js')) {
            return;
        }
        var data = JSON.parse(el.getAttribute('data-setup') || '{}'),
            youtubeId = data.techOrder && data.techOrder[0] && data.techOrder[0] == 'youtube' && data.sources && data.sources[0] &&
                data.sources[0].src && youtubeGetId(data.sources[0].src);
        if (!youtubeId) {
            return;
        }
        var iframe = document.createElement('iframe');
        iframe.id = el.id;
        iframe.src = 'https://www.youtube.com/embed/' + youtubeId;
        iframe.setAttribute('frameborder', 0);
        iframe.width = '100%';
        iframe.height = 300;
        el.parentNode.insertBefore(iframe, el);
        el.parentNode.removeChild(el);
    }
        function treatMedia(el, component, componentId, siteId) {
        addMediaAdaptClass(el);
        addExternalContent(el, component, componentId, siteId);
        angular.forEach(angular.element(el).find('source'), function(source) {
            source.setAttribute('target-src', source.getAttribute('src'));
            source.removeAttribute('src');
            addExternalContent(source, component, componentId, siteId);
        });
        angular.forEach(angular.element(el).find('track'), function(track) {
            addExternalContent(track, component, componentId, siteId);
        });
    }
    return {
        restrict: 'EA',
        scope: true,
        link: function(scope, element, attrs) {
            element.addClass('opacity-hide');
            var content = element.html();
            if (attrs.watch) {
                var matches = content.match(extractVariableRegex);
                if (matches && typeof matches[1] == 'string') {
                    var variable = matches[1].trim();
                    scope.$watch(variable, function() {
                        formatAndRenderContents(scope, element, attrs, content);
                    });
                } else {
                    formatAndRenderContents(scope, element, attrs, content);
                }
            } else {
                formatAndRenderContents(scope, element, attrs, content);
            }
        }
    };
}]);

angular.module('mm.core')
.constant('mmCoreIframeTimeout', 15000)
.directive('mmIframe', ["$log", "$mmUtil", "$mmText", "$mmSite", "$mmFS", "$timeout", "mmCoreIframeTimeout", function($log, $mmUtil, $mmText, $mmSite, $mmFS, $timeout, mmCoreIframeTimeout) {
    $log = $log.getInstance('mmIframe');
    var tags = ['iframe', 'frame', 'object', 'embed'];
        function treatFrame(element) {
        if (element) {
            redefineWindowOpen(element);
            treatLinks(element);
            element.on('load', function() {
                redefineWindowOpen(element);
                treatLinks(element);
            });
        }
    }
        function redefineWindowOpen(element) {
        var el = element[0],
            contentWindow = element.contentWindow || el.contentWindow,
            contents = element.contents();
        if (!contentWindow && el && el.contentDocument) {
            contentWindow = el.contentDocument.defaultView;
        }
        if (!contentWindow && el && el.getSVGDocument) {
            var svgDoc = el.getSVGDocument();
            if (svgDoc && svgDoc.defaultView) {
                contents = angular.element(svgdoc);
                contentWindow = svgdoc.defaultView;
            } else if (el.window) {
                contentWindow = el.window;
            } else if (el.getWindow) {
                contentWindow = el.getWindow();
            }
        }
        if (contentWindow) {
            contentWindow.open = function (url) {
                var scheme = $mmText.getUrlScheme(url);
                if (!scheme) {
                    var src = element[0] && (element[0].src || element[0].data);
                    if (src) {
                        var dirAndFile = $mmFS.getFileAndDirectoryFromPath(src);
                        if (dirAndFile.directory) {
                            url = $mmFS.concatenatePaths(dirAndFile.directory, url);
                        } else {
                            $log.warn('Cannot get iframe dir path to open relative url', url, element);
                            return {};
                        }
                    } else {
                        $log.warn('Cannot get iframe src to open relative url', url, element);
                        return {};
                    }
                }
                if (url.indexOf('cdvfile://') === 0 || url.indexOf('file://') === 0) {
                    $mmUtil.openFile(url).catch(function(error) {
                        $mmUtil.showErrorModal(error);
                    });
                } else {
                    if (!$mmSite.isLoggedIn()) {
                        $mmUtil.openInBrowser(url);
                    } else {
                        $mmSite.openInBrowserWithAutoLoginIfSameSite(url);
                    }
                }
                return {};
            };
        }
        angular.forEach(tags, function(tag) {
            angular.forEach(contents.find(tag), function(subelement) {
                treatFrame(angular.element(subelement));
            });
        });
    }
        function treatLinks(element) {
        var links = element.contents().find('a');
        angular.forEach(links, function(el) {
            var href = el.href;
            if (href) {
                var scheme = $mmText.getUrlScheme(href);
                if (scheme && scheme == 'javascript') {
                    return;
                } else if (scheme && scheme != 'file' && scheme != 'filesystem') {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            e.preventDefault();
                            if (!$mmSite.isLoggedIn()) {
                                $mmUtil.openInBrowser(href);
                            } else {
                                $mmSite.openInBrowserWithAutoLoginIfSameSite(href);
                            }
                        }
                    });
                } else if (el.target == '_parent' || el.target == '_top' || el.target == '_blank') {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            e.preventDefault();
                            $mmUtil.openFile(href).catch(function(error) {
                                $mmUtil.showErrorModal(error);
                            });
                        }
                    });
                } else if (ionic.Platform.isIOS() && (!el.target || el.target == '_self')) {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            if (element[0].tagName.toLowerCase() == 'object') {
                                e.preventDefault();
                                element.attr('data', href);
                            } else {
                                e.preventDefault();
                                element.attr('src', href);
                            }
                        }
                    });
                }
            }
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/iframe.html',
        scope: {
            src: '='
        },
        link: function(scope, element, attrs) {
            var url = (scope.src && scope.src.toString()) || '', 
                iframe = angular.element(element.find('iframe')[0]);
            scope.width = $mmUtil.formatPixelsSize(attrs.iframeWidth) || '100%';
            scope.height = $mmUtil.formatPixelsSize(attrs.iframeHeight) || '100%';
            scope.loading = !!url.match(/^https?:\/\//i);
            treatFrame(iframe);
            if (scope.loading) {
                iframe.on('load', function() {
                    scope.loading = false;
                    $timeout();
                });
                iframe.on('error', function() {
                    scope.loading = false;
                    $mmUtil.showErrorModal('mm.core.errorloadingcontent', true);
                    $timeout();
                });
                $timeout(function() {
                    scope.loading = false;
                }, mmCoreIframeTimeout);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmImageViewer', ["$ionicModal", function($ionicModal) {
    return {
        restrict: 'A',
        priority: 500,
        scope: true,
        link: function(scope, element, attrs) {
            if (attrs.img) {
                scope.img = attrs.img;
                scope.closeModal = function(){
                    scope.modal.hide();
                };
                element.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (!scope.modal) {
                        $ionicModal.fromTemplateUrl('core/templates/imageviewer.html', {
                            scope: scope,
                            animation: 'slide-in-up'
                        }).then(function(m) {
                            scope.modal = m;
                            scope.modal.show();
                        });
                    } else {
                        scope.modal.show();
                    }
                });
                scope.$on('$destroy', function() {
                    if (scope.modal) {
                        scope.modal.remove();
                    }
                });
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmInputErrors', ["$translate", "$compile", function($translate, $compile) {
    var errorContainerTemplate =
        '<div class="mm-input-error-container" ng-show="form[fieldName].$error && form.$submitted" ' +
                    'ng-messages="form[fieldName].$error" role="alert">' +
            '<div ng-repeat="(type, text) in errorMessages">' +
                '<div class="mm-input-error" ng-message-exp="type">{{text}}</div>' +
            '</div>' +
        '</div>';
    function initErrorMessages(scope, input) {
        scope.errorMessages = scope.errorMessages || {};
        scope.errorMessages.required = scope.errorMessages.required || $translate.instant('mm.core.required');
        scope.errorMessages.email = scope.errorMessages.email || $translate.instant('mm.login.invalidemail');
        scope.errorMessages.date = scope.errorMessages.date || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.datetime = scope.errorMessages.datetime || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.datetimelocal = scope.errorMessages.datetimelocal || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.time = scope.errorMessages.time || $translate.instant('mm.login.invalidtime');
        scope.errorMessages.url = scope.errorMessages.url || $translate.instant('mm.login.invalidurl');
        angular.forEach(['min', 'max'], function(type) {
            if (!scope.errorMessages[type]) {
                if (input && typeof input[type] != 'undefined' && input[type] !== '') {
                    var value = input[type];
                    if (input.type == 'date' || input.type == 'datetime' || input.type == 'datetime-local') {
                        var date = moment(value);
                        if (date.isValid()) {
                            value = moment(value).format($translate.instant('mm.core.dfdaymonthyear'));
                        }
                    }
                    scope.errorMessages[type] = $translate.instant('mm.login.invalidvalue' + type, {$a: value});
                } else {
                    scope.errorMessages[type] = $translate.instant('mm.login.profileinvaliddata');
                }
            }
        });
    }
    return {
        restrict: 'A',
        require: '^form',
        scope: {
            fieldName: '@?',
            errorMessages: '=?'
        },
        link: function(scope, element, attrs, FormController) {
            var input;
            scope.form = FormController;
            if (!scope.fieldName) {
                input = element[0].querySelector('input, select, textarea');
                if (!input || !input.name) {
                    return;
                }
                scope.fieldName = input.name;
            }
            if (input) {
                initErrorMessages(scope, input);
            }
            var errorContainer = $compile(errorContainerTemplate)(scope);
            element.append(errorContainer);
            scope.$watch('form[fieldName].$invalid && form.$submitted', function(newValue) {
                if (!input) {
                    input = element[0].querySelector('*[name="' + scope.fieldName + '"]');
                    if (input) {
                        initErrorMessages(scope, input);
                    }
                }
                if (newValue) {
                    element.addClass('mm-input-has-errors');
                } else {
                    element.removeClass('mm-input-has-errors');
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmIosSelectFix', function() {
    return {
        restrict: 'A',
        priority: 100,
        scope: false,
        require: 'select',
        link: function(scope, element) {
            if (ionic.Platform.isIOS()) {
                scope.$watch(function() {
                    return element.html();
                }, function() {
                    if (!element[0].querySelector('optgroup')) {
                        element.append('<optgroup label=""></optgroup>');
                    }
                });
            }
        }
    };
});

angular.module('mm.core')
.directive('mmKeepKeyboard', ["$mmUtil", "$timeout", "$mmApp", function($mmUtil, $timeout, $mmApp) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var selector = attrs.mmKeepKeyboard,
                keepInButton = attrs.keepInButton && attrs.keepInButton !== 'false',
                lastFocusOut = 0,
                candidateEls,
                selectedEl,
                button,
                input;
            if (typeof selector != 'string' || !selector) {
                return;
            }
            candidateEls = document.querySelectorAll(selector);
            selectedEl = candidateEls[candidateEls.length - 1];
            if (!selectedEl) {
                return;
            }
            if (keepInButton) {
                button = element[0];
                input = selectedEl;
            } else {
                button = selectedEl;
                input = element[0];
            }
            input.addEventListener('focusout', focusOut);
            button.addEventListener('click', buttonClicked);
            scope.$on('$destroy', function() {
                button.removeEventListener('click', buttonClicked);
                input.removeEventListener('focusout', focusOut);
            });
            function focusOut() {
                lastFocusOut = Date.now();
            }
            function buttonClicked() {
                if (document.activeElement == input) {
                    input.addEventListener('focusout', focusElementAgain);
                    $timeout(focusElementAgain);
                } else if (document.activeElement == button && Date.now() - lastFocusOut < 200) {
                    $timeout(focusElementAgain);
                }
            }
            function focusElementAgain() {
                if ($mmApp.isKeyboardVisible()) {
                    $mmUtil.focusElement(input);
                    input.removeEventListener('focusout', focusElementAgain);
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmLink', ["$mmUtil", "$mmContentLinksHelper", "$location", "$mmSite", function($mmUtil, $mmContentLinksHelper, $location, $mmSite) {
        function navigate(href, inApp, autoLogin) {
        inApp = inApp && inApp !== 'false';
        autoLogin = autoLogin || 'check';
        if (href.indexOf('cdvfile://') === 0 || href.indexOf('file://') === 0) {
            $mmUtil.openFile(href).catch(function(error) {
                $mmUtil.showErrorModal(error);
            });
        } else if (href.charAt(0) == '#'){
            href = href.substr(1);
            if (href.charAt(0) == '/') {
                $location.url(href);
            } else {
                $mmUtil.scrollToElement(document, "#" + href + ", [name='" + href + "']");
            }
        } else {
            if (!$mmSite.isLoggedIn()) {
                if (inApp) {
                    $mmUtil.openInApp(href);
                } else {
                    $mmUtil.openInBrowser(href);
                }
            } else if (autoLogin == 'yes') {
                if (inApp) {
                    $mmSite.openInAppWithAutoLogin(href);
                } else {
                    $mmSite.openInBrowserWithAutoLogin(href);
                }
            } else if (autoLogin == 'no') {
                if (inApp) {
                    $mmUtil.openInApp(href);
                } else {
                    $mmUtil.openInBrowser(href);
                }
            } else {
                if (inApp) {
                    $mmSite.openInAppWithAutoLoginIfSameSite(href);
                } else {
                    $mmSite.openInBrowserWithAutoLoginIfSameSite(href);
                }
            }
        }
    }
    return {
        restrict: 'A',
        priority: 100,
        link: function(scope, element, attrs) {
            element.on('click', function(event) {
                if (!event.defaultPrevented) {
                    var href = element[0].getAttribute('href');
                    if (href) {
                        event.preventDefault();
                        event.stopPropagation();
                        if (attrs.captureLink && attrs.captureLink !== 'false') {
                            $mmContentLinksHelper.handleLink(href).then(function(treated) {
                                if (!treated) {
                                   navigate(href, attrs.inApp, attrs.autoLogin);
                                }
                            });
                        } else {
                            navigate(href, attrs.inApp, attrs.autoLogin);
                        }
                    }
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmLoading', ["$translate", function($translate) {
    return {
        restrict: 'E',
        templateUrl: 'core/templates/loading.html',
        transclude: true,
        scope: {
            hideUntil: '=?',
            message: '@?',
            dynMessage: '=?',
            loadingPaddingTop: '=?'
        },
        link: function(scope, element, attrs) {
            var el = element[0],
                loading = angular.element(el.querySelector('.mm-loading-container'));
            if (!attrs.message) {
                $translate('mm.core.loading').then(function(loadingString) {
                    scope.message = loadingString;
                });
            }
            if (attrs.loadingPaddingTop) {
                scope.$watch('loadingPaddingTop', function(newValue) {
                    var num = parseInt(newValue);
                    if (num >= 0 || num < 0) {
                        loading.css('padding-top', newValue + 'px');
                    } else if(typeof newValue == 'string') {
                        loading.css('padding-top', newValue);
                    }
                });
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmLocalFile', ["$mmFS", "$mmText", "$mmUtil", "$timeout", "$translate", function($mmFS, $mmText, $mmUtil, $timeout, $translate) {
    function loadFileBasicData(scope, file) {
        scope.fileName = file.name;
        scope.fileIcon = $mmFS.getFileIcon(file.name);
        scope.fileExtension = $mmFS.getFileExtension(file.name);
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/localfile.html',
        scope: {
            file: '=',
            manage: '=?',
            fileDeleted: '&?',
            fileRenamed: '&?',
            overrideClick: '=?',
            fileClicked: '&?',
            noBorder: '@?'
        },
        link: function(scope, element) {
            var file = scope.file,
                relativePath;
            if (!file || !file.name) {
                return;
            }
            relativePath = $mmFS.removeBasePath(file.toURL());
            if (!relativePath) {
                relativePath = file.fullPath;
            }
            loadFileBasicData(scope, file);
            scope.data = {};
            $mmFS.getMetadata(file).then(function(metadata) {
                if (metadata.size >= 0) {
                    scope.size = $mmText.bytesToSize(metadata.size, 2);
                }
                scope.timeModified = moment(metadata.modificationTime).format('LLL');
            });
            scope.open = function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (scope.overrideClick && scope.fileClicked) {
                    scope.fileClicked();
                } else {
                    $mmUtil.openFile(file.toURL());
                }
            };
            scope.activateEdit = function(e) {
                e.preventDefault();
                e.stopPropagation();
                scope.editMode = true;
                scope.data.filename = file.name;
                $timeout(function() {
                    $mmUtil.focusElement(element[0].querySelector('input'));
                });
            };
            scope.changeName = function(e, newName) {
                e.preventDefault();
                e.stopPropagation();
                if (newName == file.name) {
                    scope.editMode = false;
                    return;
                }
                var modal = $mmUtil.showModalLoading(),
                    fileAndDir = $mmFS.getFileAndDirectoryFromPath(relativePath),
                    newPath = $mmFS.concatenatePaths(fileAndDir.directory, newName);
                $mmFS.getFile(newPath).then(function() {
                    $mmUtil.showErrorModal('mm.core.errorfileexistssamename', true);
                }).catch(function() {
                    return $mmFS.moveFile(relativePath, newPath).then(function(fileEntry) {
                        scope.editMode = false;
                        scope.file = file = fileEntry;
                        loadFileBasicData(scope, file);
                        scope.fileRenamed && scope.fileRenamed({file: file});
                    }).catch(function() {
                        $mmUtil.showErrorModal('mm.core.errorrenamefile', true);
                    });
                }).finally(function() {
                    modal.dismiss();
                });
            };
            scope.deleteFile = function(e) {
                e.preventDefault();
                e.stopPropagation();
                $mmUtil.showConfirm($translate.instant('mm.core.confirmdeletefile')).then(function() {
                    var modal = $mmUtil.showModalLoading();
                    $mmFS.removeFile(relativePath).then(function() {
                        scope.fileDeleted && scope.fileDeleted();
                    }).catch(function() {
                        $mmUtil.showErrorModal('mm.core.errordeletefile', true);
                    }).finally(function() {
                        modal.dismiss();
                    });
                });
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmMarkRequired', ["$translate", "$timeout", function($translate, $timeout) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var mark = attrs.mmMarkRequired && attrs.mmMarkRequired !== 'false' && attrs.mmMarkRequired !== '0',
                requiredLabel = $translate.instant('mm.core.required');
            if (mark) {
                element.append('<i class="icon ion-asterisk mm-input-required-asterisk" title="' + requiredLabel + '"></i>');
                $timeout(function() {
                    var ariaLabel = element.attr('aria-label') || $mmText.cleanTags(element.html(), true);
                    if (ariaLabel) {
                        element.attr('aria-label', ariaLabel + ' ' + requiredLabel);
                    }
                });
            } else {
                var asterisk = element[0].querySelector('.mm-input-required-asterisk');
                if (asterisk) {
                    angular.element(asterisk).remove();
                    $timeout(function() {
                        var ariaLabel = element.attr('aria-label');
                        if (ariaLabel) {
                            element.attr('aria-label', ariaLabel.replace(' ' + requiredLabel, ''));
                        }
                    });
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmMultipleSelect', ["$ionicModal", "$translate", function($ionicModal, $translate) {
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            title: '@',
            options: '='
        },
        templateUrl: 'core/templates/multipleselect.html',
        link: function(scope, element, attrs) {
            var keyProperty = attrs.keyProperty || "key",
                valueProperty = attrs.valueProperty || "value",
                selectedProperty = attrs.selectedProperty || "selected",
                strSeparator = $translate.instant('mm.core.listsep') + " ";
            scope.optionsRender = [];
            scope.selectedOptions = getSelectedOptionsText();
            element.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (!scope.modal) {
                    $ionicModal.fromTemplateUrl('core/templates/multipleselectpopover.html', {
                        scope: scope,
                        animation: 'slide-in-up'
                    }).then(function(m) {
                        scope.modal = m;
                        scope.optionsRender = scope.options.map(function(option) {
                            return {
                                key: option[keyProperty],
                                value: option[valueProperty],
                                selected: option[selectedProperty] || false
                            };
                        });
                        scope.modal.show();
                    });
                } else {
                    scope.modal.show();
                }
            });
            scope.saveOptions = function() {
                angular.forEach(scope.optionsRender, function (tempOption){
                    for (var j = 0; j < scope.options.length; j++) {
                        var option = scope.options[j];
                        if (option[keyProperty] == tempOption.key) {
                            option[selectedProperty] = tempOption.selected;
                            return;
                        }
                    }
                });
                scope.selectedOptions = getSelectedOptionsText();
                scope.closeModal();
            };
            function getSelectedOptionsText() {
                var selected = scope.options.filter(function(option) {
                    return !!option[selectedProperty];
                }).map(function(option) {
                    return option[valueProperty];
                });
                return selected.join(strSeparator);
            }
            scope.closeModal = function(){
                scope.modal.hide();
            };
            scope.$on('$destroy', function () {
                if (scope.modal){
                    scope.modal.remove();
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmNavButtons', ["$document", "$mmUtil", "$compile", "$timeout", function($document, $mmUtil, $compile, $timeout) {
        function callBeforeEnter(controller, eventData, $scope) {
        var data = angular.copy(eventData);
        delete data.navBarItems;
        data.viewNotified = false;
        data.shouldAnimate = false;
        var previousTitles = document.querySelectorAll('ion-header-bar .back-button .back-text .previous-title'),
            modifiedTitles = [];
        angular.forEach(previousTitles, function(title, index) {
            if (title.innerHTML == 'undefined') {
                angular.element(title).css('display', 'none');
                modifiedTitles.push(title);
            }
        });
        controller.beforeEnter(undefined, data);
        $timeout(function() {
            angular.forEach($scope.$$watchers, function(watcher) {
                var value = watcher.get($scope);
                if (typeof value != 'undefined') {
                    watcher.last = value;
                    watcher.fn(value, undefined, $scope);
                }
            });
        });
        $timeout(function() {
            angular.forEach(modifiedTitles, function(title) {
                angular.element(title).css('display', '');
            });
        }, 1000);
    }
    return {
        restrict: 'E',
        require: '^ionNavBar',
        priority: 100,
        compile: function(tElement, tAttrs) {
            var side = 'left';
            if (/^primary|secondary|right$/i.test(tAttrs.side || '')) {
                side = tAttrs.side.toLowerCase();
            }
            var spanEle = $document[0].createElement('span');
            spanEle.className = side + '-buttons';
            spanEle.innerHTML = tElement.html();
            var navElementType = side + 'Buttons';
            tElement.attr('class', 'hide');
            tElement.empty();
            return {
                pre: function($scope, $element, $attrs, navBarCtrl) {
                    var splitView = $mmUtil.closest($element[0], 'mm-split-view'),
                        ionView,
                        unregisterViewListener,
                        parentViewCtrl;
                    if (splitView) {
                        ionView = $mmUtil.closest(splitView, 'ion-view');
                    } else {
                        ionView = $mmUtil.closest($element[0], 'ion-view');
                    }
                    if (!ionView) {
                        return;
                    }
                    parentViewCtrl = angular.element(ionView).data('$ionViewController');
                    if (parentViewCtrl) {
                        if (splitView) {
                            var svController = angular.element(splitView).controller('mmSplitView'),
                                eventData,
                                leftPaneButtons,
                                leftPaneButtonsHtml,
                                timeToWait;
                            if (!svController) {
                                return;
                            }
                            timeToWait = 1000 - (new Date().getTime() - svController.getStartTime());
                            $timeout(function() {
                                eventData = svController.getIonicViewEventData();
                                leftPaneButtonsHtml = svController.getHeaderBarButtonsHtml(spanEle.className);
                                if (leftPaneButtonsHtml && leftPaneButtonsHtml.trim()) {
                                    leftPaneButtons = angular.element(leftPaneButtonsHtml);
                                }
                                spanEle = $compile(spanEle.outerHTML)($scope);
                                var contextMenus = spanEle[0].querySelectorAll('mm-context-menu');
                                if (contextMenus.length) {
                                    angular.element(contextMenus).remove();
                                }
                                if (leftPaneButtons && leftPaneButtons.length) {
                                    if (side == 'secondary' || side == 'right') {
                                        spanEle.prepend(leftPaneButtons);
                                    } else {
                                        spanEle.append(leftPaneButtons);
                                    }
                                }
                                parentViewCtrl.navElement(navElementType, spanEle);
                                callBeforeEnter(parentViewCtrl, eventData, $scope);
                                unregisterViewListener = svController.onViewEvent(function(eventData) {
                                    callBeforeEnter(parentViewCtrl, eventData, $scope);
                                });
                                spanEle = null;
                            }, timeToWait);
                        } else {
                            parentViewCtrl.navElement(navElementType, spanEle.outerHTML);
                            spanEle = null;
                        }
                    } else {
                        navBarCtrl.navElement(navElementType, spanEle.outerHTML);
                        spanEle = null;
                    }
                    $scope.$on('$destroy', function() {
                        if (unregisterViewListener) {
                            unregisterViewListener();
                        }
                    });
                }
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmNavigationBar', ["$state", "$translate", function($state, $translate) {
    return {
        restrict: 'E',
        scope: {
            previous: '=?',
            next: '=?',
            action: '=?',
            info: '=?',
            component: '@?',
            componentId: '@?'
        },
        templateUrl: 'core/templates/navigationbar.html',
        link: function(scope, element, attrs) {
            scope.title = attrs.title || $translate.instant('mm.core.info');
            scope.showInfo = function() {
                $state.go('site.mm_textviewer', {
                    title: scope.title,
                    content: scope.info,
                    component: attrs.component,
                    componentId: attrs.componentId
                });
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmNoInputValidation', function() {
    return {
        restrict: 'A',
        priority: 500,
        compile: function(el, attrs) {
            attrs.$set('type',
                null,               
                false               
            );
        }
    }
});

angular.module('mm.core')
.directive('mmRichTextEditor', ["$ionicPlatform", "$mmLang", "$timeout", "$q", "$window", "$ionicScrollDelegate", "$mmUtil", "$mmSite", "$mmFilepool", function($ionicPlatform, $mmLang, $timeout, $q, $window, $ionicScrollDelegate, $mmUtil,
            $mmSite, $mmFilepool) {
    var editorInitialHeightDefault = 300,
        adjustHeightDefault = true,
        frameTags = ['iframe', 'frame', 'object', 'embed'];
        function calculateFixedBarsHeight(editorEl) {
        var ionContentEl = editorEl.parentElement;
        while (ionContentEl && ionContentEl.nodeName != 'ION-CONTENT') {
            ionContentEl = ionContentEl.parentElement;
        }
        if (ionContentEl.nodeName == 'ION-CONTENT') {
            return $window.innerHeight - $mmUtil.getElementHeight(ionContentEl);
        } else {
            return 0;
        }
    }
        function changeLanguageCode(lang) {
        var split = lang.split('-');
        if (split.length > 1) {
            split[1] = split[1].toUpperCase();
            return split.join('_');
        } else {
            return lang;
        }
    }
        function getCKEditorController(element) {
        var ckeditorEl = element.querySelector('textarea[ckeditor]');
        if (ckeditorEl) {
            return angular.element(ckeditorEl).controller('ckeditor');
        }
    }
        function getSurroundingHeight(element, top) {
        var height = 0;
        while (element.parentNode && element.parentNode.tagName != "ION-CONTENT" && (!top || element != top)) {
            var parent = element.parentNode;
            angular.forEach(parent.childNodes, function(child) {
                if (child.tagName && element.tagName && element.tagName != 'MM-LOADING' && child != element) {
                    height += $mmUtil.getElementHeight(child, false, true, true);
                }
            });
            element = parent;
        }
        var cs = getComputedStyle(element);
        height += (parseInt(cs.paddingTop, 10) + parseInt(cs.paddingBottom, 10));
        return height;
    }
        function searchAndFormatWysiwyg(element, component, componentId, tries) {
        if (typeof tries == 'undefined') {
            tries = 0;
        }
        var wysiwygIframe = element.querySelector('.cke_wysiwyg_frame');
        if (wysiwygIframe) {
            treatFrame(wysiwygIframe, component, componentId);
            return $q.when(wysiwygIframe);
        } else if (tries < 5) {
            return $timeout(function() {
                return searchAndFormatWysiwyg(element, component, componentId, tries+1);
            }, 100);
        }
    }
        function treatFrame(element, component, componentId) {
        if (element) {
            var loaded = false;
            element = angular.element(element);
            element.on('load', function() {
                if (!loaded) {
                    loaded = true;
                    treatExternalContent(element, component, componentId);
                    treatSubframes(element, component, componentId);
                }
            });
            $timeout(function() {
                if (!loaded) {
                    loaded = true;
                    treatExternalContent(element, component, componentId);
                    treatSubframes(element, component, componentId);
                }
            }, 1000);
        }
    }
        function treatSubframes(element, component, componentId) {
        var el = element[0],
            contentWindow = element.contentWindow || el.contentWindow,
            contents = element.contents();
        if (!contentWindow && el && el.contentDocument) {
            contentWindow = el.contentDocument.defaultView;
        }
        if (!contentWindow && el && el.getSVGDocument) {
            var svgDoc = el.getSVGDocument();
            if (svgDoc && svgDoc.defaultView) {
                contents = angular.element(svgdoc);
            }
        }
        angular.forEach(frameTags, function(tag) {
            angular.forEach(contents.find(tag), function(subelement) {
                treatFrame(angular.element(subelement), component, componentId);
            });
        });
    }
        function treatExternalContent(element, component, componentId) {
        var elements = element.contents().find('img');
        angular.forEach(elements, function(el) {
            var url = el.src,
                siteId = $mmSite.getId();
            if (!url || !$mmUtil.isDownloadableUrl(url) || (!$mmSite.canDownloadFiles() && $mmUtil.isPluginFileUrl(url))) {
                return;
            }
            return $mmFilepool.getSrcByUrl(siteId, url, component, componentId).then(function(finalUrl) {
                el.setAttribute('src', finalUrl);
            });
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/richtexteditor.html',
        scope: {
            model: '=',
            property: '@?',
            placeholder: '@?',
            options: '=?',
            tabletOptions: '=?',
            phoneOptions: '=?',
            scrollHandle: '@?',
            name: '@?',
            textChange: '&?',
            firstRender: '&?',
            component: '@?',
            componentId: '@?',
            required: '@?'
        },
        link: function(scope, element) {
            element = element[0];
            var defaultOptions = {
                    allowedContent: true,
                    defaultLanguage: 'en',
                    height: editorInitialHeightDefault,
                    adjustHeight: adjustHeightDefault,
                    toolbarCanCollapse: true,
                    toolbarStartupExpanded: false,
                    toolbar: [
                        {name: 'basicstyles', items: ['Bold', 'Italic']},
                        {name: 'styles', items: ['Format']},
                        {name: 'links', items: ['Link', 'Unlink']},
                        {name: 'lists', items: ['NumberedList', 'BulletedList']},
                        '/',
                        {name: 'document', items: ['Source', 'RemoveFormat']},
                        {name: 'tools', items: [ 'Maximize' ]}
                    ],
                    toolbarLocation: 'bottom',
                    removePlugins: 'elementspath,resize,pastetext,pastefromword,clipboard,image',
                    removeButtons: ''
                },
                scrollView,
                resized = false,
                fixedBarsHeight,
                component = scope.component,
                componentId = scope.componentId,
                firstChange = true,
                renderTime,
                editorInitialHeight = editorInitialHeightDefault,
                adjustHeight = adjustHeightDefault;
            scope.property = typeof scope.property == 'string' ? scope.property : 'text';
            if (scope.scrollHandle) {
                scrollView = $ionicScrollDelegate.$getByHandle(scope.scrollHandle);
            }
            $mmUtil.isRichTextEditorEnabled().then(function(enabled) {
                var promise;
                scope.richTextEditor = !!enabled;
                renderTime = new Date().getTime();
                if (enabled) {
                    promise = $mmLang.getCurrentLanguage().then(function(lang) {
                        defaultOptions.language = changeLanguageCode(lang);
                    });
                } else {
                    promise = $q.when();
                }
                promise.then(function() {
                    if ($ionicPlatform.isTablet()) {
                        scope.editorOptions = angular.extend(defaultOptions, scope.options, scope.tabletOptions);
                    } else {
                        scope.editorOptions = angular.extend(defaultOptions, scope.options, scope.phoneOptions);
                    }
                    editorInitialHeight = scope.editorOptions.height;
                    adjustHeight = scope.editorOptions.adjustHeight;
                    if (!enabled) {
                        textareaReady();
                    }
                });
            });
            function textareaReady() {
                var editorEl;
                $timeout(function() {
                    if (firstChange) {
                        firstChange = false;
                        editorEl = element.querySelector('.mm-textarea');
                        resizeContentTextarea(editorEl);
                        ionic.on('resize', onResize, window);
                    }
                }, 1000);
                scope.$on('$destroy', function() {
                    ionic.off('resize', onResize, window);
                });
                function onResize() {
                    resizeContentTextarea(editorEl);
                }
            }
            scope.editorReady = function() {
                var collapser = element.querySelector('.cke_toolbox_collapser'),
                    firstButton = element.querySelector('.cke_toolbox_main .cke_toolbar:first-child'),
                    lastButton = element.querySelector('.cke_toolbox_main .cke_toolbar:last-child'),
                    toolbar = element.querySelector('.cke_bottom'),
                    editorEl = element.querySelector('.cke'),
                    contentsEl = element.querySelector('.cke_contents'),
                    sourceCodeButton = element.querySelector('.cke_button__source'),
                    seeingSourceCode = false,
                    wysiwygIframe,
                    unregisterDialogListener,
                    editorController;
                searchAndFormatWysiwyg(element, component, componentId).then(function(iframe) {
                    wysiwygIframe = iframe;
                });
                if (firstButton && lastButton && collapser && toolbar) {
                    if (firstButton.offsetTop == lastButton.offsetTop) {
                        angular.element(collapser).css('display', 'none');
                    }
                    angular.element(collapser).on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        angular.element(toolbar).toggleClass('cke_expanded');
                        if (resized) {
                            resizeContent(editorEl, contentsEl, toolbar);
                        }
                    });
                }
                if (sourceCodeButton) {
                    angular.element(sourceCodeButton).on('click', function() {
                        $timeout(function() {
                            seeingSourceCode = !seeingSourceCode;
                            if (!seeingSourceCode) {
                                searchAndFormatWysiwyg(element, component, componentId).then(function(iframe) {
                                    wysiwygIframe = iframe;
                                });
                            }
                        });
                    });
                }
                if (scope.richTextEditor) {
                    $timeout(function() {
                        if (firstChange) {
                            if (scope.firstRender) {
                                scope.firstRender();
                            }
                            firstChange = false;
                            resizeContent(editorEl, contentsEl, toolbar);
                        }
                    }, 1000);
                }
                editorController = getCKEditorController(element);
                ionic.on('resize', onResize, window);
                scope.$on('$destroy', function() {
                    if (editorController && editorController.instance) {
                        editorController.instance.destroy(false);
                    }
                    ionic.off('resize', onResize, window);
                    if (unregisterDialogListener) {
                        unregisterDialogListener();
                    }
                });
                function onResize() {
                    resizeContent(editorEl, contentsEl, toolbar);
                    if (firstButton.offsetTop == lastButton.offsetTop) {
                        angular.element(collapser).css('display', 'none');
                    } else {
                        angular.element(collapser).css('display', 'block');
                    }
                }
            };
            scope.onChange = function() {
                if (scope.richTextEditor && firstChange && scope.firstRender && new Date().getTime() - renderTime < 1000) {
                    scope.firstRender();
                }
                firstChange = false;
                if (scope.textChange) {
                    scope.textChange();
                }
            };
                        function resizeContentTextarea(editorEl) {
                var editorHeight = editorInitialHeight,
                    contentVisibleHeight,
                    screenSmallerThanEditor;
                if (typeof fixedBarsHeight == 'undefined') {
                    fixedBarsHeight = calculateFixedBarsHeight(editorEl);
                }
                contentVisibleHeight = $window.innerHeight - fixedBarsHeight;
                if (adjustHeight && contentVisibleHeight > 0) {
                    var topElement,
                        height;
                    if (adjustHeight !== true) {
                        topElement = document.getElementById(adjustHeight);
                        contentVisibleHeight = $mmUtil.getElementHeight(topElement) || contentVisibleHeight;
                    }
                    height = getSurroundingHeight(element, topElement);
                    if (contentVisibleHeight > height) {
                        editorHeight = contentVisibleHeight - height;
                        editorInitialHeight = editorHeight;
                    }
                }
                screenSmallerThanEditor = contentVisibleHeight > 0 && contentVisibleHeight < editorHeight;
                if (resized && !screenSmallerThanEditor) {
                    undoResize(editorEl);
                } else if (editorHeight > 60 && (resized || screenSmallerThanEditor || adjustHeight)) {
                    angular.element(editorEl).css('height', editorHeight + 'px');
                    resized = true;
                }
            }
                        function resizeContent(editorEl, contentsEl, toolbar) {
                var toolbarHeight = $mmUtil.getElementHeight(toolbar),
                    editorWithToolbarHeight = editorInitialHeight + toolbarHeight,
                    contentVisibleHeight,
                    editorContentNewHeight,
                    screenSmallerThanEditor,
                    editorMaximized;
                if (typeof fixedBarsHeight == 'undefined') {
                    fixedBarsHeight = calculateFixedBarsHeight(editorEl);
                }
                editorMaximized = !!editorEl.querySelector('.cke_maximized');
                contentVisibleHeight = $window.innerHeight - fixedBarsHeight;
                if (adjustHeight && !editorMaximized && contentVisibleHeight > 0) {
                    var topElement,
                        height;
                    if (adjustHeight !== true) {
                        topElement = document.getElementById(adjustHeight);
                        contentVisibleHeight = $mmUtil.getElementHeight(topElement) || contentVisibleHeight;
                    }
                    height = getSurroundingHeight(element, topElement);
                    if (contentVisibleHeight > height) {
                        editorWithToolbarHeight = contentVisibleHeight - height;
                        editorInitialHeight = editorWithToolbarHeight - toolbarHeight;
                    }
                }
                screenSmallerThanEditor = !editorMaximized && contentVisibleHeight > 0 &&
                    contentVisibleHeight < editorWithToolbarHeight;
                editorContentNewHeight = editorWithToolbarHeight - toolbarHeight;
                if (resized && !screenSmallerThanEditor) {
                    undoResize(editorEl, contentsEl);
                } else if (editorContentNewHeight > 60 && (resized || screenSmallerThanEditor || adjustHeight)) {
                    angular.element(editorEl).css('height', editorWithToolbarHeight + 'px');
                    angular.element(contentsEl).css('height', editorContentNewHeight + 'px');
                    resized = true;
                    if (scrollView) {
                        var focused = document.activeElement;
                        if (focused) {
                            var parentEditor = $mmUtil.closest(focused, '.cke');
                            if (parentEditor == editorEl) {
                                $mmUtil.scrollToElement(editorEl, undefined, scrollView);
                            }
                        }
                    }
                }
            }
            function undoResize(editorEl, contentsEl) {
                if (contentsEl) {
                    angular.element(editorEl).css('height', '');
                    angular.element(contentsEl).css('height', editorInitialHeight + 'px');
                } else {
                    angular.element(editorEl).css('height', editorInitialHeight + 'px');
                }
                resized = false;
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSearchbox', ["$translate", "$mmUtil", function($translate, $mmUtil) {
    return {
        restrict: 'E',
        scope: {
            submitAction: '=',
            initialValue: '@?',
            searchLabel: '@?',
            placeholder: '@?',
            autocorrect: '@?',
            spellcheck: '@?',
            autofocus: '@?',
            lengthCheck: '@?'
        },
        templateUrl: 'core/templates/searchbox.html',
        link: function(scope, element) {
            scope.data = {
                value : scope.initialValue ? scope.initialValue : "",
                placeholder: scope.placeholder ? scope.placeholder : $translate.instant('mm.core.search'),
                autocorrect: scope.autocorrect ? scope.autocorrect : 'on',
                spellcheck: scope.spellcheck ? scope.spellcheck : 'true',
                searchLabel: scope.searchLabel ? scope.searchLabel : $translate.instant('mm.core.search'),
                autofocus: scope.autofocus && scope.autofocus != "false",
                lengthCheck: scope.lengthCheck ? scope.lengthCheck : 3
            };
            scope.seachBoxSubmit = function() {
                if (scope.data.value.length < scope.data.lengthCheck) {
                    return;
                }
                return scope.submitAction(scope.data.value);
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmShowPassword', ["$compile", function($compile) {
    var buttonHtml = '<a class="button button-clear button-positive icon" aria-label="{{ label | translate }}" ' +
                        'ng-class="{\'ion-eye\': !shown, \'ion-eye-disabled\': shown}" ng-click="toggle()" ' +
                        'mm-keep-keyboard="{{selector}}" keep-in-button="true"></a>';
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            var button;
            if (element[0].id) {
                scope.selector = '#' + element[0].id;
            } else if (element[0].name) {
                scope.selector = element[0].tagName.toLowerCase() + '[name="' + elm[0].name + '"]';
            } else {
                scope.selector = '';
            }
            button = $compile(angular.element(buttonHtml))(scope);
            element.wrap('<div class="item-input-inset mm-show-password-container">');
            element.after(button);
            if (!element.attr('autocorrect')) {
                element.attr('autocorrect', 'off');
            }
            if (!element.attr('autocapitalize')) {
                element.attr('autocapitalize', 'none');
            }
            scope.shown = attrs.initialShown && attrs.initialShown !== 'false';
            setData();
            scope.toggle = function() {
                scope.shown = !scope.shown;
                setData();
            };
            function setData() {
                scope.label = scope.shown ? 'mm.core.hide' : 'mm.core.show';
                element[0].type = scope.shown ? 'text' : 'password';
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSitePicker', ["$mmSitesManager", "$mmSite", "$translate", "$mmText", "$q", function($mmSitesManager, $mmSite, $translate, $mmText, $q) {
    return {
        restrict: 'E',
        templateUrl: 'core/templates/sitepicker.html',
        scope: {
            siteSelected: '&',
            initialSite: '@?'
        },
        link: function(scope) {
            scope.selectedSite = scope.initialSite || $mmSite.getId();
            $mmSitesManager.getSites().then(function(sites) {
                var promises = [];
                sites.forEach(function(site) {
                    promises.push($mmText.formatText(site.sitename, true, true).catch(function() {
                        return site.sitename;
                    }).then(function(formatted) {
                        site.fullnameandsitename = $translate.instant('mm.core.fullnameandsitename',
                                {fullname: site.fullname, sitename: formatted});
                    }));
                });
                return $q.all(promises).then(function() {
                    scope.sites = sites;
                });
            });
        }
    };
}]);

angular.module('mm.core')
.constant('mmCoreSplitViewLoad', 'mmSplitView:load')
.constant('mmCoreSplitViewBlock', 'mmSplitView:block')
.controller('mmSplitView', ["$state", "$ionicPlatform", "$timeout", "$interpolate", function($state, $ionicPlatform, $timeout, $interpolate) {
    var self = this,
        element,
        menuState,
        linkToLoad,
        candidateLink,
        component,
        ionicViewEventData,
        viewEventListeners = [],
        headerBarButtons = {},
        headerButtonTypes = ['primary-buttons', 'secondary-buttons', 'left-buttons', 'right-buttons'],
        startTime = new Date().getTime();
        this.clearMarkedLinks = function() {
        angular.element(element.querySelectorAll('[mm-split-view-link]')).removeClass('mm-split-item-selected');
    };
        this.getCandidateLink = function() {
        return candidateLink;
    };
        this.getComponent = function() {
        return component;
    };
        this.getHeaderBarButtons = function(type) {
        if (!type) {
            return headerBarButtons;
        } else {
            return headerBarButtons[type];
        }
    };
        this.getHeaderBarButtonsHtml = function(type) {
        if (headerBarButtons[type]) {
            return headerBarButtons[type].innerHTML;
        }
    };
        this.getHeaderBarWithState = function(state) {
        var bars = document.querySelectorAll('ion-header-bar');
        for (var i = 0; i < bars.length; i++) {
            var bar = bars[i],
                barState = bar.parentElement && bar.parentElement.getAttribute('nav-bar');
            if (barState == state) {
                return bar;
            }
        }
    };
        this.getIonicViewEventData = function() {
        return ionicViewEventData || {};
    };
        this.getMenuState = function() {
        return menuState || $state.current.name;
    };
        this.getInactiveHeaderBar = function() {
        var bars = document.querySelectorAll('ion-header-bar'),
            activePosition = -1;
        for (var i = 0; i < bars.length; i++) {
            var bar = bars[i],
                barState = bar.parentElement && bar.parentElement.getAttribute('nav-bar');
            if (barState == 'active') {
                activePosition = i;
            }
        }
        if (activePosition === 0) {
            return bars[1];
        } else if (activePosition > 0) {
            return bars[0];
        }
    };
        this.getStartTime = function() {
        return startTime;
    };
        this.loadLink = function(scope, loadAttr, retrying) {
        if ($ionicPlatform.isTablet()) {
            if (!linkToLoad) {
                if (typeof loadAttr != 'undefined') {
                    var position = parseInt(loadAttr);
                    if (!position) {
                        position = parseInt($interpolate(loadAttr)(scope), 10);
                    }
                    if (position) {
                        var links = element.querySelectorAll('[mm-split-view-link]');
                        position = position > links.length ? 0 : position - 1;
                        linkToLoad = angular.element(links[position]);
                    } else {
                        linkToLoad = angular.element(element.querySelector('[mm-split-view-link]'));
                    }
                } else {
                    linkToLoad = angular.element(element.querySelector('[mm-split-view-link]'));
                }
            }
            if (!this.triggerClick(linkToLoad)) {
                if (!retrying) {
                    linkToLoad = undefined;
                    $timeout(function() {
                        self.loadLink(scope, loadAttr, true);
                    });
                }
            }
        }
    };
        self.onViewEvent = function(callBack) {
        if (!angular.isFunction(callBack)) {
            return;
        }
        viewEventListeners.push(callBack);
        return function() {
          var position = viewEventListeners.indexOf(callBack);
          if (position !== -1) {
            viewEventListeners.splice(position, 1);
          }
        };
    };
        self.saveHeaderBarButtons = function() {
        var headerBar = this.getHeaderBarWithState('entering');
        if (!headerBar) {
            headerBar = this.getInactiveHeaderBar();
            if (!headerBar) {
                return;
            }
        }
        headerButtonTypes.forEach(function(type) {
            headerBarButtons[type] = headerBar.querySelector('.' + type);
        });
    };
        this.setCandidateLink = function(link) {
        candidateLink = link;
    };
        this.setComponent = function(cmp) {
        component = cmp;
    };
        this.setElement = function(el) {
        element = el;
    };
        this.setLink = function(link) {
        linkToLoad = link;
        this.setCandidateLink(null);
    };
        this.setMenuState = function(state) {
        menuState = state;
    };
        this.setIonicViewEventData = function(data) {
        ionicViewEventData = data;
        angular.forEach(viewEventListeners, function(listener) {
            if (angular.isFunction(listener)) {
                listener(data);
            }
        });
    };
        this.triggerClick = function(link) {
        if (link && link.length && link.triggerHandler) {
            link.triggerHandler('click');
            return true;
        }
        return false;
    };
}])
.directive('mmSplitView', ["$log", "$state", "$ionicPlatform", "$mmUtil", "mmCoreSplitViewLoad", "mmCoreSplitViewBlock", function($log, $state, $ionicPlatform, $mmUtil, mmCoreSplitViewLoad, mmCoreSplitViewBlock) {
    $log = $log.getInstance('mmSplitView');
    return {
        restrict: 'E',
        templateUrl: 'core/templates/splitview.html',
        transclude: true,
        controller: 'mmSplitView',
        link: function(scope, element, attrs, controller) {
            var el = element[0],
                menu = angular.element(el.querySelector('.mm-split-pane-menu')),
                menuState = attrs.menuState || $state.$current.name,
                menuParams = $state.params,
                menuWidth = attrs.menuWidth,
                component = attrs.component || 'tablet',
                stateChangeListener,
                currentBlockFunction,
                leaving = false;
            controller.saveHeaderBarButtons();
            scope.component = component;
            controller.setComponent(component);
            controller.setElement(el);
            controller.setMenuState(menuState);
            if (menuWidth && $ionicPlatform.isTablet()) {
                menu.css('width', menuWidth);
                menu.css('-webkit-flex-basis', menuWidth);
                menu.css('-moz-flex-basis', menuWidth);
                menu.css('-ms-flex-basis', menuWidth);
                menu.css('flex-basis', menuWidth);
            }
            if (attrs.loadWhen) {
                scope.$watch(attrs.loadWhen, function(newValue) {
                    if (newValue) {
                        controller.loadLink(scope, attrs.load);
                    }
                });
            } else {
                controller.loadLink(scope, attrs.load);
            }
            scope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams) {
                if (toState.name === menuState && $mmUtil.basicLeftCompare(toParams, menuParams, 1)) {
                    controller.loadLink();
                }
            });
            scope.$on(mmCoreSplitViewLoad, function(e, data) {
                if (data && data.load) {
                    controller.loadLink(scope, data.load);
                } else {
                    controller.loadLink(scope, attrs.load);
                }
            });
            scope.$on('$ionicView.beforeEnter', eventReceived);
            scope.$on('$ionicView.afterEnter', eventReceived);
            scope.$on(mmCoreSplitViewBlock, blockEventReceived);
            function eventReceived(e, data) {
                if (controller.getIonicViewEventData().transitionId != data.transitionId) {
                    controller.setIonicViewEventData(data);
                }
            }
            function blockEventReceived(e, data) {
                if (!data || data.state != menuState || !$mmUtil.basicLeftCompare(data.stateParams, menuParams, 1)) {
                    return;
                }
                if (data.block && data.blockFunction) {
                    stateChangeListener && stateChangeListener();
                    stateChangeListener = scope.$on('$stateChangeStart', function(event, toState, toParams) {
                        event.preventDefault();
                        if (leaving) {
                            return;
                        }
                        leaving = true;
                        data.blockFunction().then(function() {
                            var candidateLink = controller.getCandidateLink();
                            stateChangeListener && stateChangeListener();
                            if (!controller.triggerClick(candidateLink)) {
                                return $state.go(toState.name, toParams);
                            }
                        }).finally(function() {
                            leaving = false;
                            controller.setCandidateLink(null);
                        });
                    });
                } else if (!data.block && currentBlockFunction && currentBlockFunction === data.blockFunction) {
                    stateChangeListener && stateChangeListener();
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSplitViewLink', ["$log", "$ionicPlatform", "$state", "$mmApp", function($log, $ionicPlatform, $state, $mmApp) {
    $log = $log.getInstance('mmSplitViewLink');
    var srefRegex = new RegExp(/([^\(]*)(\((.*)\))?$/);
        function createTabletState(stateName, tabletStateName, newViewName) {
        var targetState = $state.get(stateName),
            newConfig,
            viewName;
        if (targetState) {
            newConfig = angular.copy(targetState);
            viewName = Object.keys(newConfig.views)[0];
            newConfig.views[newViewName] = newConfig.views[viewName];
            delete newConfig.views[viewName];
            delete newConfig['name'];
            $mmApp.createState(tabletStateName, newConfig);
            return true;
        } else {
            $log.error('State doesn\'t exist: '+stateName);
            return false;
        }
    }
        function scopeEval(scope, value) {
        if (typeof value == 'string') {
            try {
                return scope.$eval(value);
            } catch(ex) {
                $log.error('Error evaluating string: ' + param);
            }
        }
    }
        function fillStateParams(stateParams, state) {
        if (!stateParams || !state || !state.params) {
            return;
        }
        angular.forEach(state.params, function(defaultValue, name) {
            if (typeof stateParams[name] == 'undefined') {
                stateParams[name] = defaultValue;
            }
        });
    }
    return {
        restrict: 'A',
        require: '^mmSplitView',
        link: function(scope, element, attrs, splitViewController) {
            var sref = attrs.mmSplitViewLink,
                menuState = splitViewController.getMenuState(),
                matches,
                stateName,
                stateParams,
                stateParamsString,
                tabletStateName,
                stateParamsFilled = false;
            if (sref) {
                matches = sref.match(srefRegex);
                if (matches && matches.length) {
                    stateName = matches[1];
                    tabletStateName = menuState + '.' + stateName.substr(stateName.lastIndexOf('.') + 1);
                    stateParamsString = matches[3];
                    stateParams = scopeEval(scope, stateParamsString);
                    scope.$watch(stateParamsString, function(newVal) {
                        stateParams = newVal;
                        fillStateParams(stateParams, $state.get(tabletStateName));
                    });
                    element.on('click', function(event) {
                        event.stopPropagation();
                        event.preventDefault();
                        if ($ionicPlatform.isTablet()) {
                            if (!$state.get(tabletStateName)) {
                                if (!createTabletState(stateName, tabletStateName, splitViewController.getComponent())) {
                                    return;
                                }
                            }
                            if (!stateParamsFilled) {
                                fillStateParams(stateParams, $state.get(tabletStateName));
                                stateParamsFilled = true;
                            }
                            splitViewController.setCandidateLink(element);
                            $state.go(tabletStateName, stateParams, {location:'replace'}).then(function() {
                                splitViewController.setLink(element);
                                splitViewController.clearMarkedLinks();
                                element.addClass('mm-split-item-selected');
                            });
                        } else {
                            $state.go(stateName, stateParams);
                        }
                    });
                } else {
                    $log.error('Invalid sref.');
                }
            } else {
                $log.error('Invalid sref.');
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmStateClass', ["$state", function($state) {
    return {
        restrict: 'A',
        link: function(scope, el) {
            var current = $state.$current.name,
                split,
                className = 'mm-';
            if (typeof current == 'string') {
                split = current.split('.');
                className += split.shift();
                if (split.length) {
                    className += '_' + split.pop();
                }
                el.addClass(className);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmTimer', ["$interval", "$mmUtil", function($interval, $mmUtil) {
    return {
        restrict: 'E',
        scope: {
            endTime: '=',
            finished: '&'
        },
        templateUrl: 'core/templates/timer.html',
        link: function(scope, element, attrs) {
            if (!scope.endTime || !scope.finished) {
                return;
            }
            var timeLeftClass = attrs.timeLeftClass || 'mm-timer-timeleft-',
                timeInterval;
            element.addClass('mm-timer');
            scope.text = attrs.timerText || '';
            timeInterval = $interval(function() {
                scope.timeLeft = scope.endTime - $mmUtil.timestamp();
                if (scope.timeLeft < 0) {
                    $interval.cancel(timeInterval);
                    scope.finished();
                    return;
                }
                if (scope.timeLeft < 100 && !element.hasClass(timeLeftClass + scope.timeLeft)) {
                    element.removeClass(timeLeftClass + (scope.timeLeft + 1));
                    element.removeClass(timeLeftClass + (scope.timeLeft + 2));
                    element.addClass(timeLeftClass + scope.timeLeft);
                }
            }, 200);
            scope.$on('$destroy', function() {
                if (timeInterval) {
                    $interval.cancel(timeInterval);
                }
            });
        }
    };
}]);

angular.module('mm.core.comments', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_commentviewer', {
        url: '/mm_commentviewer',
        params : {
            contextLevel: null,
            instanceId: null,
            component: null,
            itemId: null,
            area: null,
            page: null,
            title: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/comments/templates/commentviewer.html',
                controller: 'mmCommentViewerCtrl'
            }
        }
    });
}]);

angular.module('mm.core.contentlinks', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('mm_contentlinks', {
        url: '/mm_contentlinks',
        abstract: true,
        templateUrl: 'core/components/contentlinks/templates/base.html',
        cache: false,  
    })
    .state('mm_contentlinks.choosesite', {
        url: '/choosesite',
        templateUrl: 'core/components/contentlinks/templates/choosesite.html',
        controller: 'mmContentLinksChooseSiteCtrl',
        params: {
            url: null
        }
    });
}])
.run(["$log", "$mmURLDelegate", "$mmContentLinksHelper", function($log, $mmURLDelegate, $mmContentLinksHelper) {
    $log = $log.getInstance('mmContentLinks');
    $mmURLDelegate.register('mmContentLinks', $mmContentLinksHelper.handleCustomUrl);
}]);

angular.module('mm.core.course', ['mm.core.courses'])
.constant('mmCoreCoursePriority', 800)
.constant('mmCoreCourseAllSectionsId', -1)
.config(["$stateProvider", "$mmCoursesDelegateProvider", "mmCoreCoursePriority", function($stateProvider, $mmCoursesDelegateProvider, mmCoreCoursePriority) {
    $stateProvider
    .state('site.mm_course', {
        url: '/mm_course',
        params: {
            courseid: null,
            sid: null,
            moduleid: null,
            coursefullname: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/course/templates/sections.html',
                controller: 'mmCourseSectionsCtrl'
            }
        }
    })
    .state('site.mm_course-section', {
        url: '/mm_course-section',
        params: {
            sectionid: null,
            cid: null,
            mid: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/course/templates/section.html',
                controller: 'mmCourseSectionCtrl'
            }
        }
    })
    .state('site.mm_course-modcontent', {
        url: '/mm_course-modcontent',
        params: {
            module: null
        },
        views: {
            site: {
                templateUrl: 'core/components/course/templates/modcontent.html',
                controller: 'mmCourseModContentCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmCourseDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmCourseDelegate, mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCourseDelegate.updateContentHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCourseDelegate.updateContentHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCourseDelegate.updateContentHandlers);
}]);

angular.module('mm.core.courses', ['mm.core.contentlinks'])
.constant('mmCoursesSearchComponent', 'mmCoursesSearch')
.constant('mmCoursesSearchPerPage', 20)
.constant('mmCoursesEnrolInvalidKey', 'mmCoursesEnrolInvalidKey')
.constant('mmCoursesEventMyCoursesUpdated', 'my_courses_updated')
.constant('mmCoursesEventMyCoursesRefreshed', 'my_courses_refreshed')
.constant('mmCoursesAccessMethods', {
     guest: 'guest',
     default: 'default'
})
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_courses', {
        url: '/mm_courses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/list.html',
                controller: 'mmCoursesListCtrl'
            }
        }
    })
    .state('site.mm_searchcourses', {
        url: '/mm_searchcourses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/search.html',
                controller: 'mmCoursesSearchCtrl'
            }
        }
    })
    .state('site.mm_viewresult', {
        url: '/mm_viewresult',
        params: {
            course: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/viewresult.html',
                controller: 'mmCoursesViewResultCtrl'
            }
        }
    })
    .state('site.mm_coursescategories', {
        url: '/mm_coursescategories',
        params: {
            categoryid: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/coursecategories.html',
                controller: 'mmCourseCategoriesCtrl'
            }
        }
    })
    .state('site.mm_availablecourses', {
        url: '/mm_availablecourses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/availablecourses.html',
                controller: 'mmCoursesAvailableCtrl'
            }
        }
    });
}])
.config(["$mmContentLinksDelegateProvider", function($mmContentLinksDelegateProvider) {
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:courses', '$mmCoursesHandlers.coursesLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:course', '$mmCoursesHandlers.courseLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:dashboard', '$mmCoursesHandlers.dashboardLinksHandler');
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmCoursesDelegate", "$mmCourses", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmCoursesDelegate, $mmCourses,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmCoursesDelegate.clearCoursesHandlers();
        $mmCourses.clearCurrentCourses();
    });
}]);

angular.module('mm.core.fileuploader', ['mm.core'])
.constant('mmFileUploaderAlbumPriority', 2000)
.constant('mmFileUploaderCameraPriority', 1800)
.constant('mmFileUploaderAudioPriority', 1600)
.constant('mmFileUploaderVideoPriority', 1400)
.constant('mmFileUploaderFilePriority', 1200)
.config(["$mmFileUploaderDelegateProvider", "mmFileUploaderAlbumPriority", "mmFileUploaderCameraPriority", "mmFileUploaderAudioPriority", "mmFileUploaderVideoPriority", "mmFileUploaderFilePriority", function($mmFileUploaderDelegateProvider, mmFileUploaderAlbumPriority, mmFileUploaderCameraPriority,
            mmFileUploaderAudioPriority, mmFileUploaderVideoPriority, mmFileUploaderFilePriority) {
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderAlbum',
                '$mmFileUploaderHandlers.albumFilePicker', mmFileUploaderAlbumPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderCamera',
                '$mmFileUploaderHandlers.cameraFilePicker', mmFileUploaderCameraPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderAudio',
                '$mmFileUploaderHandlers.audioFilePicker', mmFileUploaderAudioPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderVideo',
                '$mmFileUploaderHandlers.videoFilePicker', mmFileUploaderVideoPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderFile',
                '$mmFileUploaderHandlers.filePicker', mmFileUploaderFilePriority);
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmFileUploaderDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmFileUploaderDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmFileUploaderDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.grades', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.grades', {
        url: '/grades',
        views: {
            'site': {
                templateUrl: 'core/components/grades/templates/table.html',
                controller: 'mmGradesTableCtrl'
            }
        },
        params: {
            course: null,
            userid: null,
            courseid: null,
            forcephoneview: null
        }
    })
    .state('site.grade', {
        url: '/grade',
        views: {
            'site': {
                templateUrl: 'core/components/grades/templates/grade.html',
                controller: 'mmGradesGradeCtrl'
            }
        },
        params: {
            courseid: null,
            userid: null,
            gradeid: null
        }
    });
}]);

angular.module('mm.core.login', [])
.constant('mmCoreLoginTokenChangePassword', '*changepassword*')
.config(["$stateProvider", "$urlRouterProvider", "$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($stateProvider, $urlRouterProvider, $mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    $stateProvider
    .state('mm_login', {
        url: '/mm_login',
        abstract: true,
        templateUrl: 'core/components/login/templates/base.html',
        cache: false,  
        onEnter: ["$ionicHistory", function($ionicHistory) {
            $ionicHistory.clearHistory();
        }]
    })
    .state('mm_login.init', {
        url: '/init',
        templateUrl: 'core/components/login/templates/init.html',
        controller: 'mmLoginInitCtrl',
        cache: false
    })
    .state('mm_login.sites', {
        url: '/sites',
        templateUrl: 'core/components/login/templates/sites.html',
        controller: 'mmLoginSitesCtrl',
        onEnter: ["$mmLoginHelper", "$mmSitesManager", function($mmLoginHelper, $mmSitesManager) {
            $mmSitesManager.hasNoSites().then(function() {
                $mmLoginHelper.goToAddSite();
            });
        }]
    })
    .state('mm_login.site', {
        url: '/site',
        templateUrl: 'core/components/login/templates/site.html',
        controller: 'mmLoginSiteCtrl'
    })
    .state('mm_login.credentials', {
        url: '/cred',
        templateUrl: 'core/components/login/templates/credentials.html',
        controller: 'mmLoginCredentialsCtrl',
        params: {
            siteurl: '',
            username: '',
            urltoopen: '',
            siteconfig: null
        },
        onEnter: ["$state", "$stateParams", function($state, $stateParams) {
            if (!$stateParams.siteurl) {
              $state.go('mm_login.init');
            }
        }]
    })
    .state('mm_login.reconnect', {
        url: '/reconnect',
        templateUrl: 'core/components/login/templates/reconnect.html',
        controller: 'mmLoginReconnectCtrl',
        cache: false,
        params: {
            siteurl: '',
            username: '',
            infositeurl: '',
            siteid: '',
            statename: null,
            stateparams: null
        }
    })
    .state('mm_login.email_signup', {
        url: '/email_signup',
        templateUrl: 'core/components/login/templates/emailsignup.html',
        controller: 'mmLoginEmailSignupCtrl',
        cache: false,
        params: {
            siteurl: ''
        }
    })
    .state('mm_login.sitepolicy', {
        url: '/sitepolicy',
        templateUrl: 'core/components/login/templates/sitepolicy.html',
        controller: 'mmLoginSitePolicyCtrl',
        cache: false,
        params: {
            siteid: ''
        }
    });
    $urlRouterProvider.otherwise(function($injector) {
        var $state = $injector.get('$state');
        return $state.href('mm_login.init').replace('#', '');
    });
    $mmInitDelegateProvider.registerProcess('mmLogin', '$mmSitesManager.restoreSession', mmInitDelegateMaxAddonPriority + 200);
}])
.run(["$log", "$state", "$mmUtil", "$translate", "$mmSitesManager", "$rootScope", "$mmSite", "$mmURLDelegate", "$ionicHistory", "$timeout", "$mmEvents", "$mmLoginHelper", "mmCoreEventSessionExpired", "$mmApp", "$ionicPlatform", "mmCoreConfigConstants", "$mmText", "mmCoreEventPasswordChangeForced", "mmCoreEventUserNotFullySetup", "mmCoreEventSitePolicyNotAgreed", "$q", function($log, $state, $mmUtil, $translate, $mmSitesManager, $rootScope, $mmSite, $mmURLDelegate, $ionicHistory, $timeout,
                $mmEvents, $mmLoginHelper, mmCoreEventSessionExpired, $mmApp, $ionicPlatform, mmCoreConfigConstants, $mmText,
                mmCoreEventPasswordChangeForced, mmCoreEventUserNotFullySetup, mmCoreEventSitePolicyNotAgreed, $q) {
    $log = $log.getInstance('mmLogin');
    var isSSOConfirmShown = false,
        isOpenEditAlertShown = false,
        waitingForBrowser = false,
        lastInAppUrl;
    $mmEvents.on(mmCoreEventSessionExpired, sessionExpired);
    $mmEvents.on(mmCoreEventPasswordChangeForced, function(siteId) {
        openInAppForEdit(siteId, '/login/change_password.php', 'mm.core.forcepasswordchangenotice');
    });
    $mmEvents.on(mmCoreEventUserNotFullySetup, function(siteId) {
        openInAppForEdit(siteId, '/user/edit.php', 'mm.core.usernotfullysetup');
    });
    $mmEvents.on(mmCoreEventSitePolicyNotAgreed, function(siteId) {
        siteId = siteId || $mmSite.getId();
        if (!siteId || siteId != $mmSite.getId()) {
            return;
        }
        if (!$mmSite.wsAvailable('core_user_agree_site_policy')) {
            return;
        }
        $ionicHistory.nextViewOptions({disableBack: true});
        $state.go('mm_login.sitepolicy', {
            siteid: siteId
        });
    });
    $mmURLDelegate.register('mmLoginSSO', appLaunchedByURL);
    $rootScope.$on('$cordovaInAppBrowser:loadstart', function(e, event) {
        var url = event.url.replace(/^https?:\/\//, '');
        if (appLaunchedByURL(url)) {
            $mmUtil.closeInAppBrowser();
        } else if (ionic.Platform.isAndroid()) {
            var urlScheme = $mmText.getUrlProtocol(url);
            if (urlScheme && urlScheme !== 'file' && urlScheme !== 'cdvfile') {
                $mmUtil.openInBrowser(url);
                if (lastInAppUrl) {
                    $mmUtil.openInApp(lastInAppUrl);
                } else {
                    $mmUtil.closeInAppBrowser();
                }
            } else {
                lastInAppUrl = event.url;
            }
        }
    });
    $rootScope.$on('$cordovaInAppBrowser:exit', function() {
        waitingForBrowser = false;
        lastInAppUrl = false;
        checkLogout();
    });
    $ionicPlatform.on('resume', function() {
        $timeout(function() {
            waitingForBrowser = false;
            checkLogout();
        }, 1000);
    });
    $rootScope.$on('$stateChangeStart', function(event, toState, toParams, fromState, fromParams) {
        if (!$mmApp.isReady() && toState.name !== 'mm_login.init') {
            event.preventDefault();
            $state.transitionTo('mm_login.init');
            $log.warn('Forbidding state change to \'' + toState.name + '\'. App is not ready yet.');
            return;
        }
        var isLoginStateWithSession = toState.name === 'mm_login.reconnect' || toState.name === 'mm_login.sitepolicy';
        if (toState.name.substr(0, 8) === 'redirect' || toState.name.substr(0, 15) === 'mm_contentlinks') {
            return;
        } else if ((toState.name.substr(0, 8) !== 'mm_login' || isLoginStateWithSession) && !$mmSite.isLoggedIn()) {
            event.preventDefault();
            $log.debug('Redirect to login page, request was: ' + toState.name);
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.transitionTo('mm_login.init');
        } else if (toState.name.substr(0, 8) === 'mm_login' && !isLoginStateWithSession && $mmSite.isLoggedIn()) {
            event.preventDefault();
            $log.debug('Redirect to course page, request was: ' + toState.name);
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $mmLoginHelper.goToSiteInitialPage();
        }
    });
    function sessionExpired(data) {
        var siteId = data && data.siteid,
            siteUrl = $mmSite.getURL(),
            promise;
        if (typeof(siteUrl) === 'undefined') {
            return;
        }
        if (siteId && siteId !== $mmSite.getId()) {
            return;
        }
        $mmSitesManager.checkSite(siteUrl).then(function(result) {
            if (result.warning) {
                $mmUtil.showErrorModal(result.warning, true, 4000);
            }
            if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                if (!$mmApp.isSSOAuthenticationOngoing() && !isSSOConfirmShown && !waitingForBrowser) {
                    isSSOConfirmShown = true;
                    if ($mmLoginHelper.shouldShowSSOConfirm(result.code)) {
                        promise = $mmUtil.showConfirm($translate.instant(
                                'mm.login.' + ($mmSite.isLoggedOut() ? 'loggedoutssodescription' : 'reconnectssodescription')));
                    } else {
                        promise = $q.when();
                    }
                    promise.then(function() {
                        waitingForBrowser = true;
                        $mmLoginHelper.openBrowserForSSOLogin(result.siteurl, result.code, result.service,
                                result.config && result.config.launchurl, data.statename, data.stateparams);
                    }).catch(function() {
                        logout();
                    }).finally(function() {
                        isSSOConfirmShown = false;
                    });
                }
            } else {
                var info = $mmSite.getInfo();
                if (typeof info != 'undefined' && typeof info.username != 'undefined') {
                    $ionicHistory.nextViewOptions({disableBack: true});
                    $state.go('mm_login.reconnect', {
                        siteurl: result.siteurl,
                        username: info.username,
                        infositeurl: info.siteurl,
                        siteid: siteId,
                        statename: data.statename,
                        stateparams: data.stateparams
                    });
                }
            }
        }).catch(function(error) {
            if ($mmSite.isLoggedOut()) {
                $mmUtil.showErrorModalDefault(error, 'mm.core.networkerrormsg', true);
                logout();
            }
        });
    }
    function openInAppForEdit(siteId, path, alertMessage) {
        if (!siteId || siteId !== $mmSite.getId()) {
            return;
        }
        var siteUrl = $mmSite.getURL();
        if (!siteUrl) {
            return;
        }
        if (!isOpenEditAlertShown && !waitingForBrowser) {
            isOpenEditAlertShown = true;
            $mmSite.invalidateWsCache();
            alertMessage = $translate.instant(alertMessage) + '<br>' + $translate.instant('mm.core.redirectingtosite');
            return $mmSite.openInAppWithAutoLogin(siteUrl + path, undefined, alertMessage).then(function() {
                waitingForBrowser = true;
            }).finally(function() {
                isOpenEditAlertShown = false;
            });
        }
    }
    function appLaunchedByURL(url) {
        var ssoScheme = mmCoreConfigConstants.customurlscheme + '://token=';
        if (url.indexOf(ssoScheme) == -1) {
            return false;
        }
        if ($mmApp.isSSOAuthenticationOngoing()) {
            return true;
        }
        $mmApp.startSSOAuthentication();
        $log.debug('App launched by URL');
        var modal = $mmUtil.showModalLoading('mm.login.authenticating', true),
            siteData;
        url = url.replace(ssoScheme, '');
        try {
            url = atob(url);
        } catch(err) {
            $log.error('Error decoding parameter received for login SSO');
            return false;
        }
        $mmApp.ready().then(function() {
            return $mmLoginHelper.validateBrowserSSOLogin(url);
        }).then(function(data) {
            siteData = data;
            return $mmLoginHelper.handleSSOLoginAuthentication(siteData.siteurl, siteData.token, siteData.privateToken);
        }).then(function() {
            if (siteData.statename) {
                $state.go(siteData.statename, siteData.stateparams);
            } else {
                $mmLoginHelper.goToSiteInitialPage();
            }
        }).catch(function(errorMessage) {
            if (typeof errorMessage === 'string' && errorMessage !== '') {
                $mmUtil.showErrorModal(errorMessage);
            }
        }).finally(function() {
            modal.dismiss();
            $mmApp.finishSSOAuthentication();
        });
        return true;
    }
    function checkLogout() {
        if (!$mmApp.isSSOAuthenticationOngoing() && $mmSite.isLoggedIn() && $mmSite.isLoggedOut() &&
                $state.current.name != 'mm_login.reconnect') {
            logout();
        }
    }
    function logout() {
        $mmSitesManager.logout().then(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
}]);

angular.module('mm.core.question', [])
.constant('mmQuestionComponent', 'mmQuestion')
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmQuestionDelegate", "$mmQuestionBehaviourDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmQuestionDelegate, $mmQuestionBehaviourDelegate,
			mmCoreEventRemoteAddonsLoaded) {
	function updateHandlers() {
		$mmQuestionDelegate.updateQuestionHandlers();
		$mmQuestionBehaviourDelegate.updateQuestionBehaviourHandlers();
	}
	$mmEvents.on(mmCoreEventLogin, updateHandlers);
	$mmEvents.on(mmCoreEventSiteUpdated, updateHandlers);
	$mmEvents.on(mmCoreEventRemoteAddonsLoaded, updateHandlers);
}]);

angular.module('mm.core.settings', [])
.constant('mmCoreSettingsReportInBackground', 'mmCoreReportInBackground')
.constant('mmCoreSettingsRichTextEditor', 'mmCoreSettingsRichTextEditor')
.constant('mmCoreSettingsSyncOnlyOnWifi', 'mmCoreSyncOnlyOnWifi')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_settings', {
        url: '/mm_settings',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/list.html',
                controller: 'mmSettingsListCtrl'
            }
        }
    })
    .state('site.mm_settings-about', {
        url: '/mm_settings-about',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/about.html',
                controller: 'mmSettingsAboutCtrl'
            }
        }
    })
    .state('site.mm_settings-general', {
        url: '/mm_settings-general',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/general.html',
                controller: 'mmSettingsGeneralCtrl'
            }
        }
    })
    .state('site.mm_settings-spaceusage', {
        url: '/mm_settings-spaceusage',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/space-usage.html',
                controller: 'mmSettingsSpaceUsageCtrl'
            }
        }
    })
    .state('site.mm_settings-synchronization', {
        url: '/mm_settings-synchronization',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/synchronization.html',
                controller: 'mmSettingsSynchronizationCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmSettingsDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmSettingsDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmSettingsDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.sharedfiles', ['mm.core'])
.constant('mmSharedFilesFolder', 'sharedfiles')
.constant('mmSharedFilesStore', 'shared_files')
.constant('mmSharedFilesEventFileShared', 'file_shared')
.constant('mmSharedFilesPickerPriority', 1000)
.config(["$stateProvider", "$mmFileUploaderDelegateProvider", "mmSharedFilesPickerPriority", function($stateProvider, $mmFileUploaderDelegateProvider, mmSharedFilesPickerPriority) {
    var chooseSiteState = {
            url: '/sharedfiles-choose-site',
            params: {
                filepath: null
            }
        },
        chooseSiteView = {
            controller: 'mmSharedFilesChooseSiteCtrl',
            templateUrl: 'core/components/sharedfiles/templates/choosesite.html'
        };
    $stateProvider
    .state('site.sharedfiles-choose-site', angular.extend(angular.copy(chooseSiteState), {
        views: {
            'site': chooseSiteView
        }
    }))
    .state('mm_login.sharedfiles-choose-site', angular.extend(angular.copy(chooseSiteState), chooseSiteView))
    .state('site.sharedfiles-list', {
        url: '/sharedfiles-list',
        params: {
            path: null,
            manage: false,
            pick: false
        },
        views: {
            'site': {
                templateUrl: 'core/components/sharedfiles/templates/list.html',
                controller: 'mmSharedFilesListCtrl'
            }
        }
    });
    $mmFileUploaderDelegateProvider.registerHandler('mmSharedFiles',
                '$mmSharedFilesHandlers.filePicker', mmSharedFilesPickerPriority);
}])
.run(["$mmSharedFilesHelper", "$ionicPlatform", function($mmSharedFilesHelper, $ionicPlatform) {
    if (ionic.Platform.isIOS()) {
        $ionicPlatform.on('resume', $mmSharedFilesHelper.searchIOSNewSharedFiles);
        $mmSharedFilesHelper.searchIOSNewSharedFiles();
    }
}]);

angular.module('mm.core.sidemenu', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site', {
        url: '/site',
        templateUrl: 'core/components/sidemenu/templates/menu.html',
        controller: 'mmSideMenuCtrl',
        abstract: true,
        cache: false,
        onEnter: ["$ionicHistory", "$state", "$mmSite", function($ionicHistory, $state, $mmSite) {
            $ionicHistory.clearHistory();
            if (!$mmSite.isLoggedIn()) {
                $state.go('mm_login.init');
            }
        }]
    })
    .state('site.iframe-view', {
        url: '/iframe-view',
        params: {
            title: null,
            url: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/sidemenu/templates/iframe.html',
                controller: 'mmSideMenuIframeViewCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmSideMenuDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmSideMenuDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmSideMenuDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.textviewer', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_textviewer', {
        url: '/mm_textviewer',
        params: {
            title: null,
            content: null,
            replacelinebreaks: null,
            component: null,
            componentId: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/textviewer/templates/textviewer.html',
                controller: 'mmTextViewerIndexCtrl'
            }
        }
    });
}]);

angular.module('mm.core.user', ['mm.core.contentlinks'])
.constant('mmUserEventProfileRefreshed', 'user_profile_refreshed')
.constant('mmUserProfilePictureUpdated', 'user_profile_picture_updated')
.constant('mmUserProfileHandlersTypeNewPage', 'newpage')
.constant('mmUserProfileHandlersTypeCommunication', 'communication')
.constant('mmUserProfileHandlersTypeAction', 'action')
.constant('mmUserPriority', 700)
.value('mmUserProfileState', 'site.mm_user-profile')
.config(["$stateProvider", "$mmContentLinksDelegateProvider", "$mmUserDelegateProvider", "mmUserPriority", function($stateProvider, $mmContentLinksDelegateProvider, $mmUserDelegateProvider, mmUserPriority) {
    $stateProvider
        .state('site.mm_user-profile', {
            url: '/mm_user-profile',
            views: {
                'site': {
                    controller: 'mmUserProfileCtrl',
                    templateUrl: 'core/components/user/templates/profile.html'
                }
            },
            params: {
                courseid: 0,
                userid: 0
            }
        })
        .state('site.mm_user-about', {
            url: '/mm_user-about',
            views: {
                'site': {
                    controller: 'mmUserAboutCtrl',
                    templateUrl: 'core/components/user/templates/about.html'
                }
            },
            params: {
                courseid: 0,
                userid: 0
            }
        });
    $mmContentLinksDelegateProvider.registerLinkHandler('mmUser', '$mmUserHandlers.linksHandler');
    $mmUserDelegateProvider.registerProfileHandler('mmUser', '$mmUserHandlers.userEmail', mmUserPriority);
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmUserDelegate", "$mmSite", "mmCoreEventUserDeleted", "$mmUser", "mmCoreEventRemoteAddonsLoaded", "$mmUserProfileFieldsDelegate", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmUserDelegate, $mmSite, mmCoreEventUserDeleted, $mmUser,
            mmCoreEventRemoteAddonsLoaded, $mmUserProfileFieldsDelegate) {
    function updateHandlers() {
        $mmUserDelegate.updateProfileHandlers();
        $mmUserProfileFieldsDelegate.updateFieldHandlers();
    }
    $mmEvents.on(mmCoreEventLogin, updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, updateHandlers);
    $mmEvents.on(mmCoreEventUserDeleted, function(data) {
        if (data.siteid && data.siteid === $mmSite.getId() && data.params) {
            var params = data.params,
                userid = 0;
            if (params.userid) {
                userid = params.userid;
            } else if (params.userids) {
                userid = params.userids[0];
            } else if (params.field === 'id' && params.values && params.values.length) {
                userid = params.values[0];
            } else if (params.userlist && params.userlist.length) {
                userid = params.userlist[0].userid;
            }
            userid = parseInt(userid);
            if (userid > 0) {
                $mmUser.deleteStoredUser(userid);
            }
        }
    });
}]);

angular.module('mm.core.user')
.provider('$mmUserDelegate', ["mmUserProfileHandlersTypeNewPage", function(mmUserProfileHandlersTypeNewPage) {
    var profileHandlers = {},
        self = {};
        self.registerProfileHandler = function(component, handler, priority) {
        if (typeof profileHandlers[component] !== 'undefined') {
            console.log("$mmUserDelegateProvider: Handler '" + profileHandlers[component].component + "' already registered as profile handler");
            return false;
        }
        console.log("$mmUserDelegateProvider: Registered component '" + component + "' as profile handler.");
        profileHandlers[component] = {
            component: component,
            handler: handler,
            instance: undefined,
            priority: typeof priority === 'undefined' ? 100 : priority
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", "$mmCourses", function($q, $log, $mmSite, $mmUtil, $mmCourses) {
        var enabledProfileHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmUserDelegate');
                self.getProfileHandlersFor = function(user, courseId) {
            var handlers = [],
                promises = [];
            return $mmCourses.getUserCourses(true).then(function(courses) {
                var courseIds = courses.map(function(course) {
                    return course.id;
                });
                return $mmCourses.getCoursesOptions(courseIds).then(function(options) {
                    var courseIdForOptions = courseId || $mmSite.getSiteHomeId();
                    var navOptions = options.navOptions[courseIdForOptions];
                    var admOptions = options.admOptions[courseIdForOptions];
                    angular.forEach(enabledProfileHandlers, function(handler) {
                        var isEnabledForUser = handler.instance.isEnabledForUser(user, courseId, navOptions, admOptions);
                        var promise = $q.when(isEnabledForUser).then(function(enabled) {
                            if (enabled) {
                                handlers.push({
                                    controller: handler.instance.getController(user, courseId),
                                    priority: handler.priority,
                                    type: handler.instance.type || mmUserProfileHandlersTypeNewPage
                                });
                            } else {
                                return $q.reject();
                            }
                        }).catch(function() {
                        });
                        promises.push(promise);
                    });
                    return $q.all(promises).then(function() {
                        return handlers;
                    });
                });
            }).catch(function() {
                return handlers;
            });
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateProfileHandler = function(component, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmUserDelegate_' + component)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledProfileHandlers[component] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledProfileHandlers[component];
                    }
                }
            });
        };
                self.updateProfileHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating profile handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(profileHandlers, function(handlerInfo, component) {
                promises.push(self.updateProfileHandler(component, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
}]);

angular.module('mm.core.user')
.factory('$mmUserHandlers', ["$mmContentLinksHelper", "mmUserProfileHandlersTypeCommunication", "$mmSite", "$window", "$mmContentLinkHandlerFactory", function($mmContentLinksHelper, mmUserProfileHandlersTypeCommunication, $mmSite, $window,
            $mmContentLinkHandlerFactory) {
    var self = {};
        self.linksHandler = $mmContentLinkHandlerFactory.createChild(
                /((\/user\/view\.php)|(\/user\/profile\.php)).*([\?\&]id=\d+)/);
    self.linksHandler.isEnabled = function(siteId, url, params, courseId) {
        return url.indexOf('/grade/report/') == -1;
    };
    self.linksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                var stateParams = {
                    courseid: params.course,
                    userid: parseInt(params.id, 10)
                };
                $mmContentLinksHelper.goInSite('site.mm_user-profile', stateParams, siteId);
            }
        }];
    };
        self.userEmail = function() {
        var self = {
            type: mmUserProfileHandlersTypeCommunication
        };
                self.isEnabled = function() {
            return true;
        };
                self.isEnabledForUser = function(user, courseId, navOptions, admOptions) {
            return user.id != $mmSite.getUserId() && user.email;
        };
                self.getController = function(user, courseId) {
                        return function($scope, $state) {
                $scope.icon = 'ion-android-mail';
                $scope.title = 'mm.user.sendemail';
                $scope.action = function($event) {
                    $event.preventDefault();
                    $event.stopPropagation();
                    $window.location.href = "mailto:" + user.email;
                };
            };
        };
        return self;
    };
    return self;
}]);

angular.module('mm.core.user')
.provider('$mmUserProfileFieldsDelegate', function() {
    var handlers = {},
        self = {};
        self.registerHandler = function(addon, fieldType, handler) {
        if (typeof handlers[fieldType] !== 'undefined') {
            console.log("$mmUserProfileFieldsDelegateProvider: Addon '" + addon +
                        "' already registered as handler for '" + fieldType + "'");
            return false;
        }
        console.log("$mmUserProfileFieldsDelegateProvider: Registered handler '" + addon + "' for user field '" + fieldType + "'");
        handlers[fieldType] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", function($q, $log, $mmSite, $mmUtil) {
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmUserProfileFieldsDelegate');
                self.getDataForField = function(field, signup, registerAuth, model) {
            var handler = self.getHandlerInstance(field, signup),
                name = 'profile_field_' + field.shortname;
            if (handler) {
                if (handler.getData) {
                    return $q.when(handler.getData(field, signup, registerAuth, model));
                } else if (field.shortname && typeof model[name] != 'undefined') {
                    return $q.when({
                        type: field.type || field.datatype,
                        name: name,
                        value: model[name]
                    });
                }
            }
            return $q.when();
        };
                self.getDataForFields = function(fields, signup, registerAuth, model) {
            var result = [],
                promises = [];
            angular.forEach(fields, function(field) {
                promises.push(self.getDataForField(field, signup, registerAuth, model).then(function(data) {
                    if (data) {
                        result.push(data);
                    }
                }));
            });
            return $q.all(promises).then(function() {
                return result;
            });
        };
                self.getDirectiveForField = function(field, signup, registerAuth) {
            var handler = self.getHandlerInstance(field, signup);
            if (handler) {
                return handler.getDirectiveName(field, signup, registerAuth);
            }
        };
                self.getHandlerInstance = function(field, signup) {
            var type = field.type || field.datatype;
            if (signup) {
                if (handlers[type]) {
                    if (typeof handlers[type].instance === 'undefined') {
                        handlers[type].instance = $mmUtil.resolveObject(handlers[type].handler, true);
                    }
                    return handlers[type].instance;
                }
            } else {
                return enabledHandlers[type];
            }
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateFieldHandler = function(fieldType, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[fieldType] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[fieldType];
                    }
                }
            });
        };
                self.updateFieldHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating field handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, fieldType) {
                promises.push(self.updateFieldHandler(fieldType, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.user')
.constant('mmCoreUsersStore', 'users')
.config(["$mmSitesFactoryProvider", "mmCoreUsersStore", function($mmSitesFactoryProvider, mmCoreUsersStore) {
    var stores = [
        {
            name: mmCoreUsersStore,
            keyPath: 'id'
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmUser', ["$log", "$q", "$mmSite", "$mmUtil", "$translate", "mmCoreUsersStore", "$mmFilepool", "$mmSitesManager", function($log, $q, $mmSite, $mmUtil, $translate, mmCoreUsersStore, $mmFilepool, $mmSitesManager) {
    $log = $log.getInstance('$mmUser');
    var self = {};
        self.deleteStoredUser = function(id) {
        if (!$mmSite.isLoggedIn()) {
            return $q.reject();
        }
        id = parseInt(id, 10);
        if (isNaN(id)) {
            return $q.reject();
        }
        self.invalidateUserCache(id);
        return $mmSite.getDb().remove(mmCoreUsersStore, id);
    };
        self.formatAddress = function(address, city, country) {
        var separator = $translate.instant('mm.core.listsep'),
            values = [address, city, country];
        values = values.filter(function (value) {
            return value && value.length > 0;
        });
        return values.join(separator + " ");
    };
        self.formatRoleList = function(roles) {
        if (!roles || roles.length <= 0) {
            return "";
        }
        var separator = $translate.instant('mm.core.listsep');
        roles = roles.reduce(function (previousValue, currentValue) {
            var role = $translate.instant('mm.user.' + currentValue.shortname);
            if (role.indexOf('mm.user.') < 0) {
                previousValue.push(role);
            }
            return previousValue;
        }, []);
        return roles.join(separator + " ");
    };
        self.getProfile = function(userid, courseid, forceLocal) {
        var deferred = $q.defer();
        if (forceLocal) {
            self.getUserFromLocal(userid).then(deferred.resolve, function() {
                self.getUserFromWS(userid, courseid).then(deferred.resolve, deferred.reject);
            });
        } else {
            self.getUserFromWS(userid, courseid).then(deferred.resolve, function() {
                self.getUserFromLocal(userid).then(deferred.resolve, deferred.reject);
            });
        }
        return deferred.promise;
    };
        function getUserCacheKey(userid) {
        return 'mmUser:data:'+userid;
    }
        self.getUserFromLocal = function(id) {
        if (!$mmSite.isLoggedIn()) {
            return $q.reject();
        }
        id = parseInt(id, 10);
        if (isNaN(id)) {
            return $q.reject();
        }
        return $mmSite.getDb().get(mmCoreUsersStore, id);
    };
        self.getUserFromWS = function(userid, courseid) {
        userid = parseInt(userid, 10);
        courseid = parseInt(courseid, 10);
        var wsName,
            data,
            preSets ={
                cacheKey: getUserCacheKey(userid)
            };
        if (courseid > 1) {
            $log.debug('Get participant with ID ' + userid + ' in course '+courseid);
            wsName = 'core_user_get_course_user_profiles';
            data = {
                "userlist[0][userid]": userid,
                "userlist[0][courseid]": courseid
            };
        } else {
            $log.debug('Get user with ID ' + userid);
            if ($mmSite.wsAvailable('core_user_get_users_by_field')) {
                wsName = 'core_user_get_users_by_field';
                data = {
                    'field': 'id',
                    'values[0]': userid
                };
            } else {
                wsName = 'core_user_get_users_by_id';
                data = {
                    'userids[0]': userid
                };
            }
        }
        return $mmSite.read(wsName, data, preSets).then(function(users) {
            if (users.length == 0) {
                return $q.reject();
            }
            var user = users.shift();
            if (user.country) {
                user.country = $mmUtil.getCountryName(user.country);
            }
            self.storeUser(user.id, user.fullname, user.profileimageurl);
            return user;
        });
    };
        self.invalidateUserCache = function(userid) {
        return $mmSite.invalidateWsCacheForKey(getUserCacheKey(userid));
    };
        self.isUpdatePictureDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isUpdatePictureDisabledInSite(site);
        });
    };
        self.isUpdatePictureDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmUserDelegate_picture');
    };
        self.prefetchProfiles = function(userIds, courseId, siteId) {
        siteId = siteId || $mmSite.getId();
        var treated = {},
            promises = [];
        angular.forEach(userIds, function(userId) {
            if (!treated[userId]) {
                treated[userId] = true;
                promises.push(self.getProfile(userId, courseId).then(function(profile) {
                    if (profile.profileimageurl) {
                        $mmFilepool.addToQueueByUrl(siteId, profile.profileimageurl);
                    }
                }));
            }
        });
        return $q.all(promises);
    };
        self.storeUser = function(id, fullname, avatar) {
        if (!$mmSite.isLoggedIn()) {
            return $q.reject();
        }
        id = parseInt(id, 10);
        if (isNaN(id)) {
            return $q.reject();
        }
        return $mmSite.getDb().insert(mmCoreUsersStore, {
            id: id,
            fullname: fullname,
            profileimageurl: avatar
        });
    };
        self.storeUsers = function(users) {
        var promises = [];
        angular.forEach(users, function(user) {
            var userid = user.id || user.userid,
                img = user.profileimageurl || user.profileimgurl;
            if (typeof userid != 'undefined') {
                promises.push(self.storeUser(userid, user.fullname, img));
            }
        });
        return $q.all(promises);
    };
        self.updateUserPreference = function(name, value, userId, siteId) {
        var preferences = [
            {
                type: name,
                value: value
            }
        ];
        return self.updateUserPreferences(preferences, undefined, userId, siteId);
    };
        self.updateUserPreferences = function(preferences, disableNotifications, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            var data = {
                    userid: userId,
                    preferences: preferences
                },
                preSets = {
                    responseExpected: false
                };
            if (typeof disableNotifications != 'undefined') {
                data.emailstop = disableNotifications ? 1 : 0;
            }
            return site.write('core_user_update_user_preferences', data, preSets);
        });
    };
        self.changeProfilePicture = function(draftItemId, userId) {
        var data = {
            'draftitemid': draftItemId,
            'delete': 0,
            'userid': userId
        };
        return $mmSite.write('core_user_update_picture', data).then(function(result) {
            if (!result.success) {
                return $q.reject();
            }
            return result.profileimageurl;
        });
    };
    return self;
}]);

angular.module('mm.core.comments')
.controller('mmCommentViewerCtrl', ["$stateParams", "$scope", "$translate", "$mmComments", "$mmUtil", "$mmUser", "$q", function($stateParams, $scope, $translate, $mmComments, $mmUtil, $mmUser, $q) {
    var contextLevel = $stateParams.contextLevel,
        instanceId = $stateParams.instanceId,
        component = $stateParams.component,
        itemId = $stateParams.itemId,
        area = $stateParams.area,
        page = $stateParams.page || 0;
    $scope.title = $stateParams.title || $translate.instant('mm.core.comments');
    function fetchComments() {
        return $mmComments.getComments(contextLevel, instanceId, component, itemId, area, page).then(function(comments) {
            $scope.comments = comments;
            angular.forEach(comments, function(comment) {
                $mmUser.getProfile(comment.userid, undefined, true).then(function(user) {
                    comment.profileimageurl = user.profileimageurl || true;
                });
            });
        }).catch(function(error) {
            if (error) {
                if (component == 'assignsubmission_comments') {
                    $mmUtil.showModal('mm.core.notice', 'mm.core.commentsnotworking');
                } else {
                    $mmUtil.showErrorModal(error);
                }
            } else {
                $translate('mm.core.error').then(function(error) {
                    $mmUtil.showErrorModal(error + ': get_comments');
                });
            }
            return $q.reject();
        });
    }
    fetchComments().finally(function() {
        $scope.commentsLoaded = true;
    });
    $scope.refreshComments = function() {
        return $mmComments.invalidateCommentsData(contextLevel, instanceId, component, itemId, area, page).finally(function() {
            return fetchComments().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);
angular.module('mm.core.comments')
.directive('mmComments', ["$mmComments", "$state", function($mmComments, $state) {
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            contextLevel: '@',
            instanceId: '@',
            component: '@',
            itemId: '@',
            area: '@?',
            page: '@?',
            title: '@?'
        },
        templateUrl: 'core/components/comments/templates/comments.html',
        link: function(scope, el, attr) {
            var params;
            scope.commentsCount = -1;
            scope.commentsLoaded = false;
            scope.showComments = function() {
                if (scope.commentsCount > 0) {
                    $state.go('site.mm_commentviewer', params);
                }
            };
            $mmComments.getComments(attr.contextLevel, attr.instanceId, attr.component, attr.itemId, attr.area, attr.page)
                    .then(function(comments) {
                params = {
                    contextLevel: attr.contextLevel,
                    instanceId: attr.instanceId,
                    component: attr.component,
                    itemId: attr.itemId,
                    area: attr.area,
                    page: attr.page,
                    title: attr.title
                };
                scope.commentsCount = comments && comments.length ? comments.length : 0;
                scope.commentsLoaded = true;
            }).catch(function() {
                scope.commentsLoaded = true;
            });
        }
    };
}]);

angular.module('mm.core.comments')
.factory('$mmComments', ["$log", "$mmSitesManager", "$mmSite", "$q", function($log, $mmSitesManager, $mmSite, $q) {
    $log = $log.getInstance('$mmComments');
    var self = {};
        function getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page) {
        page = page || 0;
        area = area || "";
        return getCommentsPrefixCacheKey(contextLevel, instanceId) + ':' + component + ':' + itemId + ':' + area + ':' + page;
    }
        function getCommentsPrefixCacheKey(contextLevel, instanceId) {
        return 'mmComments:comments:' + contextLevel + ':' + instanceId;
    }
        self.getComments = function(contextLevel, instanceId, component, itemId, area, page, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                "contextlevel": contextLevel,
                "instanceid": instanceId,
                "component": component,
                "itemid": itemId
            },
            preSets = {};
            if (area) {
                params.area = area;
            }
            if (page) {
                params.page = page;
            }
            preSets.cacheKey = getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page);
            return site.read('core_comment_get_comments', params, preSets).then(function(response) {
                if (response.comments) {
                    return response.comments;
                }
                return $q.reject();
            });
        });
    };
        self.invalidateCommentsData = function(contextLevel, instanceId, component, itemId, area, page, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page));
        });
    };
        self.invalidateCommentsByInstance = function(contextLevel, instanceId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getCommentsPrefixCacheKey(contextLevel, instanceId));
        });
    };
        self.isPluginEnabled = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return  site.wsAvailable('core_comment_get_comments');
        });
    };
    return self;
}]);

angular.module('mm.core.contentlinks')
.controller('mmContentLinksChooseSiteCtrl', ["$scope", "$stateParams", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$state", "$q", "$mmContentLinksDelegate", "$mmContentLinksHelper", function($scope, $stateParams, $mmSitesManager, $mmUtil, $ionicHistory, $state, $q,
            $mmContentLinksDelegate, $mmContentLinksHelper) {
    $scope.url = $stateParams.url || '';
    var action;
    function leaveView() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
    if (!$scope.url) {
        leaveView();
        return;
    }
    $mmContentLinksDelegate.getActionsFor($scope.url).then(function(actions) {
        action = $mmContentLinksHelper.getFirstValidAction(actions);
        if (!action) {
            return $q.reject();
        }
        $mmSitesManager.getSites(action.sites).then(function(sites) {
            $scope.sites = sites;
        });
    }).catch(function() {
        $mmUtil.showErrorModal('mm.contentlinks.errornosites', true);
        leaveView();
    });
    $scope.siteClicked = function(siteId) {
        action.action(siteId);
    };
    $scope.cancel = function() {
        leaveView();
    };
}]);

angular.module('mm.core.contentlinks')
.provider('$mmContentLinksDelegate', function() {
    var linkHandlers = {},
        self = {};
        self.registerLinkHandler = function(name, handler, priority) {
        if (typeof linkHandlers[name] !== 'undefined') {
            console.log("$mmContentLinksDelegateProvider: Handler '" + linkHandlers[name].name +
                        "' already registered as link handler");
            return false;
        }
        console.log("$mmContentLinksDelegateProvider: Registered handler '" + name + "' as link handler.");
        linkHandlers[name] = {
            name: name,
            handler: handler,
            instance: undefined,
            priority: typeof priority === 'undefined' ? 100 : priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$log", "$q", "$mmSitesManager", function($mmUtil, $log, $q, $mmSitesManager) {
        var self = {};
        $log = $log.getInstance('$mmContentLinksDelegate');
                self.getActionsFor = function(url, courseId, username) {
            if (!url) {
                return $q.when([]);
            }
            return $mmSitesManager.getSiteIdsFromUrl(url, true, username).then(function(siteIds) {
                var linkActions = [],
                    promises = [],
                    params = $mmUtil.extractUrlParams(url);
                angular.forEach(linkHandlers, function(handler) {
                    if (typeof handler.instance === 'undefined') {
                        handler.instance = $mmUtil.resolveObject(handler.handler, true);
                    }
                    if (!handler.instance || !handler.instance.handles(url)) {
                        return;
                    }
                    var checkAll = handler.instance.checkAllSites;
                    promises.push($mmUtil.filterEnabledSites(siteIds, isEnabled, checkAll).then(function(siteIds) {
                        if (!siteIds.length) {
                            return;
                        }
                        return $q.when(handler.instance.getActions(siteIds, url, params, courseId)).then(function(actions) {
                            if (actions && actions.length) {
                                angular.forEach(actions, function(action) {
                                    action.message = action.message || 'mm.core.view';
                                    action.icon = action.icon || 'ion-eye';
                                    action.sites = action.sites || siteIds;
                                });
                                linkActions.push({
                                    priority: handler.priority,
                                    actions: actions
                                });
                            }
                        });
                    }));
                    function isEnabled(siteId) {
                        var promise;
                        if (handler.instance.featureName) {
                            promise = $mmSitesManager.isFeatureDisabled(handler.instance.featureName, siteId);
                        } else {
                            promise = $q.when(false);
                        }
                        return promise.then(function(disabled) {
                            if (disabled) {
                                return false;
                            }
                            if (!handler.instance.isEnabled) {
                                return true;
                            }
                            return handler.instance.isEnabled(siteId, url, params, courseId);
                        });
                    }
                });
                return $mmUtil.allPromises(promises).catch(function() {}).then(function() {
                    return sortActionsByPriority(linkActions);
                });
            });
        };
                self.getSiteUrl = function(url) {
            if (!url) {
                return;
            }
            for (var name in linkHandlers) {
                var handler = linkHandlers[name];
                if (typeof handler.instance === 'undefined') {
                    handler.instance = $mmUtil.resolveObject(handler.handler, true);
                }
                if (handler.instance && handler.instance.handles) {
                    var siteUrl = handler.instance.handles(url);
                    if (siteUrl) {
                        return siteUrl;
                    }
                }
            }
        };
                function sortActionsByPriority(actions) {
            var sorted = [];
            actions = actions.sort(function(a, b) {
                return a.priority > b.priority;
            });
            actions.forEach(function(entry) {
                sorted = sorted.concat(entry.actions);
            });
            return sorted;
        }
        return self;
    }];
    return self;
});

angular.module('mm.core')
.factory('$mmContentLinkHandlerFactory', ["$log", function($log) {
    $log = $log.getInstance('$mmContentLinkHandlerFactory');
    var self = {},
        contentLinkHandler = (function () {
            this.pattern = false;
            this.featureName = '';
            this.checkAllSites = false;
                        this.getActions = function(siteIds, url, params, courseId) {
                return [];
            };
                        this.handles = function(url) {
                if (this.pattern) {
                    var position = url.search(this.pattern);
                    if (position > -1) {
                        return url.substr(0, position);
                    }
                }
            };
                        this.isEnabled = function(siteId, url, params, courseId) {
                return true;
            };
            return this;
        }());
        self.createChild = function(pattern, featureName, checkAllSites) {
        var child = Object.create(contentLinkHandler);
        child.pattern = pattern;
        child.featureName = featureName;
        child.checkAllSites = !!checkAllSites;
        return child;
    };
    return self;
}]);
angular.module('mm.core.contentlinks')
.factory('$mmContentLinksHelper', ["$log", "$ionicHistory", "$state", "$mmSite", "$mmContentLinksDelegate", "$mmUtil", "$translate", "$mmCourseHelper", "$mmSitesManager", "$q", "$mmLoginHelper", "$mmText", "mmCoreConfigConstants", "$mmCourse", "$mmContentLinkHandlerFactory", function($log, $ionicHistory, $state, $mmSite, $mmContentLinksDelegate, $mmUtil, $translate,
            $mmCourseHelper, $mmSitesManager, $q, $mmLoginHelper, $mmText, mmCoreConfigConstants, $mmCourse,
            $mmContentLinkHandlerFactory) {
    $log = $log.getInstance('$mmContentLinksHelper');
    var self = {};
        self.createModuleGradeLinkHandler = function(addon, modName, service, gotoReview) {
        var regex = new RegExp('\/mod\/' + modName + '\/grade\.php.*([\&\?]id=\\d+)'),
            handler = $mmContentLinkHandlerFactory.createChild(regex, '$mmCourseDelegate_' + addon);
        handler.isEnabled = function(siteId, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.isModuleIndexEnabled(service, siteId, courseId);
        };
        handler.getActions = function(siteIds, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.treatModuleGradeUrl(siteIds, url, params, courseId, gotoReview);
        };
        return handler;
    };
        self.createModuleIndexLinkHandler = function(addon, modName, service) {
        var regex = new RegExp('\/mod\/' + modName + '\/view\.php.*([\&\?]id=\\d+)'),
            handler = $mmContentLinkHandlerFactory.createChild(regex, '$mmCourseDelegate_' + addon);
        handler.isEnabled = function(siteId, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.isModuleIndexEnabled(service, siteId, courseId);
        };
        handler.getActions = self.treatModuleIndexUrl;
        return handler;
    };
        self.filterSupportedSites = $mmUtil.filterEnabledSites;
        self.getFirstValidAction = function(actions) {
        if (actions) {
            for (var i = 0; i < actions.length; i++) {
                var action = actions[i];
                if (action && action.sites && action.sites.length && angular.isFunction(action.action)) {
                    return action;
                }
            }
        }
    };
        self.goInSite = function(stateName, stateParams, siteId) {
        siteId = siteId || $mmSite.getId();
        if (siteId == $mmSite.getId()) {
            return $state.go(stateName, stateParams);
        } else {
            return $state.go('redirect', {
                siteid: siteId,
                state: stateName,
                params: stateParams
            });
        }
    };
        self.goToChooseSite = function(url) {
        $ionicHistory.nextViewOptions({
            disableBack: true
        });
        return $state.go('mm_contentlinks.choosesite', {url: url});
    };
        self.handleCustomUrl = function(url) {
        var contentLinksScheme = mmCoreConfigConstants.customurlscheme + '://link=';
        if (url.indexOf(contentLinksScheme) == -1) {
            return false;
        }
        $log.debug('Treating custom URL scheme: ' + url);
        var modal = $mmUtil.showModalLoading(),
            username;
        url = url.replace(contentLinksScheme, '');
        username = $mmText.getUsernameFromUrl(url);
        if (username) {
            url = url.replace(username + '@', '');
        }
        $mmSitesManager.getSiteIdsFromUrl(url, false, username).then(function(siteIds) {
            if (siteIds.length) {
                modal.dismiss();
                return self.handleLink(url, username).then(function(treated) {
                    if (!treated) {
                        $mmUtil.showErrorModal('mm.contentlinks.errornoactions', true);
                    }
                });
            } else {
                var siteUrl = $mmContentLinksDelegate.getSiteUrl(url);
                if (!siteUrl) {
                    $mmUtil.showErrorModal('mm.login.invalidsite', true);
                    return;
                }
                return $mmSitesManager.checkSite(siteUrl).then(function(result) {
                    var promise,
                        ssoNeeded = $mmLoginHelper.isSSOLoginNeeded(result.code);
                    modal.dismiss();
                    if (!$mmSite.isLoggedIn()) {
                        promise = $q.when();
                    } else {
                        promise = $mmUtil.showConfirm($translate('mm.contentlinks.confirmurlothersite')).then(function() {
                            if (!ssoNeeded) {
                                return $mmSitesManager.logout().catch(function() {
                                });
                            }
                        });
                    }
                    return promise.then(function() {
                        if (ssoNeeded) {
                            $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                        result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                        } else {
                            $state.go('mm_login.credentials', {
                                siteurl: result.siteurl,
                                username: username,
                                urltoopen: url
                            });
                        }
                    });
                }, function(error) {
                    $mmUtil.showErrorModal(error);
                });
            }
        }).finally(function() {
            modal.dismiss();
        });
        return true;
    };
        self.handleLink = function(url, username) {
        return $mmContentLinksDelegate.getActionsFor(url, undefined, username).then(function(actions) {
            var action = self.getFirstValidAction(actions);
            if (action) {
                if (!$mmSite.isLoggedIn()) {
                    if (action.sites.length == 1) {
                        action.action(action.sites[0]);
                    } else {
                        self.goToChooseSite(url);
                    }
                } else if (action.sites.length == 1 && action.sites[0] == $mmSite.getId()) {
                    action.action(action.sites[0]);
                } else {
                    $mmUtil.showConfirm($translate('mm.contentlinks.confirmurlothersite')).then(function() {
                        if (action.sites.length == 1) {
                            action.action(action.sites[0]);
                        } else {
                            self.goToChooseSite(url);
                        }
                    });
                }
                return true;
            }
            return false;
        }).catch(function() {
            return false;
        });
    };
        self.isModuleIndexEnabled = function(service, siteId, courseId) {
        var promise;
        if (service.isPluginEnabled) {
            promise = service.isPluginEnabled(siteId);
        } else {
            promise = $q.when(true);
        }
        return promise.then(function(enabled) {
            if (!enabled) {
                return false;
            }
            return courseId || $mmCourse.canGetModuleWithoutCourseId(siteId);
        });
    };
        self.treatModuleGradeUrl = function(siteIds, url, params, courseId, gotoReview) {
        return [{
            action: function(siteId) {
                var modal = $mmUtil.showModalLoading();
                $mmSitesManager.getSite(siteId).then(function(site) {
                    if (!params.userid || params.userid == site.getUserId()) {
                        $mmCourseHelper.navigateToModule(parseInt(params.id, 10), siteId, courseId);
                    } else if (angular.isFunction(gotoReview)) {
                        gotoReview(url, params, courseId, siteId);
                    } else {
                        return site.openInBrowserWithAutoLogin(url);
                    }
                }).finally(function() {
                    modal.dismiss();
                });
            }
        }];
    };
        self.treatModuleIndexUrl = function(siteIds, url, params, courseId) {
        courseId = courseId || params.courseid || params.cid;
        return [{
            action: function(siteId) {
                $mmCourseHelper.navigateToModule(parseInt(params.id, 10), siteId, courseId);
            }
        }];
    };
    return self;
}]);

angular.module('mm.core.course')
.controller('mmCourseModContentCtrl', ["$log", "$stateParams", "$scope", "$mmCourseDelegate", "$mmCourse", "$translate", "$mmText", function($log, $stateParams, $scope, $mmCourseDelegate, $mmCourse, $translate, $mmText) {
    $log = $log.getInstance('mmCourseModContentCtrl');
    var module = $stateParams.module || {};
    $scope.isDisabledInSite = $mmCourseDelegate.isModuleDisabledInSite(module.modname);
    $scope.isSupportedByTheApp = $mmCourseDelegate.hasContentHandler(module.modname);
    $scope.moduleName = $mmCourse.translateModuleName(module.modname);
    $scope.isContributedPlugin = $scope.moduleName == $translate.instant('mm.core.mod_external-tool');
    $scope.description = module.description;
    $scope.title = module.name;
    $scope.url = module.url;
    $scope.expandDescription = function() {
        $mmText.expandText($translate.instant('mm.core.description'), $scope.description, false);
    };
}]);

angular.module('mm.core.course')
.controller('mmCourseSectionCtrl', ["$mmCourse", "$mmUtil", "$scope", "$stateParams", "$translate", "$mmEvents", "$ionicScrollDelegate", "$mmCourses", "$q", "mmCoreEventCompletionModuleViewed", "$mmCoursePrefetchDelegate", "$mmCourseHelper", "$timeout", function($mmCourse, $mmUtil, $scope, $stateParams, $translate, $mmEvents, $ionicScrollDelegate,
            $mmCourses, $q, mmCoreEventCompletionModuleViewed, $mmCoursePrefetchDelegate, $mmCourseHelper, $timeout) {
    var courseId = $stateParams.cid,
        sectionId = $stateParams.sectionid || -1,
        moduleId = $stateParams.mid,
        scrollView;
    $scope.sections = [];
    $scope.sectionHasContent = $mmCourseHelper.sectionHasContent;
    if (sectionId < 0) {
        $scope.title = $translate.instant('mm.course.allsections');
        $scope.summary = null;
        $scope.allSections = true;
    }
    function loadContent(sectionId) {
        return $mmCourses.getUserCourse(courseId, true).catch(function() {
        }).then(function(course) {
            var promise;
            if (course && course.enablecompletion === false) {
                promise = $q.when([]);
            } else {
                promise = $mmCourse.getActivitiesCompletionStatus(courseId).catch(function() {
                    return [];
                });
            }
            return promise.then(function(completionStatus) {
                var promise,
                    sectionnumber;
                if (sectionId < 0) {
                    sectionnumber = 0;
                    promise = $mmCourse.getSections(courseId, false, true);
                } else {
                    sectionnumber = sectionId;
                    promise = $mmCourse.getSection(courseId, false, true, sectionId).then(function(section) {
                        $scope.title = section.name;
                        $scope.summary = section.summary;
                        return [section];
                    });
                }
                return promise.then(function(sections) {
                    $scope.hasContent = $mmCourseHelper.addContentHandlerControllerForSectionModules(sections, courseId,
                        moduleId, completionStatus, $scope);
                    $scope.sections = sections;
                    if (sectionId > 0 && sections[0] && typeof sections[0].section != 'undefined') {
                        $mmCourse.logView(courseId, sections[0].section);
                    } else {
                        $mmCourse.logView(courseId);
                    }
                }, function(error) {
                    if (error) {
                        $mmUtil.showErrorModal(error);
                    } else {
                        $mmUtil.showErrorModal('mm.course.couldnotloadsectioncontent', true);
                    }
                });
            });
        });
    }
    loadContent(sectionId).finally(function() {
        $scope.sectionLoaded = true;
        if (moduleId) {
            $timeout(function() {
                if (!scrollView) {
                    scrollView = $ionicScrollDelegate.$getByHandle('mmSectionScroll');
                }
                $mmUtil.scrollToElement(document.body, '#mm-course-module-' + moduleId, scrollView);
            }, 400);
        }
    });
    $scope.doRefresh = function() {
        var promises = [];
        promises.push($mmCourse.invalidateSections(courseId));
        if ($scope.sections) {
            var modules = $mmCourseHelper.getSectionsModules($scope.sections);
            promises.push($mmCoursePrefetchDelegate.invalidateModules(modules, courseId));
        }
        $q.all(promises).finally(function() {
            loadContent(sectionId).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    function refreshAfterCompletionChange() {
        if (!scrollView) {
            scrollView = $ionicScrollDelegate.$getByHandle('mmSectionScroll');
        }
        if (scrollView && scrollView.getScrollPosition()) {
            $scope.loadingPaddingTop = scrollView.getScrollPosition().top;
        }
        $scope.sectionLoaded = false;
        $scope.sections = [];
        loadContent(sectionId).finally(function() {
            $scope.sectionLoaded = true;
            $scope.loadingPaddingTop = 0;
        });
    }
    $scope.completionChanged = function() {
        $mmCourse.invalidateSections(courseId).finally(function() {
            refreshAfterCompletionChange();
        });
    };
    var observer = $mmEvents.on(mmCoreEventCompletionModuleViewed, function(cid) {
        if (cid === courseId) {
            refreshAfterCompletionChange();
        }
    });
    $scope.$on('$destroy', function() {
        if (observer && observer.off) {
            observer.off();
        }
    });
}]);

angular.module('mm.core.course')
.controller('mmCourseSectionsCtrl', ["$mmCourse", "$mmUtil", "$scope", "$stateParams", "$translate", "$mmCourseHelper", "$mmEvents", "$mmSite", "$mmCoursePrefetchDelegate", "$mmCourses", "$q", "$ionicHistory", "$ionicPlatform", "mmCoreCourseAllSectionsId", "mmCoreEventSectionStatusChanged", "$state", "$timeout", function($mmCourse, $mmUtil, $scope, $stateParams, $translate, $mmCourseHelper, $mmEvents,
            $mmSite, $mmCoursePrefetchDelegate, $mmCourses, $q, $ionicHistory, $ionicPlatform, mmCoreCourseAllSectionsId,
            mmCoreEventSectionStatusChanged, $state, $timeout) {
    var courseId = $stateParams.courseid,
        sectionId = $stateParams.sid,
        moduleId = $stateParams.moduleid,
        courseFullName = $stateParams.coursefullname;
    $scope.courseId = courseId;
    $scope.sectionToLoad = 2;
    $scope.fullname = courseFullName;
    $scope.downloadSectionsEnabled = $mmCourseHelper.isDownloadSectionsEnabled();
    $scope.downloadSectionsIcon = getDownloadSectionIcon();
    $scope.sectionHasContent = $mmCourseHelper.sectionHasContent;
    function loadSections(refresh) {
        var promise;
        if (courseFullName) {
            promise = $q.when();
        } else {
            promise = $mmCourses.getUserCourse(courseId).catch(function() {
                return $mmCourses.getCourse(courseId);
            }).then(function(course) {
                return course.fullname;
            }).catch(function() {
                return $translate.instant('mm.core.course');
            });
        }
        return promise.then(function(courseFullName) {
            if (courseFullName) {
                $scope.fullname = courseFullName;
            }
            return $mmCourse.getSections(courseId, false, true).then(function(sections) {
                return $translate('mm.course.allsections').then(function(str) {
                    var result = [{
                        name: str,
                        id: mmCoreCourseAllSectionsId
                    }].concat(sections);
                    $scope.sections = result;
                    if ($scope.downloadSectionsEnabled) {
                        calculateSectionStatus(refresh);
                    }
                });
            });
        }).catch(function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.course.couldnotloadsections', true);
            }
        });
    }
    $scope.toggleDownloadSections = function() {
        $scope.downloadSectionsEnabled = !$scope.downloadSectionsEnabled;
        $mmCourseHelper.setDownloadSectionsEnabled($scope.downloadSectionsEnabled);
        $scope.downloadSectionsIcon = getDownloadSectionIcon();
        if ($scope.downloadSectionsEnabled) {
            calculateSectionStatus(false);
        }
    };
    function getDownloadSectionIcon() {
        return $scope.downloadSectionsEnabled ? 'ion-android-checkbox-outline' : 'ion-android-checkbox-outline-blank';
    }
    function calculateSectionStatus(refresh) {
        $mmCourseHelper.calculateSectionsStatus($scope.sections, $scope.courseId, true, refresh).catch(function() {
        }).then(function(downloadpromises) {
            if (downloadpromises && downloadpromises.length) {
                $mmUtil.allPromises(downloadpromises).catch(function() {
                    if (!$scope.$$destroyed) {
                        $mmUtil.showErrorModal('mm.course.errordownloadingsection', true);
                    }
                }).finally(function() {
                    if (!$scope.$$destroyed) {
                        $mmCourseHelper.calculateSectionsStatus($scope.sections, $scope.courseId, false);
                    }
                });
            }
        });
    }
    function prefetch(section, manual) {
        $mmCourseHelper.prefetch(section, courseId, $scope.sections).catch(function() {
            if ($scope.$$destroyed) {
                return;
            }
            var current = $ionicHistory.currentStateName(),
                isCurrent = ($ionicPlatform.isTablet() && current == 'site.mm_course.mm_course-section') ||
                            (!$ionicPlatform.isTablet() && current == 'site.mm_course');
            if (!manual && !isCurrent) {
                return;
            }
            $mmUtil.showErrorModal('mm.course.errordownloadingsection', true);
        }).finally(function() {
            if (!$scope.$$destroyed) {
                $mmCourseHelper.calculateSectionsStatus($scope.sections, courseId, false);
            }
        });
    }
    function autoloadSection() {
        if (sectionId) {
            if ($ionicPlatform.isTablet()) {
                angular.forEach($scope.sections, function(section, index) {
                    if (section.id == sectionId) {
                        $scope.sectionToLoad = index + 1;
                    }
                });
                $scope.moduleId = moduleId;
                $timeout(function() {
                    $scope.moduleId = null;
                }, 500);
            } else {
                $state.go('site.mm_course-section', {
                    sectionid: sectionId,
                    cid: courseId,
                    mid: moduleId
                });
            }
        }
    }
    $scope.doRefresh = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourse.invalidateSections(courseId));
        if ($scope.sections && $scope.downloadSectionsEnabled) {
            var modules = $mmCourseHelper.getSectionsModules($scope.sections);
            promises.push($mmCoursePrefetchDelegate.invalidateModules(modules, courseId));
        }
        $q.all(promises).finally(function() {
            loadSections(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    $scope.prefetch = function(e, section) {
        e.preventDefault();
        e.stopPropagation();
        section.isCalculating = true;
        $mmCourseHelper.confirmDownloadSize(courseId, section, $scope.sections).then(function() {
            prefetch(section, true);
        }).finally(function() {
            section.isCalculating = false;
        });
    };
    loadSections().finally(function() {
        autoloadSection();
        $scope.sectionsLoaded = true;
    });
    var statusObserver = $mmEvents.on(mmCoreEventSectionStatusChanged, function(data) {
        if ($scope.downloadSectionsEnabled && $scope.sections && $scope.sections.length && data.siteid === $mmSite.getId() &&
                    !$scope.$$destroyed && data.sectionid) {
            if ($mmCoursePrefetchDelegate.isBeingDownloaded($mmCourseHelper.getSectionDownloadId({id: data.sectionid}))) {
                return;
            }
            $mmCourseHelper.calculateSectionsStatus($scope.sections, courseId, false).then(function() {
                var section;
                angular.forEach($scope.sections, function(s) {
                    if (s.id === data.sectionid) {
                        section = s;
                    }
                });
                if (section) {
                    var downloadid = $mmCourseHelper.getSectionDownloadId(section);
                    if (section.isDownloading && !$mmCoursePrefetchDelegate.isBeingDownloaded(downloadid)) {
                        prefetch(section, false);
                    }
                }
            });
        }
    });
    $scope.$on('$destroy', function() {
        statusObserver && statusObserver.off && statusObserver.off();
    });
}]);

angular.module('mm.core.course')
.directive('mmCourseModDescription', function() {
    return {
        compile: function(element, attrs) {
            if (attrs.watch) {
                element.find('mm-format-text').attr('watch', attrs.watch);
            }
            return function(scope) {
                scope.showfull = !!attrs.showfull;
            };
        },
        restrict: 'E',
        scope: {
            description: '=',
            note: '=?',
            component: '@?',
            componentId: '@?'
        },
        templateUrl: 'core/components/course/templates/mod_description.html'
    };
});

angular.module('mm.core.course')
.directive('mmCourseModule', function() {
    return {
        restrict: 'E',
        scope: {
            module: '=',
            completionChanged: '=?'
        },
        templateUrl: 'core/components/course/templates/module.html'
    };
});

angular.module('mm.core.course')
.factory('$mmCourseContentHandler', ["$mmCourse", "$mmSite", function($mmCourse, $mmSite) {
    return {
        getController: function(module) {
            return function($scope, $state) {
                $scope.icon = $mmCourse.getModuleIconSrc(module.modname);
                $scope.title = module.name;
                $scope.class = 'mm-course-default-handler mm-course-module-' + module.modname + '-handler';
                $scope.action = function(e) {
                    $state.go('site.mm_course-modcontent', {module: module});
                    e.preventDefault();
                    e.stopPropagation();
                };
                if (module.url) {
                    $scope.buttons = [{
                        icon: 'ion-share',
                        label: 'mm.core.openinbrowser',
                        action: function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            $mmSite.openInBrowserWithAutoLoginIfSameSite(module.url);
                        }
                    }];
                }
            };
        }
    };
}]);

angular.module('mm.core.course')
.constant('mmCoreCourseModulesStore', 'course_modules')
.config(["$mmSitesFactoryProvider", "mmCoreCourseModulesStore", function($mmSitesFactoryProvider, mmCoreCourseModulesStore) {
    var stores = [
        {
            name: mmCoreCourseModulesStore,
            keyPath: 'id'
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmCourse', ["$mmSite", "$translate", "$q", "$log", "$mmEvents", "$mmSitesManager", "mmCoreEventCompletionModuleViewed", function($mmSite, $translate, $q, $log, $mmEvents, $mmSitesManager, mmCoreEventCompletionModuleViewed) {
    $log = $log.getInstance('$mmCourse');
    var self = {},
        mods = ["assign", "assignment", "book", "chat", "choice", "data", "database", "date", "external-tool",
            "feedback", "file", "folder", "forum", "glossary", "ims", "imscp", "label", "lesson", "lti", "page", "quiz",
            "resource", "scorm", "survey", "url", "wiki", "workshop"
        ],
        modsWithContent = ['book', 'folder', 'imscp', 'page', 'resource', 'url'];
        function addContentsIfNeeded(module) {
        if (modsWithContent.indexOf(module.modname) > -1) {
            module.contents = module.contents || [];
        }
        return module;
    }
        self.canGetModuleWithoutCourseId = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('core_course_get_course_module');
        });
    };
        self.canGetModuleByInstance = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('core_course_get_course_module_by_instance');
        });
    };
        self.checkModuleCompletion = function(courseId, completion) {
        if (completion && completion.tracking === 2 && completion.state === 0) {
            self.invalidateSections(courseId).finally(function() {
                $mmEvents.trigger(mmCoreEventCompletionModuleViewed, courseId);
            });
        }
    };
        self.getActivitiesCompletionStatus = function(courseid, userid) {
        userid = userid || $mmSite.getUserId();
        $log.debug('Getting completion status for user ' + userid + ' in course ' + courseid);
        var params = {
                courseid: courseid,
                userid: userid
            },
            preSets = {
                cacheKey: getActivitiesCompletionCacheKey(courseid, userid)
            };
        return $mmSite.read('core_completion_get_activities_completion_status', params, preSets).then(function(data) {
            if (data && data.statuses) {
                var formattedStatuses = {};
                angular.forEach(data.statuses, function(status) {
                    formattedStatuses[status.cmid] = status;
                });
                return formattedStatuses;
            }
            return $q.reject();
        });
    };
        function getActivitiesCompletionCacheKey(courseid, userid) {
        return 'mmCourse:activitiescompletion:' + courseid + ':' + userid;
    }
        self.getModuleBasicInfo = function(moduleId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    cmid: moduleId
                },
                preSets = {
                    cacheKey: getModuleCacheKey(moduleId)
                };
            return site.read('core_course_get_course_module', params, preSets).then(function(response) {
                if (response.cm && (!response.warnings || !response.warnings.length)) {
                    return response.cm;
                }
                return $q.reject();
            });
        });
    };
        self.getModuleBasicGradeInfo = function(moduleId, siteId) {
        return self.getModuleBasicInfo(moduleId, siteId).then(function(info) {
            var grade = {
                advancedgrading: info.advancedgrading || false,
                grade: info.grade || false,
                gradecat: info.gradecat || false,
                gradepass: info.gradepass || false,
                outcomes: info.outcomes || false,
                scale: info.scale || false
            };
            if (grade.grade !== false || grade.advancedgrading !== false || grade.outcomes !== false) {
                return grade;
            }
            return false;
        });
    };
        self.getModuleBasicInfoByInstance = function(id, module, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    instance: id,
                    module: module
                },
                preSets = {
                    cacheKey: getModuleByInstanceCacheKey(id, module)
                };
            return site.read('core_course_get_course_module_by_instance', params, preSets).then(function(response) {
                if (response.cm && (!response.warnings || !response.warnings.length)) {
                    return response.cm;
                }
                return $q.reject();
            });
        });
    };
        self.getModule = function(moduleId, courseId, sectionId, preferCache, ignoreCache, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!moduleId) {
            return $q.reject();
        }
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        var promise;
        if (!courseId) {
            promise = self.getModuleBasicInfo(moduleId, siteId).then(function(module) {
                return module.course;
            });
        } else {
            promise = $q.when(courseId);
        }
        return promise.then(function(cid) {
            courseId = cid;
            return $mmSitesManager.getSite(siteId);
        }).then(function(site) {
            $log.debug('Getting module ' + moduleId + ' in course ' + courseId);
            params = {
                courseid: courseId,
                options: [
                    {
                        name: 'cmid',
                        value: moduleId
                    }
                ]
            };
            preSets = {
                cacheKey: getModuleCacheKey(moduleId),
                omitExpires: preferCache
            };
            if (!preferCache && ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            if (sectionId) {
                params.options.push({
                    name: 'sectionid',
                    value: sectionId
                });
            }
            return site.read('core_course_get_contents', params, preSets).catch(function() {
                return self.getSections(courseId, false, false, preSets, siteId);
            }).then(function(sections) {
                var section,
                    module;
                for (var i = 0; i < sections.length; i++) {
                    section = sections[i];
                    for (var j = 0; j < section.modules.length; j++) {
                        module = section.modules[j];
                        if (module.id == moduleId) {
                            module.course = courseId;
                            return addContentsIfNeeded(module);
                        }
                    }
                }
                return $q.reject();
            });
        });
    };
        function getModuleByInstanceCacheKey(id, module) {
        return 'mmCourse:moduleByInstance:' + module + ':' + id;
    }
        function getModuleCacheKey(moduleid) {
        return 'mmCourse:module:' + moduleid;
    }
        self.getModuleIconSrc = function(moduleName) {
        if (mods.indexOf(moduleName) < 0) {
            moduleName = "external-tool";
        }
        return "img/mod/" + moduleName + ".svg";
    };
        self.getModuleSectionId = function(moduleId, courseId, siteId) {
        if (!moduleId) {
            return $q.reject();
        }
        return self.getModuleBasicInfo(moduleId, siteId).then(function(module) {
            return module.section;
        }).catch(function() {
            if (!courseId) {
                return $q.reject();
            }
            return self.getSections(courseId, false, true, {}, siteId).then(function(sections) {
                for (var i = 0, seclen = sections.length; i < seclen; i++) {
                    var section = sections[i];
                    for (var j = 0, modlen = section.modules.length; j < modlen; j++) {
                        if (section.modules[j].id == moduleId) {
                            return section.id;
                        }
                    }
                }
                return $q.reject();
            });
        });
    };
        self.getSection = function(courseId, excludeModules, excludeContents, sectionId) {
        if (sectionId < 0) {
            return $q.reject('Invalid section ID');
        }
        return self.getSections(courseId, excludeModules, excludeContents).then(function(sections) {
            for (var i = 0; i < sections.length; i++) {
                if (sections[i].id == sectionId) {
                    return sections[i];
                }
            }
            return $q.reject('Unkown section');
        });
    };
        self.getSections = function(courseId, excludeModules, excludeContents, preSets, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            preSets = preSets || {};
            preSets.cacheKey = getSectionsCacheKey(courseId);
            preSets.getCacheUsingCacheKey = true;
            var options = [
                    {
                        name: 'excludemodules',
                        value: excludeModules ? 1 : 0
                    },
                    {
                        name: 'excludecontents',
                        value: excludeContents ? 1 : 0
                    }
                ];
            return site.read('core_course_get_contents', {
                courseid: courseId,
                options: options
            }, preSets).then(function(sections) {
                var siteHomeId = site.getSiteHomeId(),
                    showSections = true;
                if (courseId == siteHomeId) {
                    showSections = site.getStoredConfig('numsections');
                }
                if (typeof showSections != 'undefined' && !showSections && sections.length > 0) {
                    sections.pop();
                }
                angular.forEach(sections, function(section) {
                    angular.forEach(section.modules, function(module) {
                        addContentsIfNeeded(module);
                    });
                });
                return sections;
            });
        });
    };
        function getSectionsCacheKey(courseid) {
        return 'mmCourse:sections:' + courseid;
    }
        self.invalidateModule = function(moduleId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getModuleCacheKey(moduleId));
        });
    };
        self.invalidateModuleByInstance = function(id, module, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getModuleByInstanceCacheKey(id, module));
        });
    };
        self.invalidateSections = function(courseId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [],
                siteHomeId = site.getSiteHomeId();
            userId = userId || site.getUserId();
            promises.push(site.invalidateWsCacheForKey(getSectionsCacheKey(courseId)));
            promises.push(site.invalidateWsCacheForKey(getActivitiesCompletionCacheKey(courseId, userId)));
            if (courseId == siteHomeId) {
                promises.push(site.invalidateConfig());
            }
            return $q.all(promises);
        });
    };
        self.loadModuleContents = function(module, courseId, sectionId, preferCache, ignoreCache, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!ignoreCache && module.contents && module.contents.length) {
            return $q.when();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (site.isVersionGreaterEqualThan('2.9')) {
                return self.getModule(module.id, courseId, sectionId, preferCache, ignoreCache, siteId).then(function(mod) {
                    module.contents = mod.contents;
                });
            }
        });
    };
        self.logView = function(courseId, section) {
        var params = {
            courseid: courseId
        };
        if (typeof section != 'undefined') {
            params.sectionnumber = section;
        }
        return $mmSite.write('core_course_view_course', params).then(function(response) {
            if (!response.status) {
                return $q.reject();
            }
        });
    };
        self.translateModuleName = function(moduleName) {
        if (mods.indexOf(moduleName) < 0) {
            moduleName = "external-tool";
        }
        var langKey = 'mm.core.mod_' + moduleName,
            translated = $translate.instant(langKey);
        return translated !== langKey ? translated : moduleName;
    };
    return self;
}]);

angular.module('mm.core.course')
.provider('$mmCourseDelegate', function() {
    var contentHandlers = {},
        self = {};
        self.registerContentHandler = function(addon, handles, handler) {
        if (typeof contentHandlers[handles] !== 'undefined') {
            console.log("$mmCourseDelegateProvider: Addon '" + contentHandlers[handles].addon + "' already registered as handler for '" + handles + "'");
            return false;
        }
        console.log("$mmCourseDelegateProvider: Registered addon '" + addon + "' as course content handler.");
        contentHandlers[handles] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", "$mmCourseContentHandler", function($q, $log, $mmSite, $mmUtil, $mmCourseContentHandler) {
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart = {};
        $log = $log.getInstance('$mmCourseDelegate');
                self.getContentHandlerControllerFor = function(handles, module, courseid, sectionid) {
            if (typeof enabledHandlers[handles] !== 'undefined') {
                return enabledHandlers[handles].getController(module, courseid, sectionid);
            }
            return $mmCourseContentHandler.getController(module, courseid, sectionid);
        };
                self.hasContentHandler = function(handles) {
            return typeof contentHandlers[handles] !== 'undefined';
        };
                self.isModuleDisabled = function(handles, siteId) {
            return $mmSitesManager.getSite(siteId).then(function(site) {
                return self.isModuleDisabledInSite(handles, site);
            });
        };
                self.isModuleDisabledInSite = function(handles, site) {
            site = site || $mmSite;
            if (typeof contentHandlers[handles] !== 'undefined') {
                return site.isFeatureDisabled('$mmCourseDelegate_' + contentHandlers[handles].addon);
            }
            return false;
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateContentHandler = function(handles, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmCourseDelegate_' + handlerInfo.addon)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[handles] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[handles];
                    }
                }
            });
        };
                self.updateContentHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating content handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(contentHandlers, function(handlerInfo, handles) {
                promises.push(self.updateContentHandler(handles, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.course')
.factory('$mmCourseHelper', ["$q", "$mmCoursePrefetchDelegate", "$mmFilepool", "$mmUtil", "$mmCourse", "$mmSite", "$state", "$mmText", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreDownloading", "mmCoreCourseAllSectionsId", "$mmSitesManager", "$mmAddonManager", "$controller", "$mmCourseDelegate", "$translate", "$mmEvents", "mmCoreEventPackageStatusChanged", function($q, $mmCoursePrefetchDelegate, $mmFilepool, $mmUtil, $mmCourse, $mmSite, $state, $mmText,
            mmCoreNotDownloaded, mmCoreOutdated, mmCoreDownloading, mmCoreCourseAllSectionsId, $mmSitesManager, $mmAddonManager,
            $controller, $mmCourseDelegate, $translate, $mmEvents, mmCoreEventPackageStatusChanged) {
    var self = {},
        calculateSectionStatus = false;
        self.isDownloadSectionsEnabled = function() {
        return calculateSectionStatus;
    };
        self.setDownloadSectionsEnabled = function(status) {
        calculateSectionStatus = status;
        return calculateSectionStatus;
    };
        self.calculateSectionStatus = function(section, courseid, restoreDownloads, refresh, dwnpromises) {
        if (section.id !== mmCoreCourseAllSectionsId) {
            return $mmCoursePrefetchDelegate.getModulesStatus(section.id, section.modules, courseid, refresh, restoreDownloads)
                    .then(function(result) {
                var downloadid = self.getSectionDownloadId(section);
                if ($mmCoursePrefetchDelegate.isBeingDownloaded(downloadid)) {
                    result.status = mmCoreDownloading;
                }
                section.showDownload = result.status === mmCoreNotDownloaded;
                section.showRefresh = result.status === mmCoreOutdated;
                if (result.status !== mmCoreDownloading) {
                    section.isDownloading = false;
                    section.total = 0;
                } else if (!restoreDownloads) {
                    section.count = 0;
                    section.total = result[mmCoreOutdated].length + result[mmCoreNotDownloaded].length +
                                    result[mmCoreDownloading].length;
                    section.isDownloading = true;
                } else {
                    var promise = self.startOrRestorePrefetch(section, result, courseid).then(function(prevented) {
                        if (prevented !== true) {
                            return self.calculateSectionStatus(section, courseid);
                        }
                    });
                    if (dwnpromises) {
                        dwnpromises.push(promise);
                    }
                }
                return result;
            });
        }
        return $q.reject();
    };
        self.calculateSectionsStatus = function(sections, courseid, restoreDownloads, refresh) {
        var allsectionssection,
            allsectionsstatus,
            downloadpromises = [],
            statuspromises = [];
        angular.forEach(sections, function(section) {
            if (section.id === mmCoreCourseAllSectionsId) {
                allsectionssection = section;
                section.isCalculating = true;
            } else {
                section.isCalculating = true;
                statuspromises.push(self.calculateSectionStatus(section, courseid, restoreDownloads, refresh, downloadpromises)
                        .then(function(result) {
                    allsectionsstatus = $mmFilepool.determinePackagesStatus(allsectionsstatus, result.status);
                }).finally(function() {
                    section.isCalculating = false;
                }));
            }
        });
        return $q.all(statuspromises).then(function() {
            if (allsectionssection) {
                allsectionssection.showDownload = allsectionsstatus === mmCoreNotDownloaded;
                allsectionssection.showRefresh = allsectionsstatus === mmCoreOutdated;
                allsectionssection.isDownloading = allsectionsstatus === mmCoreDownloading;
            }
            return downloadpromises;
        }).finally(function() {
            if (allsectionssection) {
                allsectionssection.isCalculating = false;
            }
        });
    };
        self.confirmDownloadSize = function(courseid, section, sections) {
        var sizePromise;
        if (section.id != mmCoreCourseAllSectionsId) {
            sizePromise = $mmCoursePrefetchDelegate.getDownloadSize(section.modules, courseid);
        } else {
            var promises = [],
                results = {
                    size: 0,
                    total: true
                };
            angular.forEach(sections, function(s) {
                if (s.id != mmCoreCourseAllSectionsId) {
                    promises.push($mmCoursePrefetchDelegate.getDownloadSize(s.modules, courseid).then(function(sectionsize) {
                        results.total = results.total && sectionsize.total;
                        results.size += sectionsize.size;
                    }));
                }
            });
            sizePromise = $q.all(promises).then(function() {
                return results;
            });
        }
        return sizePromise.then(function(size) {
            return $mmUtil.confirmDownloadSize(size);
        });
    };
        self.getModuleCourseIdByInstance = function(id, module, siteId) {
        return $mmCourse.getModuleBasicInfoByInstance(id, module, siteId).then(function(cm) {
            return cm.course;
        }).catch(function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.course.errorgetmodule', true);
            }
            return $q.reject();
        });
    };
        self.getModulePrefetchInfo = function(module, courseId, invalidateCache) {
        var moduleInfo = {
                size: false,
                sizeReadable: false,
                timemodified: false,
                timemodifiedReadable: false,
                status: false,
                statusIcon: false
            },
            promises = [];
        if (typeof invalidateCache != "undefined" && invalidateCache) {
            $mmCoursePrefetchDelegate.invalidateModuleStatusCache(module);
        }
        promises.push($mmCoursePrefetchDelegate.getModuleDownloadedSize(module, courseId).then(function(moduleSize) {
            moduleInfo.size = moduleSize;
            moduleInfo.sizeReadable = $mmText.bytesToSize(moduleSize, 2);
        }));
        promises.push($mmCoursePrefetchDelegate.getModuleTimemodified(module, courseId).then(function(moduleModified) {
            moduleInfo.timemodified = moduleModified;
            if (moduleModified > 0) {
                var now = $mmUtil.timestamp();
                if (now - moduleModified < 7 * 86400) {
                    moduleInfo.timemodifiedReadable = moment(moduleModified * 1000).fromNow();
                } else {
                    moduleInfo.timemodifiedReadable = moment(moduleModified * 1000).calendar();
                }
            } else {
                moduleInfo.timemodifiedReadable = "";
            }
        }));
        promises.push($mmCoursePrefetchDelegate.getModuleStatus(module, courseId).then(function(moduleStatus) {
            moduleInfo.status = moduleStatus;
            switch (moduleStatus) {
                case mmCoreNotDownloaded:
                    moduleInfo.statusIcon = 'ion-ios-cloud-download-outline';
                    break;
                case mmCoreDownloading:
                    moduleInfo.statusIcon = 'spinner';
                    break;
                case mmCoreOutdated:
                    moduleInfo.statusIcon = 'ion-android-refresh';
                    break;
                default:
                    moduleInfo.statusIcon = "";
                    break;
            }
        }));
        return $q.all(promises).then(function () {
            return moduleInfo;
        });
    };
        self.getSectionDownloadId = function(section) {
        return 'Section-'+section.id;
    };
        self.getSectionsModules = function(sections) {
        if (!sections || !sections.length) {
            return [];
        }
        var modules = [];
        sections.forEach(function(section) {
            if (section.modules) {
                modules = modules.concat(section.modules);
            }
        });
        return modules;
    };
        self.addContentHandlerControllerForSectionModules = function(sections, courseId, moduleId, completionStatus, scope) {
        var hasContent = false;
        angular.forEach(sections, function(section) {
            if (!section || !self.sectionHasContent(section)) {
                return;
            }
            hasContent = true;
            angular.forEach(section.modules, function(module) {
                module._controller =
                        $mmCourseDelegate.getContentHandlerControllerFor(module.modname, module, courseId, section.id);
                if (completionStatus && typeof completionStatus[module.id] != 'undefined') {
                    module.completionstatus = completionStatus[module.id];
                }
                if (module.id == moduleId) {
                    var newScope = scope.$new();
                    $controller(module._controller, {$scope: newScope});
                    if (newScope.action) {
                        newScope.action();
                    }
                    newScope.$destroy();
                }
            });
        });
        return hasContent;
    }
        self.navigateToModule = function(moduleId, siteId, courseId, sectionId) {
        siteId = siteId || $mmSite.getId();
        var modal = $mmUtil.showModalLoading(),
            promise;
        return $mmCourse.canGetModuleWithoutCourseId(siteId).then(function(enabled) {
            if (courseId && sectionId) {
                promise = $q.when();
            } else if (!courseId && !enabled) {
                promise = $q.reject();
            } else if (!courseId) {
                promise = $mmCourse.getModuleBasicInfo(moduleId, siteId).then(function(module) {
                    courseId = module.course;
                    sectionId = module.section;
                });
            } else {
                promise = $mmCourse.getModuleSectionId(moduleId, courseId, siteId).then(function(id) {
                    sectionId = id;
                });
            }
            return promise.then(function() {
                return $mmSitesManager.getSite(siteId);
            }).then(function(site) {
                if (courseId == site.getSiteHomeId()) {
                    var $mmaFrontpage = $mmAddonManager.get('$mmaFrontpage');
                    if ($mmaFrontpage && !$mmaFrontpage.isDisabledInSite(site)) {
                        return $mmaFrontpage.isFrontpageAvailable().then(function() {
                            return $state.go('redirect', {
                                siteid: siteId,
                                state: 'site.frontpage',
                                params: {
                                    moduleid: moduleId
                                }
                            });
                        });
                    }
                } else {
                    return $state.go('redirect', {
                        siteid: siteId,
                        state: 'site.mm_course',
                        params: {
                            courseid: courseId,
                            moduleid: moduleId,
                            sid: sectionId
                        }
                    });
                }
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.course.errorgetmodule', true);
            return $q.reject();
        }).finally(function() {
            modal.dismiss();
        });
    };
        self.prefetch = function(section, courseid, sections) {
        if (section.id != mmCoreCourseAllSectionsId) {
            return self.prefetchSection(section, courseid, true, sections);
        } else {
            var promises = [];
            section.isDownloading = true;
            angular.forEach(sections, function(s) {
                if (s.id != mmCoreCourseAllSectionsId) {
                    promises.push(self.prefetchSection(s, courseid, false, sections).then(function() {
                        return self.calculateSectionStatus(s, courseid);
                    }));
                }
            });
            return $mmUtil.allPromises(promises);
        }
    };
        self.prefetchModule = function(scope, service, module, size, refresh, courseId) {
        return $mmUtil.confirmDownloadSize(size).then(function() {
            var promise = refresh ? service.invalidateContent(module.id, courseId) : $q.when();
            return promise.catch(function() {
            }).then(function() {
                var promise;
                if (service.prefetch) {
                    promise = service.prefetch(module, courseId);
                } else if (service.prefetchContent) {
                    promise = service.prefetchContent(module, courseId);
                } else {
                    return $q.reject();
                }
                return promise.catch(function() {
                    if (!scope.$$destroyed) {
                        $mmUtil.showErrorModal('mm.core.errordownloading', true);
                    }
                });
            });
        });
    };
        self.prefetchSection = function(section, courseid, singleDownload, sections) {
        if (section.id == mmCoreCourseAllSectionsId) {
            return $q.when();
        }
        section.isDownloading = true;
        return $mmCoursePrefetchDelegate.getModulesStatus(section.id, section.modules, courseid).then(function(result) {
            if (result.status === mmCoreNotDownloaded || result.status === mmCoreOutdated || result.status === mmCoreDownloading) {
                var promise = self.startOrRestorePrefetch(section, result, courseid);
                if (singleDownload) {
                    self.calculateSectionsStatus(sections, courseid, false);
                }
                return promise;
            }
        }, function() {
            section.isDownloading = false;
            return $q.reject();
        });
    };
        self.startOrRestorePrefetch = function(section, status, courseid) {
        if (section.id == mmCoreCourseAllSectionsId) {
            return $q.when(true);
        }
        if (section.total > 0) {
            return $q.when(true);
        }
        var modules = status[mmCoreOutdated].concat(status[mmCoreNotDownloaded]).concat(status[mmCoreDownloading]),
            downloadid = self.getSectionDownloadId(section);
        section.count = 0;
        section.total = modules.length;
        section.dwnModuleIds = modules.map(function(m) {
            return m.id;
        });
        section.isDownloading = true;
        return $mmCoursePrefetchDelegate.prefetchAll(downloadid, modules, courseid).then(function() {}, function() {
            return $q.reject();
        }, function(id) {
            var index = section.dwnModuleIds.indexOf(id);
            if (index > -1) {
                section.dwnModuleIds.splice(index, 1);
                section.count++;
            }
        });
    };
        self.sectionHasContent = function(section) {
        return !section.hiddenbynumsections  && (section.summary != '' || section.modules.length);
    };
        self.confirmAndRemove = function(module, courseId) {
        return $mmUtil.showConfirm($translate('mm.course.confirmdeletemodulefiles')).then(function() {
            return $mmCoursePrefetchDelegate.removeModuleFiles(module, courseId);
        });
    };
        self.contextMenuPrefetch = function(scope, module, courseId) {
        var icon = scope.prefetchStatusIcon;
        scope.prefetchStatusIcon = 'spinner';
        return $mmCoursePrefetchDelegate.getModuleDownloadSize(module, courseId).then(function(size) {
            return $mmUtil.confirmDownloadSize(size).then(function() {
                return $mmCoursePrefetchDelegate.prefetchModule(module, courseId).catch(function() {
                    return failPrefetch(!scope.$$destroyed);
                });
            }, function() {
                scope.prefetchStatusIcon = icon;
                return failPrefetch(false);
            });
        }, function(error) {
            return failPrefetch(true, error);
        });
        function failPrefetch(showError, error) {
            scope.prefetchStatusIcon = icon;
            if (showError) {
                $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
            }
            return $q.reject();
        }
    };
        self.fillContextMenu = function(scope, module, courseId, invalidateCache, component) {
        return self.getModulePrefetchInfo(module, courseId, invalidateCache).then(function(moduleInfo) {
            scope.size = moduleInfo.size > 0 ? moduleInfo.sizeReadable : 0;
            scope.prefetchStatusIcon = moduleInfo.statusIcon;
            if (moduleInfo.timemodified > 0) {
                scope.timemodified = $translate.instant('mm.core.lastmodified') + ': ' + moduleInfo.timemodifiedReadable;
            } else {
                scope.timemodified = $translate.instant('mm.core.download');
            }
            if (typeof scope.statusObserver == 'undefined' && component) {
                scope.statusObserver = $mmEvents.on(mmCoreEventPackageStatusChanged, function(data) {
                    if (data.siteid === $mmSite.getId() && data.componentId === module.id && data.component === component) {
                        self.fillContextMenu(scope, module, courseId, false, component);
                    }
                });
                scope.$on('$destroy', function() {
                    scope.statusObserver && scope.statusObserver.off && scope.statusObserver.off();
                });
            }
        });
    };
    return self;
}])
.run(["$mmEvents", "mmCoreEventLogout", "$mmCourseHelper", function($mmEvents, mmCoreEventLogout, $mmCourseHelper) {
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmCourseHelper.setDownloadSectionsEnabled(false);
    });
}]);
angular.module('mm.core')
.provider('$mmCoursePrefetchDelegate', function() {
    var prefetchHandlers = {},
        self = {};
        self.registerPrefetchHandler = function(addon, handles, handler) {
        if (typeof prefetchHandlers[handles] !== 'undefined') {
            console.log("$mmCoursePrefetchDelegateProvider: Addon '" + prefetchHandlers[handles].addon +
                            "' already registered as handler for '" + handles + "'");
            return false;
        }
        console.log("$mmCoursePrefetchDelegateProvider: Registered addon '" + addon + "' as prefetch handler.");
        prefetchHandlers[handles] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", "$mmFilepool", "$mmEvents", "$mmCourse", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreNotDownloadable", "mmCoreEventSectionStatusChanged", "$mmFS", "md5", function($q, $log, $mmSite, $mmUtil, $mmFilepool, $mmEvents, $mmCourse, mmCoreDownloaded, mmCoreDownloading,
                mmCoreNotDownloaded, mmCoreOutdated, mmCoreNotDownloadable, mmCoreEventSectionStatusChanged, $mmFS, md5) {
        var enabledHandlers = {},
            self = {},
            deferreds = {},
            lastUpdateHandlersStart,
            courseUpdatesPromises = {};
        $log = $log.getInstance('$mmCoursePrefetchDelegate');
                self.canCheckUpdates = function() {
            return $mmSite.wsAvailable('core_course_check_updates');
        };
                 self.canModuleUseCheckUpdates = function(module, courseId) {
            var handler = enabledHandlers[module.modname];
            if (!handler) {
                return $q.when(false);
            }
            if (handler.canUseCheckUpdates) {
                return $q.when(handler.canUseCheckUpdates(module, courseId));
            }
            return $q.when(true);
        };
                self.clearStatusCache = function() {
            statusCache.clear();
        };
                self.invalidateModuleStatusCache = function(module) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                statusCache.invalidate(handler.component, module.id);
            }
        };
        var statusCache = new function() {
            var cacheStore = {};
            this.clear = function() {
                cacheStore = {};
            };
                        this.get = function(component, componentId) {
                var packageId = $mmFilepool.getPackageId(component, componentId);
                if (!cacheStore[packageId]) {
                    cacheStore[packageId] = {};
                }
                return cacheStore[packageId];
            };
                        this.getValue = function(component, componentId, name, ignoreInvalidate) {
                var cache = this.get(component, componentId);
                if (cache[name] && typeof cache[name].value != "undefined") {
                    var now = new Date().getTime();
                    if (ignoreInvalidate || cache[name].lastupdate + 300000 >= now) {
                        return cache[name].value;
                    }
                }
                return undefined;
            };
                        this.setValue = function(component, componentId, name, value) {
                var cache = this.get(component, componentId);
                cache[name] = {
                    value: value,
                    lastupdate: new Date().getTime()
                };
                return value;
            };
                        this.invalidate = function(component, componentId) {
                var cache = this.get(component, componentId);
                angular.forEach(cache, function(entry) {
                    entry.lastupdate = 0;
                });
            };
        };
                self.determineModuleStatus = function(module, status, restoreDownloads, canCheck) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                if (status == mmCoreDownloading && restoreDownloads) {
                    if (!$mmFilepool.getPackageDownloadPromise($mmSite.getId(), handler.component, module.id)) {
                        handler.prefetch(module);
                    }
                } else if (handler.determineStatus) {
                    return handler.determineStatus(status, canCheck);
                }
            }
            return status;
        };
                function getCourseUpdatesCacheKey(courseId) {
            return 'mmCourse:courseUpdates:' + courseId;
        }
                function createToCheckList(modules, courseId) {
            var result = {
                    toCheck: [],
                    cannotUse: []
                },
                promises = [];
            angular.forEach(modules, function(module) {
                promises.push(getModuleStatusAndDownloadTime(module, courseId).then(function(data) {
                    if (data.status == mmCoreDownloaded) {
                        return self.canModuleUseCheckUpdates(module, courseId).then(function(canUse) {
                            if (canUse) {
                                result.toCheck.push({
                                    contextlevel: 'module',
                                    id: module.id,
                                    since: data.downloadtime || 0
                                });
                            } else {
                                result.cannotUse.push(module);
                            }
                        });
                    }
                }).catch(function() {
                }));
            });
            return $q.all(promises).then(function() {
                result.toCheck.sort(function (a, b) {
                    return a.id > b.id;
                });
                return result;
            });
        }
                function getModuleStatusAndDownloadTime(module, courseId) {
            var handler = enabledHandlers[module.modname],
                siteId = $mmSite.getId();
            if (handler) {
                return self.isModuleDownloadable(module, courseId).then(function(downloadable) {
                    if (!downloadable) {
                        return {
                            status: mmCoreNotDownloadable
                        };
                    }
                    var status = statusCache.getValue(handler.component, module.id, 'status');
                    if (typeof status != 'undefined' && status != mmCoreDownloaded) {
                        return {
                            status: status
                        };
                    }
                    return $mmFilepool.getPackageData(siteId, handler.component, module.id).then(function(data) {
                        var time = typeof data.downloadtime != 'undefined' ? data.downloadtime : data.timemodified;
                        return {
                            status: data.status,
                            downloadtime: time
                        };
                    });
                });
            }
            return $q.when({
                status: mmCoreNotDownloadable
            });
        }
                self.getCourseUpdates = function(modules, courseId) {
            if (!self.canCheckUpdates()) {
                return $q.reject();
            }
            var id = md5.createHash(courseId + '#' + JSON.stringify(modules)),
                siteId = $mmSite.getId(),
                promise;
            if (courseUpdatesPromises[siteId] && courseUpdatesPromises[siteId][id]) {
                return courseUpdatesPromises[siteId][id];
            } else if (!courseUpdatesPromises[siteId]) {
                courseUpdatesPromises[siteId] = {};
            }
            promise = createToCheckList(modules, courseId).then(function(data) {
                var result = {},
                    params,
                    preSets;
                angular.forEach(data.cannotUse, function(module) {
                    result[module.id] = false;
                });
                if (!data.toCheck.length) {
                    return result;
                }
                params = {
                    courseid: courseId,
                    tocheck: data.toCheck
                };
                preSets = {
                    cacheKey: getCourseUpdatesCacheKey(courseId),
                    getEmergencyCacheUsingCacheKey: true,
                    uniqueCacheKey: true
                };
                return $mmSite.read('core_course_check_updates', params, preSets).then(function(response) {
                    if (!response || typeof response.instances == 'undefined') {
                        return $q.reject();
                    }
                    angular.forEach(response.instances, function(instance) {
                        result[instance.id] = instance;
                    });
                    angular.forEach(response.warnings, function(warning) {
                        if (warning.warningcode == 'missingcallback') {
                            result[warning.itemid] = false;
                        }
                    });
                    return result;
                });
            }).finally(function() {
                delete courseUpdatesPromises[siteId][id];
            });
            courseUpdatesPromises[siteId][id] = promise;
            return promise;
        };
                self.getCourseUpdatesByCourseId = function(courseId) {
            if (!self.canCheckUpdates()) {
                return $q.reject();
            }
            return $mmCourse.getSections(courseId, false, true, {omitExpires: true}).then(function(sections) {
                var modules = [];
                angular.forEach(sections, function(section) {
                    if (section.modules) {
                        modules = modules.concat(section.modules);
                    }
                });
                return self.getCourseUpdates(modules, courseId);
            });
        };
                self.invalidateCourseUpdates = function(courseId) {
            return $mmSite.invalidateWsCacheForKey(getCourseUpdatesCacheKey(courseId));
        };
                self.getDownloadSize = function(modules, courseid) {
            var promises = [],
                results = {
                    size: 0,
                    total: true
                };
            angular.forEach(modules, function(module) {
                promises.push(self.getModuleStatus(module, courseid).then(function(modstatus) {
                    if (modstatus === mmCoreNotDownloaded || modstatus === mmCoreOutdated) {
                        return self.getModuleDownloadSize(module, courseid).then(function(modulesize) {
                            results.total = results.total && modulesize.total;
                            results.size += modulesize.size;
                        });
                    }
                    return $q.when();
                }));
            });
            return $q.all(promises).then(function() {
                return results;
            });
        };
                self.prefetchModule = function(module, courseid) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                return handler.prefetch(module, courseid);
            }
            return $q.when();
        };
                self.getModuleDownloadSize = function(module, courseid) {
            var downloadSize,
                handler = enabledHandlers[module.modname];
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    if (!downloadable) {
                        return;
                    }
                    downloadSize = statusCache.getValue(handler.component, module.id, 'downloadSize');
                    if (typeof downloadSize != 'undefined') {
                        return downloadSize;
                    }
                    return $q.when(handler.getDownloadSize(module, courseid)).then(function(size) {
                        return statusCache.setValue(handler.component, module.id, 'downloadSize', size);
                    }).catch(function() {
                        return statusCache.getValue(handler.component, module.id, 'downloadSize', true);
                    });
                });
            }
            return $q.when(0);
        };
                self.getModuleDownloadedSize = function(module, courseid) {
            var downloadedSize,
                handler = enabledHandlers[module.modname];
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    var promise;
                    if (!downloadable) {
                        return 0;
                    }
                    downloadedSize = statusCache.getValue(handler.component, module.id, 'downloadedSize');
                    if (typeof downloadedSize != 'undefined') {
                        return downloadedSize;
                    }
                    if (handler.getDownloadedSize) {
                        promise = $q.when(handler.getDownloadedSize(module, courseid));
                    } else {
                        promise = self.getModuleFiles(module, courseid).then(function(files) {
                            var siteId = $mmSite.getId(),
                                promises = [],
                                size = 0;
                            angular.forEach(files, function(file) {
                                promises.push($mmFilepool.getFilePathByUrl(siteId, file.fileurl).then(function(path) {
                                    return $mmFS.getFileSize(path).catch(function () {
                                        return $mmFilepool.isFileDownloadingByUrl(siteId, file.fileurl).then(function() {
                                            return file.filesize;
                                        }).catch(function() {
                                            return 0;
                                        });
                                    }).then(function(fs) {
                                        size += fs;
                                    });
                                }));
                            });
                            return $q.all(promises).then(function() {
                                return size;
                            });
                        });
                    }
                    return promise.then(function(size) {
                        return statusCache.setValue(handler.component, module.id, 'downloadedSize', size);
                    }).catch(function() {
                        return statusCache.getValue(handler.component, module.id, 'downloadedSize', true);
                    });
                });
            }
            return $q.when(0);
        };
                self.getModuleTimemodified = function(module, courseid, files) {
            var handler = enabledHandlers[module.modname],
                promise, timemodified;
            if (handler) {
                timemodified = statusCache.getValue(handler.component, module.id, 'timemodified');
                if (typeof timemodified != 'undefined') {
                    return $q.when(timemodified);
                }
                if (handler.getTimemodified) {
                    promise = handler.getTimemodified(module, courseid);
                } else {
                    promise = files ? $q.when(files) : self.getModuleFiles(module, courseid);
                    return promise.then(function(files) {
                        return $mmFilepool.getTimemodifiedFromFileList(files);
                    });
                }
                return $q.when(promise).then(function(timemodified) {
                    return statusCache.setValue(handler.component, module.id, 'timemodified', timemodified);
                }).catch(function() {
                    return statusCache.getValue(handler.component, module.id, 'timemodified', true);
                });
            }
            return $q.reject();
        };
                self.getModuleRevision = function(module, courseid, files) {
            var handler = enabledHandlers[module.modname],
                promise, revision;
            if (handler) {
                revision = statusCache.getValue(handler.component, module.id, 'revision');
                if (typeof revision != 'undefined') {
                    return $q.when(revision);
                }
                if (handler.getRevision) {
                    promise = handler.getRevision(module, courseid);
                } else {
                    promise = files ? $q.when(files) : self.getModuleFiles(module, courseid);
                    promise = promise.then(function(files) {
                        return $mmFilepool.getRevisionFromFileList(files);
                    });
                }
                return $q.when(promise).then(function(revision) {
                    return statusCache.setValue(handler.component, module.id, 'revision', revision);
                }).catch(function() {
                    return statusCache.getValue(handler.component, module.id, 'revision', true);
                });
            }
            return $q.reject();
        };
                self.getModuleFiles = function(module, courseId) {
            var handler = enabledHandlers[module.modname];
            module.contents = module.contents || [];
            if (handler.getFiles) {
                return $q.when(handler.getFiles(module, courseId));
            } else if (handler.loadContents) {
                return handler.loadContents(module, courseId).then(function() {
                    return module.contents;
                });
            } else {
                return $q.when(module.contents);
            }
        };
                self.removeModuleFiles = function(module, courseid) {
            var handler = enabledHandlers[module.modname],
                siteId = $mmSite.getId(),
                promise;
            if (handler && handler.removeFiles) {
                promise = handler.removeFiles(module, courseid);
            } else {
                promise = self.getModuleFiles(module, courseid).then(function(files) {
                    var promises = [];
                    angular.forEach(files, function(file) {
                        promises.push($mmFilepool.removeFileByUrl(siteId, file.fileurl).catch(function() {
                        }));
                    });
                    return $q.all(promises);
                });
            }
            return promise.then(function() {
                if (handler) {
                    statusCache.setValue(handler.component, module.id, 'downloadedSize', 0);
                    $mmFilepool.storePackageStatus(siteId, handler.component, module.id, mmCoreNotDownloaded);
                }
            });
        };
                self.getModuleStatus = function(module, courseid, revision, timemodified, updates) {
            var handler = enabledHandlers[module.modname],
                siteid = $mmSite.getId(),
                canCheck = self.canCheckUpdates();
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    if (!downloadable) {
                        return mmCoreNotDownloadable;
                    }
                    var status = statusCache.getValue(handler.component, module.id, 'status'),
                        promise;
                    if (typeof status != 'undefined') {
                        return self.determineModuleStatus(module, status, true, canCheck);
                    }
                    return $mmFilepool.getPackageCurrentStatus(siteid, handler.component, module.id).then(function(status) {
                        status = handler.determineStatus ? handler.determineStatus(status, canCheck) : status;
                        if (status == mmCoreNotDownloaded || status == mmCoreOutdated || status == mmCoreDownloading) {
                            self.updateStatusCache(handler.component, module.id, status);
                            return self.determineModuleStatus(module, status, true, canCheck);
                        }
                        if (typeof updates == 'undefined') {
                            promise = self.getCourseUpdatesByCourseId(courseid).then(function(updates) {
                                if (!updates || updates[module.id] === false) {
                                    return $q.reject();
                                }
                                return updates;
                            });
                        } else if (updates === false) {
                            promise = $q.reject();
                        } else {
                            promise = $q.when(updates);
                        }
                        return promise.then(function(updates) {
                            var hasUpdPrms = self.moduleHasUpdates(module, courseid, updates).then(function(hasUpdates) {
                                if (hasUpdates) {
                                    status = mmCoreOutdated;
                                    return $mmFilepool.storePackageStatus(siteid, handler.component, module.id, status)
                                            .catch(function() {
                                    }).then(function() {
                                        return status;
                                    });
                                } else {
                                    return status;
                                }
                            });
                            return getStatus(hasUpdPrms, true);
                        }, function() {
                            var revisionNeedsFiles = typeof revision == 'undefined' && !handler.getRevision &&
                                            typeof statusCache.getValue(handler.component, module.id, 'revision') == 'undefined',
                                timemodifiedNeedsFiles = typeof timemodified == 'undefined' && !handler.getTimemodified &&
                                            typeof statusCache.getValue(handler.component, module.id, 'timemodified') == 'undefined';
                            if (revisionNeedsFiles || timemodifiedNeedsFiles) {
                                promise = self.getModuleFiles(module, courseid);
                            } else {
                                promise = $q.when();
                            }
                            return promise.then(function(files) {
                                var promises = [];
                                if (typeof revision == 'undefined') {
                                    promises.push(self.getModuleRevision(module, courseid, files).then(function(rev) {
                                        revision = rev;
                                    }));
                                }
                                if (typeof timemodified == 'undefined') {
                                    promises.push(self.getModuleTimemodified(module, courseid, files).then(function(timemod) {
                                        timemodified = timemod;
                                    }));
                                }
                                return $q.all(promises).then(function() {
                                    var getStatusPromise = $mmFilepool.getPackageStatus(
                                            siteid, handler.component, module.id, revision, timemodified);
                                    return getStatus(getStatusPromise, false);
                                });
                            });
                        });
                    });
                });
            }
            return $q.when(mmCoreNotDownloadable);
            function getStatus(promise, canCheck) {
                return promise.then(function(status) {
                    self.updateStatusCache(handler.component, module.id, status);
                    return self.determineModuleStatus(module, status, true, canCheck);
                }).catch(function() {
                    var status = statusCache.getValue(handler.component, module.id, 'status', true);
                    return self.determineModuleStatus(module, status, true, canCheck);
                });
            }
        };
                self.getModulesStatus = function(sectionid, modules, courseid, refresh, restoreDownloads) {
            var promises = [],
                status = mmCoreNotDownloadable,
                result = {};
            result[mmCoreNotDownloaded] = [];
            result[mmCoreDownloaded] = [];
            result[mmCoreDownloading] = [];
            result[mmCoreOutdated] = [];
            result.total = 0;
            return self.getCourseUpdatesByCourseId(courseid).catch(function() {
                return false;
            }).then(function(updates) {
                angular.forEach(modules, function(module) {
                    var handler = enabledHandlers[module.modname],
                        promise,
                        canCheck = updates && updates[module.id] !== false;
                    module.contents = module.contents || [];
                    if (handler) {
                        var cacheStatus = statusCache.getValue(handler.component, module.id, 'status');
                        if (!refresh && typeof cacheStatus != 'undefined') {
                            promise = $q.when(self.determineModuleStatus(module, cacheStatus, restoreDownloads, canCheck));
                        } else {
                            promise = self.getModuleStatus(module, courseid, undefined, undefined, updates);
                        }
                        promises.push(
                            promise.then(function(modstatus) {
                                if (modstatus != mmCoreNotDownloadable) {
                                    statusCache.setValue(handler.component, module.id, 'sectionid', sectionid);
                                    self.updateStatusCache(handler.component, module.id, modstatus);
                                    status = $mmFilepool.determinePackagesStatus(status, modstatus);
                                    result[modstatus].push(module);
                                    result.total++;
                                }
                            }).catch(function() {
                                modstatus = statusCache.getValue(handler.component, module.id, 'status', true);
                                if (typeof modstatus == 'undefined') {
                                    return $q.reject();
                                }
                                if (modstatus != mmCoreNotDownloadable) {
                                    status = $mmFilepool.determinePackagesStatus(status, modstatus);
                                    result[modstatus].push(module);
                                    result.total++;
                                }
                            })
                        );
                    }
                });
                return $q.all(promises).then(function() {
                    result.status = status;
                    return result;
                });
            });
        };
                self.getPrefetchHandlerFor = function(handles) {
            return enabledHandlers[handles];
        };
                self.invalidateModules = function(modules, courseId) {
            var promises = [];
            angular.forEach(modules, function(module) {
                var handler = enabledHandlers[module.modname];
                if (handler) {
                    if (handler.invalidateModule) {
                        promises.push(handler.invalidateModule(module, courseId).catch(function() {
                        }));
                    }
                    statusCache.invalidate(handler.component, module.id);
                }
            });
            promises.push(self.invalidateCourseUpdates(courseId));
            return $q.all(promises);
        };
                self.isBeingDownloaded = function(id) {
            return deferreds[$mmSite.getId()] && deferreds[$mmSite.getId()][id];
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.isModuleDownloadable = function(module, courseid) {
            var handler = enabledHandlers[module.modname],
                promise;
            if (handler) {
                if (typeof handler.isDownloadable == 'function') {
                    var downloadable = statusCache.getValue(handler.component, module.id, 'downloadable');
                    if (typeof downloadable != 'undefined') {
                        promise = $q.when(downloadable);
                    } else {
                        promise = $q.when(handler.isDownloadable(module, courseid)).then(function(downloadable) {
                            statusCache.setValue(handler.component, module.id, 'downloadable', downloadable);
                            return downloadable;
                        });
                    }
                } else {
                    promise = $q.when(true);
                }
                return promise.catch(function() {
                    return false;
                });
            } else {
                return $q.when(false);
            }
        };
                self.moduleHasUpdates = function(module, courseId, updates) {
            var handler = enabledHandlers[module.modname],
                moduleUpdates = updates[module.id];
            if (handler && handler.hasUpdates) {
                return $q.when(handler.hasUpdates(module, courseId, moduleUpdates));
            } else if (!moduleUpdates || !moduleUpdates.updates || !moduleUpdates.updates.length) {
                return $q.when(false);
            } else if (handler && handler.updatesNames && handler.updatesNames.test) {
                for (var i = 0, len = moduleUpdates.updates.length; i < len; i++) {
                    if (handler.updatesNames.test(moduleUpdates.updates[i].name)) {
                        return $q.when(true);
                    }
                }
                return $q.when(false);
            }
            return $q.when(true);
        };
                self.prefetchAll = function(id, modules, courseid) {
            var siteid = $mmSite.getId();
            if (deferreds[siteid] && deferreds[siteid][id]) {
                return deferreds[siteid][id].promise;
            }
            var deferred = $q.defer(),
                promises = [];
            if (!deferreds[siteid]) {
                deferreds[siteid] = {};
            }
            deferreds[siteid][id] = deferred;
            angular.forEach(modules, function(module) {
                module.contents = module.contents || [];
                var handler = enabledHandlers[module.modname];
                if (handler) {
                    promises.push(self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                        if (!downloadable) {
                            return;
                        }
                        return handler.prefetch(module, courseid).then(function() {
                            deferred.notify(module.id);
                        });
                    }));
                }
            });
            $q.all(promises).then(function() {
                delete deferreds[siteid][id];
                deferred.resolve();
            }, function() {
                delete deferreds[siteid][id];
                deferred.reject();
            });
            return deferred.promise;
        };
                self.updatePrefetchHandler = function(handles, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[handles] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[handles];
                    }
                }
            });
        };
                self.updatePrefetchHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating prefetch handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(prefetchHandlers, function(handlerInfo, handles) {
                promises.push(self.updatePrefetchHandler(handles, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
                self.updateStatusCache = function(component, componentId, status) {
            var notify,
                cachedStatus = statusCache.getValue(component, componentId, 'status', true);
            notify = typeof cachedStatus != 'undefined' && cachedStatus !== status;
            if (notify) {
                var sectionId = statusCache.getValue(component, componentId, 'sectionid', true);
                statusCache.invalidate(component, componentId);
                statusCache.setValue(component, componentId, 'status', status);
                statusCache.setValue(component, componentId, 'sectionid', sectionId);
                $mmEvents.trigger(mmCoreEventSectionStatusChanged, {
                    sectionid: sectionId,
                    siteid: $mmSite.getId()
                });
            } else {
                statusCache.setValue(component, componentId, 'status', status);
            }
        };
        return self;
    }];
    return self;
})
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmCoursePrefetchDelegate", "$mmSite", "mmCoreEventPackageStatusChanged", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmCoursePrefetchDelegate, $mmSite,
            mmCoreEventPackageStatusChanged, mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmCoursePrefetchDelegate.clearStatusCache);
    $mmEvents.on(mmCoreEventPackageStatusChanged, function(data) {
        if (data.siteid === $mmSite.getId()) {
            $mmCoursePrefetchDelegate.updateStatusCache(data.component, data.componentId, data.status);
        }
    });
}]);

angular.module('mm.core.course')
.factory('$mmPrefetchFactory', ["$mmSite", "$mmFilepool", "$mmUtil", "$q", "$mmLang", "$mmApp", "mmCoreDownloading", "mmCoreDownloaded", "$mmCourse", function($mmSite, $mmFilepool, $mmUtil, $q, $mmLang, $mmApp, mmCoreDownloading, mmCoreDownloaded,
            $mmCourse) {
    var self = {},
        modulePrefetchHandler = (function () {
            var downloadPromises = {};
            this.component = 'core_module';
            this.isResource = false;
            this.updatesNames = /^.*files$/;
                        this.addOngoingDownload = function (id, promise, siteId) {
                var uniqueId = this.getUniqueId(id);
                siteId = siteId || $mmSite.getId();
                if (!downloadPromises[siteId]) {
                    downloadPromises[siteId] = {};
                }
                downloadPromises[siteId][uniqueId] = promise;
                return promise.finally(function() {
                    delete downloadPromises[siteId][uniqueId];
                });
            };
                        this.download = function(module, courseId) {
                return this.downloadOrPrefetch(module, courseId, false);
            };
                        this.downloadOrPrefetch = function(module, courseId, prefetch, dirPath) {
                if (!$mmApp.isOnline()) {
                    return $mmLang.translateAndReject('mm.core.networkerrormsg');
                }
                var siteId = $mmSite.getId(),
                    that = this;
                return that.loadContents(module, courseId, true).then(function() {
                    return that.getIntroFiles(module, courseId);
                }).then(function(introFiles) {
                    return that.getRevisionAndTimemodified(module, courseId, introFiles).then(function(data) {
                        var downloadFn = prefetch ? $mmFilepool.prefetchPackage : $mmFilepool.downloadPackage,
                            contentFiles = that.getContentDownloadableFiles(module),
                            promises = [];
                        if (dirPath) {
                            angular.forEach(introFiles, function(file) {
                                if (prefetch) {
                                    promises.push($mmFilepool.addToQueueByUrl(siteId, file.fileurl,
                                            that.component, module.id, file.timemodified));
                                } else {
                                    promises.push($mmFilepool.downloadUrl(siteId, file.fileurl, false,
                                            that.component, module.id, file.timemodified));
                                }
                            });
                            promises.push(downloadFn(siteId, contentFiles, that.component,
                                    module.id, data.revision, data.timemod, dirPath));
                        } else {
                            var files = introFiles.concat(contentFiles);
                            promises.push(downloadFn(siteId, files, that.component, module.id, data.revision, data.timemod));
                        }
                        return $q.all(promises);
                    });
                });
            };
                        this.getContentDownloadableFiles = function(module) {
                var files = [],
                    that = this;
                angular.forEach(module.contents, function(content) {
                    if (that.isFileDownloadable(content)) {
                        files.push(content);
                    }
                });
                return files;
            };
                        this.getDownloadSize = function(module, courseId) {
                return this.getFiles(module, courseId).then(function(files) {
                    return $mmUtil.sumFileSizes(files);
                }).catch(function() {
                    return {size: -1, total: false};
                });
            };
                        this.getDownloadedSize = function(module, courseId) {
                return $mmFilepool.getFilesSizeByComponent($mmSite.getId(), this.component, module.id);
            };
                        this.getDownloadingFilesEventNames = function(module, courseId) {
                var that = this,
                    siteId = $mmSite.getId();
                return that.loadContents(module, courseId).then(function() {
                    var promises = [],
                        eventNames = [];
                    angular.forEach(module.contents, function(content) {
                        var url = content.fileurl;
                        if (!that.isFileDownloadable(content)) {
                            return;
                        }
                        promises.push($mmFilepool.isFileDownloadingByUrl(siteId, url).then(function() {
                            return $mmFilepool.getFileEventNameByUrl(siteId, url).then(function(eventName) {
                                eventNames.push(eventName);
                            });
                        }).catch(function() {
                        }));
                    });
                    return $q.all(promises).then(function() {
                        return eventNames;
                    });
                });
            };
                        this.getFileEventNames = function(module, courseId) {
                var that = this,
                    siteId = $mmSite.getId();
                return that.loadContents(module, courseId).then(function() {
                    var promises = [];
                    angular.forEach(module.contents, function(content) {
                        var url = content.fileurl;
                        if (!that.isFileDownloadable(content)) {
                            return;
                        }
                        promises.push($mmFilepool.getFileEventNameByUrl(siteId, url));
                    });
                    return $q.all(promises);
                });
            };
                        this.getFiles = function(module, courseId) {
                var that = this;
                return that.loadContents(module, courseId).then(function() {
                    return that.getIntroFiles(module, courseId).then(function(files) {
                        return files.concat(that.getContentDownloadableFiles(module));
                    });
                });
            };
                        this.getIntroFiles = function(module, courseId) {
                return $q.when(this.getIntroFilesFromInstance(module));
            };
                        this.getIntroFilesFromInstance = function(module, instance) {
                if (instance) {
                    if (typeof instance.introfiles != 'undefined') {
                        return instance.introfiles;
                    } else if (instance.intro) {
                        return $mmUtil.extractDownloadableFilesFromHtmlAsFakeFileObjects(instance.intro);
                    }
                }
                if (module.description) {
                    return $q.when($mmUtil.extractDownloadableFilesFromHtmlAsFakeFileObjects(module.description));
                }
                return [];
            };
                        this.getOngoingDownload = function (id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isDownloading(id, siteId)) {
                    var uniqueId = this.getUniqueId(id);
                    return downloadPromises[siteId][uniqueId];
                }
                return $q.when();
            };
                        this.getRevision = function(module, courseId) {
                return this.getRevisionAndTimemodified(module, courseId).then(function(data) {
                    return data.revision;
                });
            };
                        this.getRevisionAndTimemodified = function(module, courseId, introFiles) {
                var that = this;
                return that.loadContents(module, courseId).then(function() {
                    var promise = introFiles ? $q.when(introFiles) : that.getIntroFiles(module, courseId);
                    return promise.then(function(files) {
                        files = files.concat(module.contents || []);
                        return {
                            timemod: $mmFilepool.getTimemodifiedFromFileList(files),
                            revision: $mmFilepool.getRevisionFromFileList(files)
                        };
                    });
                });
            };
                        this.getTimemodified = function(module, courseId) {
                return this.getRevisionAndTimemodified(module, courseId).then(function(data) {
                    return data.timemod;
                });
            };
                        this.getUniqueId = function(id) {
                return this.component + '#' + id;
            };
                        this.invalidateContent = function(moduleId) {
                var promises = [];
                promises.push($mmCourse.invalidateModule(moduleId));
                promises.push($mmFilepool.invalidateFilesByComponent($mmSite.getId(), this.component, moduleId));
                return $q.all(promises);
            };
                        this.invalidateModule = function(module, courseId) {
                return $mmCourse.invalidateModule(module.id);
            };
                        this.isDownloadable = function(module, courseId) {
                return $q.when(true);
            };
                        this.isDownloading = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var uniqueId = this.getUniqueId(id);
                return !!(downloadPromises[siteId] && downloadPromises[siteId][uniqueId]);
            };
                        this.isEnabled = function() {
                return $mmSite.canDownloadFiles();
            };
                        this.isFileDownloadable = function(file) {
                return file.type === 'file';
            };
                        this.loadContents = function(module, courseId, ignoreCache) {
                if (this.isResource) {
                    return $mmCourse.loadModuleContents(module, courseId, false, false, ignoreCache);
                }
                return $q.when();
            };
                        this.prefetch = function(module, courseId, single) {
                return this.downloadOrPrefetch(module, courseId, true);
            };
                        this.prefetchPackage = function(module, courseId, single, downloadFn, siteId) {
                siteId = siteId || $mmSite.getId();
                if (!$mmApp.isOnline()) {
                    return $mmLang.translateAndReject('mm.core.networkerrormsg');
                }
                var that = this,
                    prefetchPromise,
                    extraParams = Array.prototype.slice.call(arguments, 5);
                if (that.isDownloading(module.id, siteId)) {
                    return that.getOngoingDownload(module.id, siteId);
                }
                prefetchPromise = this.setDownloading(module.id, siteId).then(function() {
                    var params = [module, courseId, single, siteId].concat(extraParams);
                    return $q.when(downloadFn.apply(that, params));
                }).then(function(data) {
                    return that.setDownloaded(module.id, siteId, data.revision, data.timemod);
                }).catch(function(error) {
                    return that.setPreviousStatusAndReject(module.id, error, siteId);
                });
                return that.addOngoingDownload(module.id, prefetchPromise, siteId);
            };
                        this.setDownloaded = function(id, siteId, revision, timemod) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.storePackageStatus(siteId, this.component, id, mmCoreDownloaded, revision, timemod);
            };
                        this.setDownloading = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.storePackageStatus(siteId, this.component, id, mmCoreDownloading);
            };
                        this.setPreviousStatusAndReject = function(id, error, siteId) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.setPackagePreviousStatus(siteId, this.component, id).then(function() {
                    return $q.reject(error);
                });
            };
                        this.removeFiles = function(module, courseId) {
                return $mmFilepool.removeFilesByComponent($mmSite.getId(), this.component, module.id);
            };
            return this;
        }());
        self.createPrefetchHandler = function(component, isResource) {
        var child = Object.create(modulePrefetchHandler);
        child.component = component;
        child.isResource = !!isResource;
        return child;
    };
    return self;
}]);

angular.module('mm.core.courses')
.controller('mmCoursesAvailableCtrl', ["$scope", "$mmCourses", "$q", "$mmUtil", "$mmSite", function($scope, $mmCourses, $q, $mmUtil, $mmSite) {
    function loadCourses() {
        $scope.frontpageCourseId = $mmSite.getSiteHomeId();
        return $mmCourses.getCoursesByField().then(function(courses) {
            $scope.courses = courses;
        }).catch(function(message) {
            $mmUtil.showErrorModalDefault(message, 'mm.courses.errorloadcourses', true);
            return $q.reject();
        });
    }
    loadCourses().finally(function() {
        $scope.coursesLoaded = true;
    });
    $scope.refreshCourses = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCoursesByField());
        $q.all(promises).finally(function() {
            loadCourses().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.courses')
.controller('mmCourseCategoriesCtrl', ["$scope", "$stateParams", "$mmCourses", "$mmUtil", "$q", "$mmSite", function($scope, $stateParams, $mmCourses, $mmUtil, $q, $mmSite) {
    var categoryId = $stateParams.categoryid || 0;
    function fetchCategories() {
        return $mmCourses.getCategories(categoryId, true).then(function(cats) {
            $scope.currentCategory = false;
            angular.forEach(cats, function(cat, index) {
                if (cat.id == categoryId) {
                    $scope.currentCategory = cat;
                    delete cats[index];
                }
            });
            cats.sort(function(a,b) {
                if (a.depth == b.depth) {
                    return (a.sortorder > b.sortorder) ? 1 : ((b.sortorder > a.sortorder) ? -1 : 0);
                }
                return a.depth > b.depth ? 1 : -1;
            });
            $scope.categories = $mmUtil.formatTree(cats, 'parent', 'id', categoryId);
            if ($scope.currentCategory) {
                $scope.title = $scope.currentCategory.name;
                return $mmCourses.getCoursesByField('category', categoryId).then(function(courses) {
                    $scope.courses = courses;
                }, function(error) {
                    $mmUtil.showErrorModalDefault(error, 'mm.courses.errorloadcourses', true);
                });
            }
        }, function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.courses.errorloadcategories', true);
        });
    }
    fetchCategories().finally(function() {
        $scope.categoriesLoaded = true;
    });
    $scope.refreshCategories = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCategories(categoryId, true));
        promises.push($mmCourses.invalidateCoursesByField('category', categoryId));
        promises.push($mmSite.invalidateConfig());
        $q.all(promises).finally(function() {
            fetchCategories(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.courses')
.controller('mmCoursesListCtrl', ["$scope", "$mmCourses", "$mmCoursesDelegate", "$mmUtil", "$mmEvents", "$mmSite", "$q", "mmCoursesEventMyCoursesUpdated", "mmCoursesEventMyCoursesRefreshed", "mmCoreEventSiteUpdated", function($scope, $mmCourses, $mmCoursesDelegate, $mmUtil, $mmEvents, $mmSite, $q,
            mmCoursesEventMyCoursesUpdated, mmCoursesEventMyCoursesRefreshed, mmCoreEventSiteUpdated) {
    var updateSiteObserver,
        myCoursesObserver;
    $scope.searchEnabled = $mmCourses.isSearchCoursesAvailable() && !$mmCourses.isSearchCoursesDisabledInSite();
    $scope.areNavHandlersLoadedFor = $mmCoursesDelegate.areNavHandlersLoadedFor;
    $scope.filter = {};
    function fetchCourses(refresh) {
        return $mmCourses.getUserCourses().then(function(courses) {
            $scope.courses = courses;
            $scope.filter.filterText = '';
            return loadCoursesNavHandlers(refresh);
        }, function(error) {
            if (typeof error != 'undefined' && error !== '') {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.courses.errorloadcourses', true);
            }
        });
    }
    function loadCoursesNavHandlers(refresh) {
        var courseIds = $scope.courses.map(function(course) {
            return course.id;
        });
        return $mmCourses.getCoursesOptions(courseIds).then(function(options) {
            angular.forEach($scope.courses, function(course) {
                course._handlers = $mmCoursesDelegate.getNavHandlersFor(
                            course.id, refresh, options.navOptions[course.id], options.admOptions[course.id]);
            });
        });
    }
    fetchCourses().finally(function() {
        $scope.coursesLoaded = true;
    });
    $scope.refreshCourses = function() {
        var promises = [];
        $mmEvents.trigger(mmCoursesEventMyCoursesRefreshed);
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateUserNavigationOptions());
        promises.push($mmCourses.invalidateUserAdministrationOptions());
        $mmCoursesDelegate.clearCoursesHandlers();
        $q.all(promises).finally(function() {
            fetchCourses(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    myCoursesObserver = $mmEvents.on(mmCoursesEventMyCoursesUpdated, function(siteid) {
        if (siteid == $mmSite.getId()) {
            fetchCourses();
        }
    });
    updateSiteObserver = $mmEvents.on(mmCoreEventSiteUpdated, function(siteId) {
        if ($mmSite.getId() === siteId) {
            $scope.searchEnabled = $mmCourses.isSearchCoursesAvailable() && !$mmCourses.isSearchCoursesDisabledInSite();
        }
    });
    $scope.$on('$destroy', function() {
        myCoursesObserver && myCoursesObserver.off && myCoursesObserver.off();
        updateSiteObserver && updateSiteObserver.off && updateSiteObserver.off();
    });
}]);

angular.module('mm.core.courses')
.controller('mmCoursesSearchCtrl', ["$scope", "$mmCourses", "$q", "$mmUtil", function($scope, $mmCourses, $q, $mmUtil) {
    var page = 0,
    	currentSearch = '';
    $scope.searchText = '';
    function searchCourses(refresh) {
        if (refresh) {
            page = 0;
        }
        return $mmCourses.search(currentSearch, page).then(function(response) {
            if (page === 0) {
                $scope.courses = response.courses;
            } else {
                $scope.courses = $scope.courses.concat(response.courses);
            }
            $scope.total = response.total;
            page++;
            $scope.canLoadMore = $scope.courses.length < $scope.total;
        }).catch(function(message) {
            $scope.canLoadMore = false;
            $mmUtil.showErrorModalDefault(message, 'mm.courses.errorsearching', true);
            return $q.reject();
        });
    }
    $scope.search = function(text) {
        currentSearch = text;
        $scope.courses = undefined;
    	var modal = $mmUtil.showModalLoading('mm.core.searching', true);
    	searchCourses(true).finally(function() {
            modal.dismiss();
    	});
    };
    $scope.loadMoreResults = function() {
    	searchCourses();
    };
}]);

angular.module('mm.core.courses')
.controller('mmCoursesViewResultCtrl', ["$scope", "$stateParams", "$mmCourses", "$mmCoursesDelegate", "$mmUtil", "$translate", "$q", "$ionicModal", "$mmEvents", "$mmSite", "mmCoursesSearchComponent", "mmCoursesEnrolInvalidKey", "mmCoursesEventMyCoursesUpdated", "$timeout", function($scope, $stateParams, $mmCourses, $mmCoursesDelegate, $mmUtil, $translate, $q,
            $ionicModal, $mmEvents, $mmSite, mmCoursesSearchComponent, mmCoursesEnrolInvalidKey, mmCoursesEventMyCoursesUpdated,
            $timeout) {
    var course = angular.copy($stateParams.course || {}),
        selfEnrolWSAvailable = $mmCourses.isSelfEnrolmentEnabled(),
        guestWSAvailable = $mmCourses.isGuestWSAvailable(),
        isGuestEnabled = false,
        guestInstanceId,
        enrollmentMethods,
        waitStart = 0;
    $scope.course = course;
    $scope.component = mmCoursesSearchComponent;
    $scope.handlersShouldBeShown = true;
    $scope.selfEnrolInstances = [];
    $scope.enroldata = {
        password: ''
    };
    $scope.loadingHandlers = function() {
        return $scope.handlersShouldBeShown && !$mmCoursesDelegate.areNavHandlersLoadedFor(course.id);
    };
    function getCourse(refresh) {
        var promise;
        if (selfEnrolWSAvailable || guestWSAvailable) {
            $scope.selfEnrolInstances = [];
            promise = $mmCourses.getCourseEnrolmentMethods(course.id).then(function(methods) {
                enrollmentMethods = methods;
                angular.forEach(enrollmentMethods, function(method) {
                    if (selfEnrolWSAvailable && method.type === 'self') {
                        $scope.selfEnrolInstances.push(method);
                    } else if (guestWSAvailable && method.type === 'guest') {
                        isGuestEnabled = true;
                    }
                });
            }).catch(function(error) {
                if (error) {
                    $mmUtil.showErrorModal(error);
                }
            });
        } else {
            promise = $q.when();
        }
        return promise.then(function() {
            return $mmCourses.getUserCourse(course.id).then(function(c) {
                $scope.isEnrolled = true;
                return c;
            }).catch(function() {
                $scope.isEnrolled = false;
                return $mmCourses.getCourse(course.id);
            }).then(function(c) {
                course.fullname = c.fullname || course.fullname;
                course.summary = c.summary || course.summary;
                return loadCourseNavHandlers(refresh, false);
            }).catch(function() {
                return canAccessAsGuest().then(function(passwordRequired) {
                    if (!passwordRequired) {
                        return loadCourseNavHandlers(refresh, true);
                    } else {
                        course._handlers = [];
                        $scope.handlersShouldBeShown = false;
                    }
                }).catch(function() {
                    course._handlers = [];
                    $scope.handlersShouldBeShown = false;
                });
            });
        }).finally(function() {
            $scope.courseLoaded = true;
        });
    }
    function canAccessAsGuest() {
        if (!isGuestEnabled) {
            return $q.reject();
        }
        angular.forEach(enrollmentMethods, function(method) {
            if (method.type == 'guest') {
                guestInstanceId = method.id;
            }
        });
        if (guestInstanceId) {
            return $mmCourses.getCourseGuestEnrolmentInfo(guestInstanceId).then(function(info) {
                if (!info.status) {
                    return $q.reject();
                }
                return info.passwordrequired;
            });
        }
        return $q.reject();
    }
    function loadCourseNavHandlers(refresh, guest) {
        var promises = [],
            navOptions,
            admOptions;
        promises.push($mmCourses.getUserNavigationOptions([course.id]).catch(function() {
            return {};
        }).then(function(options) {
            navOptions = options;
        }));
        promises.push($mmCourses.getUserAdministrationOptions([course.id]).catch(function() {
            return {};
        }).then(function(options) {
            admOptions = options;
        }));
        return $q.all(promises).then(function() {
            var getHandlersFn = guest ? $mmCoursesDelegate.getNavHandlersForGuest : $mmCoursesDelegate.getNavHandlersFor;
            course._handlers = getHandlersFn(course.id, refresh, navOptions[course.id], admOptions[course.id]);
            $scope.handlersShouldBeShown = true;
        });
    }
    function refreshData() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCourse(course.id));
        promises.push($mmCourses.invalidateCourseEnrolmentMethods(course.id));
        promises.push($mmCourses.invalidateUserNavigationOptionsForCourses([course.id]));
        promises.push($mmCourses.invalidateUserAdministrationOptionsForCourses([course.id]));
        if (guestInstanceId) {
            promises.push($mmCourses.invalidateCourseGuestEnrolmentInfo(guestInstanceId));
        }
        $mmCoursesDelegate.clearCoursesHandlers(course.id);
        return $q.all(promises).finally(function() {
            return getCourse(true);
        });
    }
    getCourse();
    $scope.doRefresh = function() {
        refreshData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    if (selfEnrolWSAvailable && course.enrollmentmethods && course.enrollmentmethods.indexOf('self') > -1) {
        $ionicModal.fromTemplateUrl('core/components/courses/templates/password-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function(modal) {
            $scope.modal = modal;
            $scope.closeModal = function() {
                $scope.enroldata.password = '';
                delete $scope.currentEnrolInstance;
                return modal.hide();
            };
            $scope.$on('$destroy', function() {
                modal.remove();
            });
        });
        $scope.enrol = function(instanceId, password) {
            var promise;
            if ($scope.modal.isShown()) {
                promise = $q.when();
            } else {
                promise = $mmUtil.showConfirm($translate('mm.courses.confirmselfenrol'));
            }
            promise.then(function() {
                var modal = $mmUtil.showModalLoading('mm.core.loading', true);
                $mmCourses.selfEnrol(course.id, password, instanceId).then(function() {
                    $scope.isEnrolled = true;
                    $scope.courseLoaded = false;
                    $scope.closeModal().then(function() {
                        return waitForEnrolled(true);
                    }).then(function() {
                        refreshData().finally(function() {
                            $mmEvents.trigger(mmCoursesEventMyCoursesUpdated, $mmSite.getId());
                        });
                    });
                }).catch(function(error) {
                    if (error) {
                        if (error.code === mmCoursesEnrolInvalidKey) {
                            if ($scope.modal.isShown()) {
                                $mmUtil.showErrorModal(error.message);
                            } else {
                                $scope.currentEnrolInstance = instanceId;
                                $scope.modal.show();
                            }
                        } else if (typeof error == 'string') {
                            $mmUtil.showErrorModal(error);
                        }
                    } else {
                        $mmUtil.showErrorModal('mm.courses.errorselfenrol', true);
                    }
                }).finally(function() {
                    modal.dismiss();
                });
            });
        };
        function waitForEnrolled(init) {
            if (init) {
                waitStart = Date.now();
            }
            return $mmCourses.invalidateUserCourses().catch(function() {
            }).then(function() {
                return $mmCourses.getUserCourse(course.id);
            }).catch(function() {
                if ($scope.$$destroyed || (Date.now() - waitStart > 60000)) {
                    return;
                }
                return $timeout(function() {
                    return waitForEnrolled();
                }, 5000);
            });
        }
    }
}]);

angular.module('mm.core.courses')
.directive('mmCourseListItem', ["$mmCourses", "$translate", function($mmCourses, $translate) {
    return {
        restrict: 'E',
        templateUrl: 'core/components/courses/templates/courselistitem.html',
        scope: {
            course: '=',
        },
        link: function(scope) {
            var course = scope.course;
            return $mmCourses.getUserCourse(course.id).then(function() {
                course.isEnrolled = true;
            }).catch(function() {
                course.isEnrolled = false;
                course.enrollment = [];
                angular.forEach(course.enrollmentmethods, function(instance) {
                    if (instance === 'self') {
                        course.enrollment.push({
                            name: $translate.instant('mm.courses.selfenrolment'),
                            icon: 'ion-unlocked'
                        });
                    } else if (instance === 'guest') {
                        course.enrollment.push({
                            name: $translate.instant('mm.courses.allowguests'),
                            icon: 'ion-person'
                        });
                    }
                });
                if (course.enrollment.length == 0) {
                    course.enrollment.push({
                        name: $translate.instant('mm.courses.notenrollable'),
                        icon: 'ion-locked'
                    });
                }
            });
        }
    };
}]);

angular.module('mm.core.courses')
.factory('$mmCourses', ["$q", "$mmSite", "$log", "$mmSitesManager", "mmCoursesSearchPerPage", "mmCoursesEnrolInvalidKey", function($q, $mmSite, $log, $mmSitesManager, mmCoursesSearchPerPage, mmCoursesEnrolInvalidKey) {
    $log = $log.getInstance('$mmCourses');
    var self = {},
        currentCourses = {};
        self.getCategories = function(categoryId, addSubcategories, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var criteriaKey = categoryId == 0 ? 'parent' : 'id';
            var data = {
                    criteria: [
                        { key: criteriaKey, value: categoryId }
                    ],
                    addsubcategories: addSubcategories ? 1 : 0
                },
                preSets = {
                    cacheKey: getCategoriesCacheKey(categoryId, addSubcategories)
                };
            return site.read('core_course_get_categories', data, preSets);
        });
    };
        function getCategoriesCacheKey(categoryId, addSubcategories) {
        return 'mmCourses:categories:' + categoryId + ':' + addSubcategories;
    }
        self.isGetCategoriesAvailable = function() {
        return $mmSite.wsAvailable('core_course_get_categories');
    };
        self.isMyCoursesDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isMyCoursesDisabledInSite(site);
        });
    };
        self.isMyCoursesDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmSideMenuDelegate_mmCourses');
    };
        self.isSearchCoursesDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isSearchCoursesDisabledInSite(site);
        });
    };
        self.isSearchCoursesDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmCoursesDelegate_search');
    };
        self.clearCurrentCourses = function() {
        currentCourses = {};
    };
        self.getCourse = function(id, siteid) {
        return self.getCourses([id], siteid).then(function(courses) {
            if (courses && courses.length > 0) {
                return courses[0];
            }
            return $q.reject();
        });
    };
        self.getCourseEnrolmentMethods = function(id) {
        var params = {
                courseid: id
            },
            preSets = {
                cacheKey: getCourseEnrolmentMethodsCacheKey(id)
            };
        return $mmSite.read('core_enrol_get_course_enrolment_methods', params, preSets);
    };
        function getCourseEnrolmentMethodsCacheKey(id) {
        return 'mmCourses:enrolmentmethods:' + id;
    }
        self.getCourseGuestEnrolmentInfo = function(instanceId) {
        var params = {
                instanceid: instanceId
            },
            preSets = {
                cacheKey: getCourseGuestEnrolmentInfoCacheKey(instanceId)
            };
        return $mmSite.read('enrol_guest_get_instance_info', params, preSets).then(function(response) {
            return response.instanceinfo;
        });
    };
        function getCourseGuestEnrolmentInfoCacheKey(instanceId) {
        return 'mmCourses:guestinfo:' + instanceId;
    }
        self.getCourses = function(ids, siteid) {
        if (!angular.isArray(ids)) {
            return $q.reject();
        } else if (ids.length === 0) {
            return $q.when([]);
        }
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var data = {
                    options: {
                        ids: ids
                    }
                },
                preSets = {
                    cacheKey: getCoursesCacheKey(ids)
                };
            return site.read('core_course_get_courses', data, preSets).then(function(courses) {
                if (typeof courses != 'object' && !angular.isArray(courses)) {
                    return $q.reject();
                }
                return courses;
            });
        });
    };
        function getCoursesCacheKey(ids) {
        return 'mmCourses:course:' + JSON.stringify(ids);
    }
        self.getCoursesByField = function(field, value, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var data = {
                    field: field || "",
                    value: field ? value : ""
                },
                preSets = {
                    cacheKey: getCoursesByFieldCacheKey(field, value)
                };
            return site.read('core_course_get_courses_by_field', data, preSets).then(function(courses) {
                if (courses.courses) {
                    return courses.courses.sort(function(a, b) {
                        if (typeof a.sortorder == "undefined" && typeof b.sortorder == "undefined") {
                            return b.id - a.id;
                        }
                        if (typeof a.sortorder == "undefined") {
                            return 1;
                        }
                        if (typeof b.sortorder == "undefined") {
                            return -1;
                        }
                        return a.sortorder - b.sortorder;
                    });
                }
                return $q.reject();
            });
        });
    };
        function getCoursesByFieldCacheKey(field, value) {
        field = field || "";
        value = field ? value : "";
        return 'mmCourses:coursesbyfield:' + field + ":" + value;
    }
        self.isGetCoursesByFieldAvailable = function() {
        return $mmSite.wsAvailable('core_course_get_courses_by_field');
    };
        self.getStoredCourse = function(id) {
        $log.warn('The function \'getStoredCourse\' is deprecated. Please use \'getUserCourse\' instead');
        return currentCourses[id];
    };
        self.getCoursesOptions = function(courseIds, siteId) {
        var promises = [],
            navOptions,
            admOptions;
        return $mmSitesManager.getSite(siteId).then(function(site) {
            courseIds.push(site.getSiteHomeId());
            siteId = siteId || site.getId();
            promises.push(self.getUserNavigationOptions(courseIds, siteId).catch(function() {
                return {};
            }).then(function(options) {
                navOptions = options;
            }));
            promises.push(self.getUserAdministrationOptions(courseIds, siteId).catch(function() {
                return {};
            }).then(function(options) {
                admOptions = options;
            }));
            return $q.all(promises).then(function() {
                return {navOptions: navOptions, admOptions: admOptions};
            });
        });
    };
        function getUserAdministrationOptionsCommonCacheKey() {
        return 'mmCourses:administrationOptions:';
    }
        function getUserAdministrationOptionsCacheKey(courseIds) {
        return getUserAdministrationOptionsCommonCacheKey() + courseIds.join(',');
    }
        self.getUserAdministrationOptions = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    courseids: courseIds
                },
                preSets = {
                    cacheKey: getUserAdministrationOptionsCacheKey(courseIds)
                };
            return site.read('core_course_get_user_administration_options', params, preSets).then(function(response) {
                return formatUserOptions(response.courses);
            });
        });
    };
        self.getUserCourse = function(id, preferCache, siteid) {
        if (!id) {
            return $q.reject();
        }
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        return self.getUserCourses(preferCache, siteid).then(function(courses) {
            var course;
            angular.forEach(courses, function(c) {
                if (c.id == id) {
                    course = c;
                }
            });
            return course ? course : $q.reject();
        });
    };
        self.getUserCourses = function(preferCache, siteid) {
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var userid = site.getUserId(),
                presets = {
                    cacheKey: getUserCoursesCacheKey(),
                    omitExpires: preferCache
                },
                data = {userid: userid};
            if (typeof userid === 'undefined') {
                return $q.reject();
            }
            return site.read('core_enrol_get_users_courses', data, presets).then(function(courses) {
                siteid = siteid || site.getId();
                if (siteid === $mmSite.getId()) {
                    storeCoursesInMemory(courses);
                }
                return courses;
            });
        });
    };
        function getUserCoursesCacheKey() {
        return 'mmCourses:usercourses';
    }
        function getUserNavigationOptionsCommonCacheKey() {
        return 'mmCourses:navigationOptions:';
    }
        function getUserNavigationOptionsCacheKey(courseIds) {
        return getUserNavigationOptionsCommonCacheKey() + courseIds.join(',');
    }
        self.getUserNavigationOptions = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    courseids: courseIds
                },
                preSets = {
                    cacheKey: getUserNavigationOptionsCacheKey(courseIds)
                };
            return site.read('core_course_get_user_navigation_options', params, preSets).then(function(response) {
                return formatUserOptions(response.courses);
            });
        });
    };
        function formatUserOptions(courses) {
        var result = {};
        angular.forEach(courses, function(course) {
            var options = {};
            angular.forEach(course.options, function(option) {
                options[option.name] = option.available;
            });
            result[course.id] = options;
        });
        return result;
    }
        self.invalidateCategories = function(categoryId, addSubcategories, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCategoriesCacheKey(categoryId, addSubcategories));
        });
    };
        self.invalidateCourse = function(id, siteId) {
        return self.invalidateCourses([id], siteId);
    };
        self.invalidateCourseEnrolmentMethods = function(id) {
        return $mmSite.invalidateWsCacheForKey(getCourseEnrolmentMethodsCacheKey(id));
    };
        self.invalidateCourseGuestEnrolmentInfo = function(instanceId) {
        return $mmSite.invalidateWsCacheForKey(getCourseGuestEnrolmentInfoCacheKey(instanceId));
    };
        self.invalidateCourses = function(ids, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCoursesCacheKey(ids));
        });
    };
        self.invalidateCoursesByField = function(field, value, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCoursesByFieldCacheKey(field, value));
        });
    };
        self.invalidateUserAdministrationOptions = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getUserAdministrationOptionsCommonCacheKey());
        });
    };
        self.invalidateUserAdministrationOptionsForCourses = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getUserAdministrationOptionsCacheKey(courseIds));
        });
    };
        self.invalidateUserCourses = function(siteid) {
        return $mmSitesManager.getSite(siteid).then(function(site) {
            return site.invalidateWsCacheForKey(getUserCoursesCacheKey());
        });
    };
        self.invalidateUserNavigationOptions = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getUserNavigationOptionsCommonCacheKey());
        });
    };
        self.invalidateUserNavigationOptionsForCourses = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getUserNavigationOptionsCacheKey(courseIds));
        });
    };
        self.isGuestWSAvailable = function() {
        return $mmSite.wsAvailable('enrol_guest_get_instance_info');
    };
        self.isSearchCoursesAvailable = function() {
        return $mmSite.wsAvailable('core_course_search_courses');
    };
        self.isSelfEnrolmentEnabled = function() {
        return $mmSite.wsAvailable('enrol_self_enrol_user');
    };
        self.search = function(text, page, perpage) {
        page = page || 0;
        perpage = perpage || mmCoursesSearchPerPage;
        var params = {
                criterianame: 'search',
                criteriavalue: text,
                page: page,
                perpage: perpage
            }, preSets = {
                getFromCache: false
            };
        return $mmSite.read('core_course_search_courses', params, preSets).then(function(response) {
            if (typeof response == 'object') {
                return {total: response.total, courses: response.courses};
            }
            return $q.reject();
        });
    };
        self.selfEnrol = function(courseid, password, instanceId) {
        if (typeof password == 'undefined') {
            password = '';
        }
        var params = {
            courseid: courseid,
            password: password
        };
        if (instanceId) {
            params.instanceid = instanceId;
        }
        return $mmSite.write('enrol_self_enrol_user', params).then(function(response) {
            if (response) {
                if (response.status) {
                    return true;
                } else if (response.warnings && response.warnings.length) {
                    var message;
                    angular.forEach(response.warnings, function(warning) {
                        if (warning.warningcode == '2' || warning.warningcode == '4') {
                            message = warning.message;
                        }
                    });
                    if (message) {
                        return $q.reject({code: mmCoursesEnrolInvalidKey, message: message});
                    }
                }
            }
            return $q.reject();
        });
    };
        function storeCoursesInMemory(courses) {
        angular.forEach(courses, function(course) {
            currentCourses[course.id] = angular.copy(course);
        });
    }
    return self;
}]);

angular.module('mm.core.courses')
.provider('$mmCoursesDelegate', function() {
    var navHandlers = {},
        self = {};
        self.registerNavHandler = function(addon, handler, priority) {
        if (typeof navHandlers[addon] !== 'undefined') {
            console.log("$mmCoursesDelegateProvider: Addon '" + navHandlers[addon].addon + "' already registered as navigation handler");
            return false;
        }
        console.log("$mmCoursesDelegateProvider: Registered addon '" + addon + "' as navibation handler.");
        navHandlers[addon] = {
            addon: addon,
            handler: handler,
            instance: undefined,
            priority: priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$q", "$log", "$mmSite", "mmCoursesAccessMethods", function($mmUtil, $q, $log, $mmSite, mmCoursesAccessMethods) {
        var enabledNavHandlers = {},
            coursesHandlers = {},
            self = {},
            loaded = {},
            lastUpdateHandlersStart,
            lastUpdateHandlersForCoursesStart = {};
        $log = $log.getInstance('$mmCoursesDelegate');
                self.areNavHandlersLoadedFor = function(courseId) {
            return loaded[courseId];
        };
                self.clearCoursesHandlers = function(courseId) {
            if (courseId) {
                coursesHandlers[courseId] = false;
                loaded[courseId] = false;
            } else {
                coursesHandlers = {};
                loaded = {};
            }
        };
                function getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions) {
            if (refresh || !coursesHandlers[courseId] || coursesHandlers[courseId].access.type != accessData.type) {
                coursesHandlers[courseId] = {
                    access: accessData,
                    navOptions: navOptions,
                    admOptions: admOptions,
                    handlers: []
                };
                self.updateNavHandlersForCourse(courseId, accessData, navOptions, admOptions);
            }
            return coursesHandlers[courseId].handlers;
        }
                self.getNavHandlersFor = function(courseId, refresh, navOptions, admOptions) {
            var accessData = {
                type: mmCoursesAccessMethods.default
            };
            return getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions);
        };
                self.getNavHandlersForGuest = function(courseId, refresh, navOptions, admOptions) {
            var accessData = {
                type: mmCoursesAccessMethods.guest
            };
            return getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions);
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.isLastUpdateCourseCall = function(courseId, time) {
            if (!lastUpdateHandlersForCoursesStart[courseId]) {
                return true;
            }
            return time == lastUpdateHandlersForCoursesStart[courseId];
        };
                self.updateNavHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmCoursesDelegate_' + addon)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledNavHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledNavHandlers[addon];
                    }
                }
            });
        };
                self.updateNavHandlers = function() {
            var promises = [],
                siteId = $mmSite.getId(),
                now = new Date().getTime();
            $log.debug('Updating navigation handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(navHandlers, function(handlerInfo, addon) {
                promises.push(self.updateNavHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCall(now) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    angular.forEach(coursesHandlers, function(handler, courseId) {
                        self.updateNavHandlersForCourse(parseInt(courseId), handler.access, handler.navOptions, handler.admOptions);
                    });
                }
            });
        };
                self.updateNavHandlersForCourse = function(courseId, accessData, navOptions, admOptions) {
            var promises = [],
                enabledForCourse = [],
                siteId = $mmSite.getId(),
                now = new Date().getTime();
            lastUpdateHandlersForCoursesStart[courseId] = now;
            angular.forEach(enabledNavHandlers, function(handler) {
                var promise = $q.when(handler.instance.isEnabledForCourse(courseId, accessData, navOptions, admOptions))
                        .then(function(enabled) {
                    if (enabled) {
                        enabledForCourse.push(handler);
                    } else {
                        return $q.reject();
                    }
                }).catch(function() {
                });
                promises.push(promise);
            });
            return $q.all(promises).then(function() {
                return true;
            }).catch(function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCourseCall(courseId, now) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    $mmUtil.emptyArray(coursesHandlers[courseId].handlers);
                    angular.forEach(enabledForCourse, function(handler) {
                        coursesHandlers[courseId].handlers.push({
                            controller: handler.instance.getController(courseId),
                            priority: handler.priority
                        });
                    });
                    loaded[courseId] = true;
                }
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.courses')
.factory('$mmCoursesHandlers', ["$mmSite", "$state", "$mmCourses", "$q", "$mmUtil", "$translate", "$timeout", "$mmCourse", "$mmSitesManager", "mmCoursesEnrolInvalidKey", "$mmContentLinkHandlerFactory", function($mmSite, $state, $mmCourses, $q, $mmUtil, $translate, $timeout, $mmCourse, $mmSitesManager,
            mmCoursesEnrolInvalidKey, $mmContentLinkHandlerFactory) {
    var self = {};
        self.coursesLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /\/course\/?(index\.php.*)?$/, '$mmSideMenuDelegate_mmCourses');
    self.coursesLinksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                var state = 'site.mm_courses',
                    stateParams = {};
                if ($mmCourses.isGetCoursesByFieldAvailable()) {
                    if (params.categoryid && $mmCourses.isGetCategoriesAvailable()) {
                        state = 'site.mm_coursescategories';
                        stateParams.categoryid = parseInt(params.categoryid, 10);
                    } else {
                        state = 'site.mm_availablecourses';
                    }
                }
                $state.go('redirect', {
                    siteid: siteId || $mmSite.getId(),
                    state: state,
                    params: stateParams
                });
            }
        }];
    };
        self.courseLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /((\/enrol\/index\.php)|(\/course\/enrol\.php)|(\/course\/view\.php)).*([\?\&]id=\d+)/);
    self.courseLinksHandler.isEnabled = function(siteId, url, params, courseId) {
        courseId = parseInt(params.id, 10);
        if (!courseId) {
            return false;
        }
        return $mmSitesManager.getSiteHomeId(siteId).then(function(siteHomeId) {
           return courseId != siteHomeId;
       });
    };
    self.courseLinksHandler.getActions = function(siteIds, url, params, courseId) {
        courseId = parseInt(params.id, 10);
        return [{
            action: function(siteId) {
                siteId = siteId || $mmSite.getId();
                if (siteId == $mmSite.getId()) {
                    actionEnrol(courseId, url);
                } else {
                    $state.go('redirect', {
                        siteid: siteId,
                        state: 'site.mm_course',
                        params: {courseid: courseId}
                    });
                }
            }
        }];
    };
        function actionEnrol(courseId, url) {
        var modal = $mmUtil.showModalLoading(),
            isEnrolUrl = !!url.match(/(\/enrol\/index\.php)|(\/course\/enrol\.php)/);
        $mmCourses.getUserCourse(courseId).catch(function() {
            return canSelfEnrol(courseId).then(function() {
                var promise;
                modal.dismiss();
                promise = isEnrolUrl ? $q.when() : $mmUtil.showConfirm($translate('mm.courses.confirmselfenrol'));
                return promise.then(function() {
                    return selfEnrol(courseId).catch(function(error) {
                        if (typeof error == 'string') {
                            $mmUtil.showErrorModal(error);
                        }
                        return $q.reject();
                    });
                }, function() {
                    return $mmCourse.getSections(courseId, false, true);
                });
            }, function(error) {
                return $mmCourse.getSections(courseId, false, true).catch(function() {
                    modal.dismiss();
                    if (typeof error != 'string') {
                        error = $translate.instant('mm.courses.notenroled');
                    }
                    var body = $translate('mm.core.twoparagraphs',
                                    {p1: error, p2: $translate.instant('mm.core.confirmopeninbrowser')});
                    $mmUtil.showConfirm(body).then(function() {
                        $mmSite.openInBrowserWithAutoLogin(url);
                    });
                    return $q.reject();
                });
            });
        }).then(function() {
            modal.dismiss();
            $state.go('redirect', {
                siteid: $mmSite.getId(),
                state: 'site.mm_course',
                params: {courseid: courseId}
            });
        });
    }
        function canSelfEnrol(courseId) {
        if (!$mmCourses.isSelfEnrolmentEnabled()) {
            return $q.reject();
        }
        return $mmCourses.getCourseEnrolmentMethods(courseId).then(function(methods) {
            var isSelfEnrolEnabled = false,
                instances = 0;
            angular.forEach(methods, function(method) {
                if (method.type == 'self' && method.status) {
                    isSelfEnrolEnabled = true;
                    instances++;
                }
            });
            if (!isSelfEnrolEnabled || instances != 1) {
                return $q.reject();
            }
        });
    }
        function selfEnrol(courseId, password) {
        var modal = $mmUtil.showModalLoading();
        return $mmCourses.selfEnrol(courseId, password).then(function() {
            return $mmCourses.invalidateUserCourses().catch(function() {
            }).then(function() {
                return $timeout(function() {}, 4000).finally(function() {
                    modal.dismiss();
                });
            });
        }).catch(function(error) {
            modal.dismiss();
            if (error && error.code === mmCoursesEnrolInvalidKey) {
                var title = $translate.instant('mm.courses.selfenrolment'),
                    body = ' ',
                    placeholder = $translate.instant('mm.courses.password');
                if (typeof password != 'undefined') {
                    $mmUtil.showErrorModal(error.message);
                }
                return $mmUtil.showPrompt(body, title, placeholder).then(function(password) {
                    return selfEnrol(courseId, password);
                });
            } else {
                return $q.reject(error);
            }
        });
    }
        self.dashboardLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /\/my\/?$/, '$mmSideMenuDelegate_mmCourses');
    self.dashboardLinksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                $state.go('redirect', {
                    siteid: siteId || $mmSite.getId(),
                    state: 'site.mm_courses'
                });
            }
        }];
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.directive('mmFileUploaderOnChange', function() {
  return {
    restrict: 'A',
    link: function (scope, element, attrs) {
      var onChangeHandler = scope.$eval(attrs.mmFileUploaderOnChange);
      element.bind('change', onChangeHandler);
    }
  };
});

angular.module('mm.core.fileuploader')
.provider('$mmFileUploaderDelegate', function() {
    var handlers = {},
        self = {};
        self.registerHandler = function(addon, handler, priority) {
        if (typeof handlers[addon] !== 'undefined') {
            console.log("$mmFileUploaderDelegate: Addon '" + handlers[addon].addon + "' already registered as handler");
            return false;
        }
        console.log("$mmFileUploaderDelegate: Registered addon '" + addon + "' as handler.");
        handlers[addon] = {
            addon: addon,
            handler: handler,
            instance: undefined,
            priority: priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$q", "$log", "$mmSite", function($mmUtil, $q, $log, $mmSite) {
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmFileUploaderDelegate');
                self.clearSiteHandlers = function() {
            enabledHandlers = {};
        };
                self.getHandlers = function() {
            var handlers = [];
            angular.forEach(enabledHandlers, function(handler) {
                var data = handler.instance.getData();
                data.priority = handler.priority;
                handlers.push(data);
            });
            return handlers;
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledHandlers[addon];
                    }
                }
            });
        };
                self.updateHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating navigation handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, addon) {
                promises.push(self.updateHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.fileuploader')
.factory('$mmFileUploader', ["$mmSite", "$mmFS", "$q", "$timeout", "$log", "$mmSitesManager", "$mmFilepool", "$mmUtil", function($mmSite, $mmFS, $q, $timeout, $log, $mmSitesManager, $mmFilepool, $mmUtil) {
    $log = $log.getInstance('$mmFileUploader');
    var self = {};
        self.storeFilesToUpload = function(folderPath, files) {
        var result = {
            online: [],
            offline: 0
        };
        if (!files || !files.length) {
            return $q.when(result);
        }
        return $mmFS.removeUnusedFiles(folderPath, files).then(function() {
            var promises = [];
            angular.forEach(files, function(file) {
                if (file.filename && !file.name) {
                    result.online.push({
                        filename: file.filename,
                        fileurl: file.fileurl
                    });
                } else if (!file.name) {
                    promises.push($q.reject());
                } else if (file.fullPath && file.fullPath.indexOf(folderPath) != -1) {
                    result.offline++;
                } else {
                    var destFile = $mmFS.concatenatePaths(folderPath, file.name);
                    promises.push($mmFS.copyFile(file.toURL(), destFile));
                    result.offline++;
                }
            });
            return $q.all(promises).then(function() {
                return result;
            });
        });
    };
        self.uploadFile = function(uri, options, siteId) {
        options = options || {};
        siteId = siteId || $mmSite.getId();
        var deleteAfterUpload = options.deleteAfterUpload,
            ftOptions = angular.copy(options);
        delete ftOptions.deleteAfterUpload;
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.uploadFile(uri, ftOptions);
        }).then(function(result) {
            if (deleteAfterUpload) {
                $timeout(function() {
                    $mmFS.removeExternalFile(uri);
                }, 500);
            }
            return result;
        });
    };
        self.uploadImage = function(uri, isFromAlbum) {
        $log.debug('Uploading an image');
        var options = {
                fileName: 'image_' + $mmUtil.readableTimestamp() + '.jpg',
                mimeType: 'image/jpeg'
            },
            fileName,
            extension;
        if (typeof uri == 'undefined' || uri === '') {
            $log.debug('Received invalid URI in $mmFileUploader.uploadImage()');
            return $q.reject();
        }
        if (isFromAlbum) {
            fileName = $mmFS.getFileAndDirectoryFromPath(uri).name;
            fileName = fileName.replace(/(\.[^\.]*)\?[^\.]*$/, '$1');
            extension = $mmFS.getFileExtension(fileName);
            if (extension) {
                options.fileName = fileName;
                options.mimeType = $mmFS.getMimeType(extension);
            }
        }
        options.deleteAfterUpload = !isFromAlbum;
        options.fileKey = 'file';
        return self.uploadFile(uri, options);
    };
        self.uploadMedia = function(mediaFile) {
        $log.debug('Uploading media');
        var options = {},
            filename = mediaFile.name,
            split;
        split = filename.split('.');
        split[0] += '_' + $mmUtil.readableTimestamp();
        filename = split.join('.');
        options.fileKey = null;
        options.fileName = filename;
        options.mimeType = null;
        options.deleteAfterUpload = true;
        return self.uploadFile(mediaFile.fullPath, options);
    };
        self.uploadGenericFile = function(uri, name, type, deleteAfterUpload, fileArea, itemId, siteId) {
        var options = {};
        options.fileKey = null;
        options.fileName = name;
        options.mimeType = type;
        options.deleteAfterUpload = deleteAfterUpload;
        options.itemId = itemId || 0;
        options.fileArea = fileArea;
        return self.uploadFile(uri, options, siteId);
    };
        self.uploadOrReuploadFile = function(file, itemId, component, componentId, siteId) {
        siteId = siteId || $mmSite.getId();
        var promise,
            fileName;
        if (file.filename && !file.name) {
            fileName = file.filename;
            promise = $mmFilepool.downloadUrl(siteId, file.fileurl, false, component, componentId).then(function(path) {
                return $mmFS.getExternalFile(path);
            });
        } else {
            fileName = file.name;
            promise = $q.when(file);
        }
        return promise.then(function(fileEntry) {
            return self.uploadGenericFile(fileEntry.toURL(), fileName, fileEntry.type, true, 'draft', itemId, siteId)
                    .then(function(result) {
                return result.itemid;
            });
        });
    };
        self.uploadOrReuploadFiles = function(files, component, componentId, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!files || !files.length) {
            return $q.when(1);
        }
        return self.uploadOrReuploadFile(files[0], 0, component, componentId, siteId).then(function(itemId) {
            var promises = [],
                error;
            angular.forEach(files, function(file, index) {
                if (index === 0) {
                    return;
                }
                promises.push(self.uploadOrReuploadFile(file, itemId, component, componentId, siteId).catch(function(message) {
                    error = message;
                    return $q.reject();
                }));
            });
            return $q.all(promises).then(function() {
                return itemId;
            }).catch(function() {
                return $q.reject(error);
            });
        });
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.factory('$mmFileUploaderHandlers', ["$mmFileUploaderHelper", "$rootScope", "$compile", "$mmUtil", "$mmApp", function($mmFileUploaderHelper, $rootScope, $compile, $mmUtil, $mmApp) {
    var self = {};
        self.albumFilePicker = function() {
        var self = {};
                self.isEnabled = function() {
            return true;
        };
                self.getData = function() {
            return {
                name: 'album',
                title: 'mm.fileuploader.photoalbums',
                class: 'mm-fileuploader-album-handler',
                icon: 'ion-images',
                action: function(maxSize, upload, allowOffline) {
                    return $mmFileUploaderHelper.uploadImage(true, maxSize, upload).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        return self;
    };
        self.cameraFilePicker = function() {
        var self = {};
                self.isEnabled = function() {
            return true;
        };
                self.getData = function() {
            return {
                name: 'camera',
                title: 'mm.fileuploader.camera',
                class: 'mm-fileuploader-camera-handler',
                icon: 'ion-camera',
                action: function(maxSize, upload, allowOffline) {
                    return $mmFileUploaderHelper.uploadImage(false, maxSize, upload).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        return self;
    };
        self.audioFilePicker = function() {
        var self = {};
                self.isEnabled = function() {
            return true;
        };
                self.getData = function() {
            return {
                name: 'audio',
                title: 'mm.fileuploader.audio',
                class: 'mm-fileuploader-audio-handler',
                icon: 'ion-mic-a',
                action: function(maxSize, upload, allowOffline) {
                    return $mmFileUploaderHelper.uploadAudioOrVideo(true, maxSize, upload).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        return self;
    };
        self.videoFilePicker = function() {
        var self = {};
                self.isEnabled = function() {
            return true;
        };
                self.getData = function() {
            return {
                name: 'video',
                title: 'mm.fileuploader.video',
                class: 'mm-fileuploader-video-handler',
                icon: 'ion-ios-videocam',
                action: function(maxSize, upload, allowOffline) {
                    return $mmFileUploaderHelper.uploadAudioOrVideo(false, maxSize, upload).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        return self;
    };
        self.filePicker = function() {
        var self = {},
            uploadFileScope;
                self.isEnabled = function() {
            return ionic.Platform.isAndroid();
        };
                self.getData = function() {
            return {
                name: 'file',
                title: 'mm.fileuploader.file',
                class: 'mm-fileuploader-file-handler',
                icon: 'ion-folder',
                afterRender: function(maxSize, upload, allowOffline) {
                    var element = document.querySelector('.mm-fileuploader-file-handler');
                    if (element) {
                        var input = angular.element('<input type="file" mm-file-uploader-on-change="filePicked">');
                        if (!uploadFileScope) {
                            uploadFileScope = $rootScope.$new();
                            uploadFileScope.filePicked = function(evt) {
                                var input = evt.srcElement;
                                var file = input.files[0];
                                input.value = '';
                                if (!file) {
                                    return;
                                }
                                $mmFileUploaderHelper.uploadFileObject(file, maxSize, upload, allowOffline).then(function(result) {
                                    $mmFileUploaderHelper.fileUploaded(result);
                                }).catch(function(error) {
                                    if (error) {
                                        $mmUtil.showErrorModal(error);
                                    }
                                });
                            };
                        }
                        $compile(input)(uploadFileScope);
                        element.appendChild(input[0]);
                    }
                }
            };
        };
        return self;
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.constant('mmFileUploaderFileSizeWarning', 1048576)
.constant('mmFileUploaderWifiFileSizeWarning', 10485760)
.factory('$mmFileUploaderHelper', ["$q", "$mmUtil", "$mmApp", "$log", "$translate", "$window", "$rootScope", "$ionicActionSheet", "$mmFileUploader", "$cordovaCamera", "$cordovaCapture", "$mmLang", "$mmFS", "$mmText", "$timeout", "mmFileUploaderFileSizeWarning", "mmFileUploaderWifiFileSizeWarning", "$mmFileUploaderDelegate", function($q, $mmUtil, $mmApp, $log, $translate, $window, $rootScope, $ionicActionSheet,
        $mmFileUploader, $cordovaCamera, $cordovaCapture, $mmLang, $mmFS, $mmText, $timeout, mmFileUploaderFileSizeWarning,
        mmFileUploaderWifiFileSizeWarning, $mmFileUploaderDelegate) {
    $log = $log.getInstance('$mmFileUploaderHelper');
    var self = {},
        filePickerDeferred,
        hideActionSheet;
        self.areFileListDifferent = function(a, b) {
        a = a || [];
        b = b || [];
        if (a.length != b.length) {
            return true;
        }
        for (var i = 0; i < a.length; i++) {
            if (a[i].name != b[i].name) {
                return true;
            }
        }
        return false;
    };
        self.clearTmpFiles = function(files) {
        files.forEach(function(file) {
            if (!file.offline && file.remove) {
                file.remove();
            }
        });
    };
        self.confirmUploadFile = function(size, alwaysConfirm, allowOffline, wifiThreshold, limitedThreshold) {
        if (size == 0) {
            return $q.when();
        }
        if (!allowOffline && !$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.fileuploader.errormustbeonlinetoupload');
        }
        wifiThreshold = typeof wifiThreshold == 'undefined' ? mmFileUploaderWifiFileSizeWarning : wifiThreshold;
        limitedThreshold = typeof limitedThreshold == 'undefined' ? mmFileUploaderFileSizeWarning : limitedThreshold;
        if (size < 0) {
            return $mmUtil.showConfirm($translate('mm.fileuploader.confirmuploadunknownsize'));
        } else if (size >= wifiThreshold || ($mmApp.isNetworkAccessLimited() && size >= limitedThreshold)) {
            size = $mmText.bytesToSize(size, 2);
            return $mmUtil.showConfirm($translate('mm.fileuploader.confirmuploadfile', {size: size}));
        } else {
            if (alwaysConfirm) {
                return $mmUtil.showConfirm($translate('mm.core.areyousure'));
            } else {
                return $q.when();
            }
        }
    };
        self.copyAndUploadFile = function(file, upload) {
        var modal = $mmUtil.showModalLoading('mm.fileuploader.readingfile', true),
            fileData;
        return $mmFS.readFileData(file, $mmFS.FORMATARRAYBUFFER).then(function(data) {
            fileData = data;
            return $mmFS.getUniqueNameInFolder($mmFS.getTmpFolder(), file.name);
        }).then(function(newName) {
            var filepath = $mmFS.concatenatePaths($mmFS.getTmpFolder(), newName);
            return $mmFS.writeFile(filepath, fileData);
        }).catch(function(error) {
            $log.error('Error reading file to upload: '+JSON.stringify(error));
            modal.dismiss();
            return $mmLang.translateAndReject('mm.fileuploader.errorreadingfile');
        }).then(function(fileEntry) {
            modal.dismiss();
            if (upload) {
                return self.uploadGenericFile(fileEntry.toURL(), file.name, file.type, true);
            } else {
                return fileEntry;
            }
        });
    };
        self.errorMaxBytes = function(maxSize, fileName) {
        var error = $translate.instant('mm.fileuploader.maxbytesfile', {$a: {
            file: fileName,
            size: $mmText.bytesToSize(maxSize, 2)
        }});
        $mmUtil.showErrorModal(error);
        return $q.reject();
    };
        self.filePickerClosed = function() {
        if (filePickerDeferred) {
            filePickerDeferred.reject();
            filePickerDeferred = undefined;
        }
        if (hideActionSheet) {
            hideActionSheet();
        }
    };
        self.fileUploaded = function(result) {
        if (filePickerDeferred) {
            filePickerDeferred.resolve(result);
            filePickerDeferred = undefined;
        }
        if (hideActionSheet) {
            hideActionSheet();
        }
    };
        self.getStoredFiles = function(folderPath) {
        return $mmFS.getDirectoryContents(folderPath).then(function(files) {
            return self.markOfflineFiles(files);
        });
    };
        self.markOfflineFiles = function(files) {
        angular.forEach(files, function(file) {
            file.offline = true;
            file.filename = file.name;
        });
        return files;
    };
        self.selectAndUploadFile = function(maxSize, title, filterMethods) {
        return selectFile(maxSize, false, title, filterMethods, true);
    };
        self.selectFile = function(maxSize, allowOffline, title, filterMethods) {
        return selectFile(maxSize, allowOffline, title, filterMethods, false);
    };
        function selectFile(maxSize, allowOffline, title, filterMethods, upload) {
        var buttons = [],
            handlers;
        filePickerDeferred = $q.defer();
        handlers = $mmFileUploaderDelegate.getHandlers();
        handlers.sort(function(a, b) {
            return a.priority < b.priority;
        });
        angular.forEach(handlers, function(handler) {
            if (filterMethods && filterMethods.indexOf(handler.name) == -1) {
                return;
            }
            buttons.push({
                text: (handler.icon ? '<i class="icon ' + handler.icon + '"></i>' : '') + $translate.instant(handler.title),
                action: handler.action,
                className: handler.class,
                afterRender: handler.afterRender
            });
        });
        hideActionSheet = $ionicActionSheet.show({
            buttons: buttons,
            titleText: title ? title : $translate.instant('mm.fileuploader.' + (upload ? 'uploadafile' : 'selectafile')),
            cancelText: $translate.instant('mm.core.cancel'),
            buttonClicked: function(index) {
                if (angular.isFunction(buttons[index].action)) {
                    if (!allowOffline && !$mmApp.isOnline()) {
                        $mmUtil.showErrorModal('mm.fileuploader.errormustbeonlinetoupload', true);
                        return;
                    }
                    buttons[index].action(maxSize, upload, allowOffline).then(function(data) {
                        if (data.uploaded) {
                            return data.result;
                        } else {
                            if (data.fileEntry) {
                                return self.uploadFileEntry(data.fileEntry, data.delete, maxSize, upload, allowOffline);
                            } else if (data.path) {
                                return $mmFS.getFile(data.path).then(function(fileEntry) {
                                    return self.uploadFileEntry(fileEntry, data.delete, maxSize, upload, allowOffline);
                                }, function() {
                                    return $mmFS.getExternalFile(data.path).then(function(fileEntry) {
                                        return uploadFileEntry(fileEntry, data.delete, maxSize, upload, allowOffline);
                                    });
                                });
                            }
                            $mmUtil.showErrorModal('No file received');
                        }
                    }).then(function(result) {
                        self.fileUploaded(result);
                    }).catch(function(error) {
                        if (error) {
                            $mmUtil.showErrorModal(error);
                        }
                    });
                }
                return false;
            },
            cancel: function() {
                self.filePickerClosed();
                return true;
            }
        });
        $timeout(function() {
            angular.forEach(buttons, function(button) {
                if (angular.isFunction(button.afterRender)) {
                    button.afterRender(maxSize, upload, allowOffline);
                }
            });
        }, 500);
        return filePickerDeferred.promise;
    }
        self.showConfirmAndUploadInSite = function(fileEntry, deleteAfterUpload, siteId) {
        return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
            return self.confirmUploadFile(file.size).then(function() {
                return self.uploadGenericFile(fileEntry.toURL(), file.name, file.type, deleteAfterUpload, siteId).then(function() {
                    $mmUtil.showModal('mm.core.success', 'mm.fileuploader.fileuploaded');
                });
            }).catch(function(err) {
                if (err) {
                    $mmUtil.showErrorModal(err);
                }
                return $q.reject();
            });
        }, function() {
            $mmUtil.showErrorModal('mm.fileuploader.errorreadingfile', true);
            return $q.reject();
        });
    };
        self.uploadAudioOrVideo = function(isAudio, maxSize, upload) {
        $log.debug('Trying to record a video file');
        var fn = isAudio ? $cordovaCapture.captureAudio : $cordovaCapture.captureVideo;
        return fn({limit: 1}).then(function(medias) {
            var media = medias[0],
                path = media.localURL;
            if (upload) {
                return uploadFile(true, path, maxSize, true, $mmFileUploader.uploadMedia, media);
            } else {
                return copyToTmpFolder(path, true, maxSize);
            }
        }, function(error) {
            var defaultError = isAudio ? 'mm.fileuploader.errorcapturingaudio' : 'mm.fileuploader.errorcapturingvideo';
            return treatCaptureError(error, defaultError);
        });
    };
        self.uploadGenericFile = function(uri, name, type, deleteAfterUpload, siteId) {
        return uploadFile(deleteAfterUpload, uri, -1, false,
                $mmFileUploader.uploadGenericFile, uri, name, type, deleteAfterUpload, undefined, undefined, siteId);
    };
        self.uploadImage = function(fromAlbum, maxSize, upload) {
        $log.debug('Trying to capture an image with camera');
        var options = {
            quality: 50,
            destinationType: navigator.camera.DestinationType.FILE_URI,
            correctOrientation: true
        };
        if (fromAlbum) {
            options.sourceType = navigator.camera.PictureSourceType.PHOTOLIBRARY;
            options.popoverOptions = new CameraPopoverOptions(10, 10, $window.innerWidth  - 200, $window.innerHeight - 200,
                                            Camera.PopoverArrowDirection.ARROW_ANY);
            if (ionic.Platform.isIOS()) {
                options.mediaType = Camera.MediaType.ALLMEDIA;
            }
        }
        return $cordovaCamera.getPicture(options).then(function(path) {
            if (upload) {
                return uploadFile(!fromAlbum, path, maxSize, true, $mmFileUploader.uploadImage, path, fromAlbum);
            } else {
                return copyToTmpFolder(path, !fromAlbum, maxSize, 'jpg');
            }
        }, function(error) {
            var defaultError = fromAlbum ? 'mm.fileuploader.errorgettingimagealbum' : 'mm.fileuploader.errorcapturingimage';
            return treatImageError(error, defaultError);
        });
    };
        self.uploadFileEntry = function(fileEntry, deleteAfter, maxSize, upload, allowOffline) {
        return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
            return self.uploadFileObject(file, maxSize, upload, allowOffline).then(function(result) {
                if (deleteAfter) {
                    $mmFS.removeFileByFileEntry(fileEntry);
                }
                return result;
            });
        });
    };
        self.uploadFileObject = function(file, maxSize, upload, allowOffline) {
        if (maxSize != -1 && file.size > maxSize) {
            return self.errorMaxBytes(maxSize, file.name);
        }
        return self.confirmUploadFile(file.size, false, allowOffline).then(function() {
            return self.copyAndUploadFile(file, upload);
        });
    };
        function treatImageError(error, defaultMessage) {
        if (error) {
            if (typeof error == 'string') {
                if (error.toLowerCase().indexOf("error") > -1 || error.toLowerCase().indexOf("unable") > -1) {
                    $log.error('Error getting image: ' + error);
                    return $q.reject(error);
                } else {
                    $log.debug('Cancelled');
                }
            } else {
                return $mmLang.translateAndReject(defaultMessage);
            }
        }
        return $q.reject();
    }
        function treatCaptureError(error, defaultMessage) {
        if (error) {
            if (typeof error === 'string') {
                $log.error('Error while recording audio/video: ' + error);
                if (error.indexOf('No Activity found') > -1) {
                    return $mmLang.translateAndReject('mm.fileuploader.errornoapp');
                } else {
                    return $mmLang.translateAndReject(defaultMessage);
                }
            } else {
                if (error.code != 3) {
                    $log.error('Error while recording audio/video: ' + JSON.stringify(error));
                    return $mmLang.translateAndReject(defaultMessage);
                } else {
                    $log.debug('Cancelled');
                }
            }
        }
        return $q.reject();
    }
        function copyToTmpFolder(path, shouldDelete, maxSize, defaultExt) {
        var fileName = $mmFS.getFileAndDirectoryFromPath(path).name,
            promise,
            fileTooLarge;
        if (typeof maxSize != 'undefined' && maxSize != -1) {
            promise = $mmFS.getExternalFile(path).then(function(fileEntry) {
                return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
                    if (file.size > maxSize) {
                        fileTooLarge = file;
                    }
                });
            }).catch(function() {
            });
        } else {
            promise = $q.when();
        }
        return promise.then(function() {
            if (fileTooLarge) {
                return self.errorMaxBytes(maxSize, fileTooLarge.name);
            }
            fileName = fileName.replace(/(\.[^\.]*)\?[^\.]*$/, '$1');
            return $mmFS.getUniqueNameInFolder($mmFS.getTmpFolder(), fileName, defaultExt);
        }).then(function(newName) {
            var destPath = $mmFS.concatenatePaths($mmFS.getTmpFolder(), newName);
            if (shouldDelete) {
                return $mmFS.moveExternalFile(path, destPath);
            } else {
                return $mmFS.copyExternalFile(path, destPath);
            }
        });
    }
        function uploadFile(deleteAfterUpload, path, maxSize, checkSize, uploadFn) {
        var errorStr = $translate.instant('mm.core.error'),
            retryStr = $translate.instant('mm.core.retry'),
            args = arguments,
            progressTemplate =  "<div>" +
                                    "<ion-spinner></ion-spinner>" +
                                    "<p ng-if=\"!perc\">{{'mm.fileuploader.uploading' | translate}}</p>" +
                                    "<p ng-if=\"perc\">{{'mm.fileuploader.uploadingperc' | translate:{$a: perc} }}</p>" +
                                "</div>",
            scope,
            modal,
            promise,
            file;
        if (!$mmApp.isOnline()) {
            return errorUploading($translate.instant('mm.fileuploader.errormustbeonlinetoupload'));
        }
        if (checkSize) {
            promise = $mmFS.getExternalFile(path).then(function(fileEntry) {
                return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(f) {
                    file = f;
                    return file.size;
                });
            }).catch(function() {
            });
        } else {
            promise = $q.when(0);
        }
        return promise.then(function(size) {
            if (maxSize != -1 && size > maxSize) {
                return self.errorMaxBytes(maxSize, file.name);
            }
            if (size > 0) {
                return self.confirmUploadFile(size);
            }
        }).then(function() {
            scope = $rootScope.$new();
            modal = $mmUtil.showModalLoadingWithTemplate(progressTemplate, {scope: scope});
            return uploadFn.apply(undefined, Array.prototype.slice.call(args, 5)).then(undefined, undefined, function(progress) {
                if (progress && progress.lengthComputable) {
                    var perc = parseFloat(Math.min((progress.loaded / progress.total) * 100, 100)).toFixed(1);
                    if (perc >= 0) {
                        scope.perc = perc;
                    }
                }
            }).catch(function(error) {
                $log.error('Error uploading file: '+JSON.stringify(error));
                modal.dismiss();
                if (typeof error != 'string') {
                    error = $translate.instant('mm.fileuploader.errorwhileuploading');
                }
                return errorUploading(error);
            }).finally(function() {
                modal.dismiss();
                scope.$destroy();
            });
        });
        function errorUploading(error) {
            var options = {
                okText: retryStr
            };
            return $mmUtil.showConfirm(error, errorStr, options).then(function() {
                return uploadFile.apply(undefined, args);
            }, function() {
                if (deleteAfterUpload) {
                    angular.forEach(paths, function(path) {
                        $mmFS.removeExternalFile(path);
                    });
                }
                return $q.reject();
            });
        }
    }
    return self;
}]);

angular.module('mm.core.grades')
.controller('mmGradesGradeCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmGrades", "$mmSite", "$mmGradesHelper", "$log", function($scope, $stateParams, $mmUtil, $mmGrades, $mmSite, $mmGradesHelper, $log) {
    $log = $log.getInstance('mmGradesGradeCtrl');
    var courseId = $stateParams.courseid,
        userId = $stateParams.userid || $mmSite.getUserId();
    function fetchGrade() {
        return $mmGrades.getGradesTable(courseId, userId).then(function(table) {
            $scope.grade = $mmGradesHelper.getGradeRow(table, $stateParams.gradeid);
        }, function(message) {
            $mmUtil.showErrorModal(message);
            $scope.errormessage = message;
        });
    }
    fetchGrade().finally(function() {
        $scope.gradeLoaded = true;
    });
    $scope.refreshGrade = function() {
        fetchGrade().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.refreshGrade = function() {
        $mmGrades.invalidateGradesTableData(courseId, userId).finally(function() {
            fetchGrade().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.grades')
.controller('mmGradesTableCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmGrades", "$mmSite", "$mmGradesHelper", "$state", function($scope, $stateParams, $mmUtil, $mmGrades, $mmSite, $mmGradesHelper, $state) {
    var course = $stateParams.course || {},
        courseId = $stateParams.courseid || course.id,
        userId = $stateParams.userid || $mmSite.getUserId(),
        forcePhoneView = $stateParams.forcephoneview || false;
    $scope.forcePhoneView = !!forcePhoneView;
    function fetchGrades() {
        return $mmGrades.getGradesTable(courseId, userId).then(function(table) {
            table = $mmGradesHelper.formatGradesTable(table, forcePhoneView);
            return $mmGradesHelper.translateGradesTable(table).then(function(table) {
                $scope.gradesTable = table;
            });
        }, function(message) {
            $mmUtil.showErrorModal(message);
            $scope.errormessage = message;
        });
    }
    fetchGrades().then(function() {
        $mmSite.write('gradereport_user_view_grade_report', {
            courseid: courseId,
            userid: userId
        });
    }).finally(function() {
        $scope.gradesLoaded = true;
    });
    $scope.expandGradeInfo = function(gradeid) {
        if (gradeid) {
            $state.go('site.grade', {
                courseid: courseId,
                userid: userId,
                gradeid: gradeid
            });
        }
    };
    $scope.refreshGrades = function() {
        $mmGrades.invalidateGradesTableData(courseId, userId).finally(function() {
            fetchGrades().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.grades')
.factory('$mmGrades', ["$q", "$log", "$mmSite", "$mmCourses", "$mmSitesManager", "$mmUtil", "$mmText", function($q, $log, $mmSite, $mmCourses, $mmSitesManager, $mmUtil, $mmText) {
    $log = $log.getInstance('$mmGrades');
    var self = {};
        function getGradesTableCacheKey(courseId, userId) {
        return getGradesTablePrefixCacheKey(courseId) + userId;
    }
        function getGradeItemsCacheKey(courseId, userId, groupId) {
        groupId = groupId || 0;
        return getGradeItemsPrefixCacheKey(courseId) + userId + ':' + groupId;
    }
        function getGradesTablePrefixCacheKey(courseId) {
        return 'mmGrades:table:' + courseId + ':';
    }
        function getGradeItemsPrefixCacheKey(courseId) {
        return 'mmGrades:items:' + courseId + ':';
    }
        self.invalidateGradesTableData = function(courseId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getGradesTableCacheKey(courseId, userId));
        });
    };
        self.invalidateGradeItemsData = function(courseId, userId, groupId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getGradeItemsCacheKey(courseId, userId, groupId));
        });
    };
        self.invalidateGradesTableCourseData = function(courseId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getGradesTablePrefixCacheKey(courseId));
        });
    };
        self.invalidateGradeCourseItemsData = function(courseId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getGradeItemsPrefixCacheKey(courseId));
        });
    };
        self.isPluginEnabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('gradereport_user_get_grades_table');
        });
    };
        self.isPluginEnabledForCourse = function(courseId, siteId) {
        if (!courseId) {
            return $q.reject();
        }
        return $mmCourses.getUserCourse(courseId, true, siteId).then(function(course) {
            if (course && typeof course.showgrades != 'undefined' && course.showgrades == 0) {
                return false;
            }
            return true;
        });
    };
        self.isGradeItemsAvalaible = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('gradereport_user_get_grade_items');
        });
    };
        self.isPluginEnabledForUser = function(courseId, userId) {
        var data = {
                courseid: courseId,
                userid: userId
            };
        return $mmSite.read('gradereport_user_get_grades_table', data, {}).then(function() {
            return true;
        }).catch(function() {
            return false;
        });
    };
        self.getGradesTable = function(courseId, userId, siteId, ignoreCache) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            $log.debug('Get grades for course ' + courseId + ' and user ' + userId);
            var data = {
                    courseid : courseId,
                    userid   : userId
                },
                preSets = {
                    cacheKey: getGradesTableCacheKey(courseId, userId)
                };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('gradereport_user_get_grades_table', data, preSets).then(function (table) {
                if (table && table.tables && table.tables[0]) {
                    return table.tables[0];
                }
                return $q.reject();
            });
        });
    };
        self.getGradeItems = function(courseId, userId, groupId, siteId, ignoreCache) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            $log.debug('Get grades for course ' + courseId + ', user ' + userId);
            var data = {
                    courseid : courseId,
                    userid   : userId,
                    groupid  : groupId || 0
                },
                preSets = {
                    cacheKey: getGradeItemsCacheKey(courseId, userId, groupId)
                };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('gradereport_user_get_grade_items', data, preSets).then(function(grades) {
                if (grades && grades.usergrades && grades.usergrades[0]) {
                    return grades.usergrades[0];
                }
                return $q.reject();
            });
        });
    };
        function getGradeModuleItems(courseId, moduleId, userId, groupId, siteId, ignoreCache) {
        return self.getGradeItems(courseId, userId, groupId, siteId, ignoreCache).then(function(grades) {
            if (grades && grades.gradeitems) {
                var items = [];
                for (var x in grades.gradeitems) {
                    if (grades.gradeitems[x].cmid == moduleId) {
                        items.push(grades.gradeitems[x]);
                    }
                }
                if (items.length > 0) {
                    return items;
                }
            }
            return $q.reject();
        });
    }
        function getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache) {
        return self.getGradesTable(courseId, userId, siteId, ignoreCache).then(function(table) {
            var regex = /href="([^"]*\/mod\/[^"|^\/]*\/[^"|^\.]*\.php[^"]*)/,
                matches,
                hrefParams,
                entry,
                items = [];
            for (var i = 0; i < table.tabledata.length; i++) {
                entry = table.tabledata[i];
                if (entry.itemname && entry.itemname.content) {
                    matches = entry.itemname.content.match(regex);
                    if (matches && matches.length) {
                        hrefParams = $mmUtil.extractUrlParams(matches[1]);
                        if (hrefParams && hrefParams.id == moduleId) {
                            var item = {};
                            angular.forEach(entry, function(value, name) {
                                if (value && value.content) {
                                    switch (name) {
                                        case 'grade':
                                            var grade = parseFloat(value.content);
                                            if (!isNaN(grade)) {
                                                item.gradeformatted = grade;
                                            }
                                            break;
                                        case 'percentage':
                                        case 'range':
                                            name += 'formatted';
                                        default:
                                            item[name] = $mmText.decodeHTML(value.content).trim();
                                    }
                                }
                            });
                            items.push(item);
                        }
                    }
                }
            }
            if (items.length > 0) {
                return items;
            }
            return $q.reject();
        });
    }
        self.getGradeModuleItems = function(courseId, moduleId, userId, groupId, siteId, ignoreCache) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
                if (enabled) {
                    return getGradeModuleItems(courseId, moduleId, userId, groupId, siteId, ignoreCache).catch(function() {
                        return getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache);
                    });
                } else {
                    return getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache);
                }
            });
        });
    };
        self.invalidateGradeModuleItems = function(courseId, userId, groupId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
                if (enabled) {
                    return self.invalidateGradeItemsData(courseId, userId, groupId, siteId);
                } else {
                    return self.invalidateGradesTableData(courseId, userId, siteId);
                }
            });
        });
    };
        self.invalidateGradeCourseItems = function(courseId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
            if (enabled) {
                return self.invalidateGradeCourseItemsData(courseId, siteId);
            } else {
                return self.invalidateGradesTableCourseData(courseId, siteId);
            }
        });
    };
    return self;
}]);

angular.module('mm.core.grades')
.factory('$mmGradesHelper', ["$q", "$mmText", "$translate", "$mmCourse", "$sce", function($q, $mmText, $translate, $mmCourse, $sce) {
    var self = {};
        self.formatGradesTable = function(table, forcePhoneView) {
        var formatted = {
            columns: [],
            rows: []
        };
        var columns = {
            itemname: true,
            weight: false,
            grade: false,
            range: false,
            percentage: false,
            lettergrade: false,
            rank: false,
            average: false,
            feedback: false,
            contributiontocoursetotal: false
        };
        var returnedColumns = [];
        var tabledata = [];
        var maxDepth = 0;
        if (table['tabledata']) {
            tabledata = table['tabledata'];
            maxDepth = table['maxdepth'];
            for (var el in tabledata) {
                if (!angular.isArray(tabledata[el]) && typeof(tabledata[el]["leader"]) === "undefined") {
                    for (var col in tabledata[el]) {
                        returnedColumns.push(col);
                    }
                    break;
                }
            }
        }
        if (returnedColumns.length > 0) {
            var columnAdded = false;
            for (var i = 0; i < tabledata.length && !columnAdded; i++) {
                if (typeof(tabledata[i]["grade"]) != "undefined" &&
                        typeof(tabledata[i]["grade"]["content"]) != "undefined") {
                    columns.grade = true;
                    columnAdded = true;
                } else if (typeof(tabledata[i]["percentage"]) != "undefined" &&
                        typeof(tabledata[i]["percentage"]["content"]) != "undefined") {
                    columns.percentage = true;
                    columnAdded = true;
                }
            }
            if (!columnAdded) {
                columns.grade = true;
            }
            for (var colName in columns) {
                if (returnedColumns.indexOf(colName) > -1) {
                    var width = colName == "itemname" ? maxDepth : 1;
                    var column = {
                        id: colName,
                        name: colName,
                        width: width,
                        showAlways: columns[colName]
                    };
                    formatted.columns.push(column);
                }
            }
            var name, rowspan, tclass, colspan, content, celltype, id, headers, img;
            for (var i = 0; i < tabledata.length; i++) {
                var row = {};
                row.text = '';
                if (typeof(tabledata[i]['leader']) != "undefined") {
                    rowspan = tabledata[i]['leader']['rowspan'];
                    tclass = tabledata[i]['leader']['class'];
                    row.text += '<td class="' + tclass + '" rowspan="' + rowspan + '"></td>';
                }
                for (el in returnedColumns) {
                    name = returnedColumns[el];
                    if (forcePhoneView && !columns[name]) {
                        continue;
                    }
                    if (typeof(tabledata[i][name]) != "undefined") {
                        tclass = (typeof(tabledata[i][name]['class']) != "undefined")? tabledata[i][name]['class'] : '';
                        tclass += columns[name] ? '' : ' hidden-phone';
                        colspan = (typeof(tabledata[i][name]['colspan']) != "undefined")? "colspan='"+tabledata[i][name]['colspan']+"'" : '';
                        content = (typeof(tabledata[i][name]['content']) != "undefined")? tabledata[i][name]['content'] : null;
                        celltype = (typeof(tabledata[i][name]['celltype']) != "undefined")? tabledata[i][name]['celltype'] : 'td';
                        id = (typeof(tabledata[i][name]['id']) != "undefined")? "id='" + tabledata[i][name]['id'] +"'" : '';
                        headers = (typeof(tabledata[i][name]['headers']) != "undefined")? "headers='" + tabledata[i][name]['headers'] + "'" : '';
                        if (typeof(content) != "undefined") {
                            img = getImgHTML(content);
                            content = content.replace(/<\/span>/gi, "\n");
                            content = $mmText.cleanTags(content);
                            content = $mmText.replaceNewLines(content, '<br>');
                            content = img + " " + content;
                            row.text += "<" + celltype + " " + id + " " + headers + " " + "class='"+ tclass +"' " + colspan +">";
                            row.text += content;
                            row.text += "</" + celltype + ">";
                        }
                    }
                }
                if (row.text.length > 0) {
                    if (tabledata[i].itemname && tabledata[i].itemname.id && tabledata[i].itemname.id.substr(0, 3) == 'row') {
                        row.id = tabledata[i].itemname.id.split('_')[1];
                    }
                    row.text = $sce.trustAsHtml(row.text);
                }
                formatted.rows.push(row);
            }
        }
        return formatted;
    };
        self.getGradeRow = function(table, gradeid) {
        var row = {},
            selectedRow = false;
        if (table['tabledata']) {
            var tabledata = table['tabledata'];
            for (var i = 0; i < tabledata.length; i++) {
                if (tabledata[i].itemname && tabledata[i].itemname.id && tabledata[i].itemname.id.substr(0, 3) == 'row') {
                    if (tabledata[i].itemname.id.split('_')[1] == gradeid) {
                        selectedRow = tabledata[i];
                        break;
                    }
                }
            }
        }
        if (!selectedRow) {
            return "";
        }
        for (var name in selectedRow) {
            if (typeof(selectedRow[name]) != "undefined" && typeof(selectedRow[name]['content']) != "undefined") {
                var content = selectedRow[name]['content'];
                if (name == 'itemname') {
                    var img = getImgHTML(content);
                    row.link = getModuleLink(content);
                    content = content.replace(/<\/span>/gi, "\n");
                    content = $mmText.cleanTags(content);
                    content = img + " " + content;
                } else {
                    content = $mmText.replaceNewLines(content, '<br>');
                }
                if (content == '&nbsp;') {
                    content = "";
                }
                row[name] = content.trim();
            }
        }
        return row;
    };
        function getImgHTML(text) {
        var img = '';
        text = text.replace("%2F", "/").replace("%2f", "/");
        if (text.indexOf("/agg_mean") > -1) {
            img = '<img src="core/components/grades/img/agg_mean.png" width="16">';
        } else if (text.indexOf("/agg_sum") > -1) {
            img = '<img src="core/components/grades/img/agg_sum.png" width="16">';
        } else if (text.indexOf("/outcomes") > -1) {
            img = '<img src="core/components/grades/img/outcomes.png" width="16">';
        } else if (text.indexOf("i/folder") > -1) {
            img = '<img src="core/components/grades/img/folder.png" width="16">';
        } else if (text.indexOf("/manual_item") > -1) {
            img = '<img src="core/components/grades/img/manual_item.png" width="16">';
        } else if (text.indexOf("/mod/") > -1) {
            var module = text.match(/mod\/([^\/]*)\//);
            if (typeof module[1] != "undefined") {
                var moduleSrc = $mmCourse.getModuleIconSrc(module[1]);
                img = '<img src="' + moduleSrc + '" width="16">';
            }
        }
        if (img) {
            img = '<span class="app-ico">' + img + '</span>';
        }
        return img;
    }
        function getModuleLink(text) {
        var el = angular.element(text)[0],
            link = el.attributes['href'] ? el.attributes['href'].value : false;
        if (!link || link.indexOf("/mod/") < 0) {
            return false;
        }
        return link;
    }
        self.translateGradesTable = function(table) {
        var columns = angular.copy(table.columns),
            promises = [];
        columns.forEach(function(column) {
            var promise = $translate('mm.grades.'+column.name).then(function(translated) {
                column.name = translated;
            });
            promises.push(promise);
        });
        return $q.all(promises).then(function() {
            return {
                columns: columns,
                rows: table.rows
            };
        });
    };
    return self;
}]);

angular.module('mm.core.login')
.controller('mmLoginCredentialsCtrl', ["$scope", "$stateParams", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$mmApp", "$q", "$mmLoginHelper", "$mmContentLinksDelegate", "$mmContentLinksHelper", "$translate", function($scope, $stateParams, $mmSitesManager, $mmUtil, $ionicHistory, $mmApp,
            $q, $mmLoginHelper, $mmContentLinksDelegate, $mmContentLinksHelper, $translate) {
    $scope.siteurl = $stateParams.siteurl;
    $scope.credentials = {
        username: $stateParams.username
    };
    $scope.siteChecked = false;
    var urlToOpen = $stateParams.urltoopen,
        siteConfig = $stateParams.siteconfig;
    treatSiteConfig(siteConfig);
    function checkSite(siteurl) {
        var checkmodal = $mmUtil.showModalLoading(),
            protocol = siteurl.indexOf('http://') === 0 ? 'http://' : undefined;
        return $mmSitesManager.checkSite(siteurl, protocol).then(function(result) {
            $scope.siteChecked = true;
            $scope.siteurl = result.siteurl;
            treatSiteConfig(result.config);
            if (result && result.warning) {
                $mmUtil.showErrorModal(result.warning, true, 4000);
            }
            if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                $scope.isBrowserSSO = true;
                if (!$mmApp.isSSOAuthenticationOngoing() && !$scope.$$destroyed) {
                    $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                }
            } else {
                $scope.isBrowserSSO = false;
            }
        }).catch(function(error) {
            $mmUtil.showErrorModal(error);
            return $q.reject();
        }).finally(function() {
            checkmodal.dismiss();
        });
    }
    function treatSiteConfig(siteConfig) {
        if (siteConfig) {
            $scope.sitename = siteConfig.sitename;
            $scope.logourl = siteConfig.logourl || siteConfig.compactlogourl;
            $scope.authInstructions = siteConfig.authinstructions || $translate.instant('mm.login.loginsteps');
            $scope.canSignup = siteConfig.registerauth == 'email' && !$mmLoginHelper.isEmailSignupDisabled(siteConfig);
        } else {
            $scope.sitename = null;
            $scope.logourl = null;
            $scope.authInstructions = null;
            $scope.canSignup = false;
        }
    }
    if ($mmLoginHelper.isFixedUrlSet()) {
        checkSite($scope.siteurl);
    } else {
        $scope.siteChecked = true;
    }
    $scope.login = function() {
        $mmApp.closeKeyboard();
        var siteurl = $scope.siteurl,
            username = $scope.credentials.username,
            password = $scope.credentials.password;
        if (!$scope.siteChecked) {
            return checkSite(siteurl).then(function() {
                if (!$scope.isBrowserSSO) {
                    return $scope.login();
                }
            });
        } else if ($scope.isBrowserSSO) {
            return checkSite(siteurl);
        }
        if (!username) {
            $mmUtil.showErrorModal('mm.login.usernamerequired', true);
            return;
        }
        if (!password) {
            $mmUtil.showErrorModal('mm.login.passwordrequired', true);
            return;
        }
        var modal = $mmUtil.showModalLoading();
        return $mmSitesManager.getUserToken(siteurl, username, password).then(function(data) {
            return $mmSitesManager.newSite(data.siteurl, data.token, data.privatetoken).then(function() {
                delete $scope.credentials;
                $ionicHistory.nextViewOptions({disableBack: true});
                if (urlToOpen) {
                    return $mmContentLinksDelegate.getActionsFor(urlToOpen, undefined, username).then(function(actions) {
                        action = $mmContentLinksHelper.getFirstValidAction(actions);
                        if (action && action.sites.length) {
                            action.action(action.sites[0]);
                        } else {
                            return $mmLoginHelper.goToSiteInitialPage();
                        }
                    });
                } else {
                    return $mmLoginHelper.goToSiteInitialPage();
                }
            });
        }).catch(function(error) {
            $mmLoginHelper.treatUserTokenError(siteurl, error);
        }).finally(function() {
            modal.dismiss();
        });
    };
}]);

angular.module('mm.core.login')
.controller('mmLoginEmailSignupCtrl', ["$scope", "$stateParams", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmWS", "$q", "$translate", "$ionicModal", "$ionicScrollDelegate", "$mmUserProfileFieldsDelegate", "$mmSitesManager", "$mmText", function($scope, $stateParams, $mmUtil, $ionicHistory, $mmLoginHelper, $mmWS, $q, $translate,
            $ionicModal, $ionicScrollDelegate, $mmUserProfileFieldsDelegate, $mmSitesManager, $mmText) {
    var siteConfig,
        modalInitialized = false,
        scrollView = $ionicScrollDelegate.$getByHandle('mmLoginEmailSignupScroll');
    $scope.siteurl = $stateParams.siteurl;
    $scope.data = {};
    $scope.escapeForRegex = $mmText.escapeForRegex;
    $scope.usernameErrors = $mmLoginHelper.getErrorMessages('mm.login.usernamerequired');
    $scope.passwordErrors = $mmLoginHelper.getErrorMessages('mm.login.passwordrequired');
    $scope.emailErrors = $mmLoginHelper.getErrorMessages('mm.login.missingemail');
    $scope.email2Errors = $mmLoginHelper.getErrorMessages('mm.login.missingemail', null, 'mm.login.emailnotmatch');
    $scope.policyErrors = $mmLoginHelper.getErrorMessages('mm.login.policyagree');
    function fetchData() {
        return $mmSitesManager.getSitePublicConfig($scope.siteurl).then(function(config) {
            siteConfig = config;
            if (treatSiteConfig(siteConfig)) {
                return getSignupSettings();
            }
        }).catch(function(err) {
            $mmUtil.showErrorModal(err);
            return $q.reject();
        });
    }
    function treatSiteConfig(siteConfig) {
        if (siteConfig && siteConfig.registerauth == 'email' && !$mmLoginHelper.isEmailSignupDisabled(siteConfig)) {
            $scope.logourl = siteConfig.logourl || siteConfig.compactlogourl;
            $scope.authInstructions = siteConfig.authinstructions;
            initAuthInstructionsModal();
            return true;
        } else {
            $mmUtil.showErrorModal($translate.instant('mm.login.signupplugindisabled',
                    {$a: $translate.instant('mm.login.auth_email')}));
            $ionicHistory.goBack();
            return false;
        }
    }
    function getSignupSettings() {
        return $mmWS.callAjax('auth_email_get_signup_settings', {}, {siteurl: $scope.siteurl}).then(function(settings) {
            $scope.settings = settings;
            $scope.countries = $mmUtil.getCountryList();
            $scope.categories = $mmLoginHelper.formatProfileFieldsForSignup(settings.profilefields);
            if (settings.defaultcity && !$scope.data.city) {
                $scope.data.city = settings.defaultcity;
            }
            if (settings.country && !$scope.data.country) {
                $scope.data.country = settings.country;
            }
            $scope.namefieldsErrors = {};
            angular.forEach(settings.namefields, function(field) {
                $scope.namefieldsErrors[field] = $mmLoginHelper.getErrorMessages('mm.login.missing' + field);
            });
        });
    }
    function initAuthInstructionsModal() {
        if ($scope.authInstructions && !modalInitialized) {
            $ionicModal.fromTemplateUrl('core/components/login/templates/authinstructions-modal.html', {
                scope: $scope,
                animation: 'slide-in-up'
            }).then(function(modal) {
                modalInitialized = true;
                $scope.showAuthInstructions = function() {
                    modal.show();
                };
                $scope.closeAuthInstructions = function() {
                    modal.hide();
                };
                $scope.$on('$destroy', function() {
                    modal.remove();
                });
            });
        }
    }
    fetchData().finally(function() {
        $scope.settingsLoaded = true;
    });
    $scope.refreshSettings = function() {
        fetchData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.requestCaptcha = function() {
        var modal = $mmUtil.showModalLoading();
        $scope.data.recaptcharesponse = '';
        getSignupSettings().finally(function() {
            modal.dismiss();
        });
    };
    $scope.create = function(signupForm) {
        if (!signupForm.$valid) {
            return $mmUtil.scrollToInputError(document, scrollView).then(function(found) {
                if (!found) {
                    $mmUtil.showErrorModal('mm.core.errorinvalidform', true);
                }
            });
        } else {
            var fields = $scope.settings.profilefields,
                params = {
                    username: $scope.data.username.trim().toLowerCase(),
                    password: $scope.data.password,
                    firstname: $mmText.cleanTags($scope.data.firstname),
                    lastname: $mmText.cleanTags($scope.data.lastname),
                    email: $scope.data.email.trim(),
                    city: $mmText.cleanTags($scope.data.city),
                    country: $scope.data.country
                },
                modal = $mmUtil.showModalLoading('mm.core.sending', true);
            if (siteConfig.launchurl) {
                var service = $mmSitesManager.determineService($scope.siteurl);
                params.redirect = $mmLoginHelper.prepareForSSOLogin($scope.siteurl, service, siteConfig.launchurl);
            }
            if ($scope.settings.recaptchachallengehash && $scope.settings.recaptchachallengeimage) {
                params.recaptchachallengehash = $scope.settings.recaptchachallengehash;
                params.recaptcharesponse = $scope.data.recaptcharesponse;
            }
            $mmUserProfileFieldsDelegate.getDataForFields(fields, true, 'email', $scope.data).then(function(fieldsData) {
                params.customprofilefields = fieldsData;
                return $mmWS.callAjax('auth_email_signup_user', params, {siteurl: $scope.siteurl}).then(function(result) {
                    if (result.success) {
                        var message = $translate.instant('mm.login.emailconfirmsent', {$a: $scope.data.email});
                        $mmUtil.showModal('mm.core.success', message);
                        $ionicHistory.goBack();
                    } else {
                        if (result.warnings && result.warnings.length) {
                            $mmUtil.showErrorModal(result.warnings[0].message);
                        } else {
                            $mmUtil.showErrorModal('mm.login.usernotaddederror', true);
                        }
                        $scope.requestCaptcha();
                    }
                });
            }).catch(function(error) {
                if (error) {
                    $mmUtil.showErrorModal(error);
                } else {
                    $mmUtil.showErrorModal('mm.login.usernotaddederror', true);
                }
                $scope.requestCaptcha();
            }).finally(function() {
                modal.dismiss();
            });
        }
    };
}]);

angular.module('mm.core.login')
.controller('mmLoginInitCtrl', ["$log", "$ionicHistory", "$state", "$mmSitesManager", "$mmSite", "$mmApp", "$mmLoginHelper", function($log, $ionicHistory, $state, $mmSitesManager, $mmSite, $mmApp, $mmLoginHelper) {
    $log = $log.getInstance('mmLoginInitCtrl');
    $mmApp.ready().then(function() {
        $ionicHistory.nextViewOptions({
            disableAnimate: true,
            disableBack: true
        });
        var redirectData = $mmApp.getRedirect();
        if (redirectData.siteid && redirectData.state) {
            $mmApp.storeRedirect('', '', '');
            if (new Date().getTime() - redirectData.timemodified < 20000) {
                return $mmSitesManager.loadSite(redirectData.siteid).then(function() {
                    if (!$mmLoginHelper.isSiteLoggedOut(redirectData.state, redirectData.params)) {
                        $state.go(redirectData.state, redirectData.params);
                    }
                }).catch(function() {
                    loadCurrent();
                });
            }
        }
        loadCurrent();
    });
    function loadCurrent() {
        if ($mmSite.isLoggedIn()) {
            if (!$mmLoginHelper.isSiteLoggedOut()) {
                $mmLoginHelper.goToSiteInitialPage();
            }
        } else {
            $mmSitesManager.hasSites().then(function() {
                return $state.go('mm_login.sites');
            }, function() {
                return $mmLoginHelper.goToAddSite();
            });
        }
    }
}]);

angular.module('mm.core.login')
.controller('mmLoginReconnectCtrl', ["$scope", "$state", "$stateParams", "$mmSitesManager", "$mmApp", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmSite", function($scope, $state, $stateParams, $mmSitesManager, $mmApp, $mmUtil, $ionicHistory,
            $mmLoginHelper, $mmSite) {
    var infositeurl = $stateParams.infositeurl,
        stateName = $stateParams.statename,
        stateParams = $stateParams.stateparams;
    $scope.siteurl = $stateParams.siteurl;
    $scope.credentials = {
        username: $stateParams.username,
        password: ''
    };
    $scope.isLoggedOut = $mmSite.isLoggedOut();
    $mmSitesManager.getSite($stateParams.siteid).then(function(site) {
        $scope.site = {
            id: site.id,
            fullname: site.infos.fullname,
            avatar: site.infos.userpictureurl
        };
        $scope.credentials.username = site.infos.username;
        $scope.siteurl = site.infos.siteurl;
    });
    $scope.cancel = function() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    };
    $scope.login = function() {
        $mmApp.closeKeyboard();
        var siteurl = $scope.siteurl,
            username = $scope.credentials.username,
            password = $scope.credentials.password;
        if (!password) {
            $mmUtil.showErrorModal('mm.login.passwordrequired', true);
            return;
        }
        var modal = $mmUtil.showModalLoading();
        $mmSitesManager.getUserToken(siteurl, username, password).then(function(data) {
            $mmSitesManager.updateSiteToken(infositeurl, username, data.token, data.privatetoken).then(function() {
                $mmSitesManager.updateSiteInfoByUrl(infositeurl, username).finally(function() {
                    delete $scope.credentials;
                    $ionicHistory.nextViewOptions({disableBack: true});
                    if (stateName) {
                        return $state.go(stateName, stateParams);
                    } else {
                        return $mmLoginHelper.goToSiteInitialPage();
                    }
                });
            }, function() {
                $mmUtil.showErrorModal('mm.login.errorupdatesite', true);
                $scope.cancel();
            }).finally(function() {
                modal.dismiss();
            });
        }, function(error) {
            modal.dismiss();
            $mmLoginHelper.treatUserTokenError(siteurl, error);
        });
    };
}]);

angular.module('mm.core.login')
.controller('mmLoginSiteCtrl', ["$scope", "$state", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$mmApp", "$ionicModal", "$ionicPopup", "$mmLoginHelper", "$q", function($scope, $state, $mmSitesManager, $mmUtil, $ionicHistory, $mmApp, $ionicModal, $ionicPopup,
        $mmLoginHelper, $q) {
    $scope.siteurl = '';
    $scope.connect = function(url) {
        $mmApp.closeKeyboard();
        if (!url) {
            $mmUtil.showErrorModal('mm.login.siteurlrequired', true);
            return;
        }
        var modal = $mmUtil.showModalLoading(),
            sitedata = $mmSitesManager.getDemoSiteData(url);
        if (sitedata) {
            $mmSitesManager.getUserToken(sitedata.url, sitedata.username, sitedata.password).then(function(data) {
                $mmSitesManager.newSite(data.siteurl, data.token, data.privatetoken).then(function() {
                    $ionicHistory.nextViewOptions({disableBack: true});
                    return $mmLoginHelper.goToSiteInitialPage();
                }, function(error) {
                    $mmUtil.showErrorModal(error);
                }).finally(function() {
                    modal.dismiss();
                });
            }, function(error) {
                modal.dismiss();
                $mmLoginHelper.treatUserTokenError(sitedata.url, error);
            });
        } else {
            $mmSitesManager.checkSite(url).then(function(result) {
                if (result.warning) {
                    $mmUtil.showErrorModal(result.warning, true, 4000);
                }
                if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                    $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                } else {
                    $state.go('mm_login.credentials', {siteurl: result.siteurl, siteconfig: result.config});
                }
            }, function(error) {
                showLoginIssue(url, error);
            }).finally(function() {
                modal.dismiss();
            });
        }
    };
    $mmUtil.getDocsUrl().then(function(docsurl) {
        $scope.docsurl = docsurl;
    });
    function showLoginIssue(siteurl, issue) {
        $scope.siteurl = siteurl;
        $scope.issue = issue;
        var popup = $ionicPopup.show({
            templateUrl:  'core/components/login/templates/login-issue.html',
            scope: $scope,
            cssClass: 'mm-nohead mm-bigpopup'
        });
        $scope.closePopup = function() {
            popup.close();
        };
        return popup.then(function() {
            return $q.reject();
        });
    }
    $ionicModal.fromTemplateUrl('core/components/login/templates/help-modal.html', {
        scope: $scope,
        animation: 'slide-in-up'
    }).then(function(helpModal) {
        $scope.showHelp = function() {
            helpModal.show();
        };
        $scope.closeHelp = function() {
            helpModal.hide();
        };
        $scope.$on('$destroy', function() {
            helpModal.remove();
        });
    });
}]);

angular.module('mm.core.login')
.controller('mmLoginSitePolicyCtrl', ["$scope", "$state", "$stateParams", "$mmSitesManager", "$mmSite", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmWS", "$q", "$sce", "$mmFS", function($scope, $state, $stateParams, $mmSitesManager, $mmSite, $mmUtil, $ionicHistory,
            $mmLoginHelper, $mmWS, $q, $sce, $mmFS) {
    var siteId = $stateParams.siteid || $mmSite.getId();
    if (!siteId || siteId != $mmSite.getId() || !$mmSite.wsAvailable('core_user_agree_site_policy')) {
        cancel();
        return;
    }
    function fetchSitePolicy() {
        return $mmWS.callAjax('auth_email_get_signup_settings', {}, {siteurl: $mmSite.getURL()}).then(function(settings) {
            if (!settings.sitepolicy) {
                return $q.reject();
            }
            $scope.sitePolicy = settings.sitepolicy;
            return $mmUtil.getMimeType($scope.sitePolicy).then(function(mimeType) {
                var extension = $mmFS.getExtension(mimeType, $scope.sitePolicy);
                $scope.showInline = extension == 'html' || extension == 'html';
                if ($scope.showInline) {
                    $scope.trustedSitePolicy = $sce.trustAsResourceUrl(settings.sitepolicy);
                }
            }).catch(function() {
                $scope.showInline = false;
            }).finally(function() {
                $scope.policyLoaded = true;
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'Error getting site policy.');
            cancel();
        });
    }
    fetchSitePolicy();
    $scope.cancel = function() {
        cancel();
    };
    $scope.accept = function() {
        var modal = $mmUtil.showModalLoading('mm.core.sending', true);
        $mmLoginHelper.acceptSitePolicy(siteId).then(function() {
            return $mmSite.invalidateWsCache().catch(function() {
            }).then(function() {
                $ionicHistory.nextViewOptions({disableBack: true});
                return $mmLoginHelper.goToSiteInitialPage();
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'Error accepting site policy.');
        }).finally(function() {
            modal.dismiss();
        });
    };
    function cancel() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
}]);

angular.module('mm.core.login')
.controller('mmLoginSitesCtrl', ["$scope", "$mmSitesManager", "$log", "$translate", "$mmUtil", "$ionicHistory", "$mmText", "$mmLoginHelper", "$mmAddonManager", function($scope, $mmSitesManager, $log, $translate, $mmUtil, $ionicHistory, $mmText, $mmLoginHelper,
            $mmAddonManager) {
    $log = $log.getInstance('mmLoginSitesCtrl');
    var $mmaPushNotifications = $mmAddonManager.get('$mmaPushNotifications');
    $mmSitesManager.getSites().then(function(sites) {
        sites = sites.map(function(site) {
            site.siteurl = site.siteurl.replace(/^https?:\/\//, '');
            site.badge = 0;
            if ($mmaPushNotifications) {
                $mmaPushNotifications.getSiteCounter(site.id).then(function(number) {
                    site.badge = number;
                });
            }
            return site;
        });
        $scope.sites = sites.sort(function(a, b) {
            var compareA = a.siteurl.toLowerCase(),
                compareB = b.siteurl.toLowerCase(),
                compare = compareA.localeCompare(compareB);
            if (compare !== 0) {
                return compare;
            }
            compareA = a.fullname.toLowerCase().trim();
            compareB = b.fullname.toLowerCase().trim();
            return compareA.localeCompare(compareB);
        });
        $scope.data = {
            hasSites: sites.length > 0,
            showDelete: false
        };
    });
    $scope.toggleDelete = function() {
        $scope.data.showDelete = !$scope.data.showDelete;
    };
    $scope.onItemDelete = function(e, index) {
        e.stopPropagation();
        var site = $scope.sites[index],
            sitename = site.sitename;
        $mmText.formatText(sitename).then(function(sitename) {
            $mmUtil.showConfirm($translate.instant('mm.login.confirmdeletesite', {sitename: sitename})).then(function() {
                $mmSitesManager.deleteSite(site.id).then(function() {
                    $scope.sites.splice(index, 1);
                    $scope.data.showDelete = false;
                    $mmSitesManager.hasNoSites().then(function() {
                        $ionicHistory.nextViewOptions({disableBack: true});
                        $mmLoginHelper.goToAddSite();
                    });
                }, function() {
                    $log.error('Delete site failed');
                    $mmUtil.showErrorModal('mm.login.errordeletesite', true);
                });
            });
        });
    };
    $scope.login = function(siteId) {
        var modal = $mmUtil.showModalLoading();
        $mmSitesManager.loadSite(siteId).then(function() {
            if (!$mmLoginHelper.isSiteLoggedOut()) {
                $ionicHistory.nextViewOptions({disableBack: true});
                return $mmLoginHelper.goToSiteInitialPage();
            }
        }, function(error) {
            $log.error('Error loading site ' + siteId);
            error = error || 'Error loading site.';
            $mmUtil.showErrorModal(error);
        }).finally(function() {
            modal.dismiss();
        });
    };
    $scope.add = function() {
        $mmLoginHelper.goToAddSite();
    };
}]);

angular.module('mm.core.login')
.constant('mmLoginSSOCode', 2)
.constant('mmLoginSSOInAppCode', 3)
.constant('mmLoginLaunchSiteURL', 'mmLoginLaunchSiteURL')
.constant('mmLoginLaunchPassport', 'mmLoginLaunchPassport')
.constant('mmLoginLaunchData', 'mmLoginLaunchData')
.factory('$mmLoginHelper', ["$q", "$log", "$mmConfig", "mmLoginSSOCode", "mmLoginSSOInAppCode", "mmLoginLaunchData", "$mmEvents", "md5", "$mmSite", "$mmSitesManager", "$mmLang", "$mmUtil", "$state", "$mmAddonManager", "$translate", "mmCoreConfigConstants", "mmCoreEventSessionExpired", "mmUserProfileState", "$mmCourses", function($q, $log, $mmConfig, mmLoginSSOCode, mmLoginSSOInAppCode, mmLoginLaunchData, $mmEvents,
            md5, $mmSite, $mmSitesManager, $mmLang, $mmUtil, $state, $mmAddonManager, $translate, mmCoreConfigConstants,
            mmCoreEventSessionExpired, mmUserProfileState, $mmCourses) {
    $log = $log.getInstance('$mmLoginHelper');
    var self = {};
        self.acceptSitePolicy = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.write('core_user_agree_site_policy', {}).then(function(result) {
                if (!result.status) {
                    if (result.warnings && result.warnings.length) {
                        return $q.reject(result.warnings[0].message);
                    } else {
                        return $q.reject();
                    }
                }
            });
        });
    };
        self.confirmAndOpenBrowserForSSOLogin = function(siteurl, typeOfLogin, service, launchUrl) {
        var showConfirmation = self.shouldShowSSOConfirm(typeOfLogin),
            promise = showConfirmation ? $mmUtil.showConfirm($translate('mm.login.logininsiterequired')) : $q.when();
        promise.then(function() {
            self.openBrowserForSSOLogin(siteurl, typeOfLogin, service, launchUrl);
        });
    };
        self.formatProfileFieldsForSignup = function(profileFields) {
        var categories = {};
        angular.forEach(profileFields, function(field) {
            if (!field.signup) {
                return;
            }
            if (!categories[field.categoryid]) {
                categories[field.categoryid] = {
                    id: field.categoryid,
                    name: field.categoryname,
                    fields: []
                };
            }
            categories[field.categoryid].fields.push(field);
        });
        return categories;
    };
        self.getErrorMessages = function(requiredMsg, emailMsg, patternMsg, urlMsg, minlengthMsg, maxlengthMsg, minMsg, maxMsg) {
        var errors = {};
        if (requiredMsg) {
            errors.required = $translate.instant(requiredMsg);
        }
        if (emailMsg) {
            errors.email = $translate.instant(emailMsg);
        }
        if (patternMsg) {
            errors.pattern = $translate.instant(patternMsg);
        }
        if (urlMsg) {
            errors.url = $translate.instant(urlMsg);
        }
        if (minlengthMsg) {
            errors.minlength = $translate.instant(minlengthMsg);
        }
        if (maxlengthMsg) {
            errors.maxlength = $translate.instant(maxlengthMsg);
        }
        if (minMsg) {
            errors.min = $translate.instant(minMsg);
        }
        if (maxMsg) {
            errors.max = $translate.instant(maxMsg);
        }
        return errors;
    };
        self.goToAddSite = function() {
        if (mmCoreConfigConstants.siteurl) {
            return $state.go('mm_login.credentials', {siteurl: mmCoreConfigConstants.siteurl});
        } else {
            return $state.go('mm_login.site');
        }
    };
        self.goToSiteInitialPage = function() {
        var myCoursesDisabled = $mmCourses.isMyCoursesDisabledInSite();
        if (myCoursesDisabled || ($mmSite.getInfo() && $mmSite.getInfo().userhomepage === 0)) {
            var $mmaFrontpage = $mmAddonManager.get('$mmaFrontpage');
            if ($mmaFrontpage && !$mmaFrontpage.isDisabledInSite()) {
                return $mmaFrontpage.isFrontpageAvailable().then(function() {
                    return $state.go('site.frontpage');
                }).catch(function() {
                    if (!myCoursesDisabled) {
                        return $state.go('site.mm_courses');
                    }
                    return $state.go(mmUserProfileState, {userid: $mmSite.getUserId()});
                });
            }
        }
        if (!myCoursesDisabled) {
            return $state.go('site.mm_courses');
        }
        return $state.go(mmUserProfileState, {userid: $mmSite.getUserId()});
    };
        self.isEmailSignupDisabled = function(config) {
        var disabledFeatures = config && config.tool_mobile_disabledfeatures;
        if (!disabledFeatures) {
            return false;
        }
        var regEx = new RegExp('(,|^)\\$mmLoginEmailSignup(,|$)', 'g');
        return !!disabledFeatures.match(regEx);
    };
        self.isFixedUrlSet = function() {
        return !!mmCoreConfigConstants.siteurl;
    };
        self.isSiteLoggedOut = function(stateName, stateParams) {
        if ($mmSite.isLoggedOut()) {
            $mmEvents.trigger(mmCoreEventSessionExpired, {
                siteid: $mmSite.getId(),
                statename: stateName,
                stateparams: stateParams
            });
            return true;
        }
        return false;
    };
        self.isSSOEmbeddedBrowser = function(code) {
        return code == mmLoginSSOInAppCode;
    };
        self.isSSOLoginNeeded = function(code) {
        return code == mmLoginSSOCode || code == mmLoginSSOInAppCode;
    };
        self.openBrowserForSSOLogin = function(siteurl, typeOfLogin, service, launchUrl, stateName, stateParams) {
        var loginUrl = self.prepareForSSOLogin(siteurl, service, launchUrl, stateName, stateParams);
        if (self.isSSOEmbeddedBrowser(typeOfLogin)) {
            var options = {
                clearsessioncache: 'yes',
                closebuttoncaption: $translate.instant('mm.login.cancel'),
            };
            $mmUtil.openInApp(loginUrl, options);
        } else {
            $mmUtil.openInBrowser(loginUrl);
            if (navigator.app) {
                navigator.app.exitApp();
            }
        }
    };
        self.prepareForSSOLogin = function(siteUrl, service, launchUrl, stateName, stateParams) {
        service = service || mmCoreConfigConstants.wsextservice;
        launchUrl = launchUrl || siteUrl + '/local/mobile/launch.php';
        var passport = Math.random() * 1000,
            loginUrl = launchUrl + '?service=' + service;
        loginUrl += "&passport=" + passport;
        loginUrl += "&urlscheme=" + mmCoreConfigConstants.customurlscheme;
        $mmConfig.set(mmLoginLaunchData, {
            siteurl: siteUrl,
            passport: passport,
            statename: stateName || '',
            stateparams: stateParams || {}
        });
        return loginUrl;
    };
        self.shouldShowSSOConfirm = function(typeOfLogin) {
        return !self.isSSOEmbeddedBrowser(typeOfLogin) &&
                    (!mmCoreConfigConstants.skipssoconfirmation || mmCoreConfigConstants.skipssoconfirmation === 'false');
    };
        self.validateBrowserSSOLogin = function(url) {
        var params = url.split(":::");
        return $mmConfig.get(mmLoginLaunchData).then(function(data) {
            var launchSiteURL = data.siteurl,
                passport = data.passport;
            $mmConfig.delete(mmLoginLaunchData);
            var signature = md5.createHash(launchSiteURL + passport);
            if (signature != params[0]) {
                if (launchSiteURL.indexOf("https://") != -1) {
                    launchSiteURL = launchSiteURL.replace("https://", "http://");
                } else {
                    launchSiteURL = launchSiteURL.replace("http://", "https://");
                }
                signature = md5.createHash(launchSiteURL + passport);
            }
            if (signature == params[0]) {
                $log.debug('Signature validated');
                return {
                    siteurl: launchSiteURL,
                    token: params[1],
                    privateToken: params[2],
                    statename: data.statename,
                    stateparams: data.stateparams
                };
            } else {
                $log.debug('Inalid signature in the URL request yours: ' + params[0] + ' mine: '
                                + signature + ' for passport ' + passport);
                return $mmLang.translateAndReject('mm.core.unexpectederror');
            }
        });
    };
        self.handleSSOLoginAuthentication = function(siteurl, token, privateToken) {
        if ($mmSite.isLoggedIn()) {
            var info = $mmSite.getInfo();
            if (typeof info != 'undefined' && typeof info.username != 'undefined') {
                return $mmSitesManager.updateSiteToken(info.siteurl, info.username, token, privateToken).then(function() {
                    $mmSitesManager.updateSiteInfoByUrl(info.siteurl, info.username);
                }).catch(function() {
                    return $mmLang.translateAndReject('mm.login.errorupdatesite');
                });
            }
            return $mmLang.translateAndReject('mm.login.errorupdatesite');
        } else {
            return $mmSitesManager.newSite(siteurl, token, privateToken);
        }
    };
        self.treatUserTokenError = function(siteurl, error) {
        if (typeof error == 'string') {
            $mmUtil.showErrorModal(error);
        } else if (error.errorcode == 'forcepasswordchangenotice') {
            self.openChangePassword(siteurl, error.error);
        } else {
            $mmUtil.showErrorModal(error.error);
        }
    };
        self.openChangePassword = function(siteurl, error) {
        return $mmUtil.showModal('mm.core.notice', error, 3000).then(function() {
            var changepasswordurl = siteurl + '/login/change_password.php';
            $mmUtil.openInApp(changepasswordurl);
        });
    };
    return self;
}]);

angular.module('mm.core.question')
.directive('mmQuestionBehaviour', ["$compile", function($compile) {
    return {
        restrict: 'A',
        link: function(scope, element) {
            if (scope.directive) {
                element[0].removeAttribute('mm-question-behaviour');
                element[0].setAttribute(scope.directive, '');
                $compile(element)(scope);
            }
        }
    };
}]);

angular.module('mm.core.question')
.directive('mmQuestion', ["$log", "$compile", "$mmQuestionDelegate", "$mmQuestionHelper", "$mmQuestionBehaviourDelegate", "$mmUtil", "$translate", "$q", "$mmQuestion", function($log, $compile, $mmQuestionDelegate, $mmQuestionHelper, $mmQuestionBehaviourDelegate, $mmUtil,
            $translate, $q, $mmQuestion) {
    $log = $log.getInstance('mmQuestion');
    return {
        restrict: 'E',
        templateUrl: 'core/components/question/templates/question.html',
        scope: {
            question: '=',
            component: '=?',
            componentId: '=?',
            attemptId: '=?',
            abort: '&',
            buttonClicked: '&?',
            offlineEnabled: '@?',
            scrollHandle: '@?'
        },
        link: function(scope, element) {
            var question = scope.question,
                component = scope.component,
                attemptId = scope.attemptId,
                questionContainer = element[0].querySelector('.mm-question-container'),
                behaviour,
                promise,
                offline = scope.offlineEnabled && scope.offlineEnabled !== '0' && scope.offlineEnabled !== 'false';
            if (question && questionContainer) {
                var directive = $mmQuestionDelegate.getDirectiveForQuestion(question);
                if (directive) {
                    $mmQuestionHelper.extractQuestionScripts(question);
                    behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, question.preferredBehaviour);
                    if (!$mmQuestionBehaviourDelegate.isBehaviourSupported(behaviour)) {
                        $log.warn('Aborting question because the behaviour is not supported.', question.name);
                        $mmQuestionHelper.showDirectiveError(scope,
                                $translate.instant('mma.mod_quiz.errorbehaviournotsupported') + ' ' + behaviour);
                        return;
                    }
                    scope.seqCheck = $mmQuestionHelper.getQuestionSequenceCheckFromHtml(question.html);
                    if (!scope.seqCheck) {
                        $log.warn('Aborting question because couldn\'t retrieve sequence check.', question.name);
                        $mmQuestionHelper.showDirectiveError(scope);
                        return;
                    }
                    if (offline) {
                        promise = $mmQuestion.getQuestionAnswers(component, attemptId, question.slot).then(function(answers) {
                            question.localAnswers = $mmQuestion.convertAnswersArrayToObject(answers, true);
                        }).catch(function() {
                            question.localAnswers = {};
                        });
                    } else {
                        question.localAnswers = {};
                        promise = $q.when();
                    }
                    promise.then(function() {
                        scope.behaviourDirectives = $mmQuestionBehaviourDelegate.handleQuestion(
                                        question, question.preferredBehaviour);
                        $mmQuestionHelper.extractQbehaviourRedoButton(question);
                        question.html = $mmUtil.removeElementFromHtml(question.html, '.im-controls');
                        question.validationError = $mmQuestionHelper.getValidationErrorFromHtml(question.html);
                        $mmQuestionHelper.loadLocalAnswersInHtml(question);
                        $mmQuestionHelper.extractQuestionFeedback(question);
                        $mmQuestionHelper.extractQuestionComment(question);
                        questionContainer.setAttribute(directive, '');
                        $compile(questionContainer)(scope);
                    });
                }
            }
        }
    };
}]);

angular.module('mm.core.question')
.provider('$mmQuestionBehaviourDelegate', function() {
    var handlers = {},
        self = {};
        self.registerHandler = function(name, behaviour, handler) {
        if (typeof handlers[behaviour] !== 'undefined') {
            console.log("$mmQuestionBehaviourDelegateProvider: Addon '" + name +
                            "' already registered as handler for '" + behaviour + "'");
            return false;
        }
        console.log("$mmQuestionBehaviourDelegateProvider: Registered handler '" + name + "' for behaviour '" + behaviour + "'");
        handlers[behaviour] = {
            addon: name,
            instance: undefined,
            handler: handler
        };
    };
    self.$get = ["$log", "$q", "$mmUtil", "$mmSite", "$mmQuestionDelegate", function($log, $q, $mmUtil, $mmSite, $mmQuestionDelegate) {
        $log = $log.getInstance('$mmQuestionBehaviourDelegate');
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
                self.determineQuestionState = function(behaviour, component, attemptId, question, siteId) {
            behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, behaviour);
            var handler = enabledHandlers[behaviour];
            if (typeof handler != 'undefined' && handler.determineQuestionState) {
                return $q.when(handler.determineQuestionState(component, attemptId, question, siteId));
            }
            return $q.when(false);
        };
                self.handleQuestion = function(question, behaviour) {
            behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, behaviour);
            if (typeof enabledHandlers[behaviour] != 'undefined') {
                return enabledHandlers[behaviour].handleQuestion(question);
            }
        };
                self.isBehaviourSupported = function(behaviour) {
            return typeof enabledHandlers[behaviour] != 'undefined';
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateQuestionBehaviourHandler = function(behaviour, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[behaviour] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[behaviour];
                    }
                }
            });
        };
                self.updateQuestionBehaviourHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating question behaviour handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, behaviour) {
                promises.push(self.updateQuestionBehaviourHandler(behaviour, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.question')
.provider('$mmQuestionDelegate', function() {
    var handlers = {},
        self = {};
        self.registerHandler = function(name, questionType, handler) {
        if (typeof handlers[questionType] !== 'undefined') {
            console.log("$mmQuestionDelegateProvider: Addon '" + name + "' already registered as handler for '" + questionType + "'");
            return false;
        }
        console.log("$mmQuestionDelegateProvider: Registered handler '" + name + "' for question type '" + questionType + "'");
        handlers[questionType] = {
            addon: name,
            instance: undefined,
            handler: handler
        };
    };
    self.$get = ["$log", "$q", "$mmUtil", "$mmSite", function($log, $q, $mmUtil, $mmSite) {
        $log = $log.getInstance('$mmQuestionDelegate');
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
                self.getBehaviourForQuestion = function(question, behaviour) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined' && enabledHandlers[type].getBehaviour) {
                var questionBehaviour = enabledHandlers[type].getBehaviour(question, behaviour);
                if (questionBehaviour) {
                    return questionBehaviour;
                }
            }
            return behaviour;
        };
                self.getDirectiveForQuestion = function(question) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                return enabledHandlers[type].getDirectiveName(question);
            }
        };
                self.getPreventSubmitMessage = function(question) {
            var type = 'qtype_' + question.type,
                handler = enabledHandlers[type];
            if (typeof handler != 'undefined' && handler.getPreventSubmitMessage) {
                return handler.getPreventSubmitMessage(question);
            }
        };
                self.isCompleteResponse = function(question, answers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isCompleteResponse) {
                    return enabledHandlers[type].isCompleteResponse(question, answers);
                }
            }
            return -1;
        };
                self.isGradableResponse = function(question, answers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isGradableResponse) {
                    return enabledHandlers[type].isGradableResponse(question, answers);
                }
            }
            return -1;
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.isSameResponse = function(question, prevAnswers, newAnswers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isSameResponse) {
                    return enabledHandlers[type].isSameResponse(question, prevAnswers, newAnswers);
                }
            }
            return false;
        };
                self.isQuestionSupported = function(type) {
            return typeof enabledHandlers['qtype_' + type] != 'undefined';
        };
                self.updateQuestionHandler = function(questionType, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[questionType] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[questionType];
                    }
                }
            });
        };
                self.updateQuestionHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating question handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, questionType) {
                promises.push(self.updateQuestionHandler(questionType, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
                self.validateSequenceCheck = function(question, offlineSequenceCheck) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].validateSequenceCheck) {
                    return enabledHandlers[type].validateSequenceCheck(question, offlineSequenceCheck);
                } else {
                    return question.sequencecheck == offlineSequenceCheck;
                }
            }
            return false;
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.question')
.factory('$mmQuestionHelper', ["$mmUtil", "$mmText", "$ionicModal", "mmQuestionComponent", "$mmSitesManager", "$mmFilepool", "$q", "$mmQuestion", "$mmSite", function($mmUtil, $mmText, $ionicModal, mmQuestionComponent, $mmSitesManager, $mmFilepool, $q,
            $mmQuestion, $mmSite) {
    var self = {},
        lastErrorShown = 0;
        function addBehaviourButton(question, button) {
        if (!button || !question) {
            return;
        }
        if (!question.behaviourButtons) {
            question.behaviourButtons = [];
        }
        question.behaviourButtons.push({
            id: button.id,
            name: button.name,
            value: button.value,
            disabled: button.disabled
        });
    }
        self.directiveInit = function(scope, log) {
        var question = scope.question,
            questionEl;
        if (!question) {
            log.warn('Aborting because of no question received.');
            return self.showDirectiveError(scope);
        }
        questionEl = angular.element(question.html);
        question.text = $mmUtil.getContentsOfElement(questionEl, '.qtext');
        if (typeof question.text == 'undefined') {
            log.warn('Aborting because of an error parsing question.', question.name);
            return self.showDirectiveError(scope);
        }
        return questionEl;
    };
        self.extractQbehaviourButtons = function(question, selector) {
        selector = selector || '.im-controls input[type="submit"]';
        var div = document.createElement('div'),
            buttons;
        div.innerHTML = question.html;
        buttons = div.querySelectorAll(selector);
        angular.forEach(buttons, function(button) {
            addBehaviourButton(question, button);
        });
        question.html = div.innerHTML;
    };
        self.extractQbehaviourCBM = function(question) {
        var div = document.createElement('div'),
            labels;
        div.innerHTML = question.html;
        labels = div.querySelectorAll('.im-controls .certaintychoices label[for*="certainty"]');
        question.behaviourCertaintyOptions = [];
        angular.forEach(labels, function(label) {
            var input = label.querySelector('input[type="radio"]');
            if (input) {
                question.behaviourCertaintyOptions.push({
                    id: input.id,
                    name: input.name,
                    value: input.value,
                    text: $mmText.cleanTags(label.innerHTML),
                    disabled: input.disabled
                });
                if (input.checked) {
                    question.behaviourCertaintySelected = input.value;
                }
            }
        });
        if (question.localAnswers && typeof question.localAnswers['-certainty'] != 'undefined') {
            question.behaviourCertaintySelected = question.localAnswers['-certainty'];
        }
        return labels && labels.length;
    };
        self.extractQbehaviourRedoButton = function(question) {
        var div = document.createElement('div'),
            redoSelector = 'input[type="submit"][name*=redoslot], input[type="submit"][name*=tryagain]';
        if (!searchButton('html', '.outcome ' + redoSelector)) {
            if (question.feedbackHtml) {
                if (searchButton('feedbackHtml', redoSelector)) {
                    return;
                }
            }
            if (question.infoHtml) {
                searchButton('infoHtml', redoSelector);
            }
        }
        function searchButton(htmlProperty, selector) {
            var button;
            div.innerHTML = question[htmlProperty];
            button = div.querySelector(selector);
            if (button) {
                addBehaviourButton(question, button);
                angular.element(button).remove();
                question[htmlProperty] = div.innerHTML;
                return true;
            }
            return false;
        }
    };
        self.extractQbehaviourSeenInput = function(question) {
        var div = document.createElement('div'),
            seenInput;
        div.innerHTML = question.html;
        seenInput = div.querySelector('input[type="hidden"][name*=seen]');
        if (seenInput) {
            question.behaviourSeenInput = {
                name: seenInput.name,
                value: seenInput.value
            };
            angular.element(seenInput).remove();
            question.html = div.innerHTML;
            return true;
        }
        return false;
    };
        self.extractQuestionComment = function(question) {
        extractQuestionLastElementNotInContent(question, '.comment', 'commentHtml');
    };
        self.extractQuestionFeedback = function(question) {
        extractQuestionLastElementNotInContent(question, '.outcome', 'feedbackHtml');
    };
        self.extractQuestionInfoBox = function(question, selector) {
        extractQuestionLastElementNotInContent(question, selector, 'infoHtml');
    };
        function extractQuestionLastElementNotInContent(question, selector, attrName) {
        var div = document.createElement('div'),
            matches,
            last,
            position;
        div.innerHTML = question.html;
        matches = div.querySelectorAll(selector);
        position = matches.length -1;
        last = matches[position];
        while (last) {
            if (!$mmUtil.closest(last, '.formulation')) {
                question[attrName] = last.innerHTML;
                angular.element(last).remove();
                question.html = div.innerHTML;
                return;
            }
            position--;
            last = matches[position];
        }
    }
        self.extractQuestionScripts = function(question) {
        var matches;
        question.scriptsCode = '';
        question.initObjects = [];
        if (question.html) {
            matches = question.html.match(/<script[^>]*>[\s\S]*?<\/script>/mg);
            angular.forEach(matches, function(match) {
                question.scriptsCode += match;
                question.html = question.html.replace(match, '');
                var initMatches = match.match(new RegExp('M\.qtype_' + question.type + '\.init_question\\(.*?}\\);', 'mg'));
                if (initMatches) {
                    var initMatch = initMatches.pop();
                    initMatch = initMatch.replace('M.qtype_' + question.type + '.init_question(', '');
                    initMatch = initMatch.substr(0, initMatch.length - 2);
                    try {
                        question.initObjects = JSON.parse(initMatch);
                    } catch(ex) {}
                }
            });
        }
    };
        self.getAllInputNamesFromHtml = function(html) {
        var form = document.createElement('form'),
            answers = {};
        form.innerHTML = html;
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            answers[$mmQuestion.removeQuestionPrefix(name)] = true;
        });
        return answers;
    };
        self.getAnswersFromForm = function(form) {
        if (!form || !form.elements) {
            return {};
        }
        var answers = {};
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            if (element.type == 'checkbox') {
                answers[name] = !!element.checked;
            } else if (element.type == 'radio') {
                if (element.checked) {
                    answers[name] = element.value;
                }
            } else {
                answers[name] = element.value;
            }
        });
        return answers;
    };
        self.getQuestionAttachmentsFromHtml = function(html) {
        var el = angular.element('<div></div>'),
            anchors,
            attachments = [];
        el.html(html);
        el = el[0];
        $mmUtil.removeElement(el, 'div[id*=filemanager]');
        anchors = el.querySelectorAll('a');
        angular.forEach(anchors, function(anchor) {
            var content = anchor.innerHTML;
            if (anchor.href && content) {
                content = $mmText.cleanTags(content, true).trim();
                attachments.push({
                    filename: content,
                    fileurl: anchor.href
                });
            }
        });
        return attachments;
    };
        self.getQuestionSequenceCheckFromHtml = function(html) {
        var el,
            input;
        if (html) {
            el = angular.element(html)[0];
            input = el.querySelector('input[name*=sequencecheck]');
            if (input && typeof input.name != 'undefined' && typeof input.value != 'undefined') {
                return {
                    name: input.name,
                    value: input.value
                };
            }
        }
    };
        self.getQuestionStateClass = function(name) {
        var state = $mmQuestion.getState(name);
        return state ? state.class : '';
    };
        self.getValidationErrorFromHtml = function(html) {
        return $mmUtil.getContentsOfElement(angular.element(html), '.validationerror');
    };
        self.hasDraftFileUrls = function(html) {
        var url = $mmSite.getURL();
        if (url.slice(-1) != '/') {
            url = url += '/';
        }
        url += 'draftfile.php';
        return html.indexOf(url) != -1;
    };
        self.inputTextDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log);
        if (questionEl) {
            questionEl = questionEl[0] || questionEl;
            input = questionEl.querySelector('input[type="text"][name*=answer]');
            if (!input) {
                log.warn('Aborting because couldn\'t find input.', question.name);
                return self.showDirectiveError(scope);
            }
            scope.input = {
                id: input.id,
                name: input.name,
                value: input.value,
                readOnly: input.readOnly
            };
            if (input.className.indexOf('incorrect') >= 0) {
                scope.input.isCorrect = 0;
            } else if (input.className.indexOf('correct') >= 0) {
                scope.input.isCorrect = 1;
            }
        }
    };
        self.loadLocalAnswersInHtml = function(question) {
        var form = document.createElement('form');
        form.innerHTML = question.html;
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            name = $mmQuestion.removeQuestionPrefix(name);
            if (question.localAnswers && typeof question.localAnswers[name] != 'undefined') {
                var selected;
                if (element.tagName == 'TEXTAREA') {
                    element.innerHTML = question.localAnswers[name];
                } else if (element.tagName == 'SELECT') {
                    selected = element.querySelector('option[value="' + question.localAnswers[name] + '"]');
                    if (selected) {
                        selected.setAttribute('selected', 'selected');
                    }
                } else if (element.type == 'radio' || element.type == 'checkbox') {
                    if (element.value == question.localAnswers[name]) {
                        element.setAttribute('checked', 'checked');
                    }
                } else {
                    element.setAttribute('value', question.localAnswers[name]);
                }
            }
        });
        question.html = form.innerHTML;
    };
        self.matchingDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log),
            question = scope.question,
            rows;
        if (questionEl) {
            questionEl = questionEl[0] || questionEl;
            rows = questionEl.querySelectorAll('tr');
            if (!rows || !rows.length) {
                log.warn('Aborting because couldn\'t find any row.', question.name);
                return self.showDirectiveError(scope);
            }
            question.rows = [];
            angular.forEach(rows, function(row) {
                var rowModel = {},
                    select,
                    options,
                    accessibilityLabel,
                    columns = row.querySelectorAll('td');
                if (!columns || columns.length < 2) {
                    log.warn('Aborting because couldn\'t find the right columns.', question.name);
                    return self.showDirectiveError(scope);
                }
                rowModel.text = columns[0].innerHTML;
                select = columns[1].querySelector('select');
                options = columns[1].querySelectorAll('option');
                if (!select || !options || !options.length) {
                    log.warn('Aborting because couldn\'t find select or options.', question.name);
                    return self.showDirectiveError(scope);
                }
                rowModel.id = select.id;
                rowModel.name = select.name;
                rowModel.disabled = select.disabled;
                rowModel.selected = false;
                rowModel.options = [];
                if (columns[1].className.indexOf('incorrect') >= 0) {
                    rowModel.isCorrect = 0;
                } else if (columns[1].className.indexOf('correct') >= 0) {
                    rowModel.isCorrect = 1;
                }
                angular.forEach(options, function(option) {
                    if (typeof option.value == 'undefined') {
                        log.warn('Aborting because couldn\'t find option value.', question.name);
                        return self.showDirectiveError(scope);
                    }
                    var opt = {
                        value: option.value,
                        label: option.innerHTML,
                        selected: option.selected
                    };
                    if (opt.selected) {
                        rowModel.selected = opt;
                    }
                    rowModel.options.push(opt);
                });
                accessibilityLabel = columns[1].querySelector('label.accesshide');
                rowModel.accessibilityLabel = accessibilityLabel.innerHTML;
                question.rows.push(rowModel);
            });
            question.loaded = true;
        }
    };
        self.multiChoiceDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log),
            question = scope.question;
        scope.mcAnswers = {};
        if (questionEl) {
            questionEl = questionEl[0] || questionEl;
            question.prompt = $mmUtil.getContentsOfElement(questionEl, '.prompt');
            var options = questionEl.querySelectorAll('input[type="radio"]');
            if (!options || !options.length) {
                question.multi = true;
                options = questionEl.querySelectorAll('input[type="checkbox"]');
                if (!options || !options.length) {
                    log.warn('Aborting because of no radio and checkbox found.', question.name);
                    return self.showDirectiveError(scope);
                }
            }
            question.options = [];
            angular.forEach(options, function(element) {
                var option = {
                        id: element.id,
                        name: element.name,
                        value: element.value,
                        checked: element.checked,
                        disabled: element.disabled
                    },
                    label,
                    parent = element.parentNode,
                    feedback;
                label = questionEl.querySelector('label[for="' + option.id + '"]');
                if (label) {
                    option.text = label.innerHTML;
                    if (typeof option.name != 'undefined' && typeof option.value != 'undefined' &&
                                typeof option.text != 'undefined') {
                        if (element.checked) {
                            if (!question.multi) {
                                scope.mcAnswers[option.name] = option.value;
                            }
                            if (parent) {
                                if (parent && parent.className.indexOf('incorrect') >= 0) {
                                    option.isCorrect = 0;
                                } else if (parent && parent.className.indexOf('correct') >= 0) {
                                    option.isCorrect = 1;
                                }
                                feedback = parent.querySelector('.specificfeedback');
                                if (feedback) {
                                    option.feedback = feedback.innerHTML;
                                }
                            }
                        }
                        question.options.push(option);
                        return;
                    }
                }
                log.warn('Aborting because of an error parsing options.', question.name, option.name);
                return self.showDirectiveError(scope);
            });
        }
    };
        self.prefetchQuestionFiles = function(question, siteId, component, componentId) {
        var urls = $mmUtil.extractDownloadableFilesFromHtml(question.html);
        if (!component) {
            component = mmQuestionComponent;
            componentId = question.id;
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [];
            angular.forEach(urls, function(url) {
                if (!site.canDownloadFiles() && $mmUtil.isPluginFileUrl(url)) {
                    return;
                }
                if (url.indexOf('theme/image.php') > -1 && url.indexOf('flagged') > -1) {
                    return;
                }
                promises.push($mmFilepool.addToQueueByUrl(siteId, url, component, componentId));
            });
            return $q.all(promises);
        });
    };
        self.replaceCorrectnessClasses = function(element) {
        $mmUtil.replaceClassesInElement(element, {
            correct: 'mm-question-answer-correct',
            incorrect: 'mm-question-answer-incorrect'
        });
    };
        self.replaceFeedbackClasses = function(element) {
        $mmUtil.replaceClassesInElement(element, {
            outcome: 'mm-question-feedback-container mm-question-feedback-padding',
            specificfeedback: 'mm-question-feedback-container mm-question-feedback-inline'
        });
    };
        self.showDirectiveError = function(scope, error) {
        error = error || 'Error processing the question. This could be caused by custom modifications in your site.';
        var now = new Date().getTime();
        if (now - lastErrorShown > 500) {
            lastErrorShown = now;
            $mmUtil.showErrorModal(error);
        }
        scope.abort();
    };
        self.treatCorrectnessIcons = function(scope, element) {
        element = element[0] || element;
        var icons = element.querySelectorAll('.questioncorrectnessicon');
        angular.forEach(icons, function(icon) {
            var parent;
            if (icon.src && icon.src.indexOf('incorrect') > -1) {
                icon.src = 'img/icons/grade_incorrect.svg';
            } else if (icon.src && icon.src.indexOf('correct') > -1) {
                icon.src = 'img/icons/grade_correct.svg';
            }
            parent = icon.parentNode;
            if (!parent) {
                return;
            }
            if (!parent.querySelector('.feedbackspan.accesshide')) {
                return;
            }
            icon.setAttribute('ng-click', 'questionCorrectnessIconClicked($event)');
        });
        scope.questionCorrectnessIconClicked = function(event) {
            var parent = event.target.parentNode,
                feedback;
            if (parent) {
                feedback = parent.querySelector('.feedbackspan.accesshide');
                if (feedback && feedback.innerHTML) {
                    scope.currentFeedback = feedback.innerHTML;
                    scope.feedbackModal.show();
                }
            }
        };
        $ionicModal.fromTemplateUrl('core/components/question/templates/feedbackmodal.html', {
            scope: scope
        }).then(function(modal) {
            scope.feedbackModal = modal;
            scope.closeModal = function() {
                modal.hide();
            };
        });
    };
    return self;
}]);

angular.module('mm.core.question')
.constant('mmQuestionStore', 'questions')
.constant('mmQuestionAnswersStore', 'question_answers')
.config(["$mmSitesFactoryProvider", "mmQuestionStore", "mmQuestionAnswersStore", function($mmSitesFactoryProvider, mmQuestionStore, mmQuestionAnswersStore) {
    var stores = [
        {
            name: mmQuestionStore,
            keyPath: ['component', 'attemptid', 'slot'],
            indexes: [
                {
                    name: 'userid'
                },
                {
                    name: 'component'
                },
                {
                    name: 'componentId'
                },
                {
                    name: 'attemptid'
                },
                {
                    name: 'slot'
                },
                {
                    name: 'state'
                },
                {
                    name: 'componentAndAttempt',
                    keyPath: ['component', 'attemptid']
                },
                {
                    name: 'componentAndComponentId',
                    keyPath: ['component', 'componentId']
                }
            ]
        },
        {
            name: mmQuestionAnswersStore,
            keyPath: ['component', 'attemptid', 'name'],
            indexes: [
                {
                    name: 'userid'
                },
                {
                    name: 'component'
                },
                {
                    name: 'componentId'
                },
                {
                    name: 'attemptid'
                },
                {
                    name: 'name'
                },
                {
                    name: 'questionslot'
                },
                {
                    name: 'componentAndAttempt',
                    keyPath: ['component', 'attemptid']
                },
                {
                    name: 'componentAndComponentId',
                    keyPath: ['component', 'componentId']
                },
                {
                    name: 'componentAndAttemptAndQuestion',
                    keyPath: ['component', 'attemptid', 'questionslot']
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmQuestion', ["$log", "$mmSite", "$mmSitesManager", "$mmUtil", "$q", "$mmQuestionDelegate", "mmQuestionStore", "mmQuestionAnswersStore", function($log, $mmSite, $mmSitesManager, $mmUtil, $q, $mmQuestionDelegate, mmQuestionStore,
            mmQuestionAnswersStore) {
    $log = $log.getInstance('$mmQuestion');
    var self = {},
        questionPrefixRegex = /q\d+:(\d+)_/,
        states = {
            todo: {
                name: 'todo',
                class: 'mm-question-notyetanswered',
                status: 'notyetanswered',
                active: true,
                finished: false
            },
            invalid: {
                name: 'invalid',
                class: 'mm-question-invalidanswer',
                status: 'invalidanswer',
                active: true,
                finished: false
            },
            complete: {
                name: 'complete',
                class: 'mm-question-answersaved',
                status: 'answersaved',
                active: true,
                finished: false
            },
            needsgrading: {
                name: 'needsgrading',
                class: 'mm-question-requiresgrading',
                status: 'requiresgrading',
                active: false,
                finished: true
            },
            finished: {
                name: 'finished',
                class: 'mm-question-complete',
                status: 'complete',
                active: false,
                finished: true
            },
            gaveup: {
                name: 'gaveup',
                class: 'mm-question-notanswered',
                status: 'notanswered',
                active: false,
                finished: true
            },
            gradedwrong: {
                name: 'gradedwrong',
                class: 'mm-question-incorrect',
                status: 'incorrect',
                active: false,
                finished: true
            },
            gradedpartial: {
                name: 'gradedpartial',
                class: 'mm-question-partiallycorrect',
                status: 'partiallycorrect',
                active: false,
                finished: true
            },
            gradedright: {
                name: 'gradedright',
                class: 'mm-question-correct',
                status: 'correct',
                active: false,
                finished: true
            },
            mangrwrong: {
                name: 'mangrwrong',
                class: 'mm-question-incorrect',
                status: 'incorrect',
                active: false,
                finished: true
            },
            mangrpartial: {
                name: 'mangrpartial',
                class: 'mm-question-partiallycorrect',
                status: 'partiallycorrect',
                active: false,
                finished: true
            },
            mangrright: {
                name: 'mangrright',
                class: 'mm-question-correct',
                status: 'correct',
                active: false,
                finished: true
            },
            unknown: {
                name: 'unknown',
                class: 'mm-question-unknown',
                status: 'unknown',
                active: true,
                finished: false
            }
        };
        self.compareAllAnswers = function(prevAnswers, newAnswers) {
        var equal = true,
            keys = $mmUtil.mergeArraysWithoutDuplicates(Object.keys(prevAnswers), Object.keys(newAnswers));
        angular.forEach(keys, function(key) {
            if (!self.isExtraAnswer(key[0])) {
                if (!$mmUtil.sameAtKeyMissingIsBlank(prevAnswers, newAnswers, key)) {
                    equal = false;
                }
            }
        });
        return equal;
    };
        self.convertAnswersArrayToObject = function(answers, removePrefix) {
        var result = {};
        angular.forEach(answers, function(answer) {
            if (removePrefix) {
                var nameWithoutPrefix = self.removeQuestionPrefix(answer.name);
                result[nameWithoutPrefix] = answer.value;
            } else {
                result[answer.name] = answer.value;
            }
        });
        return result;
    };
        self.getAnswer = function(component, attemptId, name, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmQuestionAnswersStore, [component, attemptId, name]);
        });
    };
        self.getAttemptAnswers = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionAnswersStore, 'componentAndAttempt', [component, attemptId]);
        });
    };
        self.getAttemptQuestions = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionStore, 'componentAndAttempt', [component, attemptId]);
        });
    };
        self.getBasicAnswers = function(answers) {
        var result = {};
        angular.forEach(answers, function(value, name) {
            if (!self.isExtraAnswer(name)) {
                result[name] = value;
            }
        });
        return result;
    };
        self.getQuestion = function(component, attemptId, slot, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmQuestionStore, [component, attemptId, slot]);
        });
    };
        self.getQuestionAnswers = function(component, attemptId, slot, filter, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionAnswersStore, 'componentAndAttemptAndQuestion',
                        [component, attemptId, slot]).then(function(answers) {
                if (filter) {
                    var result = [];
                    angular.forEach(answers, function(answer) {
                        if (self.isExtraAnswer(answer.name)) {
                            result.push(answer);
                        }
                    });
                    return result;
                } else {
                    return answers;
                }
            });
        });
    };
        self.getQuestionSlotFromName = function(name) {
        if (name) {
            var match = name.match(questionPrefixRegex);
            if (match && match[1]) {
                return parseInt(match[1], 10);
            }
        }
        return -1;
    };
        self.getState = function(name) {
        return states[name];
    };
        self.isCompleteResponse = function(question, answers) {
        return $mmQuestionDelegate.isCompleteResponse(question, answers);
    };
        self.isExtraAnswer = function(name) {
        name = self.removeQuestionPrefix(name);
        return name[0] == '-' || name[0] == ':';
    };
        self.isGradableResponse = function(question, answers) {
        return $mmQuestionDelegate.isGradableResponse(question, answers);
    };
        self.isSameResponse = function(question, prevAnswers, newAnswers) {
        return $mmQuestionDelegate.isSameResponse(question, prevAnswers, newAnswers);
    };
        self.removeAttemptAnswers = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getAttemptAnswers(component, attemptId, siteId).then(function(answers) {
            var promises = [];
            angular.forEach(answers, function(answer) {
                promises.push(self.removeAnswer(component, attemptId, answer.name, siteId));
            });
            return $q.all(promises);
        });
    };
        self.removeAttemptQuestions = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getAttemptQuestions(component, attemptId, siteId).then(function(questions) {
            var promises = [];
            angular.forEach(questions, function(question) {
                promises.push(self.removeQuestion(component, attemptId, question.slot, siteId));
            });
            return $q.all(promises);
        });
    };
        self.removeAnswer = function(component, attemptId, name, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().remove(mmQuestionAnswersStore, [component, attemptId, name]);
        });
    };
        self.removeQuestion = function(component, attemptId, slot, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().remove(mmQuestionStore, [component, attemptId, slot]);
        });
    };
        self.removeQuestionAnswers = function(component, attemptId, slot, siteId) {
        return self.getQuestionAnswers(component, attemptId, slot, false, siteId).then(function(answers) {
            var promises = [];
            angular.forEach(answers, function(answer) {
                promises.push(self.removeAnswer(component, attemptId, answer.name, siteId));
            });
            return $q.all(promises);
        });
    };
        self.removeQuestionPrefix = function(name) {
        if (name) {
            return name.replace(questionPrefixRegex, '');
        }
        return '';
    };
        self.saveAnswers = function(component, componentId, attemptId, userId, answers, timemod, siteId) {
        siteId = siteId || $mmSite.getId();
        timemod = timemod || $mmUtil.timestamp();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                promises = [];
            angular.forEach(answers, function(value, name) {
                var entry = {
                    component: component,
                    componentId: componentId,
                    attemptid: attemptId,
                    userid: userId,
                    questionslot: self.getQuestionSlotFromName(name),
                    name: name,
                    value: value,
                    timemodified: timemod
                };
                promises.push(db.insert(mmQuestionAnswersStore, entry));
            });
            return $q.all(promises);
        });
    };
        self.saveQuestion = function(component, componentId, attemptId, userId, question, state, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var entry = {
                component: component,
                componentId: componentId,
                attemptid: attemptId,
                userid: userId,
                number: question.number,
                slot: question.slot,
                state: state
            };
            return site.getDb().insert(mmQuestionStore, entry);
        });
    };
    return self;
}]);

angular.module('mm.core.settings')
.controller('mmSettingsAboutCtrl', ["$scope", "$translate", "$window", "$mmApp", "$ionicPlatform", "$mmLang", "$mmFS", "$mmLocalNotifications", "mmCoreConfigConstants", function($scope, $translate, $window, $mmApp, $ionicPlatform, $mmLang, $mmFS,
            $mmLocalNotifications, mmCoreConfigConstants) {
    $scope.versionname = mmCoreConfigConstants.versionname;
    $scope.appname = mmCoreConfigConstants.appname;
    $scope.versioncode = mmCoreConfigConstants.versioncode;
    $scope.privacyPolicy = mmCoreConfigConstants.privacypolicy;
    $scope.navigator = $window.navigator;
    if ($window.location && $window.location.href) {
        var url = $window.location.href;
        $scope.locationhref = url.substr(0, url.indexOf('#/site/'));
    }
    $scope.appready = $mmApp.isReady() ? 'mm.core.yes' : 'mm.core.no';
    $scope.devicetype = $ionicPlatform.isTablet() ? 'mm.core.tablet' : 'mm.core.phone';
    if (ionic.Platform.isAndroid()) {
        $scope.deviceos = 'mm.core.android';
    } else if (ionic.Platform.isIOS()) {
        $scope.deviceos = 'mm.core.ios';
    } else if (ionic.Platform.isWindowsPhone()) {
        $scope.deviceos = 'mm.core.windowsphone';
    } else {
        var matches = navigator.userAgent.match(/\(([^\)]*)\)/);
        if (matches && matches.length > 1) {
            $scope.deviceos = matches[1];
        } else {
            $scope.deviceos = 'mm.core.unknown';
        }
    }
    $mmLang.getCurrentLanguage().then(function(lang) {
        $scope.currentlanguage = lang;
    });
    $scope.networkstatus = $mmApp.isOnline() ? 'mm.core.online' : 'mm.core.offline';
    $scope.wificonnection = $mmApp.isNetworkAccessLimited() ? 'mm.core.no' : 'mm.core.yes';
    $scope.devicewebworkers = !!window.Worker && !!window.URL ? 'mm.core.yes' : 'mm.core.no';
    $scope.device = ionic.Platform.device();
    if ($mmFS.isAvailable()) {
        $mmFS.getBasePath().then(function(basepath) {
            $scope.filesystemroot = basepath;
            $scope.fsclickable = $mmFS.usesHTMLAPI();
        });
    }
    $scope.storagetype = $mmApp.getDB().getType();
    $scope.localnotifavailable = $mmLocalNotifications.isAvailable() ? 'mm.core.yes' : 'mm.core.no';
}]);

angular.module('mm.core.settings')
.controller('mmSettingsGeneralCtrl', ["$scope", "$mmLang", "$ionicHistory", "$mmEvents", "$mmConfig", "mmCoreEventLanguageChanged", "mmCoreSettingsReportInBackground", "mmCoreConfigConstants", "mmCoreSettingsRichTextEditor", "$mmUtil", function($scope, $mmLang, $ionicHistory, $mmEvents, $mmConfig, mmCoreEventLanguageChanged,
            mmCoreSettingsReportInBackground, mmCoreConfigConstants, mmCoreSettingsRichTextEditor,
            $mmUtil) {
    $scope.langs = mmCoreConfigConstants.languages;
    $mmLang.getCurrentLanguage().then(function(currentLanguage) {
        $scope.selectedLanguage = currentLanguage;
    });
    $scope.languageChanged = function(newLang) {
        $mmLang.changeCurrentLanguage(newLang).finally(function() {
            $ionicHistory.clearCache();
            $mmEvents.trigger(mmCoreEventLanguageChanged);
        });
    };
    $scope.rteSupported = $mmUtil.isRichTextEditorSupported();
    if ($scope.rteSupported) {
        $mmConfig.get(mmCoreSettingsRichTextEditor, true).then(function(richTextEditorEnabled) {
            $scope.richTextEditor = richTextEditorEnabled;
        });
        $scope.richTextEditorChanged = function(richTextEditor) {
            $mmConfig.set(mmCoreSettingsRichTextEditor, richTextEditor);
        };
    }
    if (localStorage && localStorage.getItem && localStorage.setItem) {
        $scope.showReport = true;
        $scope.reportInBackground = parseInt(localStorage.getItem(mmCoreSettingsReportInBackground), 10) === 1;
        $scope.reportChanged = function(inBackground) {
            localStorage.setItem(mmCoreSettingsReportInBackground, inBackground ? '1' : '0');
        };
    } else {
        $scope.showReport = false;
    }
}]);

angular.module('mm.core.settings')
.controller('mmSettingsListCtrl', ["$scope", "$mmSettingsDelegate", function($scope, $mmSettingsDelegate) {
    $scope.isIOS = ionic.Platform.isIOS();
    $scope.handlers = $mmSettingsDelegate.getHandlers();
    $scope.areHandlersLoaded = $mmSettingsDelegate.areHandlersLoaded;
}]);

angular.module('mm.core.settings')
.controller('mmSettingsSpaceUsageCtrl', ["$log", "$scope", "$mmSitesManager", "$mmFS", "$q", "$mmUtil", "$translate", "$mmText", "$mmFilepool", function($log, $scope, $mmSitesManager, $mmFS, $q, $mmUtil, $translate,
            $mmText, $mmFilepool) {
    $log = $log.getInstance('mmSettingsSpaceUsageCtrl');
    function calculateSizeUsage() {
        return $mmSitesManager.getSites().then(function(sites) {
            var promises = [];
            $scope.sites = sites;
            angular.forEach(sites, function(siteEntry) {
                var promise = $mmSitesManager.getSite(siteEntry.id).then(function(site) {
                    return site.getSpaceUsage().then(function(size) {
                        siteEntry.spaceusage = size;
                    });
                });
                promises.push(promise);
            });
            return $q.all(promises);
        });
    }
    function calculateTotalUsage() {
        var total = 0;
        angular.forEach($scope.sites, function(site) {
            if (site.spaceusage) {
                total += parseInt(site.spaceusage, 10);
            }
        });
        $scope.totalusage = total;
    }
    function calculateFreeSpace() {
        if ($mmFS.isAvailable()) {
            return $mmFS.calculateFreeSpace().then(function(freespace) {
                $scope.freespace = freespace;
            }, function() {
                $scope.freespace = 0;
            });
        } else {
            $scope.freespace = 0;
        }
    }
    function fetchData() {
        var promises = [];
        promises.push(calculateSizeUsage().then(calculateTotalUsage));
        promises.push($q.when(calculateFreeSpace()));
        return $q.all(promises);
    }
    fetchData().finally(function() {
        $scope.sizeLoaded = true;
    });
    $scope.refresh = function() {
        fetchData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    function updateSiteUsage(site, newUsage) {
        var oldUsage = site.spaceusage;
        site.spaceusage = newUsage;
        $scope.totalusage -= oldUsage - newUsage;
        $scope.freespace += oldUsage - newUsage;
    }
    $scope.deleteSiteFiles = function(siteData) {
        if (siteData) {
            var siteid = siteData.id,
                sitename = siteData.sitename;
            $mmText.formatText(sitename).then(function(sitename) {
                $translate('mm.settings.deletesitefilestitle').then(function(title) {
                    return $mmUtil.showConfirm($translate('mm.settings.deletesitefiles', {sitename: sitename}), title);
                }).then(function() {
                    return $mmSitesManager.getSite(siteid);
                }).then(function(site) {
                    return site.deleteFolder().then(function() {
                        $mmFilepool.clearAllPackagesStatus(siteid);
                        $mmFilepool.clearFilepool(siteid);
                        updateSiteUsage(siteData, 0);
                    }).catch(function(error) {
                        if (error && error.code === FileError.NOT_FOUND_ERR) {
                            $mmFilepool.clearAllPackagesStatus(siteid);
                            updateSiteUsage(siteData, 0);
                        } else {
                            $mmUtil.showErrorModal('mm.settings.errordeletesitefiles', true);
                            site.getSpaceUsage().then(function(size) {
                                updateSiteUsage(siteData, size);
                            });
                        }
                    });
                });
            });
        }
    };
}]);

angular.module('mm.core.settings')
.controller('mmSettingsSynchronizationCtrl', ["$log", "$scope", "$mmUtil", "$mmConfig", "$mmSettingsHelper", "mmCoreSettingsSyncOnlyOnWifi", function($log, $scope, $mmUtil, $mmConfig, $mmSettingsHelper,
            mmCoreSettingsSyncOnlyOnWifi) {
    $log = $log.getInstance('mmSettingsSynchronizationCtrl');
    $mmSettingsHelper.getSites().then(function(sites) {
        $scope.sites = sites;
        angular.forEach(sites, function(site) {
            if (site.synchronizing) {
                $mmSettingsHelper.getSiteSyncPromise(site.id).catch(errorSyncing);
            }
        });
    });
    $mmConfig.get(mmCoreSettingsSyncOnlyOnWifi, true).then(function(syncOnlyOnWifi) {
        $scope.syncOnlyOnWifi = syncOnlyOnWifi;
    });
    $scope.syncWifiChanged = function(syncOnlyOnWifi) {
        $mmConfig.set(mmCoreSettingsSyncOnlyOnWifi, syncOnlyOnWifi);
    };
    $scope.synchronize = function(siteId) {
        if ($scope.sites[siteId] && !$scope.sites[siteId].synchronizing) {
            $mmSettingsHelper.synchronizeSite($scope.syncOnlyOnWifi, siteId).catch(errorSyncing);
        }
    };
    function errorSyncing(error) {
        if (!$scope.$$destroyed) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.settings.errorsyncsite', true);
            }
        }
    }
}]);

angular.module('mm.core.settings')
.provider('$mmSettingsDelegate', function() {
    var handlers = {},
        self = {};
        self.registerHandler = function(component, handler, priority) {
        if (typeof handlers[component] !== 'undefined') {
            console.log("$mmSettingsDelegateProvider: Handler '" + handlers[component].component + "' already registered as settings handler");
            return false;
        }
        console.log("$mmSettingsDelegateProvider: Registered component '" + component + "' as settings handler.");
        handlers[component] = {
            component: component,
            handler: handler,
            instance: undefined,
            priority: typeof priority === 'undefined' ? 100 : priority
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", function($q, $log, $mmSite, $mmUtil) {
        var enabledHandlers = {},
            currentSiteHandlers = [],
            self = {},
            loaded = false,
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmSettingsDelegate');
                self.areHandlersLoaded = function() {
            return loaded;
        };
                self.clearSiteHandlers = function() {
            loaded = false;
            $mmUtil.emptyArray(currentSiteHandlers);
        };
                self.getHandlers = function() {
            return currentSiteHandlers;
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledHandlers[addon];
                    }
                }
            });
        };
                self.updateHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating setting handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, addon) {
                promises.push(self.updateHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCall(now)) {
                    $mmUtil.emptyArray(currentSiteHandlers);
                    angular.forEach(enabledHandlers, function(handler) {
                        currentSiteHandlers.push({
                            controller: handler.instance.getController(),
                            priority: handler.priority
                        });
                    });
                    loaded = true;
                }
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core')
.factory('$mmSettingsHelper', ["$log", "$mmSitesManager", "$q", "$mmFilepool", "$mmLang", "$mmEvents", "$mmCronDelegate", "$mmApp", "mmCoreEventSessionExpired", function($log, $mmSitesManager, $q, $mmFilepool, $mmLang, $mmEvents, $mmCronDelegate, $mmApp,
            mmCoreEventSessionExpired) {
    $log = $log.getInstance('$mmSettingsHelper');
    var self = {},
        sites = {},
        syncPromises = {};
        self.getProcessor = function(processors, name, fallback) {
        if (!processors) {
            return;
        }
        if (typeof fallback == 'undefined') {
            fallback = true;
        }
        for (var i = 0, len = processors.length; i < len; i++) {
            var processor = processors[i];
            if (processor.name == name) {
                return processor;
            }
        }
        if (fallback) {
            return processors[0];
        }
    };
        self.getProcessorComponents = function(processor, components) {
        var result = [];
        angular.forEach(components, function(component) {
            var componentCopy = angular.copy(component);
            componentCopy.notifications = [];
            angular.forEach(component.notifications, function(notification) {
                var hasProcessor = false;
                for (var i = 0, len = notification.processors.length; i < len; i++) {
                    var proc = notification.processors[i];
                    if (proc.name == processor) {
                        hasProcessor = true;
                        notification.currentProcessor = proc;
                        break;
                    }
                }
                if (hasProcessor) {
                    componentCopy.notifications.push(notification);
                }
            });
            if (componentCopy.notifications.length) {
                result.push(componentCopy);
            }
        });
        return result;
    };
        self.getSites = function() {
        return $mmSitesManager.getSites().then(function(dbSites) {
            var newSites = {};
            angular.forEach(dbSites, function(site) {
                if (sites[site.id]) {
                    newSites[site.id] = sites[site.id];
                    newSites[site.id].siteurl = site.siteurl;
                    newSites[site.id].fullname = site.fullname;
                    newSites[site.id].sitename = site.sitename;
                    newSites[site.id].avatar = site.avatar;
                } else {
                    newSites[site.id] = site;
                    newSites[site.id].synchronizing = false;
                }
            });
            sites = newSites;
            return sites;
        });
    };
        self.getSiteSyncPromise = function(siteId) {
        if (syncPromises[siteId]) {
            return syncPromises[siteId];
        } else {
            return $q.when();
        }
    };
        self.synchronizeSite = function(syncOnlyOnWifi, siteId) {
        if (!sites[siteId]) {
            return $q.reject();
        }
        if (syncPromises[siteId]) {
            return syncPromises[siteId];
        }
        var promises = [],
            syncPromise,
            deleted = false,
            hasSyncHooks = $mmCronDelegate.hasManualSyncHooks();
        if (hasSyncHooks && !$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.settings.cannotsyncoffline');
        } else if (hasSyncHooks && syncOnlyOnWifi && $mmApp.isNetworkAccessLimited()) {
            return $mmLang.translateAndReject('mm.settings.cannotsyncwithoutwifi');
        }
        sites[siteId].synchronizing = true;
        promises.push($mmFilepool.invalidateAllFiles(siteId).catch(function() {
        }));
        promises.push($mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCache().then(function() {
                var subPromises = [];
                subPromises.push(site.checkIfLocalMobileInstalledAndNotUsed().then(function() {
                    $mmEvents.trigger(mmCoreEventSessionExpired, {siteid: siteId});
                    return $mmLang.translateAndReject('mm.core.lostconnection');
                }, function() {
                    return $mmSitesManager.updateSiteInfo(siteId).then(function() {
                        sites[siteId].siteurl = site.getInfo().siteurl;
                        sites[siteId].fullname = site.getInfo().fullname;
                        sites[siteId].sitename = site.getInfo().sitename;
                        sites[siteId].avatar = site.getInfo().userpictureurl;
                    });
                }));
                subPromises.push($mmCronDelegate.forceSyncExecution(siteId));
                return $q.all(subPromises);
            });
        }));
        syncPromise = $q.all(promises).finally(function() {
            sites[siteId].synchronizing = false;
            deleted = true;
            delete syncPromises[siteId];
        });
        if (!deleted) {
            syncPromises[siteId] = syncPromise;
        }
        return syncPromise;
    };
    return self;
}]);

angular.module('mm.core.sharedfiles')
.controller('mmSharedFilesChooseSiteCtrl', ["$scope", "$stateParams", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$mmFS", "$mmSharedFilesHelper", function($scope, $stateParams, $mmSitesManager, $mmUtil, $ionicHistory, $mmFS,
            $mmSharedFilesHelper) {
    var filePath = $stateParams.filepath || {},
        fileAndDir = $mmFS.getFileAndDirectoryFromPath(filePath),
        fileEntry;
    if (!filePath) {
        $mmUtil.showErrorModal('Error reading file.');
        $ionicHistory.goBack();
        return;
    }
    $scope.filename = fileAndDir.name;
    $mmFS.getFile(filePath).then(function(fe) {
        fileEntry = fe;
        $scope.filename = fileEntry.name;
    }).catch(function() {
        $mmUtil.showErrorModal('Error reading file.');
        $ionicHistory.goBack();
    });
    $mmSitesManager.getSites().then(function(sites) {
        $scope.sites = sites;
    }).finally(function() {
        $scope.loaded = true;
    });
    $scope.storeInSite = function(siteId) {
        $scope.loaded = false;
        $mmSharedFilesHelper.storeSharedFileInSite(fileEntry, siteId).then(function() {
            $ionicHistory.goBack();
        }).finally(function() {
            $scope.loaded = true;
        });
    };
}]);

angular.module('mm.core.sharedfiles')
.controller('mmSharedFilesListCtrl', ["$scope", "$stateParams", "$mmSharedFiles", "$ionicScrollDelegate", "$state", "$mmFS", "$translate", "$mmEvents", "$mmSite", "$mmSharedFilesHelper", "$ionicHistory", "mmSharedFilesEventFileShared", function($scope, $stateParams, $mmSharedFiles, $ionicScrollDelegate, $state, $mmFS,
            $translate, $mmEvents, $mmSite, $mmSharedFilesHelper, $ionicHistory, mmSharedFilesEventFileShared) {
    var path = $stateParams.path || '',
        manage = $stateParams.manage,
        pick = $stateParams.pick,
        shareObserver,
        siteId = $mmSite.getId();
    $scope.manage = manage;
    $scope.pick = pick;
    if (path) {
        $scope.title = $mmFS.getFileAndDirectoryFromPath(path).name;
    } else {
        $scope.title = $translate.instant('mm.sharedfiles.sharedfiles');
    }
    function loadFiles() {
        return $mmSharedFiles.getSiteSharedFiles(siteId, path).then(function(files) {
            $scope.files = files;
        });
    }
    loadFiles().finally(function() {
        $scope.filesLoaded = true;
    });
    shareObserver = $mmEvents.on(mmSharedFilesEventFileShared, function(data) {
        if (data.siteid == siteId) {
            $scope.filesLoaded = false;
            loadFiles().finally(function() {
                $scope.filesLoaded = true;
            });
        }
    });
    $scope.refreshFiles = function() {
        loadFiles().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.fileDeleted = function(index) {
        $scope.files.splice(index, 1);
        $ionicScrollDelegate.resize();
    };
    $scope.fileRenamed = function(index, file) {
        $scope.files[index] = file;
    };
    $scope.openFolder = function(folder) {
        $state.go('site.sharedfiles-list', {path: $mmFS.concatenatePaths(path, folder.name), manage: manage, pick: pick});
    };
    $scope.changeSite = function(sid) {
        siteId = sid;
        $scope.filesLoaded = false;
        loadFiles().finally(function() {
            $scope.filesLoaded = true;
        });
    };
    if (pick) {
        $scope.filePicked = function(file) {
            $mmSharedFilesHelper.filePicked(file.fullPath);
            if (path) {
                var count = path.split('/').length + 1;
                $ionicHistory.goBack(-count);
            } else {
                $ionicHistory.goBack();
            }
        };
    }
    $scope.$on('$destroy', function() {
        shareObserver && shareObserver.off && shareObserver.off();
        if (pick && !path) {
            $mmSharedFilesHelper.filePickerClosed();
        }
    });
}]);

angular.module('mm.core.sharedfiles')
.factory('$mmSharedFilesHandlers', ["$mmSharedFilesHelper", function($mmSharedFilesHelper) {
    var self = {};
        self.filePicker = function() {
        var self = {};
                self.isEnabled = function() {
            return ionic.Platform.isIOS();
        };
                self.getData = function() {
            return {
                name: 'sharedfiles',
                title: 'mm.sharedfiles.sharedfiles',
                class: 'mm-sharedfiles-filepicker-handler',
                icon: 'ion-folder',
                action: function(maxSize, upload, allowOffline) {
                    return $mmSharedFilesHelper.pickSharedFile();
                }
            };
        };
        return self;
    };
    return self;
}]);

angular.module('mm.core.sharedfiles')
.factory('$mmSharedFilesHelper', ["$mmSharedFiles", "$mmUtil", "$log", "$mmApp", "$mmSitesManager", "$mmFS", "$rootScope", "$q", "$ionicModal", "$state", "$translate", "$mmSite", function($mmSharedFiles, $mmUtil, $log, $mmApp, $mmSitesManager, $mmFS, $rootScope, $q,
            $ionicModal, $state, $translate, $mmSite) {
    $log = $log.getInstance('$mmSharedFilesHelper');
    var self = {},
        filePickerDeferred,
        fileListModal,
        fileListScope;
        self.askRenameReplace = function(originalName, newName) {
        var scope = $rootScope.$new();
        scope.originalName = originalName;
        scope.newName = newName;
        return $ionicModal.fromTemplateUrl('core/components/sharedfiles/templates/renamereplace.html', {
            scope: scope,
            animation: 'slide-in-up'
        }).then(function(modal) {
            var deferred = $q.defer();
            scope.modal = modal;
            modal.show();
            scope.click = function(name) {
                close().catch(function() {}).then(function() {
                    deferred.resolve(name);
                });
            };
            scope.closeModal = function() {
                close().catch(function() {}).then(function() {
                    deferred.reject();
                });
            };
            function close() {
                return modal.remove().then(function() {
                    scope.$destroy();
                });
            }
            return deferred.promise;
        });
    };
        self.filePickerClosed = function() {
        if (filePickerDeferred) {
            filePickerDeferred.reject();
            filePickerDeferred = undefined;
        }
    };
        self.filePicked = function(filePath) {
        if (filePickerDeferred) {
            filePickerDeferred.resolve({
                path: filePath,
                uploaded: false
            });
            filePickerDeferred = undefined;
        }
    };
        self.goToChooseSite = function(filePath) {
        var parentState = $state.$current.name.split('.')[0];
        return $state.go(parentState + '.sharedfiles-choose-site', {filepath: filePath});
    };
        self.initFileListModal = function() {
        if (fileListModal) {
            return $q.when();
        }
        if (!fileListScope) {
            fileListScope = $rootScope.$new();
        }
        return $ionicModal.fromTemplateUrl('core/components/sharedfiles/templates/listmodal.html', {
            scope: fileListScope,
            animation: 'slide-in-up'
        }).then(function(modal) {
            fileListScope.modal = modal;
        });
    };
        self.pickSharedFile = function() {
        var path = '',
            siteId = $mmSite.getId();
        filePickerDeferred = $q.defer();
        self.initFileListModal().then(function() {
            fileListScope.filesLoaded = false;
            if (path) {
                fileListScope.title = $mmFS.getFileAndDirectoryFromPath(path).name;
            } else {
                fileListScope.title = $translate.instant('mm.sharedfiles.sharedfiles');
            }
            loadFiles().then(function() {
                fileListScope.closeModal = function() {
                    fileListScope.modal.hide();
                    self.filePickerClosed();
                };
                fileListScope.refreshFiles = function() {
                    loadFiles().finally(function() {
                        fileListScope.$broadcast('scroll.refreshComplete');
                    });
                };
                fileListScope.openFolder = function(folder) {
                    path = $mmFS.concatenatePaths(path, folder.name);
                    fileListScope.filesLoaded = false;
                    loadFiles();
                };
                fileListScope.changeSite = function(sid) {
                    siteId = sid;
                    path = '';
                    fileListScope.filesLoaded = false;
                    loadFiles();
                };
                fileListScope.filePicked = function(file) {
                    self.filePicked(file.fullPath);
                    fileListScope.modal.hide();
                };
            });
            fileListScope.modal.show();
        }).catch(function() {
            self.filePickerClosed();
        });
        return filePickerDeferred.promise;
        function loadFiles() {
            return $mmSharedFiles.getSiteSharedFiles(siteId, path).then(function(files) {
                fileListScope.files = files;
                fileListScope.filesLoaded = true;
            });
        }
    };
        self.searchIOSNewSharedFiles = function() {
        return $mmApp.ready().then(function() {
            if ($state.$current.name == 'site.sharedfiles-choose-site') {
                return $q.reject();
            }
            return $mmSharedFiles.checkIOSNewFiles().then(function(fileEntry) {
                return $mmSitesManager.getSitesIds().then(function(siteIds) {
                    if (!siteIds.length) {
                        $mmUtil.showErrorModal('mm.sharedfiles.errorreceivefilenosites', true);
                        $mmSharedFiles.deleteInboxFile(fileEntry);
                    } else if (siteIds.length == 1) {
                        self.storeSharedFileInSite(fileEntry, siteIds[0]);
                    } else {
                        self.goToChooseSite(fileEntry.fullPath);
                    }
                });
            });
        });
    };
        self.storeSharedFileInSite = function(fileEntry, siteId) {
        siteId = siteId || $mmSite.getId();
        var sharedFilesDirPath = $mmSharedFiles.getSiteSharedFilesDirPath(siteId);
        return $mmFS.getUniqueNameInFolder(sharedFilesDirPath, fileEntry.name).then(function(newName) {
            if (newName == fileEntry.name) {
                return newName;
            } else {
                return self.askRenameReplace(fileEntry.name, newName);
            }
        }).then(function(name) {
            return $mmSharedFiles.storeFileInSite(fileEntry, name, siteId).finally(function() {
                $mmSharedFiles.deleteInboxFile(fileEntry);
                $mmUtil.showModal(undefined, $translate.instant('mm.sharedfiles.successstorefile'));
            }).catch(function(err) {
                $mmUtil.showErrorModal(err || 'Error moving file.');
                return $q.reject();
            });
        });
    };
    return self;
}]);

angular.module('mm.core.sharedfiles')
.config(["$mmAppProvider", "mmSharedFilesStore", function($mmAppProvider, mmSharedFilesStore) {
    var stores = [
        {
            name: mmSharedFilesStore,
            keyPath: 'id'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmSharedFiles', ["$mmFS", "$q", "$log", "$mmApp", "$mmSite", "$mmEvents", "md5", "mmSharedFilesStore", "mmSharedFilesFolder", "mmSharedFilesEventFileShared", function($mmFS, $q, $log, $mmApp, $mmSite, $mmEvents, md5, mmSharedFilesStore, mmSharedFilesFolder,
            mmSharedFilesEventFileShared) {
    $log = $log.getInstance('$mmSharedFiles');
    var self = {};
        self.checkIOSNewFiles = function() {
        $log.debug('Search for new files on iOS');
        return $mmFS.getDirectoryContents('Inbox').then(function(entries) {
            if (entries.length > 0) {
                var promises = [],
                    fileToReturn;
                angular.forEach(entries, function(entry) {
                    var fileId = self._getFileId(entry);
                    promises.push(self._isFileTreated(fileId).then(function() {
                        self.deleteInboxFile(entry);
                    }).catch(function() {
                        $log.debug('Found new file ' + entry.name + ' shared with the app.');
                        if (!fileToReturn) {
                            fileToReturn = entry;
                        }
                    }));
                });
                return $q.all(promises).then(function() {
                    var fileId;
                    if (fileToReturn) {
                        fileId = self._getFileId(fileToReturn);
                        return self._markAsTreated(fileId).then(function() {
                            $log.debug('File marked as "treated": ' + fileToReturn.name);
                            return fileToReturn;
                        });
                    } else {
                        return $q.reject();
                    }
                });
            } else {
                return $q.reject();
            }
        });
    };
        self.deleteInboxFile = function(entry) {
        var fileId = self._getFileId(entry),
            deferred = $q.defer();
        function removeMark() {
            self._unmarkAsTreated(fileId).then(function() {
                $log.debug('"Treated" mark removed from file: ' + entry.name);
                deferred.resolve();
            }).catch(function() {
                $log.debug('Error deleting "treated" mark from file: ' + entry.name);
                deferred.reject();
            });
        }
        $log.debug('Delete inbox file: ' + entry.name);
        entry.remove(removeMark, removeMark);
        return deferred.promise;
    };
        self._getFileId = function(entry) {
        return md5.createHash(entry.name);
    };
        self.getSiteSharedFiles = function(siteId, path) {
        siteId = siteId || $mmSite.getId();
        var pathToGet = self.getSiteSharedFilesDirPath(siteId);
        if (path) {
            pathToGet = $mmFS.concatenatePaths(pathToGet, path);
        }
        return $mmFS.getDirectoryContents(pathToGet).catch(function() {
            return [];
        });
    };
        self.getSiteSharedFilesDirPath = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmFS.getSiteFolder(siteId) + '/' + mmSharedFilesFolder;
    };
        self._isFileTreated = function(fileId) {
        return $mmApp.getDB().get(mmSharedFilesStore, fileId);
    };
        self._markAsTreated = function(fileId) {
        return $mmApp.getDB().insert(mmSharedFilesStore, {id: fileId});
    };
        self.storeFileInSite = function(entry, newName, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!entry || !siteId) {
            return $q.reject();
        }
        newName = newName || entry.name;
        var sharedFilesFolder = self.getSiteSharedFilesDirPath(siteId),
            newPath = $mmFS.concatenatePaths(sharedFilesFolder, newName);
        return $mmFS.createDir(sharedFilesFolder).then(function() {
            return $mmFS.moveFile(entry.fullPath, newPath).then(function(newFile) {
                $mmEvents.trigger(mmSharedFilesEventFileShared, {siteid: siteId, name: newName});
                return newFile;
            });
        });
    };
        self._unmarkAsTreated = function(fileId) {
        return $mmApp.getDB().remove(mmSharedFilesStore, fileId);
    };
    return self;
}]);

angular.module('mm.core.textviewer')
.controller('mmTextViewerIndexCtrl', ["$stateParams", "$scope", "$mmText", function($stateParams, $scope, $mmText) {
    $scope.title = $stateParams.title;
    if ($stateParams.replacelinebreaks) {
        $scope.content = $mmText.replaceNewLines($stateParams.content, '<br>');
    } else {
        $scope.content = $stateParams.content;
    }
    if ($stateParams.component) {
        $scope.component = $stateParams.component;
        if ($stateParams.componentId) {
            $scope.componentId = $stateParams.componentId;
        }
    }
}]);

angular.module('mm.core.sidemenu')
.controller('mmSideMenuIframeViewCtrl', ["$scope", "$stateParams", "$sce", function($scope, $stateParams, $sce) {
    $scope.title = $stateParams.title;
    $scope.url = $sce.trustAsResourceUrl($stateParams.url);
}]);

angular.module('mm.core.sidemenu')
.controller('mmSideMenuCtrl', ["$scope", "$state", "$mmSideMenuDelegate", "$mmSitesManager", "$mmSite", "$mmEvents", "$timeout", "mmCoreEventLanguageChanged", "mmCoreEventSiteUpdated", "$mmSideMenu", "$mmCourses", function($scope, $state, $mmSideMenuDelegate, $mmSitesManager, $mmSite, $mmEvents,
            $timeout, mmCoreEventLanguageChanged, mmCoreEventSiteUpdated, $mmSideMenu, $mmCourses) {
    $mmSideMenu.setScope($scope);
    $scope.handlers = $mmSideMenuDelegate.getNavHandlers();
    $scope.areNavHandlersLoaded = $mmSideMenuDelegate.areNavHandlersLoaded;
    loadSiteInfo();
    $scope.logout = function() {
        $mmSitesManager.logout().finally(function() {
            $state.go('mm_login.sites');
        });
    };
    function loadSiteInfo() {
        var config = $mmSite.getStoredConfig();
        $scope.siteinfo = $mmSite.getInfo();
        $scope.logoutLabel = 'mm.sidemenu.' + (config && config.tool_mobile_forcelogout == "1" ? 'logout': 'changesite');
        $scope.showMyCourses = !$mmCourses.isMyCoursesDisabledInSite();
        $scope.showWeb = !$mmSite.isFeatureDisabled('$mmSideMenuDelegate_website');
        $scope.showHelp = !$mmSite.isFeatureDisabled('$mmSideMenuDelegate_help');
        $mmSite.getDocsUrl().then(function(docsurl) {
            $scope.docsurl = docsurl;
        });
        $mmSideMenu.getCustomMenuItems().then(function(items) {
            $scope.customItems = items;
        });
    }
    function updateSiteInfo() {
        $scope.siteinfo = undefined;
        $timeout(function() {
            loadSiteInfo();
        });
    }
    var langObserver = $mmEvents.on(mmCoreEventLanguageChanged, updateSiteInfo);
    var updateSiteObserver = $mmEvents.on(mmCoreEventSiteUpdated, function(siteid) {
        if ($mmSite.getId() === siteid) {
            updateSiteInfo();
        }
    });
    $scope.$on('$destroy', function() {
        if (langObserver && langObserver.off) {
            langObserver.off();
        }
        if (updateSiteObserver && updateSiteObserver.off) {
            updateSiteObserver.off();
        }
    });
}]);

angular.module('mm.core.sidemenu')
.provider('$mmSideMenuDelegate', function() {
    var navHandlers = {},
        self = {};
        self.registerNavHandler = function(addon, handler, priority) {
        if (typeof navHandlers[addon] !== 'undefined') {
            console.log("$mmSideMenuDelegateProvider: Addon '" + navHandlers[addon].addon + "' already registered as navigation handler");
            return false;
        }
        console.log("$mmSideMenuDelegateProvider: Registered addon '" + addon + "' as navigation handler.");
        navHandlers[addon] = {
            addon: addon,
            handler: handler,
            instance: undefined,
            priority: priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$q", "$log", "$mmSite", function($mmUtil, $q, $log, $mmSite) {
        var enabledNavHandlers = {},
            currentSiteHandlers = [],
            self = {},
            loaded = false,
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmSideMenuDelegate');
                self.areNavHandlersLoaded = function() {
            return loaded;
        };
                self.clearSiteHandlers = function() {
            loaded = false;
            $mmUtil.emptyArray(currentSiteHandlers);
        };
                self.getNavHandlers = function() {
            return currentSiteHandlers;
        };
                self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
                self.updateNavHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmSideMenuDelegate_' + addon)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledNavHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledNavHandlers[addon];
                    }
                }
            });
        };
                self.updateNavHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating navigation handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(navHandlers, function(handlerInfo, addon) {
                promises.push(self.updateNavHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCall(now)) {
                    $mmUtil.emptyArray(currentSiteHandlers);
                    angular.forEach(enabledNavHandlers, function(handler) {
                        currentSiteHandlers.push({
                            controller: handler.instance.getController(),
                            priority: handler.priority
                        });
                    });
                    loaded = true;
                }
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.sidemenu')
.factory('$mmSideMenu', ["$log", "$mmLang", "$mmSitesManager", "mmCoreConfigConstants", function($log, $mmLang, $mmSitesManager, mmCoreConfigConstants) {
    $log = $log.getInstance('$mmSideMenu');
    var self = {},
        scope;
        self.getCustomMenuItems = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var itemsString = site.getStoredConfig('tool_mobile_custommenuitems'),
                items,
                position = 0,
                map = {},
                result = [];
            if (!itemsString || typeof itemsString != 'string') {
                return result;
            }
            items = itemsString.split(/(?:\r\n|\r|\n)/);
            angular.forEach(items, function(item) {
                var values = item.split('|'),
                    id,
                    label = values[0] ? values[0].trim() : values[0],
                    url = values[1] ? values[1].trim() : values[1],
                    type = values[2] ? values[2].trim() : values[2],
                    lang = (values[3] ? values[3].trim() : values[3]) || 'none',
                    icon = values[4] ? values[4].trim() : values[4];
                if (!label || !url || !type) {
                    return;
                }
                id = url + '#' + type;
                if (!icon) {
                    icon = type == 'embedded' ? 'ion-qr-scanner' : 'ion-link';
                }
                if (!map[id]) {
                    map[id] = {
                        url: url,
                        type: type,
                        position: position,
                        labels: {}
                    };
                    position++;
                }
                map[id].labels[lang.toLowerCase()] = {
                    label: label,
                    icon: icon
                };
            });
            if (!position) {
                return result;
            }
            return $mmLang.getCurrentLanguage().then(function(currentLang) {
                var fallbackLang = mmCoreConfigConstants.default_lang || 'en';
                angular.forEach(map, function(entry) {
                    var data = entry.labels[currentLang] || entry.labels.none || entry.labels[fallbackLang];
                    if (!data) {
                        data = entry.labels[Object.keys(entry.labels)[0]];
                    }
                    result[entry.position] = {
                        url: entry.url,
                        type: entry.type,
                        label: data.label,
                        icon: data.icon
                    };
                });
                return result;
            });
        });
    };
        self.hideRightSideMenu = function() {
        if (!scope) {
            return false;
        }
        if (!scope.rightSideMenu) {
            scope.rightSideMenu = {};
        }
        scope.rightSideMenu.show = false;
        return true;
    };
        self.setScope = function(scp) {
        scope = scp;
    };
        self.showRightSideMenu = function(template, data) {
        if (!template || !scope) {
            return false;
        }
        if (!scope.rightSideMenu) {
            scope.rightSideMenu = {};
        }
        scope.rightSideMenu.show = true;
        scope.rightSideMenu.template = template;
        scope.rsmScope = data;
        return true;
    };
    return self;
}])
.run(["$rootScope", "$mmSideMenu", function($rootScope, $mmSideMenu) {
    $rootScope.$on('$stateChangeStart', function(event, toState) {
        if (toState.name.split('.').length == 2) {
            $mmSideMenu.hideRightSideMenu();
        }
    });
}]);

angular.module('mm.core')
.directive('mmUserLink', ["$state", "mmUserProfileState", function($state, mmUserProfileState) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            element.on('click', function(event) {
                event.preventDefault();
                event.stopPropagation();
                $state.go(mmUserProfileState, {courseid: attrs.courseid, userid: attrs.userid});
            });
        }
    };
}]);

angular.module('mm.core.user')
.directive('mmUserProfileField', ["$mmUserProfileFieldsDelegate", "$compile", function($mmUserProfileFieldsDelegate, $compile) {
    return {
        restrict: 'E',
        scope: {
            field: '=',
            signup: '@?',
            edit: '@?',
            model: '=?',
            registerAuth: '@?',
            scrollHandle: '@?',
        },
        templateUrl: 'core/components/user/templates/userprofilefield.html',
        link: function(scope, element) {
            var field = scope.field,
                fieldContainer = element[0].querySelector('.mm-userprofilefield-container');
            scope.signup = scope.signup && scope.signup !== 'false';
            scope.edit = scope.edit && scope.edit !== 'false';
            if (field && fieldContainer) {
                var directive = $mmUserProfileFieldsDelegate.getDirectiveForField(field, scope.signup, scope.registerAuth);
                if (directive) {
                    fieldContainer.setAttribute(directive, '');
                    $compile(fieldContainer)(scope);
                }
            }
        }
    };
}]);

angular.module('mm.core.user')
.controller('mmUserAboutCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmUser", "$q", "$mmEvents", "$mmCourses", "mmUserEventProfileRefreshed", function($scope, $stateParams, $mmUtil, $mmUser, $q, $mmEvents, $mmCourses,
            mmUserEventProfileRefreshed) {
    var courseId = $stateParams.courseid,
        userId   = $stateParams.userid;
    $scope.isAndroid = ionic.Platform.isAndroid();
    function fetchUserData() {
        return $mmUser.getProfile(userId, courseId).then(function(user) {
            if (user.address) {
                user.address = $mmUser.formatAddress(user.address, user.city, user.country);
                user.encodedAddress = encodeURIComponent(user.address);
            }
            $scope.user = user;
            $scope.title = user.fullname;
            $scope.hasContact = user.email || user.phone1 || user.phone2 || user.city || user.country || user.address;
            $scope.hasDetails = user.url || user.interests || (user.customfields && user.customfields.length > 0);
        }, function(message) {
            if (message) {
                $mmUtil.showErrorModal(message);
            }
            return $q.reject();
        });
    }
    fetchUserData().finally(function() {
        $scope.userLoaded = true;
    });
    $scope.refreshUser = function() {
        var promises = [];
        promises.push($mmUser.invalidateUserCache(userId));
        $q.all(promises).finally(function() {
            fetchUserData().finally(function() {
                $mmEvents.trigger(mmUserEventProfileRefreshed, {courseid: courseId, userid: userId, user: $scope.user});
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.user')
.controller('mmUserProfileCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmUser", "$mmUserDelegate", "$mmSite", "$translate", "$mmCourses", "$q", "$mmEvents", "$mmFileUploaderHelper", "$mmSitesManager", "mmUserEventProfileRefreshed", "mmUserProfilePictureUpdated", "mmUserProfileHandlersTypeNewPage", "mmUserProfileHandlersTypeCommunication", "mmUserProfileHandlersTypeAction", function($scope, $stateParams, $mmUtil, $mmUser, $mmUserDelegate, $mmSite, $translate, $mmCourses,
            $q, $mmEvents, $mmFileUploaderHelper, $mmSitesManager, mmUserEventProfileRefreshed, mmUserProfilePictureUpdated,
            mmUserProfileHandlersTypeNewPage, mmUserProfileHandlersTypeCommunication, mmUserProfileHandlersTypeAction) {
    $scope.courseId = $stateParams.courseid;
    $scope.userId   = $stateParams.userid;
    function fetchUserData() {
        return $mmUser.getProfile($scope.userId, $scope.courseId).then(function(user) {
            user.address = $mmUser.formatAddress("", user.city, user.country);
            user.roles = $mmUser.formatRoleList(user.roles);
            $scope.user = user;
            $scope.title = user.fullname;
            $scope.isLoadingHandlers = true;
            $mmUserDelegate.getProfileHandlersFor(user, $scope.courseId).then(function(handlers) {
                $scope.actionHandlers = [];
                $scope.newPageHandlers = [];
                $scope.communicationHandlers = [];
                angular.forEach(handlers, function(handler) {
                    switch (handler.type) {
                        case mmUserProfileHandlersTypeCommunication:
                            $scope.communicationHandlers.push(handler);
                            break;
                        case mmUserProfileHandlersTypeAction:
                            $scope.actionHandlers.push(handler);
                            break;
                        case mmUserProfileHandlersTypeNewPage:
                        default:
                            $scope.newPageHandlers.push(handler);
                            break;
                    }
                });
            }).finally(function() {
                $scope.isLoadingHandlers = false;
            });
        }, function(message) {
            if (message) {
                $mmUtil.showErrorModal(message);
            }
            return $q.reject();
        });
    }
    fetchUserData().then(function() {
        return $mmSite.write('core_user_view_user_profile', {
            userid: $scope.userId,
            courseid: $scope.courseId
        }).catch(function(error) {
            $scope.isDeleted = error === $translate.instant('mm.core.userdeleted');
        });
    }).finally(function() {
        $scope.userLoaded = true;
    });
    obsRefreshed = $mmEvents.on(mmUserEventProfileRefreshed, function(data) {
        if (typeof data.user != "undefined") {
            $scope.user.email = data.user.email;
            $scope.user.address = $mmUser.formatAddress("", data.user.city, data.user.country);
        }
    });
    $scope.refreshUser = function() {
        var promises = [];
        promises.push($mmUser.invalidateUserCache($scope.userId));
        promises.push($mmCourses.invalidateUserNavigationOptions());
        promises.push($mmCourses.invalidateUserAdministrationOptions());
        $q.all(promises).finally(function() {
            fetchUserData().finally(function() {
                $mmEvents.trigger(mmUserEventProfileRefreshed, {courseid: $scope.courseId, userid: $scope.userId,
                    user: $scope.user});
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    $scope.canChangeProfilePicture =
        (!$scope.courseId || $scope.courseId == $mmSite.getSiteHomeId()) &&
        $scope.userId == $mmSite.getUserId() &&
        $mmSite.canUploadFiles() &&
        $mmSite.wsAvailable('core_user_update_picture') &&
        !$mmUser.isUpdatePictureDisabledInSite();
    $scope.changeProfilePicture = function() {
        var maxSize = -1;
        var title = $translate.instant('mm.user.newpicture');
        var filterMethods = ['album', 'camera'];
        return $mmFileUploaderHelper.selectAndUploadFile(maxSize, title, filterMethods).then(function(result) {
            return $mmUser.changeProfilePicture(result.itemid, $scope.userId).then(function(profileimageurl) {
                $mmEvents.trigger(mmUserProfilePictureUpdated, {userId: $scope.userId, picture: profileimageurl});
                $mmSitesManager.updateSiteInfo($mmSite.getId());
                $scope.refreshUser();
            });
        }).catch(function(message) {
            if (message) {
                $mmUtil.showErrorModal(message);
            }
            return $q.reject();
        });
    };
    $scope.$on('$destroy', function() {
        obsRefreshed && obsRefreshed.off && obsRefreshed.off();
    });
}]);

angular.module('mm.addons.badges', [])
.constant('mmaBadgesPriority', 50)
.constant('mmaBadgesComponent', 'mmaBadges')
.config(["$stateProvider", "$mmUserDelegateProvider", "mmaBadgesPriority", "$mmContentLinksDelegateProvider", function($stateProvider, $mmUserDelegateProvider, mmaBadgesPriority, $mmContentLinksDelegateProvider) {
    $stateProvider
    .state('site.userbadges', {
        url: '/userbadges',
        views: {
            'site': {
                templateUrl: 'addons/badges/templates/userbadges.html',
                controller: 'mmaBadgesUserCtrl'
            }
        },
        params: {
            courseid: null,
            userid: null
        }
    })
    .state('site.issuedbadge', {
        url: '/issuedbadge',
        views: {
            'site': {
                templateUrl: 'addons/badges/templates/issuedbadge.html',
                controller: 'mmaBadgesIssuedCtrl'
            }
        },
        params: {
            cid: null,
            uid: null,
            uniquehash: null
        }
    });
    $mmUserDelegateProvider.registerProfileHandler('mmaBadges', '$mmaBadgesHandlers.userProfile', mmaBadgesPriority);
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaBadges:myBadges', '$mmaBadgesHandlers.myBadgesLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaBadges:badge', '$mmaBadgesHandlers.badgeLinksHandler');
}]);

angular.module('mm.addons.calendar', [])
.constant('mmaCalendarDaysInterval', 30)
.constant('mmaCalendarDefaultNotifTime', 60)
.constant('mmaCalendarComponent', 'mmaCalendarEvents')
.constant('mmaCalendarPriority', 400)
.constant('mmaCalendarDefaultNotifTimeSetting', 'mmaCalendarDefaultNotifTime')
.constant('mmaCalendarDefaultNotifTimeChangedEvent', 'mma_calendar_default_notif_time_changed')
.config(["$stateProvider", "$mmSideMenuDelegateProvider", "mmaCalendarPriority", function($stateProvider, $mmSideMenuDelegateProvider, mmaCalendarPriority) {
    $stateProvider
        .state('site.calendar', {
            url: '/calendar',
            views: {
                'site': {
                    controller: 'mmaCalendarListCtrl',
                    templateUrl: 'addons/calendar/templates/list.html'
                }
            },
            params: {
                eventid: null,
                clear: false
            }
        })
        .state('site.calendar-event', {
            url: '/calendar-event/:id',
            views: {
                'site': {
                    controller: 'mmaCalendarEventCtrl',
                    templateUrl: 'addons/calendar/templates/event.html'
                }
            }
        })
        .state('site.calendar-settings', {
            url: '/calendar-settings',
            views: {
                'site': {
                    controller: 'mmaCalendarSettingsCtrl',
                    templateUrl: 'addons/calendar/templates/settings.html'
                }
            }
        });
    $mmSideMenuDelegateProvider.registerNavHandler('mmaCalendar', '$mmaCalendarHandlers.sideMenuNav', mmaCalendarPriority);
}])
.run(["$mmaCalendar", "$mmLocalNotifications", "$state", "$mmApp", "mmaCalendarComponent", function($mmaCalendar, $mmLocalNotifications, $state, $mmApp, mmaCalendarComponent) {
    $mmLocalNotifications.registerClick(mmaCalendarComponent, function(data) {
        if (data.eventid) {
            $mmApp.ready().then(function() {
                $mmaCalendar.isDisabled(data.siteid).then(function(disabled) {
                    if (disabled) {
                        return;
                    }
                    $state.go('redirect', {siteid: data.siteid, state: 'site.calendar', params: {eventid: data.eventid}});
                });
            });
        }
    });
    $mmApp.ready().then(function() {
        $mmaCalendar.scheduleAllSitesEventsNotifications();
    });
}]);

angular.module('mm.addons.competency', [])
.constant('mmaCompetencyPriority', 900)
.constant('mmaCourseCompetenciesPriority', 700)
.constant('mmaCompetencyStatusDraft', 0)
.constant('mmaCompetencyStatusActive', 1)
.constant('mmaCompetencyStatusComplete', 2)
.constant('mmaCompetencyStatusWaitingForReview', 3)
.constant('mmaCompetencyStatusInReview', 4)
.constant('mmaCompetencyReviewStatusIdle', 0)
.constant('mmaCompetencyReviewStatusWaitingForReview', 1)
.constant('mmaCompetencyReviewStatusInReview', 2)
.config(["$stateProvider", "$mmSideMenuDelegateProvider", "$mmCoursesDelegateProvider", "$mmUserDelegateProvider", "mmaCompetencyPriority", "mmaCourseCompetenciesPriority", function($stateProvider, $mmSideMenuDelegateProvider, $mmCoursesDelegateProvider, $mmUserDelegateProvider,
    mmaCompetencyPriority, mmaCourseCompetenciesPriority) {
    $stateProvider
        .state('site.learningplans', {
            url: '/learningplans',
            params: {
                userid: null
            },
            views: {
                'site': {
                    controller: 'mmaLearningPlansListCtrl',
                    templateUrl: 'addons/competency/templates/planlist.html'
                }
            }
        })
        .state('site.learningplan', {
            url: '/learningplan',
            params: {
                id: null
            },
            views: {
                'site': {
                    controller: 'mmaLearningPlanCtrl',
                    templateUrl: 'addons/competency/templates/plan.html'
                }
            }
        })
        .state('site.competencies', {
            url: '/competencies',
            params: {
                pid: null,
                cid: null,
                compid: null,
                uid: null
            },
            views: {
                'site': {
                    controller: 'mmaCompetenciesListCtrl',
                    templateUrl: 'addons/competency/templates/competencies.html'
                }
            }
        })
        .state('site.competency', {
            url: '/competency',
            params: {
                planid: null,
                courseid: null,
                competencyid: null,
                userid: null
            },
            views: {
                'site': {
                    controller: 'mmaCompetencyCtrl',
                    templateUrl: 'addons/competency/templates/competency.html'
                }
            }
        })
        .state('site.coursecompetencies', {
            url: '/coursecompetencies',
            params: {
                courseid: null,
                userid: null
            },
            views: {
                'site': {
                    controller: 'mmaCourseCompetenciesCtrl',
                    templateUrl: 'addons/competency/templates/coursecompetencies.html'
                }
            }
        })
        .state('site.competencysummary', {
            url: '/competencysummary',
            params: {
                competencyid: null
            },
            views: {
                'site': {
                    controller: 'mmaCompetencySummaryCtrl',
                    templateUrl: 'addons/competency/templates/competencysummary.html'
                }
            }
        });
    $mmSideMenuDelegateProvider.registerNavHandler('mmaCompetency', '$mmaCompetencyHandlers.sideMenuNav', mmaCompetencyPriority);
    $mmCoursesDelegateProvider.registerNavHandler('mmaCompetency', '$mmaCompetencyHandlers.coursesNav',
        mmaCourseCompetenciesPriority);
    $mmUserDelegateProvider.registerProfileHandler('mmaCompetency:learningPlan', '$mmaCompetencyHandlers.learningPlan',
        mmaCompetencyPriority);
}]);
angular.module('mm.addons.coursecompletion', [])
.constant('mmaCourseCompletionPriority', 200)
.constant('mmaCourseCompletionViewCompletionPriority', 200)
.config(["$stateProvider", "$mmUserDelegateProvider", "$mmCoursesDelegateProvider", "mmaCourseCompletionPriority", "mmaCourseCompletionViewCompletionPriority", function($stateProvider, $mmUserDelegateProvider, $mmCoursesDelegateProvider, mmaCourseCompletionPriority,
            mmaCourseCompletionViewCompletionPriority) {
    $stateProvider
    .state('site.course-completion', {
        url: '/course-completion',
        views: {
            'site': {
                templateUrl: 'addons/coursecompletion/templates/report.html',
                controller: 'mmaCourseCompletionReportCtrl'
            }
        },
        params: {
            course: null,
            userid: null
        }
    });
    $mmUserDelegateProvider.registerProfileHandler('mmaCourseCompletion:viewCompletion',
            '$mmaCourseCompletionHandlers.viewCompletion', mmaCourseCompletionViewCompletionPriority);
    $mmCoursesDelegateProvider.registerNavHandler('mmaCourseCompletion',
            '$mmaCourseCompletionHandlers.coursesNav', mmaCourseCompletionPriority);
}]);

angular.module('mm.addons.files', ['mm.core'])
.constant('mmaFilesMyComponent', 'mmaFilesMy')
.constant('mmaFilesSiteComponent', 'mmaFilesSite')
.constant('mmaFilesPriority', 200)
.config(["$stateProvider", "$mmSideMenuDelegateProvider", "mmaFilesPriority", function($stateProvider, $mmSideMenuDelegateProvider, mmaFilesPriority) {
    $stateProvider
        .state('site.files', {
            url: '/files',
            views: {
                'site': {
                    controller: 'mmaFilesIndexController',
                    templateUrl: 'addons/files/templates/index.html'
                }
            }
        })
        .state('site.files-list', {
            url: '/list',
            params: {
                path: false,
                root: false,
                title: false
            },
            views: {
                'site': {
                    controller: 'mmaFilesListController',
                    templateUrl: 'addons/files/templates/list.html'
                }
            }
        })
        .state('site.files-choose-site', {
            url: '/choose-site',
            params: {
                file: null
            },
            views: {
                'site': {
                    controller: 'mmaFilesChooseSiteCtrl',
                    templateUrl: 'addons/files/templates/choosesite.html'
                }
            }
        });
    $mmSideMenuDelegateProvider.registerNavHandler('mmaFiles', '$mmaFilesHandlers.sideMenuNav', mmaFilesPriority);
}]);

angular.module('mm.addons.frontpage', [])
.constant('mmaFrontpagePriority', 1000)
.config(["$stateProvider", "$mmCoursesDelegateProvider", "mmCoreCoursePriority", function($stateProvider, $mmCoursesDelegateProvider, mmCoreCoursePriority) {
    $stateProvider
    .state('site.frontpage', {
        url: '/frontpage',
        params: {
            moduleid: null
        },
        views: {
            'site': {
                templateUrl: 'addons/frontpage/templates/frontpage.html',
                controller: 'mmaFrontpageCtrl'
            }
        }
    });
}])
.config(["$mmSideMenuDelegateProvider", "$mmContentLinksDelegateProvider", "mmaFrontpagePriority", function($mmSideMenuDelegateProvider, $mmContentLinksDelegateProvider, mmaFrontpagePriority) {
    $mmSideMenuDelegateProvider.registerNavHandler('mmaFrontpage', '$mmaFrontPageHandlers.sideMenuNav', mmaFrontpagePriority);
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaFrontpage', '$mmaFrontPageHandlers.linksHandler');
}]);

angular.module('mm.addons.grades', [])
.constant('mmaGradesPriority', 400)
.constant('mmaGradesViewGradesPriority', 400)
.constant('mmaGradesSideMenuPriority', 950)
.config(["$stateProvider", "$mmUserDelegateProvider", "$mmCoursesDelegateProvider", "$mmContentLinksDelegateProvider", "$mmSideMenuDelegateProvider", "mmaGradesPriority", "mmaGradesViewGradesPriority", "mmaGradesSideMenuPriority", function($stateProvider, $mmUserDelegateProvider, $mmCoursesDelegateProvider, $mmContentLinksDelegateProvider,
            $mmSideMenuDelegateProvider, mmaGradesPriority, mmaGradesViewGradesPriority, mmaGradesSideMenuPriority) {
    $stateProvider
    .state('site.coursesgrades', {
        url: '/coursesgrades',
        views: {
            'site': {
                templateUrl: 'addons/grades/templates/courses.html',
                controller: 'mmaGradesCoursesGradesCtrl'
            }
        }
    });
    $mmUserDelegateProvider.registerProfileHandler('mmaGrades:viewGrades', '$mmaGradesHandlers.viewGrades', mmaGradesViewGradesPriority);
    $mmCoursesDelegateProvider.registerNavHandler('mmaGrades', '$mmaGradesHandlers.coursesNav', mmaGradesPriority);
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaGrades:user', '$mmaGradesHandlers.userLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaGrades:overview', '$mmaGradesHandlers.overviewLinksHandler');
    $mmSideMenuDelegateProvider.registerNavHandler('mmaGrades', '$mmaGradesHandlers.sideMenuNav', mmaGradesSideMenuPriority);
}]);

angular.module('mm.addons.messageoutput', []);

angular.module('mm.addons.messages', ['mm.core'])
.constant('mmaMessagesComponent', 'mmaMessages')
.constant('mmaMessagesLimitMessages', 50)
.constant('mmaMessagesDiscussionLoadedEvent', 'mma_messages_discussion_loaded')
.constant('mmaMessagesDiscussionLeftEvent', 'mma_messages_discussion_left')
.constant('mmaMessagesPollInterval', 10000)
.constant('mmaMessagesPriority', 600)
.constant('mmaMessagesSendMessagePriority', 1000)
.constant('mmaMessagesAddContactPriority', 800)
.constant('mmaMessagesBlockContactPriority', 600)
.constant('mmaMessagesPreferencesPriority', 600)
.constant('mmaMessagesNewMessageEvent', 'mma-messages_new_message')
.constant('mmaMessagesReadChangedEvent', 'mma-messages_read_changed')
.constant('mmaMessagesReadCronEvent', 'mma-messages_read_cron')
.constant('mmaMessagesAutomSyncedEvent', 'mma_messages_autom_synced')
.config(["$stateProvider", "$mmUserDelegateProvider", "$mmSideMenuDelegateProvider", "mmaMessagesSendMessagePriority", "mmaMessagesAddContactPriority", "mmaMessagesBlockContactPriority", "mmaMessagesPriority", "$mmContentLinksDelegateProvider", "$mmSettingsDelegateProvider", "mmaMessagesPreferencesPriority", function($stateProvider, $mmUserDelegateProvider, $mmSideMenuDelegateProvider, mmaMessagesSendMessagePriority,
            mmaMessagesAddContactPriority, mmaMessagesBlockContactPriority, mmaMessagesPriority, $mmContentLinksDelegateProvider,
            $mmSettingsDelegateProvider, mmaMessagesPreferencesPriority) {
    $stateProvider
    .state('site.messages', {
        url: '/messages',
        views: {
            'site': {
                templateUrl: 'addons/messages/templates/index.html'
            }
        }
    })
    .state('site.messages-discussion', {
        url: '/messages-discussion',
        params: {
            userId: null,
            showKeyboard: false,
        },
        views: {
            'site': {
                templateUrl: 'addons/messages/templates/discussion.html',
                controller: 'mmaMessagesDiscussionCtrl'
            }
        }
    })
    .state('site.messages-preferences', {
        url: '/messages-preferences',
        views: {
            'site': {
                controller: 'mmaMessagesPreferencesCtrl',
                templateUrl: 'addons/messages/templates/preferences.html'
            }
        }
    });
    $mmSideMenuDelegateProvider.registerNavHandler('mmaMessages', '$mmaMessagesHandlers.sideMenuNav', mmaMessagesPriority);
    $mmUserDelegateProvider.registerProfileHandler('mmaMessages:sendMessage', '$mmaMessagesHandlers.sendMessage', mmaMessagesSendMessagePriority);
    $mmUserDelegateProvider.registerProfileHandler('mmaMessages:addContact', '$mmaMessagesHandlers.addContact', mmaMessagesAddContactPriority);
    $mmUserDelegateProvider.registerProfileHandler('mmaMessages:blockContact', '$mmaMessagesHandlers.blockContact', mmaMessagesBlockContactPriority);
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaMessages:index', '$mmaMessagesHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaMessages:discussion', '$mmaMessagesHandlers.discussionLinksHandler');
    $mmSettingsDelegateProvider.registerHandler('mmaMessages:preferences',
            '$mmaMessagesHandlers.preferences', mmaMessagesPreferencesPriority);
}])
.run(["$mmaMessages", "$mmEvents", "$state", "$mmAddonManager", "$mmUtil", "mmCoreEventLogin", "$mmCronDelegate", "$mmaMessagesSync", "mmCoreEventOnlineStatusChanged", "$mmSitesManager", function($mmaMessages, $mmEvents, $state, $mmAddonManager, $mmUtil, mmCoreEventLogin, $mmCronDelegate, $mmaMessagesSync,
            mmCoreEventOnlineStatusChanged, $mmSitesManager) {
    $mmEvents.on(mmCoreEventLogin, function() {
        $mmaMessages.invalidateEnabledCache();
    });
    var $mmPushNotificationsDelegate = $mmAddonManager.get('$mmPushNotificationsDelegate');
    if ($mmPushNotificationsDelegate) {
        $mmPushNotificationsDelegate.registerHandler('mmaMessages', function(notification) {
            if ($mmUtil.isFalseOrZero(notification.notif)) {
                $mmaMessages.isMessagingEnabledForSite(notification.site).then(function() {
                    $mmSitesManager.isFeatureDisabled('$mmSideMenuDelegate_mmaMessages', notification.site).then(function(disabled) {
                        if (disabled) {
                            return;
                        }
                        $mmaMessages.invalidateDiscussionsCache().finally(function() {
                            $state.go('redirect', {siteid: notification.site, state: 'site.messages'});
                        });
                    });
                });
                return true;
            }
        });
    }
    $mmCronDelegate.register('mmaMessagesSync', '$mmaMessagesHandlers.syncHandler');
    $mmCronDelegate.register('mmaMessagesMenu', '$mmaMessagesHandlers.sideMenuNav');
    $mmEvents.on(mmCoreEventOnlineStatusChanged, function(online) {
        if (online) {
            $mmaMessagesSync.syncAllDiscussions(undefined, true);
        }
    });
}]);

angular.module('mm.addons.notes', [])
.constant('mmaNotesPriority', 200)
.constant('mmaNotesAddNotePriority', 200)
.constant('mmaNotesComponent', 'mmaNotes')
.constant('mmaNotesAutomSyncedEvent', 'mma_notes_autom_synced')
.constant('mmaModNotesSyncTime', 300000)
.config(["$stateProvider", "$mmUserDelegateProvider", "$mmCoursesDelegateProvider", "mmaNotesPriority", "mmaNotesAddNotePriority", function($stateProvider, $mmUserDelegateProvider, $mmCoursesDelegateProvider, mmaNotesPriority, mmaNotesAddNotePriority) {
    $stateProvider
    .state('site.notes-types', {
        url: '/notes-types',
        views: {
            'site': {
                templateUrl: 'addons/notes/templates/types.html',
                controller: 'mmaNotesTypesCtrl'
            }
        },
        params: {
            course: null
        }
    })
    .state('site.notes-list', {
        url: '/notes-list',
        views: {
            'site': {
                templateUrl: 'addons/notes/templates/list.html',
                controller: 'mmaNotesListCtrl'
            }
        },
        params: {
            courseid: null,
            type: null
        }
    });
    $mmUserDelegateProvider.registerProfileHandler('mmaNotes:addNote', '$mmaNotesHandlers.addNote', mmaNotesAddNotePriority);
    $mmCoursesDelegateProvider.registerNavHandler('mmaNotes', '$mmaNotesHandlers.coursesNav', mmaNotesPriority);
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaNotes', '$mmaNotesHandlers.syncHandler');
}]);

angular.module('mm.addons.notifications', [])
.constant('mmaNotificationsListLimit', 20)
.constant('mmaNotificationsPriority', 800)
.constant('mmaNotificationsPreferencesPriority', 500)
.constant('mmaNotificationsReadChangedEvent', 'mma-notifications_read_changed')
.constant('mmaNotificationsReadCronEvent', 'mma-notifications_read_cron')
.config(["$stateProvider", "$mmSideMenuDelegateProvider", "mmaNotificationsPriority", "$mmSettingsDelegateProvider", "mmaNotificationsPreferencesPriority", function($stateProvider, $mmSideMenuDelegateProvider, mmaNotificationsPriority, $mmSettingsDelegateProvider,
            mmaNotificationsPreferencesPriority) {
    $stateProvider
    .state('site.notifications', {
        url: '/notifications',
        views: {
            'site': {
                templateUrl: 'addons/notifications/templates/list.html',
                controller: 'mmaNotificationsListCtrl'
            }
        }
    })
    .state('site.notifications-preferences', {
        url: '/notifications-preferences',
        views: {
            'site': {
                controller: 'mmaNotificationsPreferencesCtrl',
                templateUrl: 'addons/notifications/templates/preferences.html'
            }
        }
    });
    $mmSideMenuDelegateProvider.registerNavHandler('mmaNotifications', '$mmaNotificationsHandlers.sideMenuNav', mmaNotificationsPriority);
    $mmSettingsDelegateProvider.registerHandler('mmaNotifications:preferences',
            '$mmaNotificationsHandlers.preferences', mmaNotificationsPreferencesPriority);
}])
.run(["$log", "$mmaNotifications", "$mmUtil", "$state", "$mmAddonManager", "$mmCronDelegate", "$mmSitesManager", function($log, $mmaNotifications, $mmUtil, $state, $mmAddonManager, $mmCronDelegate, $mmSitesManager) {
    $log = $log.getInstance('mmaNotifications');
    var $mmPushNotificationsDelegate = $mmAddonManager.get('$mmPushNotificationsDelegate');
    if ($mmPushNotificationsDelegate) {
        $mmPushNotificationsDelegate.registerHandler('mmaNotifications', function(notification) {
            if ($mmUtil.isTrueOrOne(notification.notif)) {
                $mmaNotifications.isPluginEnabledForSite(notification.site).then(function() {
                    $mmSitesManager.isFeatureDisabled('$mmSideMenuDelegate_mmaNotifications', notification.site)
                            .then(function(disabled) {
                        if (disabled) {
                            return;
                        }
                        $mmaNotifications.invalidateNotificationsList().finally(function() {
                            $state.go('redirect', {siteid: notification.site, state: 'site.notifications'});
                        });
                    });
                });
                return true;
            }
        });
    }
    $mmCronDelegate.register('mmaNotificationsMenu', '$mmaNotificationsHandlers.sideMenuNav');
}]);

angular.module('mm.addons.participants', [])
.constant('mmaParticipantsListLimit', 50)
.constant('mmaParticipantsPriority', 600)
.config(["$stateProvider", "$mmCoursesDelegateProvider", "$mmContentLinksDelegateProvider", "mmaParticipantsPriority", function($stateProvider, $mmCoursesDelegateProvider, $mmContentLinksDelegateProvider, mmaParticipantsPriority) {
    $stateProvider
        .state('site.participants', {
            url: '/participants',
            views: {
                'site': {
                    controller: 'mmaParticipantsListCtrl',
                    templateUrl: 'addons/participants/templates/list.html'
                }
            },
            params: {
                course: null
            }
        });
    $mmCoursesDelegateProvider.registerNavHandler('mmaParticipants', '$mmaParticipantsHandlers.coursesNavHandler',
                mmaParticipantsPriority);
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaParticipants', '$mmaParticipantsHandlers.linksHandler');
}]);

angular.module('mm.addons.pushnotifications', [])
.constant('mmaPushNotificationsComponent', 'mmaPushNotifications')
.run(["$mmaPushNotifications", "$ionicPlatform", "$rootScope", "$mmEvents", "$mmLocalNotifications", "mmCoreEventLogin", "mmaPushNotificationsComponent", "mmCoreEventSiteDeleted", function($mmaPushNotifications, $ionicPlatform, $rootScope, $mmEvents, $mmLocalNotifications, mmCoreEventLogin,
            mmaPushNotificationsComponent, mmCoreEventSiteDeleted) {
    $ionicPlatform.ready(function() {
        $mmaPushNotifications.registerDevice();
    });
    $rootScope.$on('$cordovaPushV5:notificationReceived', function(e, notification) {
        $mmaPushNotifications.onMessageReceived(notification);
    });
    $mmEvents.on(mmCoreEventLogin, function() {
        $mmaPushNotifications.registerDeviceOnMoodle();
    });
    $mmEvents.on(mmCoreEventSiteDeleted, function(site) {
        $mmaPushNotifications.unregisterDeviceOnMoodle(site);
        $mmaPushNotifications.cleanSiteCounters(site.id);
    });
    $mmLocalNotifications.registerClick(mmaPushNotificationsComponent, $mmaPushNotifications.notificationClicked);
}]);

angular.module('mm.addons.remotestyles', [])
.constant('mmaRemoteStylesComponent', 'mmaRemoteStyles')
.config(["$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    $mmInitDelegateProvider.registerProcess('mmaRemoteStylesCurrent',
                '$mmaRemoteStyles._preloadCurrentSite', mmInitDelegateMaxAddonPriority + 250, true);
    $mmInitDelegateProvider.registerProcess('mmaRemoteStylesPreload', '$mmaRemoteStyles._preloadSites');
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventLogout", "mmCoreEventSiteAdded", "mmCoreEventSiteUpdated", "$mmaRemoteStyles", "$mmSite", "mmCoreEventSiteDeleted", function($mmEvents, mmCoreEventLogin, mmCoreEventLogout, mmCoreEventSiteAdded, mmCoreEventSiteUpdated, $mmaRemoteStyles,
            $mmSite, mmCoreEventSiteDeleted) {
    $mmEvents.on(mmCoreEventSiteAdded, function(siteId) {
        $mmaRemoteStyles.addSite(siteId);
    });
    $mmEvents.on(mmCoreEventSiteUpdated, function(siteId) {
        if (siteId === $mmSite.getId()) {
            $mmaRemoteStyles.load(siteId);
        }
    });
    $mmEvents.on(mmCoreEventLogin, $mmaRemoteStyles.enable);
    $mmEvents.on(mmCoreEventLogout, $mmaRemoteStyles.clear);
    $mmEvents.on(mmCoreEventSiteDeleted, function(site) {
        $mmaRemoteStyles.removeSite(site.id);
    });
}]);

angular.module('mm.addons.messageoutput_airnotifier', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.messageoutput-airnotifier-preferences', {
        url: '/messageoutput-airnotifier-preferences',
        params: {
        	title: null
        },
        views: {
            'site': {
                controller: 'mmaMessageOutputAirnotifierDevicesCtrl',
                templateUrl: 'addons/messageoutput/airnotifier/templates/devices.html'
            }
        }
    });
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaMessageOutputDelegate = $mmAddonManager.get('$mmaMessageOutputDelegate');
    if ($mmaMessageOutputDelegate) {
        $mmaMessageOutputDelegate.registerHandler('mmaMessageOutputAirnotifier', 'airnotifier',
                '$mmaMessageOutputAirnotifierHandlers.processorPreferences');
    }
}]);

angular.module('mm.addons.mod_book', ['mm.core'])
.constant('mmaModBookComponent', 'mmaModBook')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_book', {
      url: '/mod_book',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModBookIndexCtrl',
          templateUrl: 'addons/mod/book/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModBook', 'book', '$mmaModBookHandlers.courseContentHandler');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModBook', 'book', '$mmaModBookPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModBook', '$mmaModBookHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_assign', ['mm.core'])
.constant('mmaModAssignComponent', 'mmaModAssign')
.constant('mmaModAssignSubmissionComponent', 'mmaModAssignSubmission')
.constant('mmaModAssignSubmissionStatusNew', 'new')
.constant('mmaModAssignSubmissionStatusReopened', 'reopened')
.constant('mmaModAssignSubmissionStatusDraft', 'draft')
.constant('mmaModAssignSubmissionStatusSubmitted', 'submitted')
.constant('mmaModAssignAttemptReopenMethodNone', 'none')
.constant('mmaModAssignAttemptReopenMethodManual', 'manual')
.constant('mmaModAssignUnlimitedAttempts', -1)
.constant('mmaModAssignGradingStatusGraded', 'graded')
.constant('mmaModAssignGradingStatusNotGraded', 'notgraded')
.constant('mmaModMarkingWorkflowStateReleased', 'released')
.constant('mmaModAssignNeedGrading', 'needgrading')
.constant('mmaModAssignSubmissionInvalidatedEvent', 'mma_mod_assign_submission_invalidated')
.constant('mmaModAssignSubmissionSavedEvent', 'mma_mod_assign_submission_saved')
.constant('mmaModAssignFeedbackSavedEvent', 'mma_mod_assign_feedback_saved')
.constant('mmaModAssignSubmittedForGradingEvent', 'mma_mod_assign_submitted_for_grading')
.constant('mmaModAssignEventAutomSynced', 'mma_mod_assign_autom_synced')
.constant('mmaModAssignEventManualSynced', 'mma_mod_assign_manual_synced')
.constant('mmaModAssignEventSubmitGrade', 'mma_mod_assign_submit_grade')
.constant('mmaModAssignGradedEvent', 'mma_mod_assign_graded')
.constant('mmaModAssignSyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_assign', {
        url: '/mod_assign',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignIndexCtrl',
                templateUrl: 'addons/mod/assign/templates/index.html'
            }
        }
    })
    .state('site.mod_assign-description', {
        url: '/mod_assign-description',
        params: {
            moduleid: null,
            description: null,
            files: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignDescriptionCtrl',
                templateUrl: 'addons/mod/assign/templates/description.html'
            }
        }
    })
    .state('site.mod_assign-submission-list', {
        url: '/mod_assign-submission-list',
        params: {
            status: null,
            moduleid: null,
            modulename: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignSubmissionListCtrl',
                templateUrl: 'addons/mod/assign/templates/submissionlist.html'
            }
        }
    })
    .state('site.mod_assign-submission', {
        url: '/mod_assign-submission',
        params: {
            submitid: null,
            blindid: null,
            moduleid: null,
            courseid: null,
            showSubmission: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignSubmissionReviewCtrl',
                templateUrl: 'addons/mod/assign/templates/submissionreview.html'
            }
        }
    })
    .state('site.mod_assign-submission-edit', {
        url: '/mod_assign-submission-edit',
        params: {
            moduleid: null,
            courseid: null,
            userid: null,
            blindid: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignEditCtrl',
                templateUrl: 'addons/mod/assign/templates/edit.html'
            }
        }
    })
    .state('site.mod_assign-feedback-edit', {
        url: '/mod_assign-feedback-edit',
        params: {
            assignid: null,
            userid: null,
            plugintype: null,
            assign: null,
            submission: null,
            plugin: null
        },
        views: {
            'site': {
                controller: 'mmaModAssignFeedbackEditCtrl',
                templateUrl: 'addons/mod/assign/templates/feedbackedit.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModAssign', 'assign', '$mmaModAssignHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModAssign', '$mmaModAssignHandlers.linksHandler');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModAssign', 'assign', '$mmaModAssignPrefetchHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModAssign', '$mmaModAssignHandlers.syncHandler');
}]);
angular.module('mm.addons.mod_chat', [])
.constant('mmaChatPollInterval', 4000)
.constant('mmaModChatComponent', 'mmaModChat')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_chat', {
        url: '/mod_chat',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModChatIndexCtrl',
                templateUrl: 'addons/mod/chat/templates/index.html'
            }
        }
    })
    .state('site.mod_chat-chat', {
        url: '/mod_chat-chat',
        params: {
            chatid: null,
            courseid: null,
            title: null
        },
        views: {
            'site': {
                controller: 'mmaModChatChatCtrl',
                templateUrl: 'addons/mod/chat/templates/chat.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModChat', 'chat', '$mmaModChatHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModChat', '$mmaModChatHandlers.linksHandler');
}]);
angular.module('mm.addons.mod_choice', ["chart.js"])
.constant('mmaModChoiceResultsNot', 0)
.constant('mmaModChoiceResultsAfterAnswer', 1)
.constant('mmaModChoiceResultsAfterClose', 2)
.constant('mmaModChoiceResultsAlways', 3)
.constant('mmaModChoiceComponent', 'mmaModChoice')
.constant('mmaModChoiceAutomSyncedEvent', 'mma-mod_choice_autom_synced')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_choice', {
        url: '/mod_choice',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModChoiceIndexCtrl',
                templateUrl: 'addons/mod/choice/templates/index.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModChoice', 'choice', '$mmaModChoiceHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModChoice', '$mmaModChoiceHandlers.linksHandler');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModChoice', 'choice', '$mmaModChoicePrefetchHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModChoice', '$mmaModChoiceHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_folder', ['mm.core'])
.constant('mmaModFolderComponent', 'mmaModFolder')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_folder', {
      url: '/mod_folder',
      params: {
        module: null,
        courseid: null,
        sectionid: null,
        path: null
      },
      views: {
        'site': {
          controller: 'mmaModFolderIndexCtrl',
          templateUrl: 'addons/mod/folder/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModFolder', 'folder', '$mmaModFolderHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModFolder', 'folder', '$mmaModFolderPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModFolder', '$mmaModFolderHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_forum', [])
.constant('mmaModForumDiscPerPage', 10)
.constant('mmaModForumComponent', 'mmaModForum')
.constant('mmaModForumNewDiscussionEvent', 'mma-mod_forum_new_discussion')
.constant('mmaModForumReplyDiscussionEvent', 'mma-mod_forum_reply_discussion')
.constant('mmaModForumAutomSyncedEvent', 'mma-mod_forum_autom_synced')
.constant('mmaModForumManualSyncedEvent', 'mma-mod_forum_manual_synced')
.constant('mmaModForumSyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_forum', {
        url: '/mod_forum',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModForumDiscussionsCtrl',
                templateUrl: 'addons/mod/forum/templates/discussions.html'
            }
        }
    })
    .state('site.mod_forum-discussion', {
        url: '/mod_forum-discussion',
        params: {
            discussionid: null,
            cid: null,
            forumid: null,
            cmid: null,
            trackposts: null,
            locked: null
        },
        views: {
            'site': {
                controller: 'mmaModForumDiscussionCtrl',
                templateUrl: 'addons/mod/forum/templates/discussion.html'
            }
        }
    })
    .state('site.mod_forum-newdiscussion', {
        url: '/mod_forum-newdiscussion',
        params: {
            cid: null,
            forumid: null,
            cmid: null,
            timecreated: null
        },
        views: {
            'site': {
                controller: 'mmaModForumNewDiscussionCtrl',
                templateUrl: 'addons/mod/forum/templates/newdiscussion.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModForum', 'forum', '$mmaModForumHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModForum', 'forum', '$mmaModForumPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModForum:index', '$mmaModForumHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModForum:discussion', '$mmaModForumHandlers.discussionLinksHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModForum', '$mmaModForumHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_glossary', ['mm.core'])
.constant('mmaModGlossaryComponent', 'mmaModGlossary')
.constant('mmaModGlossaryAddEntryEvent', 'mma-mod_glossary_add_entry')
.constant('mmaModGlossaryAutomSyncedEvent', 'mma-mod_glossar_autom_synced')
.constant('mmaModGlossaryLimitEntriesNum', 25)
.constant('mmaModGlossaryLimitCategoriesNum', 20)
.constant('mmaModGlossaryShowAllCategories', 0)
.constant('mmaModGlossaryShowNotCategorised', -1)
.constant('mmaModGlossarySyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_glossary', {
      url: '/mod_glossary',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModGlossaryIndexCtrl',
          templateUrl: 'addons/mod/glossary/templates/index.html'
        }
      }
    })
    .state('site.mod_glossary-entry', {
      url: '/mod_glossary-entry',
      params: {
        cid: null,
        entryid: null
      },
      views: {
        'site': {
          controller: 'mmaModGlossaryEntryCtrl',
          templateUrl: 'addons/mod/glossary/templates/entry.html'
        }
      }
    })
    .state('site.mod_glossary-edit', {
        url: '/mod_glossary-edit',
        params: {
            module: null,
            cmid: null,
            glossary: null,
            glossaryid: null,
            courseid: null,
            entry: null
        },
        views: {
            'site': {
                controller: 'mmaModGlossaryEditCtrl',
                templateUrl: 'addons/mod/glossary/templates/edit.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModGlossary', 'glossary', '$mmaModGlossaryHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModGlossary', 'glossary', '$mmaModGlossaryPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModGlossary:index', '$mmaModGlossaryHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModGlossary:entry', '$mmaModGlossaryHandlers.entryLinksHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModGlossary', '$mmaModGlossaryHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_imscp', ['mm.core'])
.constant('mmaModImscpComponent', 'mmaModImscp')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_imscp', {
      url: '/mod_imscp',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModImscpIndexCtrl',
          templateUrl: 'addons/mod/imscp/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModImscp', 'imscp', '$mmaModImscpHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModImscp', 'imscp', '$mmaModImscpPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModImscp', '$mmaModImscpHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_label', ['mm.core'])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModLabel', 'label', '$mmaModLabelHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModLabel', '$mmaModLabelHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_lti', [])
.constant('mmaModLtiComponent', 'mmaModLti')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_lti', {
        url: '/mod_lti',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModLtiIndexCtrl',
                templateUrl: 'addons/mod/lti/templates/index.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModLti', 'lti', '$mmaModLtiHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModLti', '$mmaModLtiHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_page', ['mm.core'])
.constant('mmaModPageComponent', 'mmaModPage')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_page', {
      url: '/mod_page',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModPageIndexCtrl',
          templateUrl: 'addons/mod/page/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModPage', 'page', '$mmaModPageHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModPage', 'page', '$mmaModPagePrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModPage', '$mmaModPageHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_quiz', ['mm.core'])
.constant('mmaModQuizComponent', 'mmaModQuiz')
.constant('mmaModQuizCheckChangesInterval', 5000)
.constant('mmaModQuizComponent', 'mmaModQuiz')
.constant('mmaModQuizEventAttemptFinished', 'mma_mod_quiz_attempt_finished')
.constant('mmaModQuizEventAutomSynced', 'mma_mod_quiz_autom_synced')
.constant('mmaModQuizSyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_quiz', {
      url: '/mod_quiz',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModQuizIndexCtrl',
          templateUrl: 'addons/mod/quiz/templates/index.html'
        }
      }
    })
    .state('site.mod_quiz-attempt', {
      url: '/mod_quiz-attempt',
      params: {
        courseid: null,
        quizid: null,
        attemptid: null
      },
      views: {
        'site': {
          controller: 'mmaModQuizAttemptCtrl',
          templateUrl: 'addons/mod/quiz/templates/attempt.html'
        }
      }
    })
    .state('site.mod_quiz-player', {
      url: '/mod_quiz-player',
      params: {
        courseid: null,
        quizid: null,
        moduleurl: null
      },
      views: {
        'site': {
          controller: 'mmaModQuizPlayerCtrl',
          templateUrl: 'addons/mod/quiz/templates/player.html'
        }
      }
    })
    .state('site.mod_quiz-review', {
      url: '/mod_quiz-review',
      params: {
        courseid: null,
        quizid: null,
        attemptid: null,
        page: -1
      },
      views: {
        'site': {
          controller: 'mmaModQuizReviewCtrl',
          templateUrl: 'addons/mod/quiz/templates/review.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModQuiz', 'quiz', '$mmaModQuizHandlers.courseContentHandler');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModQuiz', 'quiz', '$mmaModQuizPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModQuiz:index', '$mmaModQuizHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModQuiz:grade', '$mmaModQuizHandlers.gradeLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModQuiz:review', '$mmaModQuizHandlers.reviewLinksHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModQuiz', '$mmaModQuizHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_resource', ['mm.core'])
.constant('mmaModResourceComponent', 'mmaModResource')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_resource', {
      url: '/mod_resource',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModResourceIndexCtrl',
          templateUrl: 'addons/mod/resource/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModResource', 'resource', '$mmaModResourceHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModResource', 'resource', '$mmaModResourcePrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModResource', '$mmaModResourceHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_scorm', ['mm.core'])
.constant('mmaModScormComponent', 'mmaModScorm')
.constant('mmaModScormEventLaunchNextSco', 'mma_mod_scorm_launch_next_sco')
.constant('mmaModScormEventLaunchPrevSco', 'mma_mod_scorm_launch_prev_sco')
.constant('mmaModScormEventUpdateToc', 'mma_mod_scorm_update_toc')
.constant('mmaModScormEventGoOffline', 'mma_mod_scorm_go_offline')
.constant('mmaModScormEventAutomSynced', 'mma_mod_scorm_autom_synced')
.constant('mmaModScormSyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_scorm', {
      url: '/mod_scorm',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModScormIndexCtrl',
          templateUrl: 'addons/mod/scorm/templates/index.html'
        }
      }
    })
    .state('site.mod_scorm-player', {
      url: '/mod_scorm-player',
      params: {
        scorm: null,
        mode: null,
        newAttempt: false,
        organizationId: null,
        scoId: null
      },
      views: {
        'site': {
          controller: 'mmaModScormPlayerCtrl',
          templateUrl: 'addons/mod/scorm/templates/player.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmCoursePrefetchDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmCoursePrefetchDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModScorm', 'scorm', '$mmaModScormHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModScorm', 'scorm', '$mmaModScormPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModScorm:index', '$mmaModScormHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModScorm:grade', '$mmaModScormHandlers.gradeLinksHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModScorm', '$mmaModScormHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_survey', [])
.constant('mmaModSurveyComponent', 'mmaModSurvey')
.constant('mmaModSurveyAutomSyncedEvent', 'mma_mod_survey_autom_synced')
.constant('mmaModSurveySyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_survey', {
        url: '/mod_survey',
        params: {
            module: null,
            courseid: null
        },
        views: {
            'site': {
                controller: 'mmaModSurveyIndexCtrl',
                templateUrl: 'addons/mod/survey/templates/index.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModSurvey', 'survey', '$mmaModSurveyHandlers.courseContent');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModSurvey', '$mmaModSurveyHandlers.linksHandler');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModSurvey', 'survey', '$mmaModSurveyPrefetchHandler');
}])
.run(["$mmCronDelegate", function($mmCronDelegate) {
    $mmCronDelegate.register('mmaModSurvey', '$mmaModSurveyHandlers.syncHandler');
}]);

angular.module('mm.addons.mod_url', ['mm.core'])
.constant('mmaModUrlComponent', 'mmaModUrl')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_url', {
      url: '/mod_url',
      params: {
        module: null,
        courseid: null
      },
      views: {
        'site': {
          controller: 'mmaModUrlIndexCtrl',
          templateUrl: 'addons/mod/url/templates/index.html'
        }
      }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModUrl', 'url', '$mmaModUrlHandlers.courseContentHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModUrl', '$mmaModUrlHandlers.linksHandler');
}]);

angular.module('mm.addons.mod_wiki', [])
.constant('mmaModWikiSubwikiPagesLoaded', 'mma_mod_wiki_subwiki_pages_loaded')
.constant('mmaModWikiPageCreatedEvent', 'mma_mod_wiki_page_created')
.constant('mmaModWikiManualSyncedEvent', 'mma_mod_wiki_manual_synced')
.constant('mmaModWikiSubwikiAutomSyncedEvent', 'mma_mod_wiki_subwiki_autom_synced')
.constant('mmaModWikiComponent', 'mmaModWiki')
.constant('mmaModWikiRenewLockTimeout', 30)
.constant('mmaModWikiSyncTime', 300000)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mod_wiki', {
        url: '/mod_wiki',
        params: {
            module: null,
            moduleid: null,
            courseid: null,
            pageid: null,
            pagetitle: null,
            wikiid: null,
            subwikiid: null,
            userid: null,
            groupid: null,
            action: null
        },
        views: {
            'site': {
                controller: 'mmaModWikiIndexCtrl',
                templateUrl: 'addons/mod/wiki/templates/index.html'
            }
        }
    })
    .state('site.mod_wiki-edit', {
        url: '/mod_wiki-edit',
        params: {
            module: null,
            courseid: null,
            pageid: null,
            pagetitle: null,
            subwikiid: null,
            wikiid: null,
            userid: null,
            groupid: null,
            section: null
        },
        views: {
            'site': {
                controller: 'mmaModWikiEditCtrl',
                templateUrl: 'addons/mod/wiki/templates/edit.html'
            }
        }
    });
}])
.config(["$mmCourseDelegateProvider", "$mmContentLinksDelegateProvider", "$mmCoursePrefetchDelegateProvider", function($mmCourseDelegateProvider, $mmContentLinksDelegateProvider, $mmCoursePrefetchDelegateProvider) {
    $mmCourseDelegateProvider.registerContentHandler('mmaModWiki', 'wiki', '$mmaModWikiHandlers.courseContent');
    $mmCoursePrefetchDelegateProvider.registerPrefetchHandler('mmaModWiki', 'wiki', '$mmaModWikiPrefetchHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModWiki:index', '$mmaModWikiHandlers.indexLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModWiki:pagemap', '$mmaModWikiHandlers.pageMapLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModWiki:create', '$mmaModWikiHandlers.createLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmaModWiki:edit', '$mmaModWikiHandlers.editLinksHandler');
}])
.run(["$mmEvents", "mmCoreEventLogout", "$mmaModWiki", "$mmCronDelegate", function($mmEvents, mmCoreEventLogout, $mmaModWiki, $mmCronDelegate) {
    $mmEvents.on(mmCoreEventLogout, $mmaModWiki.clearSubwikiList);
    $mmCronDelegate.register('mmaModWiki', '$mmaModWikiHandlers.syncHandler');
}]);

angular.module('mm.addons.qbehaviour_adaptive', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourAdaptive', 'adaptive', '$mmaQbehaviourAdaptiveHandler');
}]);

angular.module('mm.addons.qbehaviour_adaptivenopenalty', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourAdaptiveNoPenalty', 'adaptivenopenalty',
    			'$mmaQbehaviourAdaptiveNoPenaltyHandler');
}]);

angular.module('mm.addons.qbehaviour_deferredfeedback', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourDeferredFeedback', 'deferredfeedback',
    			'$mmaQbehaviourDeferredFeedbackHandler');
}]);

angular.module('mm.addons.qbehaviour_deferredcbm', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourDeferredCBM', 'deferredcbm',
    			'$mmaQbehaviourDeferredCBMHandler');
}]);

angular.module('mm.addons.qbehaviour_immediatecbm', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourImmediateCBM', 'immediatecbm',
    			'$mmaQbehaviourImmediateCBMHandler');
}]);

angular.module('mm.addons.qbehaviour_immediatefeedback', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourImmediateFeedback', 'immediatefeedback',
    			'$mmaQbehaviourImmediateFeedbackHandler');
}]);

angular.module('mm.addons.qbehaviour_informationitem', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourInformationItem', 'informationitem',
    			'$mmaQbehaviourInformationItemHandler');
}]);

angular.module('mm.addons.qbehaviour_interactive', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourInteractive', 'interactive',
    			'$mmaQbehaviourInteractiveHandler');
}]);

angular.module('mm.addons.qbehaviour_interactivecountback', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourInteractiveCountback', 'interactivecountback',
    			'$mmaQbehaviourInteractiveCountbackHandler');
}]);

angular.module('mm.addons.qbehaviour_manualgraded', ['mm.core'])
.config(["$mmQuestionBehaviourDelegateProvider", function($mmQuestionBehaviourDelegateProvider) {
    $mmQuestionBehaviourDelegateProvider.registerHandler('mmaQbehaviourManualGraded', 'manualgraded',
    			'$mmaQbehaviourManualGradedHandler');
}]);

angular.module('mm.addons.qtype_calculated', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeCalculated', 'qtype_calculated', '$mmaQtypeCalculatedHandler');
}]);

angular.module('mm.addons.qtype_calculatedsimple', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeCalculatedSimple', 'qtype_calculatedsimple',
    												'$mmaQtypeCalculatedSimpleHandler');
}]);

angular.module('mm.addons.qtype_calculatedmulti', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeCalculatedMulti', 'qtype_calculatedmulti',
    												'$mmaQtypeCalculatedMultiHandler');
}]);

angular.module('mm.addons.qtype_ddimageortext', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeDdimageortext', 'qtype_ddimageortext', '$mmaQtypeDdimageortextHandler');
}]);

angular.module('mm.addons.qtype_ddmarker', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeDdmarker', 'qtype_ddmarker', '$mmaQtypeDdmarkerHandler');
}]);

angular.module('mm.addons.qtype_ddwtos', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeDdwtos', 'qtype_ddwtos', '$mmaQtypeDdwtosHandler');
}]);

angular.module('mm.addons.qtype_description', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeDescription', 'qtype_description', '$mmaQtypeDescriptionHandler');
}]);

angular.module('mm.addons.qtype_essay', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeEssay', 'qtype_essay', '$mmaQtypeEssayHandler');
}]);

angular.module('mm.addons.qtype_gapselect', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeGapSelect', 'qtype_gapselect', '$mmaQtypeGapSelectHandler');
}]);

angular.module('mm.addons.qtype_match', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeMatch', 'qtype_match', '$mmaQtypeMatchHandler');
}]);

angular.module('mm.addons.qtype_multianswer', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeMultianswer', 'qtype_multianswer', '$mmaQtypeMultianswerHandler');
}]);

angular.module('mm.addons.qtype_numerical', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeNumerical', 'qtype_numerical', '$mmaQtypeNumericalHandler');
}]);

angular.module('mm.addons.qtype_multichoice', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeMultichoice', 'qtype_multichoice', '$mmaQtypeMultichoiceHandler');
}]);

angular.module('mm.addons.qtype_randomsamatch', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeRandomSaMatch', 'qtype_randomsamatch', '$mmaQtypeRandomSaMatchHandler');
}]);

angular.module('mm.addons.qtype_shortanswer', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeShortAnswer', 'qtype_shortanswer', '$mmaQtypeShortAnswerHandler');
}]);

angular.module('mm.addons.qtype_truefalse', ['mm.core'])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeTruefalse', 'qtype_truefalse', '$mmaQtypeTruefalseHandler');
}]);

angular.module('mm.addons.userprofilefield_checkbox', ['mm.core'])
.config(["$mmUserProfileFieldsDelegateProvider", function($mmUserProfileFieldsDelegateProvider) {
    $mmUserProfileFieldsDelegateProvider.registerHandler('mmaUserProfileFieldCheckbox',
    		'checkbox', '$mmaUserProfileFieldCheckboxHandler');
}]);

angular.module('mm.addons.userprofilefield_datetime', ['mm.core'])
.config(["$mmUserProfileFieldsDelegateProvider", function($mmUserProfileFieldsDelegateProvider) {
    $mmUserProfileFieldsDelegateProvider.registerHandler('mmaUserProfileFieldDatetime',
    		'datetime', '$mmaUserProfileFieldDatetimeHandler');
}]);

angular.module('mm.addons.userprofilefield_menu', ['mm.core'])
.config(["$mmUserProfileFieldsDelegateProvider", function($mmUserProfileFieldsDelegateProvider) {
    $mmUserProfileFieldsDelegateProvider.registerHandler('mmaUserProfileFieldMenu',
    		'menu', '$mmaUserProfileFieldMenuHandler');
}]);

angular.module('mm.addons.userprofilefield_text', ['mm.core'])
.config(["$mmUserProfileFieldsDelegateProvider", function($mmUserProfileFieldsDelegateProvider) {
    $mmUserProfileFieldsDelegateProvider.registerHandler('mmaUserProfileFieldText',
    		'text', '$mmaUserProfileFieldTextHandler');
}]);

angular.module('mm.addons.userprofilefield_textarea', ['mm.core'])
.config(["$mmUserProfileFieldsDelegateProvider", function($mmUserProfileFieldsDelegateProvider) {
    $mmUserProfileFieldsDelegateProvider.registerHandler('mmaUserProfileFieldTextarea',
    		'textarea', '$mmaUserProfileFieldTextareaHandler');
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignFeedbackFile', ["$mmaModAssign", function($mmaModAssign) {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/feedback/file/template.html',
        link: function(scope) {
            if (!scope.plugin) {
                return;
            }
            scope.files = $mmaModAssign.getSubmissionPluginAttachments(scope.plugin);
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignFeedbackFileHandler', ["$mmaModAssign", "$mmFilepool", "$q", "mmaModAssignComponent", function($mmaModAssign, $mmFilepool, $q, mmaModAssignComponent) {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.getDirectiveName = function() {
        return 'mma-mod-assign-feedback-file';
    };
        self.getPluginFiles = function(assign, submission, plugin, siteId) {
        return $mmaModAssign.getSubmissionPluginAttachments(plugin);
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignFeedbackDelegate = $mmAddonManager.get('$mmaModAssignFeedbackDelegate');
    if ($mmaModAssignFeedbackDelegate) {
        $mmaModAssignFeedbackDelegate.registerHandler('mmaModAssignFeedbackFile', 'file', '$mmaModAssignFeedbackFileHandler');
    }
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignFeedbackEditpdf', ["$mmaModAssign", function($mmaModAssign) {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/feedback/editpdf/template.html',
        link: function(scope) {
            if (!scope.plugin) {
                return;
            }
            scope.files = $mmaModAssign.getSubmissionPluginAttachments(scope.plugin);
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignFeedbackEditpdfHandler', ["$mmaModAssign", "$mmFilepool", "$q", "mmaModAssignComponent", function($mmaModAssign, $mmFilepool, $q, mmaModAssignComponent) {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.getDirectiveName = function() {
        return 'mma-mod-assign-feedback-editpdf';
    };
        self.getPluginFiles = function(assign, submission, plugin, siteId) {
        return $mmaModAssign.getSubmissionPluginAttachments(plugin);
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignFeedbackDelegate = $mmAddonManager.get('$mmaModAssignFeedbackDelegate');
    if ($mmaModAssignFeedbackDelegate) {
        $mmaModAssignFeedbackDelegate.registerHandler('mmaModAssignFeedbackEditpdf', 'editpdf',
                '$mmaModAssignFeedbackEditpdfHandler');
    }
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignFeedbackComments', ["$mmaModAssign", "$mmText", "$mmUtil", "$q", "$mmaModAssignFeedbackCommentsHandler", "$mmEvents", "mmaModAssignFeedbackSavedEvent", "$mmSite", "$mmaModAssignOffline", function($mmaModAssign, $mmText, $mmUtil, $q, $mmaModAssignFeedbackCommentsHandler,
        $mmEvents, mmaModAssignFeedbackSavedEvent, $mmSite, $mmaModAssignOffline) {
    function getContents(scope, rteEnabled) {
        var draft = $mmaModAssignFeedbackCommentsHandler.getDraft(scope.assign.id, scope.userid);
        if (!draft) {
            return $mmaModAssignOffline.getSubmissionGrade(scope.assign.id, scope.userid).catch(function() {
            }).then(function(offlineData) {
                if (offlineData && offlineData.plugindata && offlineData.plugindata.assignfeedbackcomments_editor) {
                    scope.isSent = false;
                    $mmaModAssignFeedbackCommentsHandler.saveDraft(scope.assign.id, scope.userid,
                        offlineData.plugindata.assignfeedbackcomments_editor);
                    return offlineData.plugindata.assignfeedbackcomments_editor.text;
                }
                scope.isSent = true;
                return $mmaModAssign.getSubmissionPluginText(scope.plugin, scope.edit && !rteEnabled);
            });
        } else {
            scope.isSent = false;
        }
        return $q.when(draft.text);
    }
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/feedback/comments/template.html',
        link: function(scope, element, attributes) {
            var obsSaved;
            if (!scope.plugin) {
                return;
            }
            if (scope.edit) {
                promise = $mmUtil.isRichTextEditorEnabled();
            } else {
                promise = $q.when(false);
            }
            promise.then(function(enabled) {
                rteEnabled = enabled;
                return getContents(scope, rteEnabled);
            }).then(function(text) {
                scope.model = {
                    text: text
                };
                scope.plugin.originalText = text;
                if (!scope.canEdit && !scope.edit) {
                    angular.element(element).on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        if (scope.model.text && scope.model.text != "") {
                            $mmText.expandText(scope.plugin.name, scope.model.text, false, scope.assignComponent,
                                scope.assign.cmid);
                        }
                    });
                }
                if (!scope.edit) {
                    obsSaved = $mmEvents.on(mmaModAssignFeedbackSavedEvent, function(data) {
                        if (scope.plugin.type ==  data.pluginType && scope.assign && data.assignmentId == scope.assign.id &&
                                data.userId == scope.userid && data.siteId == $mmSite.getId()) {
                            return getContents(scope, rteEnabled).then(function(text) {
                                scope.model.text = text;
                            });
                        }
                    });
                    scope.$on('$destroy', function() {
                        obsSaved && obsSaved.off && obsSaved.off();
                    });
                }
                scope.firstRender = function() {
                    scope.plugin.originalText = scope.model.text;
                };
            });
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignFeedbackCommentsHandler', ["$mmText", "$mmSite", "$mmUtil", function($mmText, $mmSite, $mmUtil) {
    var self = {},
        drafts = {};
        self.isEnabled = function() {
        return true;
    };
        self.isEnabledForEdit = function() {
        return true;
    };
        self.getDirectiveName = function() {
        return 'mma-mod-assign-feedback-comments';
    };
        self.prepareFeedbackData = function(assignId, userId, pluginData, siteId) {
        var draft = self.getDraft(assignId, userId, siteId);
        if (draft) {
            return $mmUtil.isRichTextEditorEnabled().then(function(enabled) {
                if (!enabled) {
                    draft.text = $mmText.formatHtmlLines(draft.text);
                }
                pluginData.assignfeedbackcomments_editor = draft;
            });
        }
    };
        self.getFeedbackDataToDraft = function(plugin, inputData) {
        return {
            text: getTextToSubmit(plugin, inputData),
            format: 1
        };
    };
        self.hasDataChanged = function(assign, plugin, inputData) {
        if (typeof plugin.originalText != 'undefined') {
            return plugin.originalText != inputData.assignfeedbackcomments_editor;
        } else {
            return false;
        }
    };
        self.hasDraftData = function(assignId, userId, siteId) {
        var draft = self.getDraft(assignId, userId, siteId);
        if (draft) {
            return true;
        }
        return false;
    };
        function getTextToSubmit(plugin, inputData) {
        var text = inputData.assignfeedbackcomments_editor,
            files = plugin.fileareas && plugin.fileareas[0] ? plugin.fileareas[0].files : [];
        return $mmText.restorePluginfileUrls(text, files);
    }
        self.getDraft = function(assignId, userId, siteId) {
        var id = getDraftId(assignId, userId, siteId);
        if (typeof drafts[id] != 'undefined') {
            return drafts[id];
        }
        return false;
    };
        self.discardDraft = function(assignId, userId, siteId) {
        var id = getDraftId(assignId, userId, siteId);
        if (typeof drafts[id] != 'undefined') {
            delete drafts[id];
        }
    };
        self.saveDraft = function(assignId, userId, data, siteId) {
        if (data) {
            var id = getDraftId(assignId, userId, siteId);
            drafts[id] = data;
        }
    };
        function getDraftId(assignId, userId, siteId) {
        siteId = siteId || $mmSite.getId();
        return siteId + '#' + assignId + '#' + userId;
    }
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignFeedbackDelegate = $mmAddonManager.get('$mmaModAssignFeedbackDelegate');
    if ($mmaModAssignFeedbackDelegate) {
        $mmaModAssignFeedbackDelegate.registerHandler('mmaModAssignFeedbackComments', 'comments',
                '$mmaModAssignFeedbackCommentsHandler');
    }
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignSubmissionFile', ["$mmaModAssign", "$mmaModAssignSubmissionFileSession", "$mmaModAssignHelper", "$mmaModAssignOffline", "mmaModAssignSubmissionFileName", "$mmFileUploaderHelper", "$q", function($mmaModAssign, $mmaModAssignSubmissionFileSession, $mmaModAssignHelper,
            $mmaModAssignOffline, mmaModAssignSubmissionFileName, $mmFileUploaderHelper, $q) {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/submission/file/template.html',
        link: function(scope) {
            if (!scope.plugin) {
                return;
            }
            $mmaModAssignOffline.getSubmission(scope.assign.id).catch(function() {
            }).then(function(offlineData) {
                if (offlineData && offlineData.plugindata && offlineData.plugindata.files_filemanager) {
                    var promise;
                    if (offlineData.plugindata.files_filemanager.offline) {
                        promise = $mmaModAssignHelper.getStoredSubmissionFiles(scope.assign.id, mmaModAssignSubmissionFileName);
                    } else {
                        promise = $q.when([]);
                    }
                    return promise.then(function(offlineFiles) {
                        var onlineFiles = offlineData.plugindata.files_filemanager.online || [];
                        offlineFiles = $mmFileUploaderHelper.markOfflineFiles(offlineFiles);
                        scope.files = onlineFiles.concat(offlineFiles);
                    });
                } else {
                    scope.files = $mmaModAssign.getSubmissionPluginAttachments(scope.plugin);
                }
            }).finally(function() {
                $mmaModAssignSubmissionFileSession.setFiles(scope.assign.id, scope.files);
            });
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.constant('mmaModAssignSubmissionFileName', 'submission_file')
.factory('$mmaModAssignSubmissionFileHandler', ["$mmaModAssignSubmissionFileSession", "$mmaModAssign", "$mmSite", "$q", "$mmaModAssignHelper", "$mmWS", "$mmFS", "$mmFilepool", "$mmUtil", "$mmaModAssignOffline", "mmaModAssignSubmissionFileName", "$mmFileUploaderHelper", function($mmaModAssignSubmissionFileSession, $mmaModAssign, $mmSite, $q,
            $mmaModAssignHelper, $mmWS, $mmFS, $mmFilepool, $mmUtil, $mmaModAssignOffline, mmaModAssignSubmissionFileName,
            $mmFileUploaderHelper) {
    var self = {};
        self.canEditOffline = function(assign, submission, plugin) {
        return true;
    };
        self.clearTmpData = function(assign, submission, plugin, inputData) {
        var files = $mmaModAssignSubmissionFileSession.getFiles(assign.id);
        $mmaModAssignSubmissionFileSession.clearFiles(assign.id);
        $mmFileUploaderHelper.clearTmpFiles(files);
    };
        self.copySubmissionData = function(assign, plugin, pluginData) {
        var files = $mmaModAssign.getSubmissionPluginAttachments(plugin);
        return $mmaModAssignHelper.uploadFiles(assign.id, files).then(function(itemId) {
            pluginData.files_filemanager = itemId;
        });
    };
        self.deleteOfflineData = function(assign, submission, plugin, offlineData, siteId) {
        return $mmaModAssignHelper.deleteStoredSubmissionFiles(assign.id,
                mmaModAssignSubmissionFileName, submission.userid, siteId).catch(function() {
        });
    };
        self.getSizeForCopy = function(assign, plugin) {
        var files = $mmaModAssign.getSubmissionPluginAttachments(plugin),
            totalSize = 0,
            promises = [];
        angular.forEach(files, function(file) {
            promises.push($mmWS.getRemoteFileSize(file.fileurl).then(function(size) {
                if (size == -1) {
                    return $q.reject();
                }
                totalSize += size;
            }));
        });
        return $q.all(promises).then(function() {
            return totalSize;
        });
    };
        self.getSizeForEdit = function(assign, submission, plugin, inputData) {
        var siteId = $mmSite.getId();
        if (self.hasDataChanged(assign, submission, plugin, inputData)) {
            var files = $mmaModAssignSubmissionFileSession.getFiles(assign.id),
                totalSize = 0,
                promises = [];
            angular.forEach(files, function(file) {
                if (file.filename && !file.name) {
                    promises.push($mmFilepool.getFilePathByUrl(siteId, file.fileurl).then(function(path) {
                        return $mmFS.getFile(path).then(function(fileEntry) {
                            return $mmFS.getFileObjectFromFileEntry(fileEntry);
                        }).then(function(file) {
                            totalSize += file.size;
                        });
                    }).catch(function() {
                        return $mmWS.getRemoteFileSize(file.fileurl).then(function(size) {
                            if (size == -1) {
                                return $q.reject();
                            }
                            totalSize += size;
                        });
                    }));
                } else if (file.name) {
                    promises.push($mmFS.getFileObjectFromFileEntry(file).then(function(file) {
                        totalSize += file.size;
                    }));
                }
            });
            return $q.all(promises).then(function() {
                return totalSize;
            });
        } else {
            return 0;
        }
    };
        self.isEnabled = function() {
        return true;
    };
        self.isEnabledForEdit = function() {
        return true;
    };
        self.getDirectiveName = function(plugin, edit) {
        return 'mma-mod-assign-submission-file';
    };
        self.getPluginFiles = function(assign, submission, plugin, siteId) {
        return $mmaModAssign.getSubmissionPluginAttachments(plugin);
    };
        self.hasDataChanged = function(assign, submission, plugin, inputData) {
        return $mmaModAssignOffline.getSubmission(assign.id, submission.userid).catch(function() {
        }).then(function(offlineData) {
            if (offlineData && offlineData.plugindata && offlineData.plugindata.files_filemanager) {
                return offlineData.plugindata.files_filemanager.offline + offlineData.plugindata.files_filemanager.online.length;
            }
            var pluginFiles = $mmaModAssign.getSubmissionPluginAttachments(plugin);
            return pluginFiles && pluginFiles.length;
        }).then(function(numFiles) {
            var currentFiles = $mmaModAssignSubmissionFileSession.getFiles(assign.id);
            if (currentFiles.length != numFiles) {
                return true;
            }
            for (var i = 0; i < currentFiles.length; i++) {
                var file = currentFiles[i];
                if (!file.filename && typeof file.name != 'undefined' && !file.offline) {
                    return true;
                }
            }
            return false;
        });
    };
        self.prepareSubmissionData = function(assign, submission, plugin, inputData, pluginData, offline, userId, siteId) {
        siteId = siteId || $mmSite.getId();
        if (self.hasDataChanged(assign, submission, plugin, inputData)) {
            var currentFiles = $mmaModAssignSubmissionFileSession.getFiles(assign.id),
                error = $mmUtil.hasRepeatedFilenames(currentFiles);
            if (error) {
                return $q.reject(error);
            }
            return $mmaModAssignHelper.uploadOrStoreFiles(assign.id, mmaModAssignSubmissionFileName,
                        currentFiles, offline, userId, siteId).then(function(result) {
                pluginData.files_filemanager = result;
            });
        }
    };
        self.prepareSyncData = function(assign, submission, plugin, offlineData, pluginData, siteId) {
        var filesData = offlineData && offlineData.plugindata && offlineData.plugindata.files_filemanager;
        if (filesData) {
            var files = filesData.online || [],
                promise;
            if (filesData.offline) {
                promise = $mmaModAssignHelper.getStoredSubmissionFiles(assign.id,
                            mmaModAssignSubmissionFileName, submission.userid, siteId).then(function(result) {
                    files = files.concat(result);
                }).catch(function() {
                });
            } else {
                promise = $q.when();
            }
            return promise.then(function() {
                return $mmaModAssignHelper.uploadFiles(assign.id, files, siteId).then(function(itemId) {
                    pluginData.files_filemanager = itemId;
                });
            });
        }
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignSubmissionDelegate = $mmAddonManager.get('$mmaModAssignSubmissionDelegate');
    if ($mmaModAssignSubmissionDelegate) {
        $mmaModAssignSubmissionDelegate.registerHandler('mmaModAssignSubmissionFile', 'file',
                                '$mmaModAssignSubmissionFileHandler');
    }
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignSubmissionFileSession', ["$mmSite", function($mmSite) {
    var self = {},
        files = {};
        self.addFile = function(assignmentId, file, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!files[siteId]) {
            files[siteId] = {};
        }
        if (!files[siteId][assignmentId]) {
            files[siteId][assignmentId] = [];
        }
        files[siteId][assignmentId].push(file);
    };
        self.clearFiles = function(assignmentId, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][assignmentId]) {
            files[siteId][assignmentId] = [];
        }
    };
        self.getFiles = function(assignmentId, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][assignmentId]) {
            return files[siteId][assignmentId];
        }
        return [];
    };
        self.removeFile = function(assignmentId, file, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][assignmentId]) {
            var position = files[siteId][assignmentId].indexOf(file);
            if (position != -1) {
                files[siteId][assignmentId].splice(position, 1);
            }
        }
    };
        self.removeFileByIndex = function(assignmentId, index, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][assignmentId] && index >= 0 && index < files[siteId][assignmentId].length) {
            files[siteId][assignmentId].splice(index, 1);
        }
    };
        self.setFiles = function(assignmentId, newFiles, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!files[siteId]) {
            files[siteId] = {};
        }
        files[siteId][assignmentId] = newFiles;
    };
    return self;
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignSubmissionComments', ["$state", "$mmComments", "mmaModAssignSubmissionInvalidatedEvent", function($state, $mmComments, mmaModAssignSubmissionInvalidatedEvent) {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/submission/comments/template.html',
        link: function(scope) {
            scope.showComments = function() {
                var params = {
                    contextLevel: 'module',
                    instanceId: scope.cmid,
                    component: 'assignsubmission_comments',
                    itemId: scope.submissionId,
                    area: 'submission_comments',
                    title: scope.plugin.name
                };
                $state.go('site.mm_commentviewer', params);
            };
            scope.submissionId = scope.submission.id;
            scope.cmid = scope.assign.cmid;
            var obsLoaded = scope.$on(mmaModAssignSubmissionInvalidatedEvent, function() {
                $mmComments.invalidateCommentsData('module', scope.cmid, 'assignsubmission_comments', scope.submissionId,
                    'submission_comments');
            });
            scope.$on('$destroy', obsLoaded);
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignSubmissionCommentsHandler', ["$mmComments", function($mmComments) {
    var self = {};
        self.canEditOffline = function(assign, submission, plugin) {
        return true;
    };
        self.isEnabled = function() {
        return $mmComments.isPluginEnabled();
    };
        self.isEnabledForEdit = function() {
        return true;
    };
        self.getDirectiveName = function(plugin, edit) {
        return edit ? false : 'mma-mod-assign-submission-comments';
    };
        self.prefetch = function(assign, submission, plugin, siteId) {
        return $mmComments.getComments('module', assign.cmid, 'assignsubmission_comments', submission.id,
                    'submission_comments', 0, siteId).catch(function() {
        });
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignSubmissionDelegate = $mmAddonManager.get('$mmaModAssignSubmissionDelegate');
    if ($mmaModAssignSubmissionDelegate) {
        $mmaModAssignSubmissionDelegate.registerHandler('mmaModAssignSubmissionComments', 'comments',
                                '$mmaModAssignSubmissionCommentsHandler');
    }
}]);

angular.module('mm.addons.mod_assign')
.directive('mmaModAssignSubmissionOnlinetext', ["$mmaModAssign", "$mmText", "$timeout", "$q", "$mmUtil", "$mmaModAssignOffline", function($mmaModAssign, $mmText, $timeout, $q, $mmUtil, $mmaModAssignOffline) {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/assign/submission/onlinetext/template.html',
        link: function(scope, element) {
            var wordCountTimeout,
                promise,
                rteEnabled;
            if (!scope.plugin) {
                return;
            }
            if (scope.edit) {
                promise = $mmUtil.isRichTextEditorEnabled();
            } else {
                promise = $q.when(false);
            }
            promise.then(function(enabled) {
                rteEnabled = enabled;
                return $mmaModAssignOffline.getSubmission(scope.assign.id).catch(function() {
                }).then(function(offlineData) {
                    if (offlineData && offlineData.plugindata && offlineData.plugindata.onlinetext_editor) {
                        return offlineData.plugindata.onlinetext_editor.text;
                    }
                    return $mmaModAssign.getSubmissionPluginText(scope.plugin, scope.edit && !rteEnabled);
                });
            }).then(function(text) {
                scope.configs.wordlimit = parseInt(scope.configs.wordlimit, 10);
                scope.configs.wordlimitenabled = parseInt(scope.configs.wordlimitenabled, 10);
                scope.model = {
                    text: text
                };
                if (rteEnabled) {
                    scope.plugin.rteInitialText = text;
                }
                if (!scope.edit) {
                    angular.element(element).on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        if (text) {
                            $mmText.expandText(scope.plugin.name, text, false, scope.assignComponent, scope.assign.cmid);
                        }
                    });
                }
                scope.onChange = function() {
                    if (scope.configs.wordlimitenabled) {
                        $timeout.cancel(wordCountTimeout);
                        wordCountTimeout = $timeout(function() {
                            scope.words = $mmText.countWords(scope.model.text);
                        }, 1500);
                    }
                };
                scope.firstRender = function() {
                    scope.plugin.rteInitialText = scope.model.text;
                    if (scope.configs.wordlimitenabled) {
                        scope.words = $mmText.countWords(scope.model.text);
                    }
                };
                if (!rteEnabled && scope.configs.wordlimitenabled) {
                    scope.words = $mmText.countWords(scope.model.text);
                }
            });
        }
    };
}]);

angular.module('mm.addons.mod_assign')
.factory('$mmaModAssignSubmissionOnlinetextHandler', ["$mmSite", "$mmaModAssign", "$q", "$mmaModAssignHelper", "$mmWS", "$mmText", "$mmaModAssignOffline", "$mmUtil", function($mmSite, $mmaModAssign, $q, $mmaModAssignHelper, $mmWS, $mmText,
            $mmaModAssignOffline, $mmUtil) {
    var self = {};
        self.canEditOffline = function(assign, submission, plugin) {
        return false;
    };
        self.copySubmissionData = function(assign, plugin, pluginData) {
        var text = $mmaModAssign.getSubmissionPluginText(plugin, true),
            files = $mmaModAssign.getSubmissionPluginAttachments(plugin),
            promise;
        if (!files.length) {
            promise = $q.when(0);
        } else {
            promise = $mmaModAssignHelper.uploadFiles(assign.id, files);
        }
        return promise.then(function(itemId) {
            pluginData.onlinetext_editor = {
                text: text,
                format: 1,
                itemid: itemId
            };
        });
    };
        self.getPluginFiles = function(assign, submission, plugin, siteId) {
        return $mmaModAssign.getSubmissionPluginAttachments(plugin);
    };
        self.getSizeForCopy = function(assign, plugin) {
        var text = $mmaModAssign.getSubmissionPluginText(plugin, true),
            files = $mmaModAssign.getSubmissionPluginAttachments(plugin),
            totalSize = text.length,
            promises;
        if (!files.length) {
            return totalSize;
        }
        promises = [];
        angular.forEach(files, function(file) {
            promises.push($mmWS.getRemoteFileSize(file.fileurl).then(function(size) {
                if (size == -1) {
                    return $q.reject();
                }
                totalSize += size;
            }));
        });
        return $q.all(promises).then(function() {
            return totalSize;
        });
    };
        self.getSizeForEdit = function(assign, submission, plugin, inputData) {
        var text = $mmaModAssign.getSubmissionPluginText(plugin, true);
        return text.length;
    };
        self.isEnabled = function() {
        return true;
    };
        self.isEnabledForEdit = function() {
        return $mmSite.isVersionGreaterEqualThan('3.1.1') || $mmSite.checkIfAppUsesLocalMobile();
    };
        self.getDirectiveName = function(plugin, edit) {
        return 'mma-mod-assign-submission-onlinetext';
    };
        self.prepareSubmissionData = function(assign, submission, plugin, inputData, pluginData, offline, userId, siteId) {
        return $mmUtil.isRichTextEditorEnabled().then(function(enabled) {
            var text = getTextToSubmit(plugin, inputData);
            if (!enabled) {
                text = $mmText.formatHtmlLines(text);
            }
            pluginData.onlinetext_editor = {
                text: text,
                format: 1,
                itemid: 0
            };
        });
    };
        self.hasDataChanged = function(assign, submission, plugin, inputData) {
        if (typeof plugin.rteInitialText != 'undefined') {
            return plugin.rteInitialText != inputData.onlinetext_editor_text;
        } else {
            return $mmaModAssignOffline.getSubmission(assign.id, submission.userid).catch(function() {
            }).then(function(data) {
                if (data && data.plugindata && data.plugindata.onlinetext_editor) {
                    return data.plugindata.onlinetext_editor.text;
                }
                return plugin.editorfields && plugin.editorfields[0] ? plugin.editorfields[0].text : '';
            }).then(function(initialText) {
                return initialText != getTextToSubmit(plugin, inputData);
            });
        }
    };
        function getTextToSubmit(plugin, inputData) {
        var text = inputData.onlinetext_editor_text,
            files = plugin.fileareas && plugin.fileareas[0] ? plugin.fileareas[0].files : [];
        return $mmText.restorePluginfileUrls(text, files);
    }
        self.prepareSyncData = function(assign, submission, plugin, offlineData, pluginData, siteId) {
        var textData = offlineData && offlineData.plugindata && offlineData.plugindata.onlinetext_editor;
        if (textData) {
            pluginData.onlinetext_editor = textData;
        }
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModAssignSubmissionDelegate = $mmAddonManager.get('$mmaModAssignSubmissionDelegate');
    if ($mmaModAssignSubmissionDelegate) {
        $mmaModAssignSubmissionDelegate.registerHandler('mmaModAssignSubmissionOnlinetext', 'onlinetext',
                                '$mmaModAssignSubmissionOnlinetextHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessIpAddressHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessIpAddress', 'quizaccess_ipaddress',
                                '$mmaQuizAccessIpAddressHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessNumAttemptsHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessNumAttempts', 'quizaccess_numattempts',
                                '$mmaQuizAccessNumAttemptsHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessDelayBetweenAttemptsHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessDelayBetweenAttempts', 'quizaccess_delaybetweenattempts',
                                '$mmaQuizAccessDelayBetweenAttemptsHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.directive('mmaQuizAccessOfflineAttemptsPreflight', function() {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/quiz/accessrules/offlineattempts/template.html'
    };
});

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessOfflineAttemptsHandler', ["mmaModQuizSyncTime", function(mmaModQuizSyncTime) {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        if (prefetch) {
            return false;
        }
        if (!attempt) {
            return true;
        }
        return new Date().getTime() - mmaModQuizSyncTime > attempt.quizSyncTime;
    };
        self.getFixedPreflightData = function(quiz, attempt, preflightData, prefetch, siteId) {
        preflightData.confirmdatasaved = 1;
    };
        self.getPreflightDirectiveName = function() {
        return 'mma-quiz-access-offline-attempts-preflight';
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessOfflineAttempts', 'quizaccess_offlineattempts',
                                '$mmaQuizAccessOfflineAttemptsHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessOpenCloseDateHandler', ["$mmaModQuiz", function($mmaModQuiz) {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
        self.shouldShowTimeLeft = function(attempt, endTime, timeNow) {
        if (attempt.preview && timeNow > endTime) {
            return false;
        }
        if (timeNow > endTime - $mmaModQuiz.QUIZ_SHOW_TIME_BEFORE_DEADLINE) {
            return true;
        }
        return false;
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessOpenCloseDate', 'quizaccess_openclosedate',
                                '$mmaQuizAccessOpenCloseDateHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.directive('mmaQuizAccessPasswordPreflight', function() {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/quiz/accessrules/password/template.html'
    };
});

angular.module('mm.addons.mod_quiz')
.constant('mmaModQuizAccessPasswordStore', 'mod_quiz_access_password')
.config(["$mmSitesFactoryProvider", "mmaModQuizAccessPasswordStore", function($mmSitesFactoryProvider, mmaModQuizAccessPasswordStore) {
    var stores = [
        {
            name: mmaModQuizAccessPasswordStore,
            keyPath: 'id',
            indexes: []
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmaQuizAccessPasswordHandler', ["$mmSitesManager", "$mmSite", "$q", "mmaModQuizAccessPasswordStore", function($mmSitesManager, $mmSite, $q, mmaModQuizAccessPasswordStore) {
    var self = {};
        self.cleanPreflight = function(data) {
        delete data.quizpassword;
    };
        function getPasswordEntry(quizId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmaModQuizAccessPasswordStore, quizId);
        });
    }
        function removePassword(quizId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().remove(mmaModQuizAccessPasswordStore, quizId);
        });
    }
        function storePassword(quizId, password, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var entry = {
                id: quizId,
                password: password,
                timemodified: new Date().getTime()
            };
            return site.getDb().insert(mmaModQuizAccessPasswordStore, entry);
        });
    }
        self.getFixedPreflightData = function(quiz, attempt, preflightData, prefetch, siteId) {
        if (quiz && quiz.id && typeof preflightData.quizpassword == 'undefined') {
            return getPasswordEntry(quiz.id, siteId).then(function(entry) {
                preflightData.quizpassword = entry.password;
            }).catch(function() {
            });
        }
        return $q.when();
    };
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return getPasswordEntry(quiz.id, siteId).then(function() {
            return false;
        }).catch(function() {
            return true;
        });
    };
        self.getPreflightDirectiveName = function() {
        return 'mma-quiz-access-password-preflight';
    };
        self.notifyPreflightCheckPassed = function(quiz, attempt, preflightData, prefetch, siteId) {
        if (quiz && quiz.id && typeof preflightData.quizpassword != 'undefined') {
            return storePassword(quiz.id, preflightData.quizpassword, siteId);
        }
        return $q.when();
    };
        self.notifyPreflightCheckFailed = function(quiz, attempt, preflightData, prefetch, siteId) {
        if (quiz && quiz.id) {
            return removePassword(quiz.id, siteId);
        }
        return $q.when();
    };
    return self;
}])
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessPassword', 'quizaccess_password',
                                '$mmaQuizAccessPasswordHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessSafeBrowserHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessSafeBrowser', 'quizaccess_safebrowser',
                                '$mmaQuizAccessSafeBrowserHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessSecureWindowHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return false;
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessSecureWindow', 'quizaccess_securewindow',
                                '$mmaQuizAccessSecureWindowHandler');
    }
}]);

angular.module('mm.addons.mod_quiz')
.directive('mmaQuizAccessTimeLimitPreflight', function() {
    return {
        restrict: 'A',
        priority: 100,
        templateUrl: 'addons/mod/quiz/accessrules/timelimit/template.html'
    };
});

angular.module('mm.addons.mod_quiz')
.factory('$mmaQuizAccessTimeLimitHandler', function() {
    var self = {};
        self.isEnabled = function() {
        return true;
    };
        self.isPreflightCheckRequired = function(quiz, attempt, prefetch, siteId) {
        return !attempt;
    };
        self.getPreflightDirectiveName = function() {
        return 'mma-quiz-access-time-limit-preflight';
    };
        self.shouldShowTimeLeft = function(attempt, endTime, timeNow) {
        return !(attempt.preview && timeNow > endTime);
    };
    return self;
})
.run(["$mmAddonManager", function($mmAddonManager) {
    var $mmaModQuizAccessRulesDelegate = $mmAddonManager.get('$mmaModQuizAccessRulesDelegate');
    if ($mmaModQuizAccessRulesDelegate) {
        $mmaModQuizAccessRulesDelegate.registerHandler('mmaQuizAccessTimeLimit', 'quizaccess_timelimit',
                                '$mmaQuizAccessTimeLimitHandler');
    }
}]);

angular.module('mm.addons.badges')
.controller('mmaBadgesIssuedCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmaBadges", "$mmSite", "$q", "$mmCourses", "$mmUser", function($scope, $stateParams, $mmUtil, $mmaBadges, $mmSite, $q, $mmCourses, $mmUser) {
    $scope.courseId = $stateParams.cid;
    $scope.userId = $stateParams.uid || $mmSite.getUserId();
    var uniqueHash = $stateParams.uniquehash;
    function fetchIssuedBadge() {
        var promises = [],
            promise;
        promise = $mmUser.getProfile($scope.userId, $scope.courseId, true).then(function(user) {
            $scope.user = user;
        });
        promises.push(promise);
        promise = $mmaBadges.getUserBadges($scope.courseId, $scope.userId).then(function(badges) {
            angular.forEach(badges, function(badge) {
                if (uniqueHash == badge.uniquehash) {
                    $scope.badge = badge;
                    if (badge.courseid) {
                        return $mmCourses.getUserCourse(badge.courseid, true).then(function(course) {
                            $scope.course = course;
                        }).catch(function() {
                            $scope.course = null;
                        });
                    }
                }
            });
        }).catch(function(message) {
            if (message) {
                $mmUtil.showErrorModal(message);
            } else {
                $mmUtil.showErrorModal('Error getting badge data.');
            }
            return $q.reject();
        });
        promises.push(promise);
        return $q.all(promises);
    }
    fetchIssuedBadge().finally(function() {
        $scope.badgeLoaded = true;
    });
    $scope.refreshBadges = function() {
        $mmaBadges.invalidateUserBadges($scope.courseId, $scope.userId).finally(function() {
            fetchIssuedBadge().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.addons.badges')
.controller('mmaBadgesUserCtrl', ["$scope", "$mmaBadges", "$mmUtil", "$stateParams", "$q", "$mmSite", function($scope, $mmaBadges, $mmUtil, $stateParams, $q, $mmSite) {
    $scope.courseId = $stateParams.courseid;
    $scope.userId = $stateParams.userid || $mmSite.getUserId();
    function fetchBadges() {
        return $mmaBadges.getUserBadges($scope.courseId, $scope.userId).then(function(badges) {
            $scope.badges = badges;
        }).catch(function(message) {
            if (message) {
                $mmUtil.showErrorModal(message);
            } else {
                $mmUtil.showErrorModal('Error getting badges data.');
            }
            return $q.reject();
        });
    }
    fetchBadges().finally(function() {
        $scope.badgesLoaded = true;
    });
    $scope.refreshBadges = function() {
        $mmaBadges.invalidateUserBadges($scope.courseId, $scope.userId).finally(function() {
            fetchBadges().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.addons.badges')
.factory('$mmaBadges', ["$log", "$mmSitesManager", function($log, $mmSitesManager) {
    $log = $log.getInstance('$mmaBadges');
    var self = {};
        self.isPluginEnabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (!site.canUseAdvancedFeature('enablebadges')) {
                return false;
            } else if (!site.wsAvailable('core_badges_get_user_badges') || !site.wsAvailable('core_course_get_user_navigation_options')) {
                return false;
            }
            return true;
        });
    };
        function getBadgesCacheKey(courseId, userId) {
        return 'mmaBadges:badges:' + courseId + ':' + userId;
    }
        self.getUserBadges = function(courseId, userId, siteId) {
        $log.debug('Get badges for course ' + courseId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var data = {
                    courseid : courseId,
                    userid : userId
                },
                presets = {
                    cacheKey: getBadgesCacheKey(courseId, userId)
                };
            return site.read('core_badges_get_user_badges', data, presets).then(function(response) {
                if (response && response.badges) {
                    return response.badges;
                } else {
                    return $q.reject();
                }
            });
        });
    };
        self.invalidateUserBadges = function(courseId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getBadgesCacheKey(courseId, userId));
        });
    };
    return self;
}]);

angular.module('mm.addons.badges')
.factory('$mmaBadgesHandlers', ["$mmaBadges", "$mmContentLinksHelper", "mmUserProfileHandlersTypeNewPage", "$mmContentLinkHandlerFactory", function($mmaBadges, $mmContentLinksHelper, mmUserProfileHandlersTypeNewPage,
            $mmContentLinkHandlerFactory) {
    var self = {};
        self.userProfile = function() {
        var self = {
            type: mmUserProfileHandlersTypeNewPage
        };
                self.isEnabled = function() {
            return $mmaBadges.isPluginEnabled();
        };
                self.isEnabledForUser = function(user, courseId, navOptions, admOptions) {
            if (navOptions && typeof navOptions.badges != 'undefined') {
                return navOptions.badges;
            }
            return false;
        };
                self.getController = function(user, courseId) {
                        return function($scope, $state) {
                $scope.icon = 'ion-trophy';
                $scope.title = 'mma.badges.badges';
                $scope.action = function($event) {
                    $event.preventDefault();
                    $event.stopPropagation();
                    $state.go('site.userbadges', {
                        courseid: courseId,
                        userid: user.id
                    });
                };
            };
        };
        return self;
    };
        self.myBadgesLinksHandler = $mmContentLinkHandlerFactory.createChild('/badges/mybadges.php', '$mmUserDelegate_mmaBadges');
    self.myBadgesLinksHandler.isEnabled = $mmaBadges.isPluginEnabled;
    self.myBadgesLinksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                var stateParams = {
                    courseid: 0
                };
                $mmContentLinksHelper.goInSite('site.userbadges', stateParams, siteId);
            }
        }];
    };
        self.badgeLinksHandler = $mmContentLinkHandlerFactory.createChild(/\/badges\/badge\.php.*([\?\&]hash=)/);
    self.badgeLinksHandler.isEnabled = $mmaBadges.isPluginEnabled;
    self.badgeLinksHandler.getActions = function(siteIds, url, params) {
        return [{
            action: function(siteId) {
                var stateParams = {
                    cid: 0,
                    uniquehash: params.hash
                };
                $mmContentLinksHelper.goInSite('site.issuedbadge', stateParams, siteId);
            }
        }];
    };
    return self;
}]);

angular.module('mm.addons.calendar')
.controller('mmaCalendarEventCtrl', ["$scope", "$log", "$stateParams", "$mmaCalendar", "$mmUtil", "$mmCourse", "$mmCourses", "$translate", "$mmLocalNotifications", function($scope, $log, $stateParams, $mmaCalendar, $mmUtil, $mmCourse, $mmCourses, $translate,
        $mmLocalNotifications) {
    $log = $log.getInstance('mmaCalendarEventCtrl');
    var eventid = parseInt($stateParams.id);
    function fetchEvent(refresh) {
        return $mmaCalendar.getEvent(eventid, refresh).then(function(e) {
            $mmaCalendar.formatEventData(e);
            $scope.event = e;
            $scope.title = e.name;
            if (e.moduleicon) {
                var name = $mmCourse.translateModuleName(e.modulename);
                if (name.indexOf('mm.core.mod') === -1) {
                    e.modulename = name;
                }
            }
            if (e.courseid > 1) {
                $mmCourses.getUserCourse(e.courseid, true).then(function(course) {
                    $scope.coursename = course.fullname;
                });
            }
        }, function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mma.calendar.errorloadevent', true);
            }
        });
    }
    fetchEvent().finally(function() {
        $scope.eventLoaded = true;
    });
    $scope.refreshEvent = function() {
        fetchEvent(true).finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.notificationsEnabled = $mmLocalNotifications.isAvailable();
    if ($scope.notificationsEnabled) {
        $mmaCalendar.getEventNotificationTimeOption(eventid).then(function(notificationtime) {
            $scope.notification = {
                time: String(notificationtime)
            };
        });
        $mmaCalendar.getDefaultNotificationTime().then(function(defaultTime) {
            if (defaultTime === 0) {
                $scope.defaultTimeReadable = $translate.instant('mm.settings.disabled');
            } else {
                $scope.defaultTimeReadable = moment.duration(defaultTime * 60 * 1000).humanize();
            }
        });
        $scope.updateNotificationTime = function() {
            var time = parseInt($scope.notification.time, 10);
            if (!isNaN(time) && $scope.event && $scope.event.id) {
                $mmaCalendar.updateNotificationTime($scope.event, time);
            }
        };
    }
}]);

angular.module('mm.addons.calendar')
.controller('mmaCalendarListCtrl', ["$scope", "$stateParams", "$log", "$state", "$mmaCalendar", "$mmUtil", "$ionicHistory", "$mmEvents", "mmaCalendarDaysInterval", "$ionicScrollDelegate", "$mmLocalNotifications", "$mmCourses", "mmaCalendarDefaultNotifTimeChangedEvent", "$ionicPopover", "$q", "$translate", function($scope, $stateParams, $log, $state, $mmaCalendar, $mmUtil, $ionicHistory, $mmEvents,
        mmaCalendarDaysInterval, $ionicScrollDelegate, $mmLocalNotifications, $mmCourses, mmaCalendarDefaultNotifTimeChangedEvent,
        $ionicPopover, $q, $translate) {
    $log = $log.getInstance('mmaCalendarListCtrl');
    var daysLoaded,
        emptyEventsTimes,
        scrollView = $ionicScrollDelegate.$getByHandle('mmaCalendarEventsListScroll'),
        obsDefaultTimeChange,
        popover,
        allCourses = {
            id: -1,
            fullname: $translate.instant('mm.core.fulllistofcourses')
        };
    if ($stateParams.eventid) {
        $ionicHistory.clearHistory();
        $state.go('site.calendar-event', {id: $stateParams.eventid});
    }
    function initVars() {
        daysLoaded = 0;
        emptyEventsTimes = 0;
        $scope.events = [];
    }
    function fetchData(refresh) {
        initVars();
        return loadCourses().then(function() {
            return fetchEvents(refresh);
        });
    }
    function fetchEvents(refresh) {
        return $mmaCalendar.getEvents(daysLoaded, mmaCalendarDaysInterval, refresh).then(function(events) {
            daysLoaded += mmaCalendarDaysInterval;
            if (events.length === 0) {
                emptyEventsTimes++;
                if (emptyEventsTimes > 5) {
                    $scope.canLoadMore = false;
                    $scope.eventsLoaded = true;
                } else {
                    return fetchEvents();
                }
            } else {
                angular.forEach(events, $mmaCalendar.formatEventData);
                if (refresh) {
                    $scope.events = events;
                } else {
                    $scope.events = $scope.events.concat(events);
                }
                $scope.eventsLoaded = true;
                $scope.canLoadMore = true;
                $mmaCalendar.scheduleEventsNotifications(events);
            }
            scrollView.resize();
        }, function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mma.calendar.errorloadevents', true);
            }
            $scope.eventsLoaded = true;
            $scope.canLoadMore = false;
        });
    }
    function loadCourses() {
        return $mmCourses.getUserCourses(false).then(function(courses) {
            courses.unshift(allCourses);
            $scope.courses = courses;
        });
    }
    $scope.filter = {
        courseid: -1,
    };
    $scope.notificationsEnabled = $mmLocalNotifications.isAvailable();
    fetchData();
    $ionicPopover.fromTemplateUrl('addons/calendar/templates/course_picker.html', {
        scope: $scope
    }).then(function(po) {
        popover = po;
        $scope.pickCourse = function(event) {
            popover.show(event);
        };
        $scope.coursePicked = function() {
            popover.hide();
            scrollView.scrollTop();
        };
    });
    $scope.loadMoreEvents = function() {
        fetchEvents().finally(function() {
            $scope.$broadcast('scroll.infiniteScrollComplete');
        });
    };
    $scope.refreshEvents = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmaCalendar.invalidateEventsList());
        return $q.all(promises).finally(function() {
            fetchData(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    $scope.openSettings = function() {
        $state.go('site.calendar-settings');
    };
    $scope.filterEvent = function(event) {
        if ($scope.filter.courseid == -1) {
            return true;
        }
        return event.courseid === 1 || event.courseid == $scope.filter.courseid;
    };
    if ($scope.notificationsEnabled) {
        obsDefaultTimeChange = $mmEvents.on(mmaCalendarDefaultNotifTimeChangedEvent, function() {
            $mmaCalendar.scheduleEventsNotifications($scope.events);
        });
    }
    $scope.$on('$destroy', function() {
        obsDefaultTimeChange && obsDefaultTimeChange.off && obsDefaultTimeChange.off();
        popover && popover.remove();
    });
}]);

angular.module('mm.addons.calendar')
.controller('mmaCalendarSettingsCtrl', ["$scope", "$mmaCalendar", "$mmEvents", "$mmSite", "mmaCalendarDefaultNotifTimeChangedEvent", function($scope, $mmaCalendar, $mmEvents, $mmSite,
            mmaCalendarDefaultNotifTimeChangedEvent) {
    $mmaCalendar.getDefaultNotificationTime().then(function(time) {
        $scope.defaultTime = String(time);
    });
    $scope.updateDefaultTime = function(newTime) {
        $mmaCalendar.setDefaultNotificationTime(newTime);
        $mmEvents.trigger(mmaCalendarDefaultNotifTimeChangedEvent, {siteid: $mmSite.getId(), time: newTime});
    };
}]);

angular.module('mm.addons.calendar')
.constant('mmaCalendarEventsStore', 'calendar_events')
.config(["$mmSitesFactoryProvider", "mmaCalendarEventsStore", function($mmSitesFactoryProvider, mmaCalendarEventsStore) {
    var stores = [
        {
            name: mmaCalendarEventsStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'notificationtime'
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmaCalendar', ["$log", "$q", "$mmSite", "$mmUtil", "$mmCourses", "$mmGroups", "$mmCourse", "$mmLocalNotifications", "$mmSitesManager", "mmCoreSecondsDay", "mmaCalendarDaysInterval", "mmaCalendarEventsStore", "mmaCalendarDefaultNotifTime", "mmaCalendarComponent", "mmaCalendarDefaultNotifTimeSetting", "$mmConfig", function($log, $q, $mmSite, $mmUtil, $mmCourses, $mmGroups, $mmCourse, $mmLocalNotifications,
        $mmSitesManager, mmCoreSecondsDay, mmaCalendarDaysInterval, mmaCalendarEventsStore, mmaCalendarDefaultNotifTime,
        mmaCalendarComponent, mmaCalendarDefaultNotifTimeSetting, $mmConfig) {
    $log = $log.getInstance('$mmaCalendar');
    var self = {},
        calendarImgPath = 'addons/calendar/img/',
        eventicons = {
            'course': calendarImgPath + 'courseevent.svg',
            'group': calendarImgPath + 'groupevent.svg',
            'site': calendarImgPath + 'siteevent.svg',
            'user': calendarImgPath + 'userevent.svg'
        };
        function getEventsListCacheKey(daysToStart, daysInterval) {
        return 'mmaCalendar:events:' + daysToStart + ':' + daysInterval;
    }
        function getEventCacheKey(id) {
        return 'mmaCalendar:events:' + id;
    }
        function getEventsCommonCacheKey() {
        return 'mmaCalendar:events:';
    }
        function storeEventsInLocalDB(events, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [],
                db = site.getDb();
            angular.forEach(events, function(event) {
                promises.push(self.getEventFromLocalDb(event.id, siteId).catch(function() {
                    return {};
                }).then(function(e) {
                    if (typeof e.notificationtime != 'undefined') {
                        event.notificationtime = e.notificationtime;
                    }
                    return db.insert(mmaCalendarEventsStore, event);
                }));
            });
            return $q.all(promises);
        });
    }
        self.formatEventData = function(e) {
        var icon = self.getEventIcon(e.eventtype);
        if (icon === '') {
            icon = $mmCourse.getModuleIconSrc(e.modulename);
            e.moduleicon = icon;
        }
        e.icon = icon;
    };
        self.getAllEventsFromLocalDb = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().getAll(mmaCalendarEventsStore);
        });
    };
        self.getDefaultNotificationTime = function(siteId) {
        siteId = siteId || $mmSite.getId();
        var key = mmaCalendarDefaultNotifTimeSetting + '#' + siteId;
        return $mmConfig.get(key, mmaCalendarDefaultNotifTime);
    };
        self.getEvent = function(id, refresh) {
        var presets = {},
            data = {
                "options[userevents]": 0,
                "options[siteevents]": 0,
                "events[eventids][0]": id
            };
        presets.cacheKey = getEventCacheKey(id);
        if (refresh) {
            presets.getFromCache = false;
        }
        return $mmSite.read('core_calendar_get_calendar_events', data, presets).then(function(response) {
            var e = response.events[0];
            if (e) {
                return e;
            } else {
                return self.getEventFromLocalDb(id);
            }
        }, function() {
            return self.getEventFromLocalDb(id);
        });
    };
        self.getEventFromLocalDb = function(id, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmaCalendarEventsStore, id);
        });
    };
        self.getEventIcon = function(type) {
        return eventicons[type] || '';
    };
        self.getEventNotificationTime = function(id, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getEventNotificationTimeOption(id, siteId).then(function(time) {
            if (time == -1) {
                return self.getDefaultNotificationTime(siteId);
            }
            return time;
        });
    };
        self.getEventNotificationTimeOption = function(id, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getEventFromLocalDb(id, siteId).then(function(e) {
            if (typeof e.notificationtime != 'undefined') {
                return e.notificationtime;
            }
            return -1;
        }, function() {
            return -1;
        });
    };
        self.getEvents = function(daysToStart, daysInterval, refresh, siteId) {
        daysToStart = daysToStart || 0;
        daysInterval = daysInterval || mmaCalendarDaysInterval;
        siteId = siteId || $mmSite.getId();
         var now = $mmUtil.timestamp(),
            start = now + (mmCoreSecondsDay * daysToStart),
            end = start + (mmCoreSecondsDay * daysInterval);
        var data = {
            "options[userevents]": 1,
            "options[siteevents]": 1,
            "options[timestart]": start,
            "options[timeend]": end
        };
        return $mmCourses.getUserCourses(false, siteId).then(function(courses) {
            courses.push({id: 1});
            angular.forEach(courses, function(course, index) {
                data["events[courseids][" + index + "]"] = course.id;
            });
            return $mmGroups.getUserGroups(courses, refresh, siteId).then(function(groups) {
                angular.forEach(groups, function(group, index) {
                    data["events[groupids][" + index + "]"] = group.id;
                });
                return $mmSitesManager.getSite(siteId).then(function(site) {
                    var preSets = {
                        cacheKey: getEventsListCacheKey(daysToStart, daysInterval),
                        getCacheUsingCacheKey: true
                    };
                    return site.read('core_calendar_get_calendar_events', data, preSets).then(function(response) {
                        storeEventsInLocalDB(response.events, siteId);
                        return response.events;
                    });
                });
            });
        });
    };
        self.invalidateEventsList = function() {
        var p1 = $mmCourses.invalidateUserCourses(),
            p2 = $mmSite.invalidateWsCacheForKeyStartingWith(getEventsCommonCacheKey());
        return $q.all([p1, p2]);
    };
        self.isAvailable = function() {
        return $mmSite.wsAvailable('core_calendar_get_calendar_events');
    };
        self.isDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isDisabledInSite(site);
        });
    };
        self.isDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmSideMenuDelegate_mmaCalendar');
    };
        self.scheduleAllSitesEventsNotifications = function() {
        if ($mmLocalNotifications.isAvailable()) {
            return $mmSitesManager.getSitesIds().then(function(siteIds) {
                var promises = [];
                angular.forEach(siteIds, function(siteId) {
                    promises.push(self.isDisabled(siteId).then(function(disabled) {
                        if (!disabled) {
                            return self.getEvents(undefined, undefined, false, siteId).then(function(events) {
                                return self.scheduleEventsNotifications(events, siteId);
                            });
                        }
                    }));
                });
                return $q.all(promises);
            });
        } else {
            return $q.when();
        }
    };
        self.scheduleEventNotification = function(event, time, siteId) {
        siteId = siteId || $mmSite.getId();
        if ($mmLocalNotifications.isAvailable()) {
            if (time === 0) {
                return $mmLocalNotifications.cancel(event.id, mmaCalendarComponent, siteId);
            }
            var promise = time == -1 ? self.getDefaultNotificationTime(siteId) : $q.when(time);
            return promise.then(function(time) {
                var timeend = (event.timestart + event.timeduration) * 1000;
                if (timeend <= new Date().getTime()) {
                    return $q.when();
                }
                var dateTriggered = new Date((event.timestart - (time * 60)) * 1000),
                    startDate = new Date(event.timestart * 1000),
                    notification = {
                        id: event.id,
                        title: event.name,
                        text: startDate.toLocaleString(),
                        at: dateTriggered,
                        data: {
                            eventid: event.id,
                            siteid: siteId
                        }
                    };
                return $mmLocalNotifications.schedule(notification, mmaCalendarComponent, siteId);
            });
        } else {
            return $q.when();
        }
    };
        self.scheduleEventsNotifications = function(events, siteId) {
        siteId = siteId || $mmSite.getId();
        var promises = [];
        if ($mmLocalNotifications.isAvailable()) {
            angular.forEach(events, function(e) {
                var promise = self.getEventNotificationTime(e.id, siteId).then(function(time) {
                    return self.scheduleEventNotification(e, time, siteId);
                });
                promises.push(promise);
            });
        }
        return $q.all(promises);